/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.navigator;

import com.genuitec.eclipse.core.ui.util.SearchComboControl;
import com.genuitec.eclipse.meexplorer.MEExplorerPlugin;
import com.genuitec.eclipse.meexplorer.MEExplorerSearchConstants;
import com.genuitec.eclipse.meexplorer.SearchPatternData;
import com.genuitec.eclipse.meexplorer.actions.MENavigatorSearchHandler;
import com.genuitec.eclipse.meexplorer.navigator.FilteringStatusComposite;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.LinkHelperService;
import org.eclipse.ui.part.ShowInContext;

public class MENavigator
extends CommonNavigator
implements MEExplorerSearchConstants {
    public static final String VIEW_ID = "com.genuitec.eclipse.meexplorer.MENavigator";
    private MENavigatorSearchHandler meNavigatorSearchHandler;
    private SearchComboControl filterControl2;
    private int rootMode;
    private String workingSetLabel;

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
    }

    public void saveState(IMemento aMemento) {
        this.memento = aMemento;
        this.saveSearchFilterHistory();
        super.saveState(aMemento);
    }

    private void saveSearchFilterHistory() {
        if (this.meNavigatorSearchHandler != null) {
            Map<String, SearchPatternData> filterSearchPatternDataHistory = this.meNavigatorSearchHandler.getFilterSearchPatternDataHistory();
            for (SearchPatternData searchPatternData : filterSearchPatternDataHistory.values()) {
                IMemento child = this.memento.createChild("filter_history", searchPatternData.getPatternString());
                child.putBoolean("filtermode", searchPatternData.isFileContentSearchMode());
                child.putBoolean("regex", searchPatternData.isRegExpressionEnabled());
                child.putBoolean("casesensitive", searchPatternData.isCaseSensitiveEnabled());
                child.putBoolean("folderexcludefilterstate", searchPatternData.isFolderExcludeFilter());
            }
        }
    }

    public void createPartControl(Composite aParent) {
        GridLayout gridlayout = new GridLayout(2, false);
        gridlayout.marginHeight = 0;
        gridlayout.marginWidth = 0;
        aParent.setLayout((Layout)gridlayout);
        this.filterControl2 = new SearchComboControl(aParent, 128);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        data.horizontalIndent = 5;
        this.filterControl2.setLayoutData((Object)data);
        FilteringStatusComposite filterControl = new FilteringStatusComposite();
        filterControl.createContents(aParent);
        Composite treeViewerComposite = new Composite(aParent, 0);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        treeViewerComposite.setLayoutData((Object)data);
        treeViewerComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(treeViewerComposite);
        aParent.layout();
        this.meNavigatorSearchHandler = new MENavigatorSearchHandler(aParent, this.getCommonViewer(), filterControl, this.filterControl2);
        this.restoreSearchFilterHistoryState();
        this.meNavigatorSearchHandler.initializeFilterControls();
    }

    private void restoreSearchFilterHistoryState() {
        if (this.memento != null) {
            IMemento[] children;
            Map<String, SearchPatternData> filterSearchPatternDataHistory = this.meNavigatorSearchHandler.getFilterSearchPatternDataHistory();
            filterSearchPatternDataHistory.clear();
            IMemento[] iMementoArray = children = this.memento.getChildren("filter_history");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String patternString = child.getID();
                boolean isFileContentSearchMode = false;
                boolean regExpressionEnableState = false;
                boolean caseSensitiveEnableState = false;
                boolean isFolderExcludeFilter = false;
                try {
                    isFileContentSearchMode = child.getBoolean("filtermode");
                    regExpressionEnableState = child.getBoolean("regex");
                    caseSensitiveEnableState = child.getBoolean("casesensitive");
                    isFolderExcludeFilter = child.getBoolean("folderexcludefilterstate");
                }
                catch (Exception exception) {}
                filterSearchPatternDataHistory.put(patternString, new SearchPatternData(patternString, isFileContentSearchMode, regExpressionEnableState, caseSensitiveEnableState, isFolderExcludeFilter));
                ++n2;
            }
        }
    }

    public MENavigatorSearchHandler getMENavigatorSearchHandler() {
        return this.meNavigatorSearchHandler;
    }

    public boolean show(ShowInContext context) {
        Object input;
        if (context == null) {
            return false;
        }
        ISelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.selectReveal(selection);
            if (!this.getCommonViewer().getSelection().isEmpty()) {
                return true;
            }
        }
        if ((input = context.getInput()) != null) {
            LinkHelperService lhs;
            if (input instanceof IEditorInput && (selection = (lhs = this.getLinkHelperService()).getSelectionFor((IEditorInput)input)) != null && !selection.isEmpty()) {
                this.selectReveal(selection);
                return true;
            }
            selection = new StructuredSelection(input);
            this.selectReveal(selection);
            return true;
        }
        return false;
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IStructuredSelection selection;
        Object element;
        ICommandService commandService = (ICommandService)this.getViewSite().getService(ICommandService.class);
        Command openProjectCommand = commandService.getCommand("org.eclipse.ui.project.openProject");
        if (openProjectCommand != null && openProjectCommand.isHandled() && (element = (selection = (IStructuredSelection)anEvent.getSelection()).getFirstElement()) instanceof IProject && !((IProject)element).isOpen()) {
            try {
                openProjectCommand.executeWithChecks(new ExecutionEvent());
            }
            catch (CommandException ex) {
                MEExplorerPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.genuitec.eclipse.meexplorer", "'Open Project' failed", (Throwable)ex));
            }
            return;
        }
        super.handleDoubleClick(anEvent);
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void setRootMode(int rootMode) {
        this.rootMode = rootMode;
    }

    public String getWorkingSetLabel() {
        return this.workingSetLabel;
    }

    public void setWorkingSetLabel(String workingSetLabel) {
        this.workingSetLabel = workingSetLabel;
    }
}

