/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active;

import com.crack.me.active.MACAddressUtil;
import com.jniwrapper.util.ProcessorInfo;
import java.net.InetAddress;

public class SystemIdFactory {
    public static final int HD_FIELD_LENGTH = "0000".length();

    public String generateHostId() {
        String hostName = null;
        try {
            InetAddress localInetAddress = InetAddress.getLocalHost();
            hostName = localInetAddress.getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int hashCode = hostName == null || "".equals(hostName) ? 0 : Math.abs(hostName.hashCode());
        String hostId = String.format("%02X", new Integer(hashCode % 256));
        return hostId;
    }

    public String generateSystemInfoId() throws Exception {
        ProcessorInfo pi = null;
        try {
            pi = ProcessorInfo.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        if (pi != null) {
            String familyId = Integer.toHexString(pi.getFamily() % 16);
            String modelId = Integer.toHexString(pi.getModel() % 16);
            String stepId = Integer.toHexString(pi.getStepping() % 16);
            String frequencyId = String.format("%04X", new Long(pi.getFrequency() % 65536L));
            return String.valueOf(familyId) + modelId + stepId + frequencyId;
        }
        return "0000";
    }

    public String generateMacAddress() {
        return new MACAddressUtil().getMacAddress();
    }

    public String generateHDId() {
        String home = System.getenv("HOME");
        String user = System.getenv("USER");
        String logname = System.getenv("LOGNAME");
        String shell = System.getenv("SHELL");
        String currentUse = null;
        currentUse = home != null ? home : (user != null ? user : (logname != null ? logname : (shell != null ? shell : "0000")));
        String hdId = Integer.toString(Math.abs(currentUse.hashCode()));
        int length = currentUse.length();
        if (length > HD_FIELD_LENGTH) {
            hdId = hdId.substring(0, HD_FIELD_LENGTH);
        } else if (length < HD_FIELD_LENGTH) {
            hdId = String.valueOf(hdId) + "FEED".substring(0, HD_FIELD_LENGTH - length);
        }
        return hdId;
    }

    public boolean isNodeLocked() {
        return true;
    }

    public String generateSystemId() throws Exception {
        int i = this.isNodeLocked() ? 1 : 2;
        int j = 0;
        ++j;
        j += 2;
        j += 4;
        return String.valueOf(Integer.toString(i, 16)) + Integer.toString(j += 8, 16) + this.generateHostId() + this.generateSystemInfoId() + this.generateMacAddress() + this.generateHDId();
    }
}

