/*
 * Copyright (c) 2015 Adobe Systems.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
/*global require, exports */
"use strict";

var winston = require("winston");

//
// Logging levels
//
var config = {
    levels: {
        silly: 0,
        input: 1,
        verbose: 2,
        prompt: 3,
        payload: 4,
        debug: 5,
        info: 6,
        help: 7,
        warn: 8,
        error: 9
    },

    colors: {
        silly: "magenta",
        input: "grey",
        verbose: "cyan",
        prompt: "grey",
        debug: "blue",
        info: "green",
        payload: "rainbow",
        help: "cyan",
        warn: "yellow",
        error: "red"
    }
};

// change this loglevel to something higher for debugging purpose
var DEFAULT_LOGLEVEL = "info";

function getTransport() {
    if (global.LOG_INTO_FILE) {
        return new (winston.transports.File)({
            filename: "node-usbmux.log",
            level: DEFAULT_LOGLEVEL
        });
    } else {
        return new (winston.transports.Console)({
            timestamp: true,
            level: "info",
            colorize: DEFAULT_LOGLEVEL
        });
    }
}

function Logger(options) {
    this.name = options.name || "root";
    this.level = options.level || "debug";

    this.logger = new (winston.Logger)({
        transports: [getTransport()],
        levels: config.levels
    });

    winston.addColors(config.colors);
}

Logger.prototype.debug = function() {
    var args = ["[" + this.name + "]"];
    this.logger.debug.apply(this.logger, args.concat(Array.prototype.slice.call(arguments)));
};

Logger.prototype.log = function () {
    this.logger.log.apply(this.logger, arguments);
};

function createLogger(options) {
    return new Logger(options);
}

exports.createLogger = createLogger;
