Texture2D texColor <
	string type = "input";
>;
Texture2D texTarget <
	string type = "output";
>;
SamplerState samplerColor
{
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Clamp; AddressV = Clamp;
};

SamplerState samplerInput
{
	Filter = COMPARISON_MIN_MAG_MIP_POINT;
	AddressU = Clamp; AddressV = Clamp;
};

SamplerState samplerNoise
{
	Filter = COMPARISON_MIN_MAG_MIP_POINT;
	AddressU = Wrap; AddressV = Wrap;
};

Texture2D tex2D < string type = "input"; >;

// --------------------------------------------------------- \\

struct VS_INPUT
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};
struct VS_OUTPUT
{
	float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};

// --------------------------------------------------------- \\

VS_OUTPUT PostProcess_VS(VS_INPUT IN)
{
	VS_OUTPUT OUT;
	
	OUT.pos = IN.pos;
	OUT.tex = IN.tex;
	
	return OUT;
}

// --------------------------------------------------------- \\	
float4 ScreenSize=float4(1920,(1/1920),(1920/1080),(1080/1920));
static float FlipSize = ScreenSize.w*ScreenSize.x;
static float2 screenRes = {ScreenSize.x,FlipSize};

#include "..\..\GEM_settings.txt"
float BlurSamplingRange=3.6;
float BlurPower=GBlurPwr;
float BlurVignetteCurve=0.530;
float BlurVignetteRadius=GBlurRad; 

float4 PS_ProcessBlur(VS_OUTPUT OUT) : SV_TARGET
{
	float4 res;
	float4 coord=0.0;

	coord.xy=OUT.tex.xy;
	float4 origcolor;

	coord.w=0.0;

	origcolor=tex2D.Sample(samplerColor, coord.xy);

	// coord.x=IN.txcoord.x-(1.5/ScreenSize);
	// float4 lshift=tex2Dlod(SamplerColor, coord);
	// coord.x=IN.txcoord.x+(1.5/ScreenSize);
	// float4 rshift=tex2Dlod(SamplerInput, coord);


	float2 offset[16]=
	{
		float2(0.262, 0.641),
		float2(0.262, -0.641),
		float2(0.641, 0.262),
		float2(-0.641, 0.262),

 		float2(1.0, 1.0),
 		float2(-1.0, -1.0),
 		float2(-1.0, 1.0),
 		float2(1.0, -1.0),

		float2(1.0, 0.0),
	 	float2(-1.0, 0.0),
	 	float2(0.0, 1.0),
	 	float2(0.0, -1.0),

		float2(0.262, 0.0),
		float2(0.262, 0.0),
		float2(0.0, 0.262),
		float2(0.0, 0.262)
	};
	int i=0;

	float4 tcol=origcolor;
	float2 invscreensize=1.0/ScreenSize.x;
	invscreensize.y=invscreensize.y;
	//for (i=0; i<8; i++) //higher quality
	//for (i=0; i<4; i++)
	for (i=0; i<16; i++)
	{
	 float2 tdir=offset[i].xy;
	 coord.xy=OUT.tex.xy+tdir.xy*invscreensize*BlurSamplingRange;//*1.0;
	 float4 ct=tex2D.Sample(samplerColor, coord.xy);

	 tcol+=ct;
	}
	//tcol*=0.2; // 1.0/(4+1)
	//tcol*=0.111; // 1.0/(8+1)  //higher quality
	tcol*=0.05882353;
	//tcol*=0.0584;

	float2	uv=(OUT.tex.y-GBlurFocus)*BlurVignetteRadius;
	float	vignette=saturate(dot(uv.xy, uv.xy));
	vignette=pow(vignette, BlurVignetteCurve);
	//res.xyz=tcol.xyz*0.2;
#if (GEMBlur == 1)
	res.xyz=lerp(origcolor.xyz, tcol.xyz, vignette*BlurPower);
#else
	res.xyz=lerp(origcolor.xyz, tcol.xyz, vignette*0);
#endif

//res.xyz=tcol.xyz;

	res.w=1.0;
	return res;
}

#define ESHARPENING
#define ESHARPENINGCOLOR
//#define ENOISE

float SamplingRange=1;//1.0; //sharpening or blurring range
float SharpeningAmount=0.00;//.05;
float ScanLineAmount=2;
float ScanLineRepeat=0.125; //0.5, 0.3333, 0.25, 0.125, so on
float NoiseAmount=0.15;

float4 PS_PostProcess(VS_OUTPUT OUT) : SV_TARGET
{
float4 res;
float4 coord=0.0;

coord.xy=OUT.tex.xy;
	float4 origcolor;

	coord.w=0.0;

	origcolor=tex2D.Sample(samplerInput, coord.xy);

// coord.x=IN.txcoord.x-(1.5/ScreenSize);
// float4 lshift=tex2Dlod(SamplerColor, coord);
// coord.x=IN.txcoord.x+(1.5/ScreenSize);
// float4 rshift=tex2Dlod(SamplerColor, coord);


float2 offset[8]=
{
 float2(1.0, 1.0),
 float2(-1.0, -1.0),
 float2(-1.0, 1.0),
 float2(1.0, -1.0),

 float2(1.41, 0.0),
 float2(-1.41, 0.0),
 float2(0.0, 1.41),
 float2(0.0, -1.41)
};
int i=0;

float4 tcol=origcolor;
float invscreensize=1.0/ScreenSize;
//for (i=0; i<8; i++) //higher quality
for (i=0; i<4; i++)
{
 float2 tdir=offset[i].xy;
coord.xy=OUT.tex.xy+tdir.xy*invscreensize*BlurSamplingRange;//*1.0;
float4 ct=tex2D.Sample(samplerInput, coord.xy);

 tcol+=ct;
}
tcol*=0.2; // 1.0/(4+1)
//tcol*=0.111; // 1.0/(8+1)  //higher quality


/*
//not interesting
#ifdef EBLURRING
//blur
res=tcol;
#endif
*/

//sharp
#ifdef ESHARPENING

#ifdef ESHARPENINGCOLOR
//color
res=origcolor*(1.0+((origcolor-tcol)*SharpeningAmount));
#else
 //non color
float difffact=dot((origcolor.xyz-tcol.xyz), 0.333);
res=origcolor*(1.0+difffact*SharpeningAmount);
#endif

//less sharpening for bright pixels
float rgray=origcolor.z; //blue fit well
//float rgray=max(origcolor.x, max(origcolor.y, origcolor.z));
rgray=pow(rgray, 3.0);
res=lerp(res, origcolor, saturate(rgray));

#endif




//grain noise
#ifdef ENOISE
float origgray=max(res.x, res.y);//dot(res.xyz, 0.333);
origgray=max(origgray, res.z);
coord.xy=OUT.tex.xy*16.0 + origgray;
float4 cnoi=tex2D.Sample(samplerNoise, coord);
res=lerp(res, (cnoi.x+0.5)*res, NoiseAmount*saturate(1.0-origgray*1.8));
#endif


res.w=1.0;
return res;
}

#define ChromaticAmount			0.0025
#define LensSize			0.5005
#define LensDistortion	 		0.00
#define LensDistortionCubic		0.00

#define ELenzIntensity			50.0
#define ELenzPower			1.0
#define LenzThresh			0.95

float ScreenScaleY=1.333;

float4 PS_PostProcess2(VS_OUTPUT OUT) : SV_TARGET
{
	float4 res;
	float4 coord=0.0;

	coord.xy=OUT.tex.xy;
	float4 origcolor;

	coord.w=0.0;

	origcolor=tex2D.Sample(samplerInput, coord.xy);

// coord.x=IN.txcoord.x-(1.5/ScreenSize);
// float4 lshift=tex2Dlod(SamplerColor, coord);
// coord.x=IN.txcoord.x+(1.5/ScreenSize);
// float4 rshift=tex2Dlod(SamplerColor, coord);


float2 offset[8]=
{
 float2(1.0, 1.0),
 float2(-1.0, -1.0),
 float2(-1.0, 1.0),
 float2(1.0, -1.0),

 float2(1.41, 0.0),
 float2(-1.41, 0.0),
 float2(0.0, 1.41),
 float2(0.0, -1.41)
};
int i=0;

float4 tcol=origcolor;
float2 invscreensize=1.0/ScreenSize;
invscreensize.y=invscreensize.y/ScreenScaleY;
//for (i=0; i<8; i++) //higher quality
/*	for (i=0; i<4; i++)
{
 float2 tdir=offset[i].xy;
 coord.xy=OUT.tex.xy+tdir.xy*invscreensize*SamplingRange;//*1.0;
 float4 ct=tex2D.Sample(samplerInput, coord.xy);

 tcol+=ct;
}
tcol*=0.2; // 1.0/(4+1)
//tcol*=0.111; // 1.0/(8+1)  //higher quality
*/

float3 eta = float3(1.0+ChromaticAmount*0.9,1.0+ChromaticAmount*0.6,1.0+ChromaticAmount*0.3);
float2 center;
center.x = coord.x-0.5;
center.y = coord.y-0.5;
float LensZoom = 1.0/LensSize;

float r2 = (OUT.tex.x-0.5) * (OUT.tex.x-0.5) + (OUT.tex.y-0.5) * (OUT.tex.y-0.5);     
float f = 0;

if( LensDistortionCubic == 0.0){
	f = 1 + r2 * LensDistortion;
}else{
                f = 1 + r2 * (LensDistortion + LensDistortionCubic * sqrt(r2));
};

float x = f*LensZoom*(coord.x-0.5)+0.5;
float y = f*LensZoom*(coord.y-0.5)+0.5;
float2 rCoords = (f*eta.r)*LensZoom*(center.xy*0.5)+0.5;
float2 gCoords = (f*eta.g)*LensZoom*(center.xy*0.5)+0.5;
float2 bCoords = (f*eta.b)*LensZoom*(center.xy*0.5)+0.5;

//float3 inputDistord = tex2D.Sample(samplerInput,float2(x,y));
float4 inputDistord = float4(tex2D.Sample(samplerInput,rCoords).r , tex2D.Sample(samplerInput,gCoords).g ,tex2D.Sample(samplerInput,bCoords).b, tex2D.Sample(samplerInput,float2(x,y)).a);
return float4(inputDistord.r,inputDistord.g,inputDistord.b,1);

res.w=1.0;
return res;
}

float3 sampleblurred(float2 uvsrc)
{
	
	float4	res;
	res =tex2D.Sample(samplerColor, uvsrc);
	float ScaleXY= (1/1024);

	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.94201624*ScaleXY, -0.39906216*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.94558609*ScaleXY, -0.76890725*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.09418410*ScaleXY, -0.92938870*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.34495938*ScaleXY,  0.29387760*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.91588581*ScaleXY,  0.45771432*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.81544232*ScaleXY, -0.87912464*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.38277543*ScaleXY,  0.27676845*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.97484398*ScaleXY,  0.75648379*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.44323325*ScaleXY, -0.97511554*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.53742981*ScaleXY, -0.47373420*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.26496911*ScaleXY, -0.41893023*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.79197514*ScaleXY,  0.19090188*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.24188840*ScaleXY,  0.99706507*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2(-0.81409955*ScaleXY,  0.91437590*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.19984126*ScaleXY,  0.78641367*ScaleXY));
	res+=tex2D.Sample(samplerColor, uvsrc+float2( 0.14383161*ScaleXY, -0.14100790*ScaleXY));
res /= 17;



res.xyz = dot(res.xyz, float3(0.3, 0.59, 0.11));


res.xyz=res.xyz-float3(LenzThresh,LenzThresh,LenzThresh);

if(res.x < 0)	
	{
res.x=0;
}
if(res.y < 0)	
	{
res.y=0;
}
if(res.z < 0)	
	{
res.z=0;
}
res.w= 1.0;



res *= 4;
	return res;
}

float4 Flares(VS_OUTPUT OUT) : SV_TARGET
{
float3	origcolor=tex2D.Sample(samplerColor, OUT.tex.xy);
/*
float4 coord=0.0;
coord.xy=OUT.tex.xy;
coord.w=0.0;  
float3 eta = float3(1.0+ChromaticAmount*0.9,1.0+ChromaticAmount*0.6,1.0+ChromaticAmount*0.3);
float2 center;
center.x = coord.x-0.5;
center.y = coord.y-0.5;
float LensZoom = 1.0/LensSize;

float r2 = (OUT.tex.x-0.5) * (OUT.tex.x-0.5) + (OUT.tex.y-0.5) * (OUT.tex.y-0.5);     
float f = 0;

if( LensDistortionCubic == 0.0){
	f = 1 + r2 * LensDistortion;
}else{
                f = 1 + r2 * (LensDistortion + LensDistortionCubic * sqrt(r2));
};

float x = f*LensZoom*(coord.x-0.5)+0.5;
float y = f*LensZoom*(coord.y-0.5)+0.5;
float2 rCoords = (f*eta.r)*LensZoom*(center.xy*0.5)+0.5;
float2 gCoords = (f*eta.g)*LensZoom*(center.xy*0.5)+0.5;
float2 bCoords = (f*eta.b)*LensZoom*(center.xy*0.5)+0.5;

float4 inputDistord = float4(tex2D.Sample(samplerColor, rCoords).r , tex2D.Sample(samplerColor, gCoords).g ,tex2D.Sample(samplerColor, bCoords).b, tex2D.Sample(samplerColor, float2(x,y)).a);

float4 schmotzcolor = float4(inputDistord.r,inputDistord.g,inputDistord.b,1);

origcolor = schmotzcolor.xyz;
*/
	float4	res;
	float3	lenz=0;
	float2	lenzuv=0.0;
/*	
	const float3 offset[15]=
	{
		float3(0.3, 0.01, 4),
		float3(0.7, 0.25, 25),
		float3(0.3, 0.25, 15),
// Full
		float3(1, 1.0, 5),
// Arriere
		float3(-0.15, 20, 1),
		float3(-0.3, 20, 1),
// Avant
		float3(0.5, 0.1, 1),
		float3(0.01, 10, 1),
		float3(20, 0.25, 1),
		float3(1000, 5, 100),
//Plein ecran passe inverse
		float3(0.5, -0.5, 2),
//Rond bleu du debut
		float3(2, 2, -5),
//2eme partie de la passe FS
		float3(-5, 0.2, 0.2),
//Derniere passe
		float3(0.15, 0.5, 20),
		float3(0.4, 1, 10)
	};

const float3 factors[15]=
	{
		float3(0.5, 0.5, 0),
		float3(0, 0.5, 0),
		float3(0, 0, 0.5),
// Full
		float3(0.2, 0.25, 0),
// Arriere
		float3(0.15, 0, 0.0),
		float3(0, 0.0, 0.15),
// Avant
		float3(0.2, 0.2, 0.05),
		float3(0.25, 0.25, 0.25),
		float3(1, 1, 1),
		float3(0, 0.25, 1),
//Plein ecran
		float3(0, 0,0.25),
//Rond bleu au debut
		float3(0, 0, 1),
//Derniere passe avec passe full combine
		float3(2, 2, 2),
		float3(1, 1, 0.25),
		float3(0, 0, 0)

	};


	for (int i=0; i<15; i++)
	{
		float2 distfact=(OUT.tex.xy-0.5);
		lenzuv.xy=offset[i].x*distfact;
		lenzuv.xy*=pow(2.0*length(float2(distfact.x*ScreenSize.z,distfact.y)), offset[i].y);
		lenzuv.xy*=offset[i].z*0.5;
		lenzuv.xy=0.5-lenzuv.xy;
		float3 templenz=sampleblurred(lenzuv.xy);
		templenz=templenz*factors[i];
		distfact=(lenzuv.xy-0.5);
		distfact*=2.0;
		templenz*=saturate(1.0-dot(distfact,distfact));
		float maxlenz=max(templenz.x, max(templenz.y, templenz.z));
		float tempnor=(maxlenz/(1.0+maxlenz));
		tempnor=pow(tempnor, ELenzPower);
		templenz.xyz*=tempnor;
		lenz+=templenz;
	}


	lenz.xyz*=1.25*ELenzIntensity;
	
	res.xyz=origcolor + lenz;*/
	res.xyz=origcolor;
	res.w=1.0;
	return res;
}

#define fFlareLuminance 		gHFlThresh						
#define fFlareBlur 			10000.0						
#define fFlareIntensity 		gHFlInt //35					
#define fFlareTint			float3(0.007, 0.006, 0.004)		
#define FlareRadius 			1/952

float3 BrightPass(float2 tex)
{
    float3 couleur = tex2D.Sample(samplerColor, tex).rgb;
    float3 bC = max(couleur - float3(fFlareLuminance, fFlareLuminance, fFlareLuminance), 0.0);
    float bright = dot(bC, 1.0);
    bright = smoothstep(0.0f, 0.5, bright);
    return lerp(0.0, couleur, bright);
}

float3 AnamorphicSample(int axis, float2 tex, float blur)
{
	tex = 2.0 * tex - 1.0;
	if (!axis) tex.x /= -blur;
	else tex.y /= -blur;
	tex = 0.5 * tex + 0.5;
	return BrightPass(tex);
}

float4 PS_ProcessPass_Anamorphic(VS_OUTPUT OUT) : SV_TARGET
{
	float4 res;
	float2 coord = OUT.tex.xy;
        
	float3 anamFlare = AnamorphicSample(0, coord.xy, fFlareBlur) * fFlareTint;

	anamFlare += AnamorphicSample(0, coord.xy+float2(0, 4)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;
	anamFlare += AnamorphicSample(0, coord.xy+float2(0, 3)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(0, coord.xy+float2(0, 2)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(0, coord.xy+float2(0, 1)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(0, coord.xy+float2(0, -1)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(0, coord.xy+float2(0, -2)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(0, coord.xy+float2(0, -3)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(0, coord.xy+float2(0, -4)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;

/*
        anamFlare += AnamorphicSample(90, coord.xy+float2(4, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;
	anamFlare += AnamorphicSample(90, coord.xy+float2(3, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(90, coord.xy+float2(2, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(90, coord.xy+float2(1, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(90, coord.xy+float2(1, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(90, coord.xy+float2(2, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(90, coord.xy+float2(3, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(90, coord.xy+float2(4, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;
*/

	res.rgb = anamFlare * fFlareIntensity;
	res.w = 0.0;
	return res;
}
		
#define TINTCOLOR 			0
#define COLORING			1			
#define REDAMOUNT  			0.8		
#define GREENAMOUNT 			0.7		
#define BLUEAMOUNT 			0.8
#define ScreenLightPos			float2(1.5,-0.5)
#define Density				0.35	// 0.25
#define Weight				0.0650 //0.0300
#define NUM_SAMPLES			100
#define Decay				0.992
#define SStresh				0.9765 //0.975
#define SunExposure			2.0	//3.0
float4 PS_ProcessSunShafts(VS_OUTPUT OUT) : SV_TARGET 
{	
	float2 texCoord = OUT.tex;
	  
    half2 deltaTexCoord = (texCoord - ScreenLightPos.xy);  
      
    deltaTexCoord *= 1.0f / NUM_SAMPLES * Density;  
     
    half3 color = max(float4(0,0,0,0),tex2D.Sample(samplerColor, texCoord)-SStresh);  
	 
	half illuminationDecay = 1.0f;  
	  
	for (int i = 0; i < NUM_SAMPLES; i++)  
	{  
		  
		texCoord -= deltaTexCoord;  
		  
	    half3 sample = max(float4(0,0,0,0),tex2D.Sample(samplerColor, texCoord)-SStresh);  
		  
#ifdef TINTCOLOR
                //sample.r *= REDAMOUNT;
		//sample.g *= GREENAMOUNT;
		//sample.b *= BLUEAMOUNT;
#endif

#ifdef COLORING
//sample = dot(sample, float3(0.3, 0.59, 0.11));
                //sample.r *= REDAMOUNT;
		//sample.g *= GREENAMOUNT;
		//sample.b *= BLUEAMOUNT;
#endif
		sample *= illuminationDecay * Weight;  
		  
		color += sample;  
		  
		illuminationDecay *= Decay;  
	}
	  
	return float4( saturate(color*SunExposure) , color.x);
}

BlendState SrcAlphaBlendingAdd
{
    BlendEnable[0] = TRUE;
    SrcBlend = ONE;
    DestBlend = ONE;
    BlendOp = ADD;
    SrcBlendAlpha = One;
    DestBlendAlpha = One;
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x0F;
};

BlendState SrcAlphaBlendingAdd2
{
    BlendEnable[0] = TRUE;
    SrcBlend = INV_SRC_COLOR; //zero
    DestBlend = SRC_COLOR; //src_color
    BlendOp = ADD;
    SrcBlendAlpha = one; //one
    DestBlendAlpha = INV_SRC_COLOR; //one
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x00;
};

BlendState NoBlending {
    AlphaToCoverageEnable = TRUE;
    BlendEnable[0] = TRUE;
};

DepthStencilState DisableDepth
{

    DepthEnable = FALSE;
    DepthWriteMask = ZERO;
    DepthFunc = LESS_EQUAL;

    StencilEnable  = FALSE;

};

DepthStencilState DisableDepthReplaceStencil {
    DepthEnable = FALSE;
    StencilEnable = TRUE;
    FrontFaceStencilPass = REPLACE;
};

DepthStencilState DisableDepthUseStencil {
    DepthEnable = FALSE;
    StencilEnable = TRUE;
    FrontFaceStencilFunc = EQUAL;
};


technique11 PostProcess
{
pass P0
    	{
 		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS())); 
		SetGeometryShader( NULL );     
        	SetPixelShader(CompileShader(ps_4_0, PS_ProcessBlur()));
	}
pass P1
    	{
 		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS())); 
		SetGeometryShader( NULL );     
        	SetPixelShader(CompileShader(ps_4_0, PS_PostProcess()));
	}
pass P2
    	{
 		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS())); 
		SetGeometryShader( NULL );     
        	SetPixelShader(CompileShader(ps_4_0, PS_PostProcess2()));
	}
pass P3
    	{
 		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS())); 
		SetGeometryShader( NULL );     
        	SetPixelShader(CompileShader(ps_4_0, Flares()));
	}
pass P4
        {         
		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS()));
		SetGeometryShader( NULL );      
                SetPixelShader(CompileShader(ps_4_0, PS_ProcessPass_Anamorphic()));
		SetBlendState( SrcAlphaBlendingAdd, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
         }
pass P5 
	{
		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS()));
		SetGeometryShader( NULL );
		SetPixelShader(CompileShader(ps_4_0, PS_ProcessSunShafts()));
		SetBlendState( SrcAlphaBlendingAdd, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
	}

}