#define ESHARPENING
#define ESHARPENINGCOLOR
#define BLURRYVIGNETTE

#include "..\..\GEM_settings.txt"

float SamplingRange=1;
float SharpeningAmount=0.00;
float ScanLineAmount=2;
float ScanLineRepeat=0.125; 
float NoiseAmount=0.15;

float4 ScreenSize=float4(1920,(1/1920),(1920/1080),(1080/1920));

float BlurSamplingRange=3.6;
float BlurPower=GBlurPwr;
float BlurVignetteCurve=0.530;
float BlurVignetteRadius=GBlurRad; 

#define ChromaticAmount			0.0025
#define LensSize			0.5005
#define LensDistortion	 		0.00
#define LensDistortionCubic		0.00

#define ELenzIntensity			50.0
#define ELenzPower			1.0
#define LenzThresh			0.95

#define fFlareLuminance 		gHFlThresh						
#define fFlareBlur 			10000.0						
#define fFlareIntensity 		gHFlInt //35					
#define fFlareTint			float3(0.007, 0.006, 0.004)		
#define FlareRadius 			1/952

#define TINTCOLOR 			0
#define COLORING			0			
#define REDAMOUNT  			0.7		
#define GREENAMOUNT 			0.6		
#define BLUEAMOUNT 			0.4
#define ScreenLightPos			float2(1.0,0.0)
#define Density				0.30	// 0.25
#define Weight				0.0350 //0.0300
#define NUM_SAMPLES			64
#define Decay				1.0
#define SStresh				0.938 //0.975
#define SunExposure			5.0	//3.0

static float FlipSize = ScreenSize.w*ScreenSize.x;
static float2 screenRes = {ScreenSize.x,FlipSize};

float ScreenScaleY=1.333;

#define fFlareHorizontal		1

texture2D texColor;
texture2D texDepth;
texture2D texNoise;

sampler2D SamplerColor = sampler_state
{
Texture   = <texColor>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = NONE;//NONE;
AddressU  = Clamp;
AddressV  = Clamp;
SRGBTexture=FALSE;
MaxMipLevel=0;
MipMapLodBias=0;
};

sampler2D InputSampler = sampler_state
{
    Texture = (texColor);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
    AddressU   = Clamp;
	AddressV   = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerDepth = sampler_state
{
	Texture   = <texDepth>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerNoise = sampler_state
{
Texture = <texNoise>;
MinFilter = POINT;
MagFilter = POINT;
MipFilter = NONE;//NONE;
AddressU = Wrap;
AddressV = Wrap;
SRGBTexture=false;
MaxMipLevel=0;
MipMapLodBias=0;
};  

struct VS_OUTPUT_POST {
 float4 vpos  : POSITION;
 float2 txcoord : TEXCOORD0;
};

struct VS_INPUT_POST {
 float3 pos  : POSITION;
 float2 txcoord : TEXCOORD0;
};

float pixelWidth;
float pixelHeight;

VS_OUTPUT_POST VS_PostProcess(VS_INPUT_POST IN)
{
VS_OUTPUT_POST OUT;

float4 pos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);

OUT.vpos=pos;
OUT.txcoord.xy=IN.txcoord.xy;

return OUT;
}

float3 sampleblurred(float2 uvsrc)
{
	
	float4	res;
	res =tex2D(InputSampler, uvsrc);
	float ScaleXY= (1/1024);

	res+=tex2D(InputSampler, uvsrc+float2(-0.94201624*ScaleXY, -0.39906216*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.94558609*ScaleXY, -0.76890725*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2(-0.09418410*ScaleXY, -0.92938870*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.34495938*ScaleXY,  0.29387760*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2(-0.91588581*ScaleXY,  0.45771432*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2(-0.81544232*ScaleXY, -0.87912464*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2(-0.38277543*ScaleXY,  0.27676845*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.97484398*ScaleXY,  0.75648379*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.44323325*ScaleXY, -0.97511554*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.53742981*ScaleXY, -0.47373420*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2(-0.26496911*ScaleXY, -0.41893023*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.79197514*ScaleXY,  0.19090188*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2(-0.24188840*ScaleXY,  0.99706507*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2(-0.81409955*ScaleXY,  0.91437590*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.19984126*ScaleXY,  0.78641367*ScaleXY));
	res+=tex2D(InputSampler, uvsrc+float2( 0.14383161*ScaleXY, -0.14100790*ScaleXY));
res /= 17;



res.xyz = dot(res.xyz, float3(0.3, 0.59, 0.11));


res.xyz=res.xyz-float3(LenzThresh,LenzThresh,LenzThresh);

if(res.x < 0)	
	{
res.x=0;
}
if(res.y < 0)	
	{
res.y=0;
}
if(res.z < 0)	
	{
res.z=0;
}
res.w= 1.0;



res *= 4;
	return res;
}

float3 BrightPass(float2 tex)
{
    float3 couleur = tex2D(InputSampler, tex).rgb;
    float3 bC = max(couleur - float3(fFlareLuminance, fFlareLuminance, fFlareLuminance), 0.0);
    float bright = dot(bC, 1.0);
    bright = smoothstep(0.0f, 0.5, bright);
    return lerp(0.0, couleur, bright);
}


float3 AnamorphicSample(int axis, float2 tex, float blur)
{
	tex = 2.0 * tex - 1.0;
	if (!axis) tex.x /= -blur;
	else tex.y /= -blur;
	tex = 0.5 * tex + 0.5;
	return BrightPass(tex);
}

float4 PS_ProcessBlur(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR
{
	float4 res;
	float4 coord=0.0;

	coord.xy=IN.txcoord.xy;
	float4 origcolor;

	coord.w=0.0;

	origcolor=tex2Dlod(SamplerColor, coord);

	float2 offset[16]=
	{
		float2(0.262, 0.641),
		float2(0.262, -0.641),
		float2(0.641, 0.262),
		float2(-0.641, 0.262),

 		float2(1.0, 1.0),
 		float2(-1.0, -1.0),
 		float2(-1.0, 1.0),
 		float2(1.0, -1.0),

		float2(1.0, 0.0),
	 	float2(-1.0, 0.0),
	 	float2(0.0, 1.0),
	 	float2(0.0, -1.0),

		float2(0.262, 0.0),
		float2(0.262, 0.0),
		float2(0.0, 0.262),
		float2(0.0, 0.262)
	};
	int i=0;

	float4 tcol=origcolor;
	float2 invscreensize=1.0/ScreenSize.x;
	invscreensize.y=invscreensize.y;
	for (i=0; i<16; i++)
	{
	 float2 tdir=offset[i].xy;
	 coord.xy=IN.txcoord.xy+tdir.xy*invscreensize*BlurSamplingRange;//*1.0;
	 float4 ct=tex2Dlod(SamplerColor, coord);

	 tcol+=ct;
	}
	tcol*=0.05882353;

	float2	uv=(IN.txcoord.y-GBlurFocus)*BlurVignetteRadius;
	float	vignette=saturate(dot(uv.xy, uv.xy));
	vignette=pow(vignette, BlurVignetteCurve);
#if (GEMBlur == 1)
	res.xyz=lerp(origcolor.xyz, tcol.xyz, vignette*BlurPower);
#else
	res.xyz=lerp(origcolor.xyz, tcol.xyz, vignette*0);
#endif

	res.w=1.0;
	return res;
}




float4 PS_PostProcess(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR
{
float4 res;
float4 coord=0.0;

coord.xy=IN.txcoord.xy;
float4 origcolor;

coord.w=0.0;


origcolor=tex2Dlod(SamplerColor, coord);


float2 offset[8]=
{
 float2(1.0, 1.0),
 float2(-1.0, -1.0),
 float2(-1.0, 1.0),
 float2(1.0, -1.0),

 float2(1.41, 0.0),
 float2(-1.41, 0.0),
 float2(0.0, 1.41),
 float2(0.0, -1.41)
};
int i=0;

float4 tcol=origcolor;
float invscreensize=1.0/ScreenSize;
for (i=0; i<4; i++)
{
 float2 tdir=offset[i].xy;
 coord.xy=IN.txcoord.xy+tdir.xy*invscreensize*SamplingRange;//*1.0;
 float4 ct=tex2Dlod(SamplerColor, coord);

 tcol+=ct;
}
tcol*=0.2; // 1.0/(4+1)

#ifdef ESHARPENING

#ifdef ESHARPENINGCOLOR

res=origcolor*(1.0+((origcolor-tcol)*SharpeningAmount));
#else
float difffact=dot((origcolor.xyz-tcol.xyz), 0.333);
res=origcolor*(1.0+difffact*SharpeningAmount);
#endif

//less sharpening for bright pixels
float rgray=origcolor.z; //blue fit well
//float rgray=max(origcolor.x, max(origcolor.y, origcolor.z));
rgray=pow(rgray, 3.0);
res=lerp(res, origcolor, saturate(rgray));

#endif




//grain noise
#ifdef ENOISE
float origgray=max(res.x, res.y);//dot(res.xyz, 0.333);
origgray=max(origgray, res.z);
coord.xy=IN.txcoord.xy*16.0 + origgray;
float4 cnoi=tex2Dlod(SamplerNoise, coord);
res=lerp(res, (cnoi.x+0.5)*res, NoiseAmount*saturate(1.0-origgray*1.8));
#endif


res.w=1.0;
return res;
}


float4 PS_PostProcess2(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR
{
float4 res;
float4 coord=0.0;

coord.xy=IN.txcoord.xy;
float4 origcolor;

coord.w=0.0;


origcolor=tex2Dlod(SamplerColor, coord);

float2 offset[8]=
{
 float2(1.0, 1.0),
 float2(-1.0, -1.0),
 float2(-1.0, 1.0),
 float2(1.0, -1.0),

 float2(1.41, 0.0),
 float2(-1.41, 0.0),
 float2(0.0, 1.41),
 float2(0.0, -1.41)
};
int i=0;

float4 tcol=origcolor;
float2 invscreensize=1.0/ScreenSize;
invscreensize.y=invscreensize.y/ScreenScaleY;

float3 eta = float3(1.0+ChromaticAmount*0.9,1.0+ChromaticAmount*0.6,1.0+ChromaticAmount*0.3);
float2 center;
center.x = coord.x-0.5;
center.y = coord.y-0.5;
float LensZoom = 1.0/LensSize;

float r2 = (IN.txcoord.x-0.5) * (IN.txcoord.x-0.5) + (IN.txcoord.y-0.5) * (IN.txcoord.y-0.5);     
float f = 0;

if( LensDistortionCubic == 0.0){
	f = 1 + r2 * LensDistortion;
}else{
                f = 1 + r2 * (LensDistortion + LensDistortionCubic * sqrt(r2));
};

float x = f*LensZoom*(coord.x-0.5)+0.5;
float y = f*LensZoom*(coord.y-0.5)+0.5;
float2 rCoords = (f*eta.r)*LensZoom*(center.xy*0.5)+0.5;
float2 gCoords = (f*eta.g)*LensZoom*(center.xy*0.5)+0.5;
float2 bCoords = (f*eta.b)*LensZoom*(center.xy*0.5)+0.5;

float4 inputDistord = float4(tex2D(SamplerColor,rCoords).r , tex2D(SamplerColor,gCoords).g ,tex2D(SamplerColor,bCoords).b, tex2D(SamplerColor,float2(x,y)).a);
return float4(inputDistord.r,inputDistord.g,inputDistord.b,1);

res.w=1.0;
return res;
}

float4 PS_ProcessPass_Anamorphic(VS_OUTPUT_POST IN, float2 vPos : VPOS, uniform int axis) : COLOR
{
	float4 res;
	float2 coord = IN.txcoord.xy;
	

#ifdef fFlareHorizontal
	#define fFlareAxis	0
#endif
#ifdef fFlareVertical
	#define fFlareAxis	90
#endif
        
	float3 anamFlare = AnamorphicSample(axis, coord.xy, fFlareBlur) * fFlareTint;
#ifdef fFlareHorizontal
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, 4)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, 3)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, 2)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, 1)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, -1)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, -2)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, -3)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(0, -4)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;
#endif
#ifdef fFlareVertical
        anamFlare += AnamorphicSample(axis, coord.xy+float2(4, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(3, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(2, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(1, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(1, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.90;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(2, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.72;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(3, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.54;
	anamFlare += AnamorphicSample(axis, coord.xy+float2(4, 0)*FlareRadius, fFlareBlur) * fFlareTint* 0.30;
#endif

	res.rgb = anamFlare * fFlareIntensity;
	res.a = 1.0;
	return res;
}

float4 PS_ProcessSunShafts(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR 
{	
	float2 texCoord = IN.txcoord;
	// Calculate vector from pixel to light source in screen space.  
    half2 deltaTexCoord = (texCoord - ScreenLightPos.xy);  
    // Divide by number of samples and scale by control factor.  
    deltaTexCoord *= 1.0f / NUM_SAMPLES * Density;  
    // Store initial sample.  
    half3 color = max(float4(0,0,0,0),tex2D(InputSampler, texCoord)-SStresh);  
	// Set up illumination decay factor.  
	half illuminationDecay = 1.0f;  
	// Evaluate summation from Equation 3 NUM_SAMPLES iterations.  
	for (int i = 0; i < NUM_SAMPLES; i++)  
	{  
		// Step sample location along ray.  
		texCoord -= deltaTexCoord;  
		// Retrieve sample at new location.  
	    half3 sample = max(float4(0,0,0,0),tex2D(InputSampler, texCoord)-SStresh);  
		// Apply sample attenuation scale/decay factors.  

#ifdef TINTCOLOR
                sample.r *= REDAMOUNT;
		sample.g *= GREENAMOUNT;
		sample.b *= BLUEAMOUNT;
#endif

#ifdef COLORING
sample = dot(sample, float3(0.3, 0.59, 0.11));
                sample.r *= REDAMOUNT;
		sample.g *= GREENAMOUNT;
		sample.b *= BLUEAMOUNT;
#endif

		sample *= illuminationDecay * Weight;  
		// Accumulate combined color.  
		color += sample;  
		// Update exponential decay factor.  
		illuminationDecay *= Decay;  
	}
	// Output final color with a further scale control factor.  
	return float4( saturate(color*SunExposure) , color.x);
}

technique PostProcess
{
   pass P0
   {

VertexShader = compile vs_3_0 VS_PostProcess();
PixelShader  = compile ps_3_0 PS_ProcessBlur();


DitherEnable=FALSE;
ZEnable=FALSE;
CullMode=NONE;
ALPHATESTENABLE=FALSE;
SEPARATEALPHABLENDENABLE=FALSE;
AlphaBlendEnable=FALSE;
StencilEnable=FALSE;
FogEnable=FALSE;
SRGBWRITEENABLE=FALSE;
}
}


technique PostProcess2
{
pass P0
{

VertexShader = compile vs_3_0 VS_PostProcess();
PixelShader  = compile ps_3_0 PS_PostProcess();

DitherEnable=FALSE;
ZEnable=FALSE;
CullMode=NONE;
ALPHATESTENABLE=FALSE;
SEPARATEALPHABLENDENABLE=FALSE;
AlphaBlendEnable=FALSE;
StencilEnable=FALSE;
FogEnable=FALSE;
SRGBWRITEENABLE=FALSE;
}
}

technique PostProcess3
{
pass P0
{

VertexShader = compile vs_3_0 VS_PostProcess();
PixelShader  = compile ps_3_0 PS_PostProcess2();

DitherEnable=FALSE;
ZEnable=FALSE;
CullMode=NONE;
ALPHATESTENABLE=FALSE;
SEPARATEALPHABLENDENABLE=FALSE;
AlphaBlendEnable=FALSE;
StencilEnable=FALSE;
FogEnable=FALSE;
SRGBWRITEENABLE=FALSE;
}
}


technique PostProcess4
{

pass P0
        {
                AlphaBlendEnable = true;
                SrcBlend = One;
                DestBlend = One;
                VertexShader = compile vs_3_0 VS_PostProcess();               	
                PixelShader = compile ps_3_0 PS_ProcessPass_Anamorphic(fFlareAxis);
         }
pass P1
		{
			VertexShader = compile vs_3_0 VS_PostProcess();
			PixelShader  = compile ps_3_0 PS_ProcessSunShafts();
			AlphaBlendEnable=True;
			SrcBlend = One;
			DestBlend = One;
		}
}
