﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace MyFileEditor
{
    public partial class MyEdit : Form
    {
        private int tabNum=0;                // 标签数
        RichTextBox r;
        private string[] fontFamilyNames;

        public MyEdit()
        {
            InitializeComponent();
            GetFontFamilies();
            ts_addItems();    
        }

        public RichTextBox GetCurrentRichTextBox()
        {
            r = new RichTextBox(); //初始化RichTextBox实例
            
            TabPage tabPage = new TabPage ();  // 新建标签
            tabPage = tabControl1.SelectedTab;
            if ( tabControl1.TabCount > 0 )    //选项卡数量大于0
            {
                  
                foreach ( Control c in tabPage.Controls )
                {
                    if ( c.GetType() == typeof(Child) )
                    {
                        Child form = c as Child;
                        return form.getRichTextBox();
                    }
                }
            }
            return r;
        }


        public Child getChildForm()
        {
            Child form1 = new Child();
            TabPage tabPage = new TabPage();
            tabPage = tabControl1.SelectedTab;
            if ( tabControl1.TabCount > 0 )
            {
                foreach (Control c in tabPage.Controls)
                {
                    if ( c.GetType() == typeof(Child) )
                    {

                        Child form = c as Child;
                        return form;
                    }
                }
            }
            return form1;
        }

        public Child getChildForm1( int i )
        {
            Child form1 = new Child();
            TabPage tabPage = new TabPage();
            tabPage = tabControl1.TabPages[i];
            if (tabControl1.TabCount > 0)
            {
                foreach (Control c in tabPage.Controls)
                {
                    if (c.GetType() == typeof(Child))
                    {

                        Child form = c as Child;

                        return form;
                    }
                }
            }
            return form1;
        }
        private void 新建NToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.openFileDialog1.FileName = "";    //第一个在对话框中显示的文件或最后一个选取的文件,开始设置为空
            Child child = new Child();             //建立子窗口
            child.setF1(this);
            child.openFileDialog1.FileName  = this.openFileDialog1.FileName; // 将现有属性添加到子窗口
            child.saveFileDialog1.FileName  = this.saveFileDialog1.FileName;
            
            //关键语句
            child.TopLevel = false;
            child.TopMost = false;
            child.ControlBox = true;
            child.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
            child.Dock = DockStyle.Fill;
            TabPage newPage = new TabPage();
            tabNum += 1;     //标签数加1

            newPage.Text = "Untitled " + tabNum.ToString();
            newPage.Parent = tabControl1;
            child.Parent = newPage;
            child.Show();
            tabControl1.SelectedTab = newPage;

        }

        public void 打开OToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.openFileDialog1.Title = "打开文件...";
            this.openFileDialog1.Filter = "文本文件(*.txt)|*.txt|富格式文件(*.rtf)|*.rtf|所有文件(*.*)|*.*";
            this.openFileDialog1.FilterIndex = 1;
            this.openFileDialog1.InitialDirectory = "桌面";
            this.openFileDialog1.ShowReadOnly = true;
            this.openFileDialog1.ReadOnlyChecked = false;
            this.openFileDialog1.FileName = "";


            Child child = new Child();
            child.setF1(this);
            //关键语句
            child.TopLevel = false;
            child.TopMost = false;
            child.ControlBox = true;
            child.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;

            if (this.openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                int i = 0;
                this.Text = this.openFileDialog1.FileName ;
                for (i = 0; i < tabControl1.TabCount; i++)
                {
                    Child child2 = this.getChildForm1(i);
                    
                    if (this.openFileDialog1.FileName.Equals(child2.openFileDialog1.FileName))
                    {
                        break;
                    }
                }
                if ( i == tabControl1.TabCount )
                {
                    RichTextBox f = child.getRichTextBox();


                    if (Path.GetExtension(openFileDialog1.FileName) == ".rtf")
                        f.LoadFile(this.openFileDialog1.FileName.ToString(), RichTextBoxStreamType.RichText);
                    else
                        f.LoadFile(this.openFileDialog1.FileName.ToString(), RichTextBoxStreamType.PlainText);
                    
                    child.openFileDialog1.FileName = this.openFileDialog1.FileName.ToString();

                    TabPage newPage = new TabPage();

                    newPage.Text = this.openFileDialog1.SafeFileName.ToString();
                    newPage.Parent = tabControl1;
                    child.Parent = newPage;
                    child.Show();
                    tabControl1.SelectedTab = newPage;
                }
                else
                {
                    tabControl1.SelectedTab = tabControl1.TabPages[i];
                }
            }
            this.openFileDialog1.FileName = "";
        }

        private void 文件FToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void 保存SToolStripMenuItem_Click(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();         
            Child f = this.getChildForm();

            if ( r.Text == "" )
            {
                MessageBox.Show("当前文档内容为空，不允许保存空文件！","提示");
                return;
            }

            if ( f.openFileDialog1.FileName == "" )//当前编辑的文件是新建的新文件
            {
                TabPage tabPage3 = tabControl1.SelectedTab;
                this.saveFileDialog1.Title = "保存";
                this.saveFileDialog1.DefaultExt = "*.txt";
                this.saveFileDialog1.Filter = "文本文件(*.txt)|*.txt|富格式文件(*.rtf)|*.rtf|所有文件(*.*)|*.*";
                if ( f.saveFileDialog1.FileName  == "" ) //当前编辑的文件没有保存过
                {
                    if (this.saveFileDialog1.ShowDialog() == DialogResult.OK && this.saveFileDialog1.FileName.Length > 0)
                    {
                        tabPage3.Text = this.saveFileDialog1.FileName;
                        f.saveFileDialog1.FileName = this.saveFileDialog1.FileName.ToString();

                        // 如果扩展名为rtf格式，则以RTF格式保存文件，否则以普通文本格式保存文件
                        if ( Path.GetExtension(f.saveFileDialog1.FileName) == ".rtf" )
                            f.richTextBox1.SaveFile(f.saveFileDialog1.FileName, RichTextBoxStreamType.RichText);
                        else
                            f.richTextBox1.SaveFile(f.saveFileDialog1.FileName, RichTextBoxStreamType.PlainText);

                        r.Modified = false;

                    }
                    else
                    {
                        MessageBox.Show("您的文件尚未保存哦！", "提示");
                        return;
                    }
                }
                else //文件已经保存过了
                {
                    // 如果扩展名为rtf格式，则以RTF格式保存文件，否则以普通文本格式保存文件
                    if (Path.GetExtension(f.saveFileDialog1.FileName) == ".rtf")
                        f.richTextBox1.SaveFile(f.saveFileDialog1.FileName, RichTextBoxStreamType.RichText);
                    else
                        f.richTextBox1.SaveFile(f.saveFileDialog1.FileName, RichTextBoxStreamType.PlainText);   
                }
            }
            else//当前编辑的文件是打开的已存在文件
            {
                // 如果扩展名为rtf格式，则以RTF格式保存文件，否则以普通文本格式保存文件
                if (Path.GetExtension( f.openFileDialog1.FileName ) == ".rtf")
                    f.richTextBox1.SaveFile( f.openFileDialog1.FileName, RichTextBoxStreamType.RichText );
                else
                    f.richTextBox1.SaveFile( f.openFileDialog1.FileName, RichTextBoxStreamType.PlainText );
            }
            this.saveFileDialog1.FileName = "";
            this.openFileDialog1.FileName = "";
        }

        private void 另存为AToolStripMenuItem_Click(object sender, EventArgs e)
        {
            RichTextBox r = this.GetCurrentRichTextBox();
            Child f = this.getChildForm();
            this.saveFileDialog1.Title = "另存为...";
            this.saveFileDialog1.Filter = "文本文件(*.txt)|*.txt|所有文件(*.*)|*.*";
            this.saveFileDialog1.InitialDirectory = "桌面";
            this.saveFileDialog1.FileName = "";
            if (this.saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                f.saveFileDialog1.FileName = this.saveFileDialog1.FileName .ToString();
                f.richTextBox1.SaveFile(f.saveFileDialog1.FileName, RichTextBoxStreamType.RichText);
            }
            this.saveFileDialog1.FileName = "";
            this.openFileDialog1.FileName = "";
        }

        private void 打印PToolStripMenuItem_Click(object sender, EventArgs e)
        {
            RichTextBox r = this.GetCurrentRichTextBox();
            this.printDialog1.AllowPrintToFile = true;
            this.printDialog1.Document = this.PrintDocument;
            if (this.printDialog1.ShowDialog() == DialogResult.OK)
            {
                this.PrintDocument.Print();
            }
        }

        private void 退出XToolStripMenuItem_Click(object sender, EventArgs e)
        {        
            int i = 0;
            for ( i = tabControl1.TabCount-1; i >=0; i-- )
            {
                Child child2 = this.getChildForm1(i);
                RichTextBox n = child2.getRichTextBox();
                if (n.Modified == true)  //文档被修改了
                {
                    DialogResult f = MessageBox.Show("当前标签中的文档内容尚未保存！\n是否要保存?", "提示", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);
                    n.Focus();      //给予焦点
                    if ( f == DialogResult.Yes )
                    {
                        this.保存SToolStripMenuItem_Click(sender, e);
                        tabControl1.TabPages.RemoveAt(i);
                    }
                    else if (f == DialogResult.No)
                    {
                        tabControl1.TabPages.RemoveAt(i);
                    }
                    else
                    {
                        break;
                    }
                }
                else//文档没有被修改，直接关闭所在的标签
                {
                    tabControl1.TabPages.RemoveAt(i);
                }
                
            }

            if ( i == -1 )
            {
                Application.Exit();
            }
        }


           
        private void statusStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();
            
            this.toolStripStatusLabel3.Text = "正在执行：文件读写操作    ";
            this.toolStripStatusLabel4.Text = "当前文档字数合计：" + r.Text.Length;
            新建NToolStripMenuItem_Click(sender, e);               //打开编辑器时，首先建立一个标签
        }
        private void MyEdit_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.Cancel == false)
                退出XToolStripMenuItem_Click(sender, e);
        }

        private void 全选AToolStripMenuItem_Click(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();
            r.SelectAll();
        }

       public void 替换ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //RichTextBox r = new RichTextBox();
            r = this.GetCurrentRichTextBox();

            ReplaceDialog f = new ReplaceDialog();
            f.rtb = r; //传值（从主窗口传到FindForm）
            f.Owner = this; //悬浮于当前窗体
            f.Show();
        }

        public  void 查找ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();
            FindDialog f = new FindDialog();
            f.rtb = r;                     //传值（从主窗口传到FindForm）
            f.Owner = this;               //悬浮于当前窗体
            f.Show();

        }

        public void 剪切TToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
            r = this.GetCurrentRichTextBox();
            if (r.SelectedText == "")
                return;
            else
                r.Cut();
        }


        public  void 复制ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
            r = this.GetCurrentRichTextBox();
            if (r.SelectedText == "")
                return;
            else
                r.Copy();
        }

        public  void 粘贴ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
            r = this.GetCurrentRichTextBox();
            r.Paste();
        }

       public  void 撤销ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();
            r.Undo();
        }

        private void 打印预览VToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.pageSetupDialog1.Document = this.PrintDocument;
            this.pageSetupDialog1.ShowDialog();
        }

        public  void 字体_Click(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();
            this.fontDialog1.ShowEffects = true;
            this.fontDialog1.Font = r.SelectionFont;
            if (this.fontDialog1.ShowDialog() == DialogResult.OK)
            {
                r.SelectionFont = this.fontDialog1.Font;
            }
        }

        public void 颜色_Click(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();
            this.colorDialog1.AnyColor = true;
            this.colorDialog1.Color = r.SelectionColor;
            if (this.colorDialog1.ShowDialog() == DialogResult.OK)
            {
                r.SelectionColor = this.colorDialog1.Color;
            }
        }

        private void 自动换行ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            r = this.GetCurrentRichTextBox();
            if (this.自动换行ToolStripMenuItem.Checked == false)
            {
                this.自动换行ToolStripMenuItem.Checked = true;
                r.WordWrap = true;
            }
            else
            {
                this.自动换行ToolStripMenuItem.Checked = false;
                r.WordWrap = false;
            }
        }

        private void toolStripStatusLabel1_Click(object sender, EventArgs e)
        {

        }

       public  void 关闭ToolStripMenuItem_Click(object sender, EventArgs e)  //关闭当前标签
        {
            if (tabNum == 0)  // 当有0个标签是，不能关闭
                return;
            r = this.GetCurrentRichTextBox();
            if ( r.Modified == true )
            {
                DialogResult z = MessageBox.Show("您正要关闭的标签中，文件内容已经修改！\n是否要保存当前文件?", "提示！", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation);

                if ( z == DialogResult.Yes )
                {
                    this.保存SToolStripMenuItem_Click( sender, e );

                    tabControl1.TabPages.RemoveAt(tabControl1.SelectedIndex);
                    tabNum--;
                }
                else if ( z == DialogResult.No )
                {
                    tabControl1.TabPages.RemoveAt(tabControl1.SelectedIndex);
                    tabNum--;
                }
                else  //其他操作不响应
                {

                }


            }
            else
            {
                tabControl1.TabPages.RemoveAt(tabControl1.SelectedIndex);
                tabNum--;
            }

        }



       private void GetFontFamilies()
       {
           Graphics g = this.CreateGraphics();
           FontFamily[] ffs = FontFamily.Families;
           fontFamilyNames = new string[ffs.Length];
           for (int i = 0; i < ffs.Length; i++)
           {
               fontFamilyNames[i] = ffs[i].Name;
               //this.tSComboBoxFont.Items.Add(fontFamilyNames[i]);  // 逐个添加字体
           }
           this.tf.Items.AddRange(fontFamilyNames);      //一次性添加所有字体
       }

       private  void ts_addItems()
       {

           for (int i = 0; i <=50; i++)
           {
               this.ts.Items.Add(i.ToString());
           }
       }


       private void tSBtnLeft_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           r.SelectionAlignment = HorizontalAlignment.Left;
           setAlign(HorizontalAlignment.Left);
       }

       private void tSBtnCenter_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           r.SelectionAlignment = HorizontalAlignment.Center;
           setAlign(HorizontalAlignment.Center);
       }

       private void tSBtnRight_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           r.SelectionAlignment = HorizontalAlignment.Right;
           setAlign(HorizontalAlignment.Right);
       }

       private void setAlign(HorizontalAlignment align)
       {
           this.tSBtnLeft.Checked = false;
           this.tSBtnCenter.Checked = false;
           this.tSBtnRight.Checked = false;
           switch (align)
           {
               case HorizontalAlignment.Left:
                   this.tSBtnLeft.Checked = true;
                   break;
               case HorizontalAlignment.Center:
                   this.tSBtnCenter.Checked = true;
                   break;
               case HorizontalAlignment.Right:
                   this.tSBtnRight.Checked = true;
                   break;
           }
       }

       private void tf_SelectedIndexChanged(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           float fontSize;
           if (ts.SelectedIndex == -1)
               fontSize = 14;
           else
               fontSize = float.Parse(ts.SelectedItem.ToString());
           if (r.SelectedText.Length > 0)
           {
               r.SelectionFont = new Font(tf.Text, fontSize);
           }
       }

       private void ts_SelectedIndexChanged(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           string fontname;
           if ( tf.SelectedIndex == -1 ) 
               fontname = "宋体";
           else 
               fontname = tf.Text;
           if ( r.SelectedText.Length > 0 )
               r.SelectionFont = new Font(fontname, float.Parse(ts.SelectedItem.ToString()));
       }

       public  void r_SelectionChanged(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();

           Font currFont;
           //说明：判断有无选择字符串可根据SelectionLength来判断；
           //SelectionFont 等于null 并不等于没有选择字符串，可能是由于所选择的
           //   字符串中同时包含多个字体
           if (r.SelectionFont != null)
           {
               currFont = r.SelectionFont;
               tf.SelectedIndex = tf.FindString(currFont.Name);

               //设置粗体按钮
               //if ((editor.SelectionFont.Style & FontStyle.Bold) == FontStyle.Bold) this.tSBtnBold.Checked = true; else this.tSBtnBold.Checked = false;
               this.tSBtnBold.Checked = r.SelectionFont.Bold;
               this.tSBtnItalic.Checked = r.SelectionFont.Italic;
               this.tSBtnUnderline.Checked = r.SelectionFont.Underline;
           }
           else
               tf.SelectedIndex = -1;

           this.toolStripStatusLabel3.Text = "（光标）当前位置：行：" + r.GetLineFromCharIndex(r.SelectionStart).ToString();
           this.toolStripStatusLabel3.Text += "  列：" + (r.SelectionStart - r.GetFirstCharIndexOfCurrentLine()).ToString();
           setAlign(r.SelectionAlignment);  //设置对齐方式按钮的多选一效果
       }

       private void tSBtnBold_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           if (r.SelectionFont.Bold)
               r.SelectionFont = new Font(r.SelectionFont, r.SelectionFont.Style ^ FontStyle.Bold);
           else
               r.SelectionFont = new Font(r.SelectionFont, r.SelectionFont.Style | FontStyle.Bold);
       }

       private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
       {

       }

       private void tf_Click(object sender, EventArgs e)
       {

       }

       private void tSBtnItalic_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           if ( r.SelectionFont.Italic )
               r.SelectionFont = new Font(r.SelectionFont, r.SelectionFont.Style ^ FontStyle.Italic);
           else
               r.SelectionFont = new Font(r.SelectionFont, r.SelectionFont.Style | FontStyle.Italic);

       }

       private void tSBtnUnderline_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           if (r.SelectionFont.Underline)
               r.SelectionFont = new Font(r.SelectionFont, r.SelectionFont.Style ^ FontStyle.Underline);
           else
               r.SelectionFont = new Font(r.SelectionFont, r.SelectionFont.Style | FontStyle.Underline);

       }

       public void 恢复RToolStripMenuItem1_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           r.Redo();

       }

       public void 清空内容ToolStripMenuItem_Click(object sender, EventArgs e)
       {
           r = this.GetCurrentRichTextBox();
           r.Clear();
           r.Modified = true;  //默认情况下，Clear()后，修改标志也被清除，这里设为true

       }

       private void 格式TToolStripMenuItem1_Click(object sender, EventArgs e)
       {

       }

       private void saveFileDialog1_FileOk(object sender, CancelEventArgs e)
       {

       }

       private void toolStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
       {

       }

       private void tf_Click_1(object sender, EventArgs e)
       {

       }

       private void TabRightClick_Opening(object sender, CancelEventArgs e)
       {

       }

       private void PrintDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
       {

       }

       private void fontDialog1_Apply(object sender, EventArgs e)
       {

       }

       private void 关于ToolStripMenuItem_Click(object sender, EventArgs e)
       {

       }

       private void 文件FToolStripMenuItem1_Click(object sender, EventArgs e)
       {

       }

       private void 关于本程序ToolStripMenuItem_Click(object sender, EventArgs e)
       {
           AboutDialog about = new AboutDialog();
           if (about.ShowDialog() == DialogResult.OK )
               return;
       }

       private void 帮助HToolStripMenuItem1_Click(object sender, EventArgs e )
       {
           
       }

       private void toolStripStatusLabel3_Click(object sender, EventArgs e)
       {

       }

       private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
       {
           this.Show();
           if (this.WindowState == FormWindowState.Minimized)
               this.WindowState = FormWindowState.Normal;
           this.Activate();
       }

       private void MyEdit_Resize(object sender, EventArgs e)
       {
           if (this.WindowState == FormWindowState.Minimized)
               this.Hide();
       }

       private void notifyIcon1_MouseDoubleClick(object sender, EventArgs e)
       {
           notifyIcon1_MouseDoubleClick(sender, e);
       }


    }  
    
}
