<?xml version="1.0" encoding="utf-8"?>
<!--
Feed View XSLT Template v 1.0
SiC 2007-03-02 11:26:39
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
								xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
								xmlns:rss09="http://my.netscape.com/rdf/simple/0.9/"
								xmlns:rss1="http://purl.org/rss/1.0/"
								xmlns:atom03="http://purl.org/atom/ns#"
								xmlns:atom1="http://www.w3.org/2005/Atom"

								xmlns:dc="http://purl.org/dc/elements/1.1/" 
								xmlns:dcterms="http://purl.org/dc/terms/"
								xmlns:content="http://purl.org/rss/1.0/modules/content/"
								xmlns:annotate="http://purl.org/rss/1.0/modules/annotate/"
								xmlns:reqv="http://purl.org/rss/1.0/modules/richequiv/"
								xmlns:slash="http://purl.org/rss/1.0/modules/slash/"
								xmlns:image="http://purl.org/rss/1.0/modules/image/"
								xmlns:l="http://purl.org/rss/1.0/modules/link"
								xmlns:syn="http://purl.org/rss/1.0/modules/syndication/"
								xmlns:admin="http://webns.net/mvcb/"
								xmlns:cc="http://web.resource.org/cc/"

								exclude-result-prefixes="rdf dc atom03 atom1 dcterms rss1 rss09 content annotate admin image cc reqv slash syn l"

								version="1.0">
								
	<xsl:output
		indent="yes" omit-xml-declaration="yes"
		method="html" encoding="utf-8"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	/>

	<xsl:preserve-space elements="*"/>

	<!-- //////////////////// Main ///////////////////////////////// -->
	
	<!-- ********* main ********* -->
	<xsl:template match="/">
		<xsl:apply-templates select="/rss"/>
		<xsl:apply-templates select="/rdf:RDF"/>
		<xsl:apply-templates select="/atom03:feed"/>
		<xsl:apply-templates select="/atom1:feed"/>
	</xsl:template>


	<!-- sub : wrapper -->
	<xsl:template name="outputWrapper">

		<xsl:param name="title"/>
		<xsl:param name="link"/>
		<xsl:param name="type"/>
		<xsl:param name="items"/>

		<html xmlns="http://www.w3.org/1999/xhtml">
		<!-- saved from url=(0014)about:internet -->
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			<title><xsl:value-of select="$type"/> :: <xsl:value-of select="$title"/></title>
			<link rel="stylesheet" href="/?$LOCALREL$???SECURITYID??/Template/_shared/css/base.css" type="text/css" />
			<link rel="stylesheet" href="/?$LOCALREL$???SECURITYID??/Template/FeedView/feed.css" type="text/css" />
			<script type="text/javascript" src="/?$LOCALREL$???SECURITYID??/Template/_shared/js/func.js"></script>
			<script type="text/javascript" src="/?$LOCALREL$???SECURITYID??/Template/FeedView/feed.js"></script>
		</head>

		<body>
			<xsl:attribute name="onload">maxFeedView.rebuildContent(<xsl:value-of select="count($items)"/>)</xsl:attribute>

	<div class="contentWrapper">

		<div class="content">
			<div class="innerContent">
				
				<div class="feed-note">
					<h3>
						<img src="/?$LOCALREL$???SECURITYID??/Template/FeedView/images/feed.png" alt=""/>
						<a href="{$link}" target="_blank"><xsl:value-of select="$title"/></a>
						<span class="feed-type">
							&#160;&#160;[<xsl:value-of select="$type"/>]
						</span>
					</h3>
					<p><script type="text/javascript">maxFeedView.writeLang("explain")</script></p>
					<p>
						<a href="javascript:;" onclick="maxFeedView.addFeed();"><script type="text/javascript">maxFeedView.writeLang("add_feed")</script></a>
					</p>
				</div>

				<xsl:apply-templates select="$items">
					<xsl:with-param name="mode" select="'full'"/>
				</xsl:apply-templates>

			</div>
		</div>

		<div class="sidebar">
			<div class="innerSidebar">

				<div class="sidebarBlock">
				<div class="sidebarContent">
					<ul>
						<xsl:apply-templates select="$items">
							<xsl:with-param name="mode" select="'list'"/>
						</xsl:apply-templates>
					</ul>
				</div>
				</div>

			</div>
		</div>

	</div>

		</body>

		</html>

	</xsl:template>

	
	<!-- sub : title list -->
	<xsl:template name="outputList">

		<xsl:param name="title"/>
		<xsl:param name="link"/>
		<xsl:param name="escape_title" select="1"/>

		<li>
			<a href="#{generate-id($link)}" title="{$title}" id="nav_{position()}">
				<xsl:value-of select="position()"/>
				»
				<xsl:choose>
					<xsl:when test="$escape_title=1">
						<xsl:value-of select="$title"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$title" disable-output-escaping="yes" />
					</xsl:otherwise>
				</xsl:choose>
			</a>
		</li>

	</xsl:template>


	<!-- sub : item blocks -->
	<xsl:template name="outputItem">

		<xsl:param name="title"/>
		<xsl:param name="link"/>
		<xsl:param name="author"/>
		<xsl:param name="date"/>
		<xsl:param name="description" select="''"/>
		<xsl:param name="escape_desc" select="1"/>
		<xsl:param name="escape_title" select="1"/>

		<div class="contentBlock">
		<div class="contentText">
			<a name="{generate-id($link)}" />
			<h4>
				<div class="go-top">
					<a href="javascript:window.scroll(0,0);">
						<img src="/?$LOCALREL$???SECURITYID??/Template/FeedView/images/go_top.png" alt=""/>
					</a>
				</div>
				<a href="{$link}" target="_blank">
					<xsl:attribute name="id">title_<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:value-of select="position()"/>
					»
					<xsl:choose>
						<xsl:when test="$escape_title=1">
							<xsl:value-of select="$title"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$title" disable-output-escaping="yes" />
						</xsl:otherwise>
					</xsl:choose>
				</a>
			</h4>
			<p class="label">
				<xsl:value-of select="$date"/>
				<xsl:if test="$author!='' and $author!=''"> | </xsl:if>
				<xsl:value-of select="$author"/>
			</p>
			<div>
				<xsl:attribute name="id">content_<xsl:value-of select="position()"/></xsl:attribute>
			</div>
			<pre style="display:none">
				<xsl:attribute name="id">content_data_<xsl:value-of select="position()"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="$escape_desc=1">
						<xsl:value-of select="$description" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$description" disable-output-escaping="yes" />
					</xsl:otherwise>
				</xsl:choose>
			</pre>
			<br style="clear:left" />
		</div>
		</div>

	</xsl:template>	
	

	<!-- //////////////////// Helper Templates ///////////////////////////////// -->
	
	<!-- ********* RSS 2.0/0.92 ********* -->
	<!-- sub : wrapper -->
	<xsl:template match="/rss">

		<xsl:call-template name="outputWrapper">
			<xsl:with-param name="type" select="concat('RSS ', /rss/@version)"/>
			<xsl:with-param name="title" select="//channel/title"/>
			<xsl:with-param name="link" select="//channel/link"/>
			<xsl:with-param name="items" select="channel/item"/>
		</xsl:call-template>

	</xsl:template>

	<!-- sub : item -->
	<xsl:template match="channel/item">

		<xsl:param name="mode" select="'full'" />

		<xsl:choose>
			<xsl:when test="$mode='list'">
				<xsl:call-template name="outputList">
					<xsl:with-param name="title" select="title"/>
					<xsl:with-param name="link" select="link"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="outputItem">
					<xsl:with-param name="title" select="title"/>
					<xsl:with-param name="link" select="link"/>
					<xsl:with-param name="description" select="description"/>
					<xsl:with-param name="author" select="author"/>
					<xsl:with-param name="date" select="pubDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<!-- ********* RSS 1.0 & 0.9 ********* -->
	<!-- sub : wrapper -->
	<xsl:template match="/rdf:RDF">

		<xsl:choose>
			<xsl:when test="count(rss09:item)&gt;0">
				<xsl:call-template name="outputWrapper">
					<xsl:with-param name="type" select="'RSS 0.9'"/>
					<xsl:with-param name="title" select="//rss09:channel/rss09:title"/>
					<xsl:with-param name="link" select="//rss09:channel/rss09:link"/>
					<xsl:with-param name="items" select="rss09:item"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="outputWrapper">
					<xsl:with-param name="type" select="'RSS 1.0'"/>
					<xsl:with-param name="title" select="//rss1:channel/rss1:title"/>
					<xsl:with-param name="link" select="//rss1:channel/rss1:link"/>
					<xsl:with-param name="items" select="rss1:item"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<!-- sub : item 0.9 -->
	<xsl:template match="rss09:item">

		<xsl:param name="mode" select="'full'" />

		<xsl:choose>
			<xsl:when test="$mode='list'">
				<xsl:call-template name="outputList">
					<xsl:with-param name="title" select="rss09:title"/>
					<xsl:with-param name="link" select="rss09:link"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="outputItem">
					<xsl:with-param name="title" select="rss09:title"/>
					<xsl:with-param name="link" select="rss09:link"/>
					<xsl:with-param name="description" select="rss09:description"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<!-- sub : item 1.0 -->
	<xsl:template match="rss1:item">

		<xsl:param name="mode" select="'full'" />

		<xsl:choose>
			<xsl:when test="$mode='list'">
				<xsl:call-template name="outputList">
					<xsl:with-param name="title" select="rss1:title"/>
					<xsl:with-param name="link" select="rss1:link"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="outputItem">
					<xsl:with-param name="title" select="rss1:title"/>
					<xsl:with-param name="link" select="rss1:link"/>
					<xsl:with-param name="description" select="rss1:description"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<!-- ********* Atom 0.3 ********* -->
	<!-- sub : wrapper -->
	<xsl:template match="/atom03:feed">

		<xsl:call-template name="outputWrapper">
			<xsl:with-param name="type" select="'Atom 0.3'"/>
			<xsl:with-param name="title" select="atom03:title"/>
			<xsl:with-param name="link" select="atom03:link[@rel='alternate' and @type='text/html']/@href"/>
			<xsl:with-param name="items" select="atom03:entry"/>
		</xsl:call-template>

	</xsl:template>

	<!-- sub : item -->
	<xsl:template match="atom03:entry">

		<xsl:param name="mode" select="'full'" />

		<xsl:variable name="desc">
		<xsl:choose>
			<xsl:when test="atom03:content[contains(@type,'html')]">
				<xsl:value-of select="atom03:content[contains(@type, 'html')]"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="atom03:summary"/>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$mode='list'">
				<xsl:call-template name="outputList">
					<xsl:with-param name="title" select="atom03:title"/>
					<xsl:with-param name="link" select="atom03:link[@rel='alternate' and @type='text/html']/@href"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="outputItem">
					<xsl:with-param name="title" select="atom03:title"/>
					<xsl:with-param name="link" select="atom03:link[@rel='alternate' and @type='text/html']/@href"/>
					<xsl:with-param name="description" select="$desc"/>
					<xsl:with-param name="author" select="atom03:author/atom03:name"/>
					<xsl:with-param name="date" select="atom03:modified"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>


	<!-- ********* Atom 1.0 ********* -->
	<!-- sub : wrapper -->
	<xsl:template match="/atom1:feed">

		<xsl:call-template name="outputWrapper">
			<xsl:with-param name="type" select="'Atom 1.0'"/>
			<xsl:with-param name="title" select="atom1:title"/>
			<xsl:with-param name="link" select="atom1:link[@rel='alternate' and @type='text/html']/@href"/>
			<xsl:with-param name="items" select="atom1:entry"/>
		</xsl:call-template>

	</xsl:template>

	<!-- sub : item -->
	<xsl:template match="atom1:entry">
		
		<xsl:param name="mode" select="'full'"/>
		
		<!-- title -->
		<xsl:variable name="title">
		<xsl:choose>
			<xsl:when test="atom1:title[@type='xhtml']">
				<xsl:value-of select="atom1:title[@type='xhtml']/div"/>
			</xsl:when>
			<xsl:when test="atom1:title[@type='html']">
				<xsl:value-of select="atom1:title[@type='html']"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="atom1:title"/>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:variable>

		<xsl:variable name="escape_title">
		<xsl:choose>
			<xsl:when test="atom1:title[contains(@type,'html')]">
				<xsl:value-of select="0"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="1"/>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:variable>

		<!-- description -->
		<xsl:variable name="desc">
		<xsl:choose>
			<xsl:when test="atom1:content[@type='xhtml']">
				<xsl:value-of select="atom1:content[@type='xhtml']/div"/>
			</xsl:when>
			<xsl:when test="atom1:content[@type='html']">
				<xsl:value-of select="atom1:content[@type='html']"/>
			</xsl:when>
			<xsl:when test="atom1:summary[@type='xhtml']">
				<xsl:value-of select="atom1:summary[@type='xhtml']/div"/>
			</xsl:when>
			<xsl:when test="atom1:summary[@type='html']">
				<xsl:value-of select="atom1:summary[@type='html']"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="atom1:summary"/>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$mode='list'">
				<xsl:call-template name="outputList">
					<xsl:with-param name="title" select="atom1:title"/>
					<xsl:with-param name="escape_title" select="$escape_title"/>
					<xsl:with-param name="link" select="atom1:link[@rel='alternate' or @type='text/html']/@href"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="outputItem">
					<xsl:with-param name="title" select="$title"/>
					<xsl:with-param name="escape_title" select="$escape_title"/>
					<xsl:with-param name="link" select="atom1:link[@rel='alternate' or @type='text/html']/@href"/>
					<xsl:with-param name="description" select="$desc"/>
					<xsl:with-param name="author" select="atom1:author/atom1:name"/>
					<xsl:with-param name="date" select="atom1:updated"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

</xsl:stylesheet>