ToRegEx(FilterTxt)
{
   ;;; Process the following char to convert into RegExp
   ;;; (1) x -> \x
   ;;;     \	.	,	:	;	/	[	]	^	$	+	(	)	&	~	?	-	=
;   FilterTxt:=RegExReplace(FilterTxt, "is)([\\\.\,\:\;\/\[\]\^\$\+\(\)\&\~\?\-\=])", "\$1")
   StringReplace FilterTxt, FilterTxt, \, \\, ALL
   StringReplace FilterTxt, FilterTxt, ., \., ALL
   StringReplace FilterTxt, FilterTxt, `,, \`,, ALL
   StringReplace FilterTxt, FilterTxt, :, \:, ALL
   StringReplace FilterTxt, FilterTxt, `;, \`;, ALL
   StringReplace FilterTxt, FilterTxt, /, \/, ALL
   StringReplace FilterTxt, FilterTxt, [, \[, ALL
   StringReplace FilterTxt, FilterTxt, ], \], ALL
   StringReplace FilterTxt, FilterTxt, ^, \^, ALL
   StringReplace FilterTxt, FilterTxt, $, \$, ALL
   StringReplace FilterTxt, FilterTxt, +, \+, ALL
   StringReplace FilterTxt, FilterTxt, (, \(, ALL
   StringReplace FilterTxt, FilterTxt, ), \), ALL
   StringReplace FilterTxt, FilterTxt, &, \&, ALL
   StringReplace FilterTxt, FilterTxt, ~, \~, ALL
   StringReplace FilterTxt, FilterTxt, ?, \?, ALL
   StringReplace FilterTxt, FilterTxt, -, \-, ALL
   StringReplace FilterTxt, FilterTxt, =, \=, ALL

   ;;; (2) * -> .*
;   FilterTxt:=RegExReplace(FilterTxt, "is)\*", ".*")
   StringReplace FilterTxt, FilterTxt, *, .*, ALL

   ;;; (3) |... -> ^...
   ;;;     ...| -> ...$
;   FilterTxt:=RegExReplace(FilterTxt, "is)^\|", "^")
    If InStr(FilterTxt, "|") = 1
      FilterTxt := SubStr(FilterTxt, 2) 

;   FilterTxt:=RegExReplace(FilterTxt, "is)\|$", "$")
    If (InStr(FilterTxt, "|", false, 0) = StrLen(FilterTxt))
      FilterTxt := SubStr(FilterTxt, 1, StrLen(FilterTxt) - 1) 

   ;;; (4) other | -> \|
;   FilterTxt:=RegExReplace(FilterTxt, "is)\|", "\|")
   StringReplace FilterTxt, FilterTxt, |, \|, ALL

   Return FilterTxt
}
