#Include Grep.ahk

;;;;;;;;;;;;;;;;;;

MergeXML:
FileDelete SiteList.DB

_SQLite_Startup()
$iRC := _SQLite_OpenDB("SiteList.DB")

$iRC := _SQLite_Exec($SQLITE_h_DB, "Create table usitelist (domain, blackwhite, regexp, item);")
$iRC := _SQLite_Exec($SQLITE_h_DB, "Create index iusl on usitelist (domain, blackwhite, regexp, item);")
$iRC := _SQLite_Exec($SQLITE_h_DB, "Create table nsitelist (domain, blackwhite, regexp, item);")
$iRC := _SQLite_Exec($SQLITE_h_DB, "Create index insl on nsitelist (domain, blackwhite, regexp, item);")
$iRC := _SQLite_Exec($SQLITE_h_DB, "Create table ositelist (domain, blackwhite, regexp, item);")
$iRC := _SQLite_Exec($SQLITE_h_DB, "Create index iosl on ositelist (domain, blackwhite, regexp, item);")
$iRC := _SQLite_Exec($SQLITE_h_DB, "Create table tmp (domain, blackwhite, regexp, item);")
$iRC := _SQLite_Exec($SQLITE_h_DB, "Create index itmp on tmp (domain, blackwhite, regexp, item);")

$iRC := _SQLite_Exec($SQLITE_h_DB, "begin transaction a;")

Process_SiteList("Download\SiteList.xml", $SQLITE_h_DB, "nsitelist")
If Merge=1
{
  Process_SiteList("Download\oSiteList.xml", $SQLITE_h_DB, "ositelist")
  Process_SiteList(sSiteList . "\SiteList.xml", $SQLITE_h_DB, "usitelist")
}

$iRC := _SQLite_Exec($SQLITE_h_DB, "insert into tmp select * from usitelist except select * from ositelist union select * from nsitelist;")

$iRC := _SQLite_Exec($SQLITE_h_DB, "commit transaction a;")
;$iRC := _SQLite_Exec($SQLITE_h_DB, "vacuum;")

GoSub SQLgenSitelist

$iRC := _SQLite_CloseDB(-1)
$iRC := _SQLite_ShutDown()
Return

;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;
;; Sub-Routine to gen SiteList
;;;;;;;;;;;;;;;;;;
SQLgenSitelist:
$sSQL =
( 
   select domain,
          sum(case blackwhite when 'b' then 1 else 0 end) bl,
          sum(case blackwhite when 'w' then 1 else 0 end) wl
   from tmp
   group by domain;
)
$iRC := _SQLite_GetTable($SQLITE_h_DB, $sSQL, $sResult, $iRows, $iCols, -1, 512)

;;;;;;;;;;;;;;;;;;
;; <sp>
;;;;;;;;;;;;;;;;;;
$vSiteList=
(
<?xml version="1.0" encoding="utf-8"?>
<sp>
)
Loop, Parse, $sResult, `n
{
   If (A_Index > 1)
   {
      StringSplit, $Field, A_LoopField, |
      Domain:=$Field1
      BL:=$Field2
      WL:=$Field3
      
;;;;;;;;;;;;;;;;;;
;; <m2filter d=domain
;;;;;;;;;;;;;;;;;;
$vSiteList=
(
%$vSiteList%
	<m2filter d="%Domain%" version="1.0">
)

;;;;;;;;;;;;;;;;;;
;; <blacklist....item
;;;;;;;;;;;;;;;;;;
      $Working=b
      If BL > 0
      {
         GoSub SQLGetItem
      }
      Else
      {
$vSiteList=
(
%$vSiteList%<blacklist/>
)
      }

;;;;;;;;;;;;;;;;;;
;; <whitelist....item
;;;;;;;;;;;;;;;;;;
      $Working=w
      If WL > 0
      {
         GoSub SQLGetItem
      }
      Else
      {
$vSiteList=
(
%$vSiteList%<whitelist/>
)
      }

;;;;;;;;;;;;;;;;;;
;; </m2filter>
;;;;;;;;;;;;;;;;;;
$vSiteList=
(
%$vSiteList%</m2filter>
)

   }
}

;;;;;;;;;;;;;;;;;;
;; </sp>
;;;;;;;;;;;;;;;;;;
$vSiteList=
(
%$vSiteList%
</sp>
)

FileDelete Download\SiteList.xml
FileAppend %$vSiteList%, Download\SiteList.xml
Return

;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;
;; Sub-Routine to retrieve blacklist/whitelist item
;;;;;;;;;;;;;;;;;;
SQLGetItem:
$sSQL =
( 
   select '<item mode="' || regexp || '">' || item || '</item>' rule
   from tmp
   where domain = '%DOMAIN%'
   and   blackwhite = '%$Working%'
   order by rule;
)
$iRC := _SQLite_GetTable($SQLITE_h_DB, $sSQL, $sResult, $iRows, $iCols, -1, 512)

If $Working=b
{
$vSiteList=
(
%$vSiteList%<blacklist>
)
}
else
{
$vSiteList=
(
%$vSiteList%<whitelist>
)
}

Loop, Parse, $sResult, `n
If (A_Index > 1)
{
$vSiteList=
(
%$vSiteList%%A_LoopField%
)
}

If $Working=b
{
$vSiteList=
(
%$vSiteList%</blacklist>
)
}
else
{
$vSiteList=
(
%$vSiteList%</whitelist>
)
}

Return

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;
;; break sitelist.xml and insert into SQLite tables
;;;;;;;;;;;;;;;;;;

Process_SiteList(filename, $SQLITE_h_DB, tablename)
{
  FileRead,XML,%filename% 
   
;  XML:=RegExReplace(XML, "is)(\t|\r|\n)", "")
  Grep(XML, "is)\<m2filter.*?\<\/m2filter\>", m2filter)
  StringSplit, m2filter, m2filter, % chr(4)
   
   ;--- For every entry of <m2filter.....</m2filter>
   Loop
   {
      if m2filter%A_Index% =
         break
      
      RegExMatch(m2filter%A_Index%, "is)\<m2filter.*?d\=\""(.*?)\""", Domain)
      Domain:=Domain1
      Domain1=
   
      ;---------- blacklist
      RegExMatch(m2filter%A_Index%, "is)(\<blacklist(\s*?\/\>|.*?\<\/blacklist\>))", filterList)
      blackwhite=b
      filterList:=filterList1
      filterList1=
      Process_list(Domain, blackwhite, filterList, $SQLITE_h_DB, tablename)

      ;---------- whitelist
      RegExMatch(m2filter%A_Index%, "is)(\<whitelist(\s*?\/\>|.*?\<\/whitelist\>))", filterList)
      blackwhite=w
      filterList:=filterList1
      filterList1=
      Process_list(Domain, blackwhite, filterList, $SQLITE_h_DB, tablename)
   }
}

;;;;;;;;;;;;;;;;;;
;; break item
;;;;;;;;;;;;;;;;;;
Process_list(Domain, blackwhite, filterList, $SQLITE_h_DB, tablename)
{
  Grep(filterList, "is)\<item.*?\<\/item\>", filterList)
  StringSplit, filterList, filterList, % chr(4)
  
  Loop
  {
     if filterList%A_Index% =
        break
        
     RegExMatch(filterList%A_Index%, "is)\<item.*?mode\=\""(.*?)\"".*?\>([^<]*)", item)
  
     ;--- If rules exists in new version then ignore
     $iRC := _SQLite_Exec($SQLITE_h_DB, "insert into " tablename " values ('" Domain "','" blackwhite "','" item1 "','" item2 "');")      
  }
}