#Include ToRegEx.ahk
;;;
;;; Get Maxthon2 Installed Path
;;;
GetMxPath()
{
   IfExist, %A_WorkingDir%\Maxthon.exe
      Return A_WorkingDir

   StringCaseSense Off
   MxPath := _GetMxFromRegistry()
   StringCaseSense On

   StringReplace MxPath, MxPath, \Maxthon.exe,, ALL
   Return MxPath
}

;;;
;;; Find Path to Maxthon2 via Registry
;;;
_GetMxFromRegistry()
{
   ;;;HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\Maxthon2\DisplayIcon
   ;;;   C:\Program Files\Maxthon2\Maxthon.exe
   RegRead, TmpPath, HKLM
          , SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Maxthon2
          , DisplayIcon

   if ErrorLevel
      TmpPath = c:\maxthon.exe

   IfExist, %TmpPath%
      Return TmpPath

   ;;;HKCR\<M2.Filter>\shell\open\command
   ;;;   M2.Filter, M2.Language, M2.Plugin, M2.Skin
   ;;;      C:\Program Files\Maxthon2\Maxthon.exe "%1"
   TmpPath:=_GetMxFromRegistry_MX("Filter")
   IfExist, %TmpPath%
      Return TmpPath
   TmpPath:=_GetMxFromRegistry_MX("Language")
   IfExist, %TmpPath%
      Return TmpPath
   TmpPath:=_GetMxFromRegistry_MX("Plugin")
   IfExist, %TmpPath%
      Return TmpPath
   TmpPath:=_GetMxFromRegistry_MX("Skin")
   IfExist, %TmpPath%
      Return TmpPath

   ;;; No Maxthon2 found
   MsgBox % GetMsg("MAXNotFound")
   ExitApp
}

_GetMxFromRegistry_MX(reg)
{
   ;;;HKCR\<M2.Filter>\shell\open\command
   ;;;   M2.Filter, M2.Language, M2.Plugin, M2.Skin
   ;;;      C:\Program Files\Maxthon2\Maxthon.exe "%1"
   ;;;   M2.Filter
   RegRead, TmpPath, HKCR, M2.%reg%\shell\open\command

   if ErrorLevel
      Return "c:\maxthon.exe"

   RegExMatch(TmpPath, "is)(?:[\""]*?)(.*?Maxthon\.exe)(?:[\""]*?[\s])",TmpPath)

   TmpPath=%TmpPath1%
;   StringLeft, TmpPath, TmpPath, StrLen(TmpPath) - 5
   IfExist, %TmpPath%
      Return TmpPath
   Else
      Return "c:\maxthon.exe"
}
;;;
;;; Get Last Logon a/c
;;;
GetMxLastAC(MxPath)
{
   iniFile:=_GetMxIni(MxPath)
   StringReplace LastAccount, iniFile, %MxPath%\,, ALL
   LastAccount := SubStr(LastAccount, 1, StrLen(LastAccount) - 18)
   Return LastAccount
}

;;;
;;; Get ini File name
;;;
_GetMxINI(MxPath)
{
   excludeINI=%MxPath%\Config\Config.ini
   excludeINI2=%MxPath%\Default\config\Config.ini
   
   iniList =
   Loop, %MxPath%\config.ini, 0 , 1
       iniList = %iniList%%A_LoopFileTimeModified%`t%A_LoopFileFullPath%`n

   Sort, iniList, R  ; Sort by date.
   Loop, parse, iniList, `n
   {
       if A_LoopField =  ; Omit the last linefeed (blank item) at the end of the list.
           continue
       StringSplit, iniItem, A_LoopField, %A_Tab%  ; Split into two parts at the tab char.

       If InStr(iniItem2,excludeINI)
            continue
       If InStr(iniItem2,excludeINI2)
            continue
       
       break
   ;    MsgBox, 4,, The next file (modified at %iniItem1%) is:`n%iniItem2%`n`nContinue?
   ;    IfMsgBox, No
   ;        break
   }
   iniFile := iniItem2
   iniList    =
   iniItem1   =
   iniItem2   =
   excludeINI =
;   iniFile=%MxPath%\Config\%iniFile%
   Return iniFile
}

;;;
;;; Get Language Setting of Current A/C
;;;
GetMxLang(MxPath, LastAccount)
{
   _IniRead( Lang, MxPath . "\" . LastAccount . "\Config\Config.ini"
            , "Settings", "Language", "English" )
   _IniRead( Lang, MxPath . "\Language\" . Lang . "\Language.ini"
            , "GENERAL", "language_id", "0x0409" )
   Return Lang
}

;;;;;;;;;;
;;; Multi-lang support
;;;;;;;;;;
GetMsg(MsgID)
{
   Global Lang

   _IniRead( TxtMsg, "Language\" . Lang . ".ini"
            , "General", MsgID, "null" )

   If TxtMsg=null
      _IniRead( TxtMsg, "Language\0x0409.ini"
                , "General", MsgID, "null" )

   If TxtMsg=null
      TxtMsg=%MsgID%

   Return TxtMsg
}

;;; INI Read to handle UTF-8
_IniRead(ByRef OutputVar, Filename, Section, Key, Default = "ERROR")
{
   IniRead, OutputVar, %Filename%, %Section%, %Key%, NOTFOUND-UTF8

   ;;; To handle UTF-8
   If OutputVar = NOTFOUND-UTF8
   {
      FileRead sFILE, %Filename%
      sRegEx = is)\[%Section%\][^\[]*?[\r\n]%Key%\s*?\=\s*?([^\r]*)
      RegExMatch(sFILE, sRegEx, OutputVar)
      OutputVar=%OutputVar1%
      OutputVar1=
      UTF8toASCII(OutputVar)
      sFILE=
   }
   If OutputVar =
   {
      OutputVar = %Default%
   }
}

#Include ChgCP.ahk
UTF8toASCII(ByRef Str)
{
;  ;UTF8 -> ASCII
;  Transform, Clipboard, Unicode, %Str%
;  Str=%Clipboard%
  Str:=UTF82Ansi(Str)
}
