/*
CP_ACP   = 0
CP_OEMCP = 1
CP_MACCP = 2
CP_UTF7  = 65000
CP_UTF8  = 65001
*/

Ansi2Oem(sString)
{
   Ansi2Unicode(sString, wString, 0)
   Unicode2Ansi(wString, zString, 1)
   Return zString
}

Oem2Ansi(zString)
{
   Ansi2Unicode(zString, wString, 1)
   Unicode2Ansi(wString, sString, 0)
   Return sString
}

Ansi2UTF8(sString)
{
   Ansi2Unicode(sString, wString, 0)
   Unicode2Ansi(wString, zString, 65001)
   Return zString
}

UTF82Ansi(zString)
{
   Ansi2Unicode(zString, wString, 65001)
   Unicode2Ansi(wString, sString, 0)
   Return sString
}

Ansi2Unicode(ByRef sString, ByRef wString, CP = 0)
{
    nLen := DllCall("MultiByteToWideChar"
    , "Uint", CP
    , "Uint", 0
    , "Uint", &sString
    , "int",  -1
    , "Uint", 0
    , "int",  0)

   VarSetCapacity(wString, nLen * 2)

   DllCall("MultiByteToWideChar"
      , "Uint", CP
      , "Uint", 0
      , "Uint", &sString
      , "int",  -1
      , "Uint", &wString
      , "int",  nLen)
   VarSetCapacity(wString, -1)
}

Unicode2Ansi(ByRef wString, ByRef sString, CP = 0)
{
   pString := wString + 1 > 65536 ? wString : &wString

    nLen := DllCall("WideCharToMultiByte"
    , "Uint", CP
    , "Uint", 0
    , "Uint", pString
    , "int",  -1
    , "Uint", 0
    , "int",  0
    , "Uint", 0
    , "Uint", 0)

   VarSetCapacity(sString, nLen)

   DllCall("WideCharToMultiByte"
      , "Uint", CP
      , "Uint", 0
      , "Uint", pString
      , "int",  -1
      , "str",  sString
      , "int",  nLen
      , "Uint", 0
      , "Uint", 0)
   VarSetCapacity(sString, -1)
}

;;;--- Convert Dec value to Hex, e.g. 255 -> FF
Hex(d) {
   VarSetCapacity(S,10)
   DllCall("msvcrt\sprintf", "Str",S, "Str","%02X","Int",d)
   VarSetCapacity(S, -1)
   Return S
}
