;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; AutoHotkey Setting
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#Include Base64.ahk
#Include RC4.ahk
#Include GetMxInfo.ahk
#Include SQLite.ahk
#Include SetIEProxy.ahk

#SingleInstance IGNORE
#NoEnv
#NoTrayIcon 
SendMode Input
SetBatchLines -1
Process Priority,,High

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; General Setting
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MxPath:=GetMxPath()
SetWorkingDir, %A_ScriptDir%

LastAccount:=GetMxLastAC(MxPath)
Lang:=GetMxLang(MxPath, LastAccount)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Loop, %0%  ; For each parameter:
{
   param := %A_Index%  ; Fetch the contents of the variable whose name is contained in A_Index.
   
   ;Path to SiteList.xml
   ;-setup
   
   ;-h=xxxxxxxx
   ;-u=url
   ;-wie=xxxxxxx
   
   ; else.... param error
   if param = -setup
      setup = 1
   else
      sSiteList = %param%
}

;;;;If Setup, Show Setup Screen and Exit
if setup
{
   GoSub Setup
   GUIExit()
}

GUIMsgBox("AdHunterEnhancer " GetMsg("Start"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Check if Update need
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Timeout = 1
Today := A_Now
_IniRead( LastUpdate, "version.ini", "Version", "LastUpdate", "19000101000000" )

;;;;;;;;;;;;;;
;;; Get & Set Proxy
;;;;;;;;;;;;;;
SetIEProxy()
_IniRead( Proxy, "version.ini", "Setting", "Proxy")

If Proxy=
  Proxy=
Else If Proxy = ERROR
  Proxy=
Else If Proxy = IE
  Proxy=
Else If Proxy = NONE
  Proxy=-x ""
Else
  Proxy=-x %Proxy%

;;;;;;;;;;
;;; Setup
;;;;;;;;;;

;;; Local FileName for curl
sLocalFileName=SiteList.zip

;;; Setup Path
sZipPath=Download\%sLocalFileName%

;;; URL of Zip file to be download
sForumURL=http://bbs.maxthon.cn/
sLoginURL=%sForumURL%logging.php?action=login
sPostURL=%sForumURL%viewthread.php?tid=27298

sLoginString=c87c6fc5bffa67ab63404d514fd61c8832899c9cc4db20bef7e5414e167164eff3793408c281ae6e1fa604998dfc94e8f84dcc4a614edb557fdf845127c5c2e303ebef9958987c330c303de168c0b5750fe0cb045b58b68b35eafb13ec206b3a40f424fd6f684748c6df71d19285addae357154e9d9be157d95e496c59b5f514e81c9ef009fdac8298b12f417388132d982517e7eabcd6eb806f11a0e1afaae1de5791889fb485c20e7e739597bea621fcd9697129f399caac370cd0

if sSiteList =
{
   sSiteList := _GetMxINI(MxPath)
;   sSiteList := RegExReplace(sSiteList, "is)\\config\.ini", "")
   sSiteList := SubStr(sSiteList, 1, StrLen(sSiteList) - 11)
}

IniWrite %Today%, version.ini, Version, LastUpdate

; Get IE default download folder, for updating from Local SiteList.zip
RegRead, sDownloadDirectory, HKEY_CURRENT_USER, Software\Microsoft\Internet Explorer, Download Directory
if ErrorLevel
  sDownloadDirectory=%MxPath%
  
; Check if Local file exist for updating
sLocalSiteList=0
IfExist, %sDownloadDirectory%\%sLocalFileName%
  sLocalSiteList=1

;;; Prepare the old version for data merging
FileDelete Download\oSiteList.xml
FileDelete Download\SiteList.xml
RunWait, 7za.exe x -o"Download" -y "%sZipPath%",, Hide UseErrorLevel
FileMove Download\SiteList.xml, Download\oSiteList.xml, 1

;;; If Updating from Local SiteList.zip, unzip the downloaded file into correct folder
If sLocalSiteList=1
{
  RunWait, 7za.exe x -o"Download" -y "%sDownloadDirectory%\%sLocalFileName%",, Hide UseErrorLevel
  If ErrorLevel <> 0
  {
     GUIMsgBox(GetMsg("ZIP"))
     GUIExit()
  }
  FileMove %sDownloadDirectory%\%sLocalFileName%, %sZipPath%, 1
  sVersion=Local File
}
;;; If Updating via cURL, download and unzip the file into correct folder
Else
{
  ;;; Copy old file for version checking
  FileDelete %sLocalFileName%
  FileCopy %sZipPath%, %sLocalFileName%, 1

  ;;; Remove old cookie & create new cookie to login forum
;  FileCopy cookie, cookie.txt
;  FileDelete cookie.txt

  sLoginString:=Base64Decode(RC4hex2txt(sLoginString, sPostURL))
  
  RunWait curl.exe %Proxy% --output "post" --data "%sLoginString%" "%sLoginURL%",, Hide UseErrorLevel
  If ErrorLevel <> 0
  {
;     FileDelete cookie.txt
     FileDelete post
     FileDelete header
     GUIMsgBox(GetMsg("Fail") . " (cURL - 1)")
     GUIExit()
  }

  ;;; Read Forum Post
  RunWait curl.exe %Proxy% --output "post" "%sPostURL%",, Hide UseErrorLevel
  If ErrorLevel <> 0
  {
;     FileDelete cookie.txt
     FileDelete post
     FileDelete header
     GUIMsgBox(GetMsg("Fail") . " (cURL - 2)")
     GUIExit()
  }

  ;;; Get Attached ZIP URL
  FileRead sPost, post
  FileDelete post
  If RegExMatch(sPost, "is)\<a href\=\""(attachment\.php\?aid\=[^\""]*)\"" [^\>]*\>SiteList\.zip\<\/a\>.*?\<p\>\s*([^\,]*)", sPost) <= 0
  {
;     FileDelete cookie.txt
     FileDelete header
    GUIMsgBox(GetMsg("Fail") . " (attachment)")
    GUIExit()
  }
  
  sPost:=sPost1
  sPost1=

  sFileDate:=sPost2
  sVersion:=sFileDate
  sPost2=

  ;;;;;;;;;;;;;;;;;;
  ;;; Check if update need
  ;;;;;;;;;;;;;;;;;;
  _IniRead( LastFileDate, "version.ini", "Version", "FileDate", "19000101000000" )
  If LastFileDate = %sFileDate%
  {
;    FileDelete cookie.txt
    FileDelete header
    FileDelete %sLocalFileName%
    
    GUIMsgBox(GetMsg("SameVersion"))
    GUIExit()
  }

  ;;; Download ZIP
  RunWait curl.exe %Proxy% --output "%sLocalFileName%" --time-cond "%sLocalFileName%" "%sForumURL%%sPost%",, Hide UseErrorLevel
  If ErrorLevel <> 0
  {
;     FileDelete cookie.txt
     FileDelete header
     GUIMsgBox(GetMsg("Fail") . " (cURL - 3)")
     GUIExit()
  }

;  FileDelete cookie.txt
  FileDelete header

  ;;; unzip the file into correct folder
  RunWait, 7za.exe x -o"Download" -y "%sLocalFileName%",, Hide UseErrorLevel
  If ErrorLevel <> 0
  {
     GUIMsgBox(GetMsg("ZIP"))
     GUIExit()
  }
  FileMove %sLocalFileName%, %sZipPath%, 1
}

;;; If Data Merging is required
_IniRead( Merge, "version.ini", "Setting", "Merge", "0" )
GoSub MergeXML

;;; Update SiteList.xml to Profile
FileCopy Download\SiteList.xml, %sSiteList%\SiteList.xml, 1

;;; Check if SiteListUpdater is installed and enabled
_IniRead( b_SiteListUpdater, MxPath "\" LastAccount "\Config\plugins.ini", "Paths", "SiteListUpdater", "0" )
If b_SiteListUpdater = 1
  IfExist, ..\SiteListUpdater\SiteListUpdater.exe
     RunWait, ..\SiteListUpdater\SiteListUpdater.exe,, Hide UseErrorLevel

;;; DONE
GUIMsgBox("AdHunterEnhancer`n" . GetMsg("Done") . ": " . sVersion, 350, 30)
If sLocalSiteList <> 1
{
  IniWrite %sFileDate%, version.ini, Version, FileDate
  IniWrite %sVersion%, version.ini, Version, Version
}
GUIExit()

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#Include MergeSiteList.ahk
#Include GUIMsgBox.ahk
#Include GUISetup.ahk
;;;;;;;;;;
;;; End
;;;;;;;;;;
