/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This software may be redistributed and/or modified under 
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * File: rhine_cfg.h
 *
 * Purpose: The vmns driver support header file.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Aug 15, 2003
 *
 */

#ifndef FET_CONFIG_H
#define FET_CONFIG_H

#include <linux/config.h>

typedef __u8	UCHAR,	*PUCHAR;
typedef __u16	U16,	*PU16;
typedef __u8	UINT8,	*PUINT8;
typedef __u32	U32,	*PU32;
typedef __u32	UINT32, *PUINT32;
typedef __u32	UINT, 	*PUINT;
typedef __u8	BYTE,	*PBYTE;
typedef __u8	U8,		*PU8;
typedef __u32	BOOL,	*PBOOL;
typedef __u16  	WORD,	*PWORD;
typedef __u32	DWORD,	*PDWORD;
typedef unsigned long	ULONG,	*PULONG;

typedef
struct _version {
	UINT8	major;
	UINT8	minor;
	UINT8	build;
} version_t, *pversion_t;

#ifndef	FALSE
#define	FALSE	(0)
#endif

#ifndef	TRUE
#define	TRUE	(!(FALSE))
#endif

#define VID_TABLE_SIZE		64
#define MCAST_TABLE_SIZE	64
#define MCAM_SIZE			32
#define VCAM_SIZE			32
#define TX_QUEUE_NO			8

#define RHINE_NAME			"rhinefet"
#define RHINE_FULL_DRV_NAM "VIA Rhine Family Fast Ethernet Adapter Driver"

#ifndef MAJOR_VERSION
#define MAJOR_VERSION		4
#endif

#ifndef MINOR_VERSION
#define MINOR_VERSION		30
#endif

#ifndef RHINE_VERSION
#define RHINE_VERSION		"4.32"
#endif

#define PKT_BUF_SZ			1540

#define MALLOC(x,y)			kmalloc((x),(y))
#define FREE(x)				kfree((x))
#define MAX_UINTS			8
#define	OPTION_DEFAULT		{ [0 ... MAX_UINTS-1] = -1}



typedef enum  _chip_type{
	VT86C100A=1,
	VT6102=2,
	VT6105=3,
	VT6105M=4
} CHIP_TYPE, *PCHIP_TYPE;

#endif
