assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("sweetpotatosouffle", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "VEGGIE"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_MED
    inst.components.edible.hungervalue = TUNING.CALORIES_LARGE
	inst.components.edible.sanityvalue = TUNING.SANITY_MED
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.SWEETPOTATOSOUFFLE = "Carrot Souffle"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.SWEETPOTATOSOUFFLE = "Carrot souffles are a rising trend."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.SWEETPOTATOSOUFFLE = "Cooked to perfection!"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.SWEETPOTATOSOUFFLE = "Wolfgang will eat!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.SWEETPOTATOSOUFFLE = "Delicate, but delicious."
STRINGS.CHARACTERS.WX78.DESCRIBE.SWEETPOTATOSOUFFLE = "OFFENSIVE"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.SWEETPOTATOSOUFFLE = "Quite delicious."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.SWEETPOTATOSOUFFLE = "Pretty extravagant!"
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.SWEETPOTATOSOUFFLE = "Why, this looks halfway palatable!"
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.SWEETPOTATOSOUFFLE = "It is filled with deliciöus air!"
STRINGS.CHARACTERS.WEBBER.DESCRIBE.SWEETPOTATOSOUFFLE = "It's so dainty."

return Prefab( "common/inventory/sweetpotatosouffle", fn, assets, prefabs)