assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("surfnturf", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_HUGE
    inst.components.edible.hungervalue = TUNING.CALORIES_LARGE
	inst.components.edible.sanityvalue = TUNING.SANITY_LARGE
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.SURFNTURF = "Surf 'n' Turf"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.SURFNTURF = "It's perf!"
STRINGS.CHARACTERS.WILLOW.DESCRIBE.SURFNTURF = "Ugh. This is old person food!"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.SURFNTURF = "Very good."
STRINGS.CHARACTERS.WENDY.DESCRIBE.SURFNTURF = "It could be worse."
STRINGS.CHARACTERS.WX78.DESCRIBE.SURFNTURF = "PREPARE FOR CALORIC INTAKE"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.SURFNTURF = "The perfect dish."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.SURFNTURF = "Good eating, that."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.SURFNTURF = "A very balanced meal, I suppose."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.SURFNTURF = "Yuck! Turf!"
STRINGS.CHARACTERS.WEBBER.DESCRIBE.SURFNTURF = "Eww, healthy!"

return Prefab( "common/inventory/surfnturf", fn, assets, prefabs)