assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("seafoodgumbo", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_LARGE
    inst.components.edible.hungervalue = TUNING.CALORIES_LARGE
	inst.components.edible.sanityvalue = TUNING.SANITY_MEDLARGE
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.SEAFOODGUMBO = "Seafood Gumbo"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEAFOODGUMBO = "It's a jumbo seafood gumbo."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.SEAFOODGUMBO = "Ew, what IS this?"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.SEAFOODGUMBO = "This will make very strong Wolfgang!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.SEAFOODGUMBO = "A sea once teeming with life. No more."
STRINGS.CHARACTERS.WX78.DESCRIBE.SEAFOODGUMBO = "READY FOR INGESTION"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.SEAFOODGUMBO = "I can feel the heartburn already!"
STRINGS.CHARACTERS.WOODIE.DESCRIBE.SEAFOODGUMBO = "We don't have this back home."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.SEAFOODGUMBO = "It looks passable."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.SEAFOODGUMBO = "A meal fit för a queen."
STRINGS.CHARACTERS.WEBBER.DESCRIBE.SEAFOODGUMBO = "We could eat it forever!"

return Prefab( "common/inventory/seafoodgumbo", fn, assets, prefabs)