assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("monstertartare", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_SMALL
    inst.components.edible.hungervalue = TUNING.CALORIES_LARGE
	inst.components.edible.sanityvalue = TUNING.SANITY_SMALL
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.MONSTERTARTARE = "Monster Tartare"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.MONSTERTARTARE = "There's got to be something else to eat around here."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.MONSTERTARTARE = "Gross!"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MONSTERTARTARE = "Blech!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.MONSTERTARTARE = "Looks good, tastes horrible."
STRINGS.CHARACTERS.WX78.DESCRIBE.MONSTERTARTARE = "IT WILL SUFFICE"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MONSTERTARTARE = "Monster meat, dressed up fancy."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.MONSTERTARTARE = "Isn't there anything else to eat?"
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.MONSTERTARTARE = "It's less than appetizing."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.MONSTERTARTARE = "Still quivering."
STRINGS.CHARACTERS.WEBBER.DESCRIBE.MONSTERTARTARE = "Looks amazing!"

return Prefab( "common/inventory/monstertartare", fn, assets, prefabs)