assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("jellyopop", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "VEGGIE"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_MED
    inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
	inst.components.edible.sanityvalue = 0
    inst.components.edible.temperaturedelta = TUNING.COLD_FOOD_BONUS_TEMP
    inst.components.edible.temperatureduration = TUNING.FOOD_TEMP_AVERAGE
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERFAST)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.JELLYOPOP = "Honey Pop"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.JELLYOPOP = "Honey pop it right in my mouth!"
STRINGS.CHARACTERS.WILLOW.DESCRIBE.JELLYOPOP = "I want twenty!"
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.JELLYOPOP = "Wolfgang can eat in one bite!" --"Looks like candy, but tastes like meat!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.JELLYOPOP = "I used to eat these with Abigail..." --"Death comes to us all. Sometimes on a stick."
STRINGS.CHARACTERS.WX78.DESCRIBE.JELLYOPOP = "IT WILL KEEP MY SYSTEMS RUNNING"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.JELLYOPOP = "Takes me back to my youth. Sort of."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.JELLYOPOP = "I guess this is a dessert island, eh?"
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.JELLYOPOP = "Hm... I don't think this meshes well with my cultivated look."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.JELLYOPOP = "I've sömehöw föund a way tö make it even LESS appealing!" --"I cöuld gö berserk ön these!"
STRINGS.CHARACTERS.WEBBER.DESCRIBE.JELLYOPOP = "Yummy!"

return Prefab( "common/inventory/jellyopop", fn, assets, prefabs)