assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("freshfruitcrepes", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "VEGGIE"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_HUGE
    inst.components.edible.hungervalue = TUNING.CALORIES_SUPERHUGE
	inst.components.edible.sanityvalue = TUNING.SANITY_MED
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.FRESHFRUITCREPES = "Fresh Fruit Crepes"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.FRESHFRUITCREPES = "Sugary fruit! Part of a balanced breakfast."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.FRESHFRUITCREPES = "Ooo la la."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.FRESHFRUITCREPES = "Manly midmorning brunch."
STRINGS.CHARACTERS.WENDY.DESCRIBE.FRESHFRUITCREPES = "Could I get this a la mode?"
STRINGS.CHARACTERS.WX78.DESCRIBE.FRESHFRUITCREPES = "READY FOR DELICIOUS CONSUMPTION"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.FRESHFRUITCREPES = "Sticky fingers will ensue."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.FRESHFRUITCREPES = "I can get maple syrup on that?"
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.FRESHFRUITCREPES = "Deserves to be eaten with fine silverware. Sadly, I've just my hands."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.FRESHFRUITCREPES = "Sö light and airy!"
STRINGS.CHARACTERS.WEBBER.DESCRIBE.FRESHFRUITCREPES = "Cripes! We can't wait for these crepes!"

return Prefab( "common/inventory/freshfruitcrepes", fn, assets, prefabs)