assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("ceviche", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_MED
    inst.components.edible.hungervalue = TUNING.CALORIES_MED
	inst.components.edible.sanityvalue = TUNING.SANITY_TINY
    inst.components.edible.temperaturedelta = TUNING.COLD_FOOD_BONUS_TEMP
    inst.components.edible.temperatureduration = TUNING.FOOD_TEMP_AVERAGE
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.CEVICHE = "Ceviche"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.CEVICHE = "Can I get a bigger bowl? This one looks a little shrimpy."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.CEVICHE = "It's still slimy."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CEVICHE = "It will be better in Wolfgang's belly!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.CEVICHE = "All I taste is my sadness..."
STRINGS.CHARACTERS.WX78.DESCRIBE.CEVICHE = "INITIATING MASTICATION PROTOCOL"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CEVICHE = "Could use a little more sauce."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.CEVICHE = "I'd be loonie not to eat this."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CEVICHE = "A delightful, cultured dish."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CEVICHE = "Fancy för my taste, but it'll dö."
STRINGS.CHARACTERS.WEBBER.DESCRIBE.CEVICHE = "Yucky!"

return Prefab( "common/inventory/ceviche", fn, assets, prefabs)