assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("californiaroll", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_MED
    inst.components.edible.hungervalue = TUNING.CALORIES_LARGE
	inst.components.edible.sanityvalue = TUNING.SANITY_SMALL
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.CALIFORNIAROLL = "California Roll"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.CALIFORNIAROLL = "But I don't have chopsticks."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.CALIFORNIAROLL = "Oh, goody. Fish rolled in seaweed."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.CALIFORNIAROLL = "Get in Wolfgang's stomach!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.CALIFORNIAROLL = "Crabbit, dressed up in a seaweed jacket."
STRINGS.CHARACTERS.WX78.DESCRIBE.CALIFORNIAROLL = "NUTRITION ROLLS"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.CALIFORNIAROLL = "Delicious makizushi."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.CALIFORNIAROLL = "I feel like a regular Vancouverite."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.CALIFORNIAROLL = "We meet again, crabbit."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.CALIFORNIAROLL = "That's just a mörsel öf fish fööd."
STRINGS.CHARACTERS.WEBBER.DESCRIBE.CALIFORNIAROLL = "Hmm, something smells fishy about this!"

return Prefab( "common/inventory/californiaroll", fn, assets, prefabs)