assets=
{
    Asset("ANIM", "anim/sw_cook_pot_food.zip"),
    Asset("ATLAS", "images/sw_inventoryimages.xml"),
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)
    
    inst:AddTag("preparedfood")
	
    inst.AnimState:SetBuild("sw_cook_pot_food")
	inst.AnimState:SetBank("food")
	inst.AnimState:PlayAnimation("bananapop", false)
	
	if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "VEGGIE"
	inst.components.edible.foodstate = "PREPARED"
	
    inst.components.edible.healthvalue = TUNING.HEALING_MED
    inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
	inst.components.edible.sanityvalue = TUNING.SANITY_LARGE
    inst.components.edible.temperaturedelta = TUNING.COLD_FOOD_BONUS_TEMP
    inst.components.edible.temperatureduration = TUNING.FOOD_TEMP_AVERAGE
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("tradable")
	
    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERFAST)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/sw_inventoryimages.xml"
	
	inst:AddComponent("bait")
	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	
    return inst
end

STRINGS.NAMES.BANANAPOP = "Banana Pop"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.BANANAPOP = "No, not brain freeze! I need that for science!"
STRINGS.CHARACTERS.WILLOW.DESCRIBE.BANANAPOP = "This is the opposite of burning."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.BANANAPOP = "Wolfgang can eat in one bite!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.BANANAPOP = "I used to eat these with Abigail..."
STRINGS.CHARACTERS.WX78.DESCRIBE.BANANAPOP = "STICK ADDON INSTALLED"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.BANANAPOP = "Well, isn't that refreshing?"
STRINGS.CHARACTERS.WOODIE.DESCRIBE.BANANAPOP = "I'd prefer maple taffy..."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.BANANAPOP = "Hm... I don't know what I was expecting."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.BANANAPOP = "I've sömehöw föund a way tö make it even LESS appealing!"
STRINGS.CHARACTERS.WEBBER.DESCRIBE.BANANAPOP = "Yaaay! Popsicle, popsicle!"

return Prefab( "common/inventory/bananapop", fn, assets, prefabs)