/* THIS FILE IS AUTOGENERATED FROM RTCPeerConnection.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_RTCPeerConnectionBinding_h
#define mozilla_dom_RTCPeerConnectionBinding_h

#include "RTCPeerConnectionBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsWeakReference.h"

class nsIDOMDataChannel;

namespace mozilla {

class DOMMediaStream;

namespace dom {

class DOMError;
struct DeprecatedRTCOfferOptionsSet;
struct DeprecatedRTCOfferOptionsSetAtoms;
class EventHandlerNonNull;
class MediaStreamTrack;
struct NativePropertyHooks;
class ObjectOrString;
class OwningObjectOrString;
class Promise;
class ProtoAndIfaceCache;
struct RTCAnswerOptions;
struct RTCConfiguration;
struct RTCDataChannelInit;
struct RTCDataChannelInitAtoms;
class RTCIceCandidate;
struct RTCOfferOptions;
struct RTCOfferOptionsAtoms;
class RTCPeerConnection;
struct RTCPeerConnectionAtoms;
class RTCPeerConnectionErrorCallback;
class RTCRtpReceiver;
class RTCRtpSender;
class RTCSessionDescription;
class RTCSessionDescriptionCallback;
class RTCStatsCallback;
class RTCStatsReport;
class VoidFunction;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {

enum class RTCSignalingState : uint32_t {
  Stable,
  Have_local_offer,
  Have_remote_offer,
  Have_local_pranswer,
  Have_remote_pranswer,
  Closed,
  EndGuard_
};

namespace RTCSignalingStateValues {
extern const EnumEntry strings[7];
} // namespace RTCSignalingStateValues

bool
ToJSValue(JSContext* aCx, RTCSignalingState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCIceGatheringState : uint32_t {
  New,
  Gathering,
  Complete,
  EndGuard_
};

namespace RTCIceGatheringStateValues {
extern const EnumEntry strings[4];
} // namespace RTCIceGatheringStateValues

bool
ToJSValue(JSContext* aCx, RTCIceGatheringState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCIceConnectionState : uint32_t {
  New,
  Checking,
  Connected,
  Completed,
  Failed,
  Disconnected,
  Closed,
  EndGuard_
};

namespace RTCIceConnectionStateValues {
extern const EnumEntry strings[8];
} // namespace RTCIceConnectionStateValues

bool
ToJSValue(JSContext* aCx, RTCIceConnectionState aArgument, JS::MutableHandle<JS::Value> aValue);


struct DeprecatedRTCOfferOptionsSet : public DictionaryBase
{
  Optional<bool> mMozBundleOnly;
  Optional<bool> mMozDontOfferDataChannel;
  Optional<bool> mOfferToReceiveAudio;
  Optional<bool> mOfferToReceiveVideo;

  DeprecatedRTCOfferOptionsSet();

  explicit inline DeprecatedRTCOfferOptionsSet(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline DeprecatedRTCOfferOptionsSet(const DeprecatedRTCOfferOptionsSet& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const DeprecatedRTCOfferOptionsSet& aOther);

private:
  static bool
  InitIds(JSContext* cx, DeprecatedRTCOfferOptionsSetAtoms* atomsCache);
};

namespace binding_detail {
struct FastDeprecatedRTCOfferOptionsSet : public DeprecatedRTCOfferOptionsSet
{
  inline FastDeprecatedRTCOfferOptionsSet()
    : DeprecatedRTCOfferOptionsSet(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCDataChannelInit : public DictionaryBase
{
  Nullable<uint16_t> mId;
  Optional<uint16_t> mMaxRetransmitNum;
  Nullable<uint16_t> mMaxRetransmitTime;
  Nullable<uint16_t> mMaxRetransmits;
  bool mNegotiated;
  bool mOrdered;
  Optional<bool> mOutOfOrderAllowed;
  Optional<bool> mPreset;
  nsString mProtocol;
  Optional<uint16_t> mStream;

  RTCDataChannelInit();

  explicit inline RTCDataChannelInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCDataChannelInit(const RTCDataChannelInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCDataChannelInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCDataChannelInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCDataChannelInit : public RTCDataChannelInit
{
  inline FastRTCDataChannelInit()
    : RTCDataChannelInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCOfferAnswerOptions : public DictionaryBase
{
  RTCOfferAnswerOptions();

  explicit inline RTCOfferAnswerOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCOfferAnswerOptions(const RTCOfferAnswerOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCOfferAnswerOptions& aOther);
};

namespace binding_detail {
struct FastRTCOfferAnswerOptions : public RTCOfferAnswerOptions
{
  inline FastRTCOfferAnswerOptions()
    : RTCOfferAnswerOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCAnswerOptions : public RTCOfferAnswerOptions
{
  RTCAnswerOptions();

  explicit inline RTCAnswerOptions(const FastDictionaryInitializer& )
    : RTCOfferAnswerOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCAnswerOptions(const RTCAnswerOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCAnswerOptions& aOther);
};

namespace binding_detail {
struct FastRTCAnswerOptions : public RTCAnswerOptions
{
  inline FastRTCAnswerOptions()
    : RTCAnswerOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCOfferOptions : public RTCOfferAnswerOptions
{
  bool mIceRestart;
  DeprecatedRTCOfferOptionsSet mMandatory;
  Optional<bool> mMozBundleOnly;
  Optional<bool> mMozDontOfferDataChannel;
  Optional<int32_t> mOfferToReceiveAudio;
  Optional<int32_t> mOfferToReceiveVideo;
  Optional<Sequence<DeprecatedRTCOfferOptionsSet>> mOptional;

  RTCOfferOptions();

  explicit inline RTCOfferOptions(const FastDictionaryInitializer& )
    : RTCOfferAnswerOptions(FastDictionaryInitializer()),
      mMandatory(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCOfferOptions(const RTCOfferOptions& aOther)
    : mMandatory(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const RTCOfferOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCOfferOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCOfferOptions : public RTCOfferOptions
{
  inline FastRTCOfferOptions()
    : RTCOfferOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RTCSessionDescriptionCallback : public CallbackFunction
{
public:
  explicit inline RTCSessionDescriptionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCSessionDescriptionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, RTCSessionDescription& sdp, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "RTCSessionDescriptionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, sdp, aRv);
  }

  inline void
  Call(RTCSessionDescription& sdp, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "RTCSessionDescriptionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, sdp, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, RTCSessionDescription& sdp, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, sdp, rv, aExecutionReason);
  }

  inline void
  Call(RTCSessionDescription& sdp, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(sdp, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const RTCSessionDescriptionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, RTCSessionDescription& sdp, ErrorResult& aRv);
};


class RTCPeerConnectionErrorCallback : public CallbackFunction
{
public:
  explicit inline RTCPeerConnectionErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCPeerConnectionErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, DOMError& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "RTCPeerConnectionErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, error, aRv);
  }

  inline void
  Call(DOMError& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "RTCPeerConnectionErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, error, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, DOMError& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, error, rv, aExecutionReason);
  }

  inline void
  Call(DOMError& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(error, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const RTCPeerConnectionErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, DOMError& error, ErrorResult& aRv);
};


class VoidFunction : public CallbackFunction
{
public:
  explicit inline VoidFunction(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline VoidFunction(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline VoidFunction(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline VoidFunction(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "VoidFunction";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "VoidFunction";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, rv, aExecutionReason);
  }

  inline void
  Call(const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const VoidFunction& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


class RTCStatsCallback : public CallbackFunction
{
public:
  explicit inline RTCStatsCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCStatsCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCStatsCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline RTCStatsCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, RTCStatsReport& report, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "RTCStatsCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, report, aRv);
  }

  inline void
  Call(RTCStatsReport& report, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "RTCStatsCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, report, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, RTCStatsReport& report, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, report, rv, aExecutionReason);
  }

  inline void
  Call(RTCStatsReport& report, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(report, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const RTCStatsCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, RTCStatsReport& report, ErrorResult& aRv);
};


namespace binding_detail {
class FastRTCSessionDescriptionCallback : public RTCSessionDescriptionCallback
{
public:
  explicit inline FastRTCSessionDescriptionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : RTCSessionDescriptionCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    RTCSessionDescriptionCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    RTCSessionDescriptionCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastRTCPeerConnectionErrorCallback : public RTCPeerConnectionErrorCallback
{
public:
  explicit inline FastRTCPeerConnectionErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : RTCPeerConnectionErrorCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    RTCPeerConnectionErrorCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    RTCPeerConnectionErrorCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastVoidFunction : public VoidFunction
{
public:
  explicit inline FastVoidFunction(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : VoidFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    VoidFunction::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    VoidFunction::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastRTCStatsCallback : public RTCStatsCallback
{
public:
  explicit inline FastRTCStatsCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : RTCStatsCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    RTCStatsCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    RTCStatsCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace RTCPeerConnectionBinding {

  typedef mozilla::dom::RTCPeerConnection NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::RTCPeerConnection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace RTCPeerConnectionBinding



class RTCPeerConnectionJSImpl : public CallbackInterface
{
public:
  explicit inline RTCPeerConnectionJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline RTCPeerConnectionJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  explicit inline RTCPeerConnectionJSImpl(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  void SetIdentityProvider(const nsAString& provider, const Optional<nsAString>& protocol, const Optional<nsAString>& username, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetIdentityAssertion(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateAnswer(const RTCAnswerOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetLocalDescription(RTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetLocalDescription(RTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetRemoteDescription(RTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetRemoteDescription(RTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> AddIceCandidate(RTCIceCandidate& candidate, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> AddIceCandidate(RTCIceCandidate& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocalStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<RTCRtpSender> AddTrack(MediaStreamTrack& track, DOMMediaStream& stream, const nsTArray<OwningNonNull<DOMMediaStream>>& moreStreams, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetSenders(nsTArray<RefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetReceivers(nsTArray<RefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void MozSelectSsrc(RTCRtpReceiver& receiver, uint16_t ssrcIndex, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetStats(const Optional<MediaStreamTrack*>& selector, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const RTCPeerConnectionJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<RTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<RTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<bool> GetCanTrickleIceCandidates(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetPeerIdentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddtrack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOntrack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetId(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOntrack(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, RTCPeerConnectionAtoms* atomsCache);
};


class RTCPeerConnection : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(RTCPeerConnection, mozilla::DOMEventTargetHelper)

private:
  RefPtr<RTCPeerConnectionJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  RTCPeerConnection(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

protected:
  virtual ~RTCPeerConnection();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<RTCPeerConnection> Constructor(const GlobalObject& global, JSContext* cx, const RTCConfiguration& configuration, const Optional<JS::Handle<JSObject*>>& constraints, ErrorResult& aRv);

  void SetIdentityProvider(const nsAString& provider, const Optional<nsAString>& protocol, const Optional<nsAString>& username, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetIdentityAssertion(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateAnswer(const RTCAnswerOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetLocalDescription(RTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetLocalDescription(RTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetRemoteDescription(RTCSessionDescription& description, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetRemoteDescription(RTCSessionDescription& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetLocalDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCSessionDescription> GetRemoteDescription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCSignalingState GetSignalingState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddIceCandidate(RTCIceCandidate& candidate, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddIceCandidate(RTCIceCandidate& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<bool> GetCanTrickleIceCandidates(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCIceGatheringState GetIceGatheringState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  RTCIceConnectionState GetIceConnectionState(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetPeerIdentity(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetId(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocalStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRemoteStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMMediaStream> GetStreamById(const nsAString& streamId, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void AddStream(DOMMediaStream& stream, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<RTCRtpSender> AddTrack(MediaStreamTrack& track, DOMMediaStream& stream, const Sequence<OwningNonNull<DOMMediaStream>>& moreStreams, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetSenders(nsTArray<RefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetReceivers(nsTArray<RefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void MozSelectSsrc(RTCRtpReceiver& receiver, uint16_t ssrcIndex, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnegotiationneeded(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnicecandidate(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsignalingstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddstream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddtrack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOntrack(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOntrack(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremovestream(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnremovestream(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOniceconnectionstatechange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetStats(const Optional<MediaStreamTrack*>& selector, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetStats(MediaStreamTrack* selector, RTCStatsCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<nsIDOMDataChannel> CreateDataChannel(const nsAString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOndatachannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCPeerConnectionBinding_h
