/*
Djinn Copyright © 2010-2016 Lost Decade Games, LLC

Indie Game Sim Copyright © 2016-2016 Lost Decade Games, LLC

Web: http://www.lostdecadegames.com
Email: hello@lostdecadegames.com
Twitter: @LostDecadeGames
*/

// Prevent browser drag and drop
document.body.addEventListener("dragover", function (e) {
	e.preventDefault();
	e.stopPropagation();
}, false);
document.body.addEventListener("drop", function (e) {
	e.preventDefault();
	e.stopPropagation();
}, false);

(function () {
	var win = nw.Window.get();

	// NW.js specific key binds
	window.addEventListener("keydown", function (e) {
		switch (e.keyIdentifier) {
			case "F11":
				win.toggleFullscreen();
				break;
		}
	}, false);
}());

var greenworks = require("./greenworks");

// Djinn globally accessible functions
// Everything in here should have a damn good reason for being global :)

// Bind a function to a specific context
// Global because function.bind is slower than a custom implementation
// Used everywhere, a lot so it'd be really tedious to include a file for bind
var bind = function globalBind (context, fn) {
	if (typeof fn == "string") {
		fn = context[fn];
	}
	return function globalBindInner () {
		fn.apply(context, arguments);
	};
};

// Merge N objects together
// I'd rather this live in utils/object but it's used in so many places :(
// TODO: Figure out how to move this out of global without a huge mess
var merge = function globalMerge () {
	var merged = {};
	for (var i = arguments.length - 1; i >= 0; --i) {
		var toMerge = arguments[i];

		if (typeof toMerge != "object") { continue; }

		for (var key in toMerge) {
			var prop = toMerge[key];
			if (prop === undefined) { continue; }

			if (prop && typeof prop.concat == "function") {
				// An array
				merged[key] = prop.concat([]);
			} else if (prop && prop.constructor === Object) {
				// A merge-able object
				merged[key] = arguments.callee(prop, merged[key]);
			} else {
				// A scalar or un-mergeable object
				// WARNING: This will copy the reference to an object!
				merged[key] = prop;
			}
		}
	}
	return merged;
};

var djinn = {
	manifest: {"title":"Indie Game Sim","description":"Become the game developer of your dreams.","entry":"title","version":"1.0.0","demo":false,"pirates":false,"cursor":false,"pixelated":true,"port":8832,"shortName":"igs","launch":"js/Main","node-main":"app.js","keywords":"indie game sim, game dev, development, indie, sim, simulation, simulator, platformer, windows, mac","size":[256,144],"steam":{"appId":549740},"developer":{"name":"Lost Decade Games, LLC","minCopyrightYear":2016,"url":"http://www.lostdecadegames.com","email":"hello@lostdecadegames.com","twitter":"@LostDecadeGames"},"icons":{"16":"media/images/icons/16.png","19":"media/images/icons/19.png","29":"media/images/icons/29.png","42":"media/images/icons/42.png","48":"media/images/icons/48.png","114":"media/images/icons/114.png","128":"media/images/icons/128.png","256":"media/images/icons/256.png","favicon":"media/images/icons/favicon.ico"}},
	platform: "steam"
};

/**
 * @license almond 0.2.9 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/*!
 *  howler.js v1.1.21
 *  howlerjs.com
 *
 *  (c) 2013-2014, James Simpson of GoldFire Studios
 *  goldfirestudios.com
 *
 *  MIT License
 */

/*
	var blue = [89, 125, 206];
	var complementaryColor = function(c) {
		return [ (c[0] ^ 0xff), (c[1] ^ 0xff), (c[2] ^ 0xff) ];
	};
	var cc = complementaryColor(blue);
	var r = cc[0];
	var g = cc[1];
	var b = cc[2];
	this.backgroundColor = "rgb("+r+","+g+","+b+")";
	*/

(function(){var e,t,n;(function(r){function v(e,t){return h.call(e,t)}function m(e,t){var n,r,i,s,o,u,a,f,c,h,p,v=t&&t.split("/"),m=l.map,g=m&&m["*"]||{};if(e&&e.charAt(0)===".")if(t){v=v.slice(0,v.length-1),e=e.split("/"),o=e.length-1,l.nodeIdCompat&&d.test(e[o])&&(e[o]=e[o].replace(d,"")),e=v.concat(e);for(c=0;c<e.length;c+=1){p=e[c];if(p===".")e.splice(c,1),c-=1;else if(p===".."){if(c===1&&(e[2]===".."||e[0]===".."))break;c>0&&(e.splice(c-1,2),c-=2)}}e=e.join("/")}else e.indexOf("./")===0&&(e=e.substring(2));if((v||g)&&m){n=e.split("/");for(c=n.length;c>0;c-=1){r=n.slice(0,c).join("/");if(v)for(h=v.length;h>0;h-=1){i=m[v.slice(0,h).join("/")];if(i){i=i[r];if(i){s=i,u=c;break}}}if(s)break;!a&&g&&g[r]&&(a=g[r],f=c)}!s&&a&&(s=a,u=f),s&&(n.splice(0,u,s),e=n.join("/"))}return e}function g(e,t){return function(){return s.apply(r,p.call(arguments,0).concat([e,t]))}}function y(e){return function(t){return m(t,e)}}function b(e){return function(t){a[e]=t}}function w(e){if(v(f,e)){var t=f[e];delete f[e],c[e]=!0,i.apply(r,t)}if(!v(a,e)&&!v(c,e))throw new Error("No "+e);return a[e]}function E(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function S(e){return function(){return l&&l.config&&l.config[e]||{}}}var i,s,o,u,a={},f={},l={},c={},h=Object.prototype.hasOwnProperty,p=[].slice,d=/\.js$/;o=function(e,t){var n,r=E(e),i=r[0];return e=r[1],i&&(i=m(i,t),n=w(i)),i?n&&n.normalize?e=n.normalize(e,y(t)):e=m(e,t):(e=m(e,t),r=E(e),i=r[0],e=r[1],i&&(n=w(i))),{f:i?i+"!"+e:e,n:e,pr:i,p:n}},u={require:function(e){return g(e)},exports:function(e){var t=a[e];return typeof t!="undefined"?t:a[e]={}},module:function(e){return{id:e,uri:"",exports:a[e],config:S(e)}}},i=function(e,t,n,i){var s,l,h,p,d,m=[],y=typeof n,E;i=i||e;if(y==="undefined"||y==="function"){t=!t.length&&n.length?["require","exports","module"]:t;for(d=0;d<t.length;d+=1){p=o(t[d],i),l=p.f;if(l==="require")m[d]=u.require(e);else if(l==="exports")m[d]=u.exports(e),E=!0;else if(l==="module")s=m[d]=u.module(e);else if(v(a,l)||v(f,l)||v(c,l))m[d]=w(l);else{if(!p.p)throw new Error(e+" missing "+l);p.p.load(p.n,g(i,!0),b(l),{}),m[d]=a[l]}}h=n?n.apply(a[e],m):undefined;if(e)if(s&&s.exports!==r&&s.exports!==a[e])a[e]=s.exports;else if(h!==r||!E)a[e]=h}else e&&(a[e]=n)},e=t=s=function(e,t,n,a,f){if(typeof e=="string")return u[e]?u[e](t):w(o(e,t).f);if(!e.splice){l=e,l.deps&&s(l.deps,l.callback);if(!t)return;t.splice?(e=t,t=n,n=null):e=r}return t=t||function(){},typeof n=="function"&&(n=a,a=f),a?i(r,e,t,n):setTimeout(function(){i(r,e,t,n)},4),s},s.config=function(e){return s(e)},e._defined=a,n=function(e,t,n){t.splice||(n=t,t=[]),!v(a,e)&&!v(f,e)&&(f[e]=[e,t,n])},n.amd={jQuery:!0}})(),n("../djinn/lib/require/almond-0.2.9",function(){}),n("djinn/utils/pool",["require","exports","module"],function(e,t,n){var r={};t.create=function(e){if(r[e])return;r[e]=[]},t.get=function(e){return t.create(e),r[e].length>0?r[e].pop():null},t.put=function(e,n){t.create(e),r[e].push(n)}}),n("djinn/Class",["require","exports","module","./utils/pool"],function(e,t,n){var r=e("./utils/pool"),i=function(){var e=Object.create(this.prototype);return this.apply(e,arguments),e},s=function(){},o=0,u=!1,a=/\b_super\b/,f=function(){};return f.uid=0,f.extend=function(e){var t=this.prototype;u=!0;var n=new this;u=!1;for(var r in e)n[r]=typeof e[r]=="function"&&typeof t[r]=="function"&&a.test(e[r])?function(e,n){return function(){var r=this._super;this._super=t[e];var i=n.apply(this,arguments);return this._super=r,i}}(r,e[r]):e[r];var s=function(){!u&&this.init&&this.init.apply(this,arguments)};return s.prototype=n,s.prototype.constructor=s,s.extend=arguments.callee,s.create=i,s.uid="Class_"+String(++o),s},f.prototype.dispose=s,f}),n("djinn/Emitter",["require","exports","module","./Class"],function(e,t,n){var r=e("./Class");n.exports=r.extend({init:function(){this._listeners={}},dispose:function(){this.removeAllListeners(),this._super()},fire:function(e,t){if(!this._listeners)return;var n=this._listeners[e];if(!n)return;for(var r=0,i=n.length;r<i;++r){var s=n[r];if(!s)continue;s.method.apply(s.context,t)}},on:function(e){var t=this._listeners[e];t||(t=this._listeners[e]=[]);if(arguments.length===2)t.push({context:this,method:arguments[1]});else{var n=arguments[1],r=arguments[2];typeof r=="string"&&(n[r]||console.warn("[Emitter.on] method doesn't exist",r),r=n[r]),t.push({context:n,method:r})}return this},removeListener:function(e,t){var n=this._listeners[e];if(!n)return;if(t===undefined)this._listeners[e]=[];else for(var r=n.length-1;r>=0;--r)n[r].context===t&&n.splice(r,1);return this},removeAllListeners:function(){return this._listeners={},this},removeListenersByContext:function(e){for(var t in this._listeners){var n=this._listeners[t];for(var r=n.length-1;r>=0;--r)n[r].context===e&&n.splice(r,1)}return this}})}),n("djinn/utils/object",["require","exports","module"],function(e,t,n){t.clone=function(e){return JSON.parse(JSON.stringify(e))},t.getKeys=function(e){var t=[];for(var n in e)t.push(n);return t},t.getLength=function(e){var t=0;for(var n in e)++t;return t},t.getRandomKey=function(e){return random.choice(t.getKeys(e))},t.merge=function(){var e={};for(var t=arguments.length-1;t>=0;--t){var n=arguments[t];if(typeof n!="object")continue;for(var r in n){var i=n[r];if(i===undefined)continue;i&&typeof i.concat=="function"?e[r]=i.concat([]):i&&i.constructor===Object?e[r]=arguments.callee(i,e[r]):e[r]=i}}return e}}),n("djinn/math/core",["require","exports","module"],function(e,t,n){t.twoPi=Math.PI*2,t.isNumber=function(e){return e!==null&&!isNaN(e)},t.sign=function(e){return e>0?1:e==0?0:-1},t.clamp=function(e,t,n){return Math.min(Math.max(e,t),n)},t.round=function(e,t){var n=Math.pow(10,t);return Math.round(e*n)/n},t.normalize=function(e,t,n){return(e-t)/(n-t)},t.map=function(e,n,r,i,s){return t.lerp(i,s,t.normalize(e,n,r))},t.lerp=function(e,t,n,r){var i=e+(t-e)*n;return r?Math.round(i):i},t.distance=function(e,t,n,r){return Math.sqrt(Math.pow(n-e,2)+Math.pow(r-t,2))},t.approximately=function(e,t){return Math.abs(e-t)<Number.EPSILON},t.wrapRadians=function(e){return(e+t.twoPi)%t.twoPi},t.snapRadians=function(e,t){return e*Math.round(e/t)},t.indexToX=function(e,t){return e%t},t.indexToY=function(e,t){return Math.floor(e/t)},t.gridToIndex=function(e,t){return t*width+e},t.random=function(e,t){return e instanceof Array?arguments.callee(0,e.length-1):Math.round(Math.random()*(t-e))+e},t.intersects=function(e,t){return e.x<t.x+t.width&&t.x<e.x+e.width&&e.y<t.y+t.height&&t.y<e.y+e.height},t.pointInCircle=function(e,t,n,r,i){var s=Math.pow(e-n,2)+Math.pow(t-r,2);return s<Math.pow(i,2)},t.pointDistance=function(e,t){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))}}),n("djinn/utils/string",["require","exports","module","djinn/math/core"],function(e,t,n){var r=e("djinn/math/core");t.formatMoney=function(e){var e=r.round(e,2),n=t.formatNumber(e);return n.substr(n.length-2,1)==="."&&(n+="0"),n},t.formatNumber=function(e){var e=String(e),t=e.split("."),n=t[0],r=t.length>1?"."+t[1]:"",i=/(\d+)(\d{3})/;while(i.test(n))n=n.replace(i,"$1,$2");return n+r},t.formatOrdinalNumber=function(e){var e=String(e),t="";switch(e.slice(-1)){case"1":t="st";break;case"2":t="nd";break;case"3":t="rd";break;default:t="th"}return e+t},t.formatTime=function(e,n){var r=Math.floor(e%1e3),i=Math.floor(e/1e3)%60,s=Math.floor(e/6e4)%60,o=Math.floor(e/36e5)%24;return i=t.padLeft(i,"0",2),n>0&&(r=t.padLeft(r,"0",3),i+="."+r.substr(0,n)),o>0?(s=t.padLeft(s,"0",2),t.sprintf("%s:%s:%s",o,s,i)):t.sprintf("%s:%s",s,i)},t.hashCharCode=function(e){var t=0;if(e.length<1)return t;for(i=0,j=e.length;i<j;i++){var n=e.charCodeAt(i);t=(t<<5)-t+n,t|=0}return Math.abs(t)},t.padLeft=function(e,t,n){var e=String(e),r=n-e.length;for(var i=0;i<r;++i)e=t+e;return e},t.parseNumber=function(e){return Number(e.replace(/([^0-9\.])/g,""))},t.ucfirst=function(e){return e.charAt(0).toUpperCase()+e.slice(1)},t.sprintf=function(){var e=arguments[0],t=arguments.length;for(var n=1;n<t;++n)e=e.replace(/%s/,arguments[n]);return e},t.updateCharAtIndex=function(e,t,n){return e.substr(0,t)+n+e.substr(t+1)}}),n("djinn/utils/array",["require","exports","module","../math/core"],function(e,t,n){var r=e("../math/core"),i=function(e,t){var n=e.indexOf(t);n!==-1&&e.splice(n,1)};t.isArray=function(e){return e?typeof e.unshift=="function":!1},t.clone=function(e){return e.concat()},t.force=function(e){return t.isArray(e)?e:[e]},t.contains=function(e,t){return e.indexOf(t)!==-1},t.unique=function(e){var t={},n=[],r=0;for(var i=0,s=e.length;i<s;++i){var o=e[i];t[o]||(t[o]=!0,n[r++]=o)}return n},t.containsAny=function(e,n){for(var r=0,i=n.length;r<i;++r)if(t.contains(e,n[r]))return!0;return!1},t.remove=function(e,n){if(t.isArray(n))for(var r=0,s=n.length;r<s;++r)i(e,n[r]);else i(e,n)},t.removeValue=function(e,t){var n=e.indexOf(t);if(n===-1)return;e.splice(n,1)},t.removeIndices=function(e,t){t.length>1&&t.sort(function(e,t){return t-e});for(var n=0,r=t.length;n<r;++n)e.splice(t[n],1)},t.addItems=function(e,t,n){for(var r=0,i=t.length;r<i;++r){var s=t[r];if(n&&e.indexOf(s)!==-1)continue;e.push(s)}},t.pushOnce=function(e,t){if(e.indexOf(t)!==-1)return;e.push(t)},t.pickRandom=function(e){var t=r.random(0,e.length-1);return e[t]},t.popRandom=function(e){var t=r.random(0,e.length-1),n=e[t];return e.splice(t,1),n},t.merge=function(e,t,n){var r=[];while(e.length>0&&t.length>0)n(e[0],t[0])<=0?r.push(e.shift()):r.push(t.shift());return r.concat(e,t)},t.sort=function(e,n){var r=e.length;if(r<2)return e;var i=Math.ceil(r/2);return t.merge(t.sort(e.slice(0,i),n),t.sort(e.slice(i),n),n)},t.shuffle=function(e){var t=e.length;if(t<1)return;while(--t){var n=Math.floor(Math.random()*(t+1)),r=e[n];e[n]=e[t],e[t]=r}return e},t.max=function(e){var t=e[0]||0;for(var n=0,r=e.length;n<r;++n)t=Math.max(e[n],t);return t},t.sum=function(e){var t=0;for(var n=0,r=e.length;n<r;++n){if(isNaN(e[n]))continue;t+=e[n]}return t},t.last=function(e){return e[t.lastIndex(e)]},t.lastIndex=function(e){return e.length-1}}),n("djinn/math/PRNG",["require","exports","module","../utils/string","../utils/array"],function(e,t,n){var r=e("../utils/string"),i=e("../utils/array"),s=2147483648,o=1103515245,u=12345;n.exports=function(e){this.state=null,e&&this.seed(e)};var a=n.exports.prototype;a.seed=function(e){e?isNaN(e)&&(e=r.hashCharCode(String(e))):e=Math.floor(Math.random()*(s-1)),this.seedValue=e,this.state=e},a.normal=function(){return this.state===null?Math.random():(this.state=(o*this.state+u)%s,this.state/s)},a.integer=function(e){return Math.round(this.normal()*e)},a.range=function(e,t){return this.integer(t-e)+e},a.radians=function(e,t){var e=e||0,t=t||Math.PI*2,n=t-e;return e+n*this.normal()},a.chance=function(e){return this.normal()<=e},a.choice=function(e,t){if(e.length===0)return null;var n=this.integer(e.length-1),r=e[n];return t&&e.splice(n,1),r},a.weightedChoice=function(e){var t=arguments.length>1;if(t||i.isArray(e))e=this.autoWeight(t?arguments:e);var n=0,r={};for(var s in e){var o=~~(n*1e3);n+=e[s],r[s]={min:o,max:~~(n*1e3)}}var u=this.integer(~~(n*1e3)-1);for(var s in r){var a=r[s];if(u>=a.min&&u<a.max)return s}return console.warn("[PRNG.weightedChoice] No matching option found!",u,r),null},a.weightedIndex=function(e,t){var n=[];for(var r=0;r<e;++r)n.push(r);var i=this.autoWeight(n,t);return+this.weightedChoice(i)},a.autoWeight=function(e,t){var t=t||2,n={},r=0;for(var i=0,s=e.length;i<s;++i){var o=Math.pow(s-i,t);n[e[i]]=o,r+=o}var u=1/r;for(var a in n)n[a]*=u;return n},a.shuffle=function(e){var t=e.length;if(t<2)return;for(var n=0;n<t;++n){var r=this.range(n,t-1),i=e[n];e[n]=e[r],e[r]=i}}}),n("djinn/math/random",["require","exports","module","./PRNG"],function(e,t,n){var r=e("./PRNG");return new r}),n("djinn/utils/intl",["require","exports","module","../Emitter","./object","./string","../math/random"],function(e,t,n){var r=e("../Emitter"),i=e("./object"),s=e("./string"),o=e("../math/random"),u=r.extend({init:function(e){this._super(e),this._languages={},this._currentLangCode=null},addLanguage:function(e){this._languages[e.code]=e},setLanguage:function(e){this._currentLangCode=e},get:function(e){var t=this._getString(e);return t?arguments.length>1?(arguments[0]=t,s.sprintf.apply(null,arguments)):t:s.sprintf("[Missing intl: %s]",e)},random:function(e){return o.choice(this._getString(e))},pluralize:function(e,t){var e=t>1?e+"_PLURAL":e;return this.get(e,t)},exists:function(e){var t=this._getString(e);return t&&t.length>0},getArray:function(e){return i.clone(this._getString(e))},_getString:function(e){return this._languages[this._currentLangCode].strings[e]}});n.exports=new u}),n("js/intl/en",{code:"en",strings:{FUN:"%sx FUN!",moveUp:"Move up",moveDown:"Move down",moveLeft:"Move left",moveRight:"Move right",action:"Action",negate:"Negate",danger:"DANGER!",bling:"BLING!",cool:"COOL!",ride:"RIDE!",zoom:"ZOOM!"}}),n("djinn/core/time",["require","exports","module"],function(e,t,n){const r=50;var i=!1,s=0,o=null,u=function(e){t.deltaTime=Math.min(e-s,r),s=e,o&&o(t.deltaTime),i&&requestAnimationFrame(u)};t.deltaTime=0,t.start=function(e){i||(i=!0,o=e,requestAnimationFrame(u))},t.stop=function(){i&&(i=!1)}}),n("djinn/manifest",["require","exports","module"],function(e,t,n){n.exports=djinn.manifest}),n("djinn/client",["require","exports","module","djinn/Emitter","djinn/manifest","djinn/utils/string"],function(e,t,n){var r=e("djinn/Emitter"),i=e("djinn/manifest"),s=e("djinn/utils/string"),t=r.extend({init:function(e){this._super(e),this.debug=!1,this._detectEnvironment(),this._updateSize();if(this.isTouch){var t=bind(this,function(e){e.preventDefault()}),n=["touchstart","touchmove","touchend"];for(var r=0,i=n.length;r<i;++r)addEventListener(n[r],t,!1)}window.addEventListener("error",bind(this,"_onError"),!1);var s=bind(this,"_updateSize");window.addEventListener("resize",s,!1),window.addEventListener("orientationchange",s,!1),window.addEventListener("DOMContentLoaded",s,!1),window.addEventListener("load",bind(this,"_onLoad"),!1),window.addEventListener("blur",this._onBlur.bind(this),!1),this._initVisibilityChange()},enterFullscreen:function(){this.native&&nw.Window.get().enterFullscreen()},toggleFullscreen:function(){this.native&&nw.Window.get().toggleFullscreen()},open:function(e){this.native?nw.Shell.openExternal(e):location.href=e},quit:function(){this.native&&nw.App.quit()},vibrate:function(e){if(!navigator.vibrate)return;navigator.vibrate(e)},log:function(){if(arguments.length>1)var e=s.sprintf.apply(null,arguments);else var e=arguments[0];console.log(e)},_detectEnvironment:function(){var e=this.userAgent=navigator.userAgent;this.pixelRatio=window.devicePixelRatio||1,this.isTouch=typeof window.ontouchstart!="undefined"||!this.isBrowser,this.isIPhone=/iPhone OS/.test(e),this.isIPad=/iPad/.test(e),this.isIOS=this.isIPhone||this.isIPad,this.isAndroid=/Android/.test(e);if(this.native){var t=nw.Window.get(),n=bind(this,"_onFullscreenChange");t.on("enter-fullscreen",n),t.on("restore",n)}this.debug&&(this.log("[client._detectEnvironment] Debugging info:"),this.log("User Agent: %s",this.userAgent),this.log("Device: %s",this.deviceType),this.log("Pixel Ratio: %s",this.pixelRatio))},_queryWindowSize:function(){var e={width:~~window.innerWidth,height:~~window.innerHeight};return e},_updateSize:function(){var e=this._queryWindowSize();if(e.width!==this.width||e.height!==this.height)this.width=e.width,this.height=e.height,this.debug&&this.log("[client._updateSize] %sx%s",this.width,this.height),this.fire("resize",[this.width,this.height,this.orientation])},_onError:function(e){this.fire("error",[e])},_onLoad:function(){this._updateSize(),this.isAndroid&&setInterval(bind(this,"_updateSize"),500)},_initVisibilityChange:function(){var e=null;this._hiddenPropertyName=null,typeof document.hidden!="undefined"?(e="visibilitychange",this._hiddenPropertyName="hidden"):typeof document.webkitHidden!="undefined"?(e="webkitvisibilitychange",this._hiddenPropertyName="webkitHidden"):typeof document.mozHidden!="undefined"?(e="mozvisibilitychange",this._hiddenPropertyName="mozHidden"):typeof document.msHidden!="undefined"&&(e="msvisibilitychange",this._hiddenPropertyName="msHidden");if(!e)return;document.addEventListener(e,bind(this,"_onVisibilityChange"),!1)},_onVisibilityChange:function(){this.fire("visibilityChange",[this.hidden]),this.hidden&&this._onBlur()},_onFullscreenChange:function(){this.fire("fullscreenChange",[this.fullscreen])},_onBlur:function(){this.fire("blur")}}),o=t.prototype;Object.defineProperty(o,"native",{get:function(){return typeof nw!="undefined"}}),Object.defineProperty(t.prototype,"orientation",{get:function(){var e=this.width>=this.height?"landscape":"portrait";return isNaN(window.orientation)&&i.orientation!=="both"?i.orientation:e}}),Object.defineProperty(t.prototype,"hidden",{get:function(){return this._hiddenPropertyName?document[this._hiddenPropertyName]:!1}}),Object.defineProperty(t.prototype,"fullscreen",{get:function(){return this.native?nw.Window.get().isFullscreen():!1}}),Object.defineProperty(t.prototype,"deviceType",{get:function(){return this.isAndroid?"Android":this.isIPhone?"iPhone":this.isIPad?"iPad":"Unknown"}}),Object.defineProperty(t.prototype,"isBrowser",{get:function(){return document&&typeof document.querySelectorAll=="function"&&!this.isCocoonJS}}),Object.defineProperty(t.prototype,"isCocoonJS",{get:function(){return navigator.isCocoonJS}}),Object.defineProperty(t.prototype,"isSteam",{get:function(){return djinn.platform==="steam"}}),n.exports=new t}),n("djinn/input/keys",["require","exports","module"],function(e,t,n){n.exports={backspace:8,tab:9,enter:13,shift:16,ctrl:17,alt:18,pause:19,capsLock:20,escape:27,space:32,pageUp:33,pageDown:34,end:35,home:36,left:37,up:38,right:39,down:40,insert:45,del:46,n0:48,n1:49,n2:50,n3:51,n4:52,n5:53,n6:54,n7:55,n8:56,n9:57,a:65,b:66,c:67,d:68,e:69,f:70,g:71,h:72,i:73,j:74,k:75,l:76,m:77,n:78,o:79,p:80,q:81,r:82,s:83,t:84,u:85,v:86,w:87,x:88,y:89,z:90,leftWindow:91,rightWindow:92,select:93,numpad0:96,numpad1:97,numpad2:98,numpad3:99,numpad4:100,numpad5:101,numpad6:102,numpad7:103,numpad8:104,numpad9:105,multiply:106,add:107,subtract:109,decimalPoint:110,divide:111,f1:112,f2:113,f3:114,f4:115,f5:116,f6:117,f7:118,f8:119,f9:120,f10:121,f11:122,f12:123,numLock:144,scrollLock:145,semicolon:186,equal:197,comma:188,dash:189,period:190,slash:191,grave:192,openBracket:219,backSlash:220,closeBracket:221,quote:222}}),n("djinn/input/keyboard",["require","exports","module","../Emitter","../client","../utils/array","./keys"],function(e,t,n){var r=e("../Emitter"),i=e("../client"),s=e("../utils/array"),o=e("./keys"),u=r.extend({init:function(e){this._super(e),this._capture=[],this.binds={},this.keys=o,this._keysDown={},this._keyHistory=[],this._lastKeysDown={},this._shiftDown=!1,this.bind({up:["up","w"],left:["left","a"],down:["down","s"],right:["right","d"],accept:["enter","space"],negate:["escape"]}),window.addEventListener("keydown",bind(this,"_handleKeyEvent"),!1),window.addEventListener("keyup",bind(this,"_handleKeyEvent"),!1),i.on("blur",this,"_onClientBlur")},bind:function(e){var t=this.binds;for(var n in e){var r=t[n]=[],i=s.force(e[n]);i.forEach(function(e){r.push(o[e])}),this.capture(r)}},test:function(e,t){var n=this.binds[e];return n?this.isDown(n,t):!1},capture:function(e){var t=this._capture;e.forEach(function(e){if(t.indexOf(e)!==-1)return;t.push(e)})},endFrame:function(){this._lastKeysDown={};for(var e in this._keysDown)this._lastKeysDown[e]=this._keysDown[e]},checkHistory:function(e){var t=e.length,n=this._keyHistory.slice(-t);if(n.length!=t)return!1;for(var r=0;r<t;r++)if(e[r]!==n[r])return!1;return!0},clearHistory:function(){this._keyHistory=[]},isDown:function(e,t){s.isArray(e)||(e=[e]);for(var n=0,r=e.length;n<r;++n)if(this._keysDown[e[n]])if(t!==!0||this._lastKeysDown[e[n]]!==!0)return!0;return!1},isShiftDown:function(){return this._shiftDown},isAnyDown:function(){for(var e in this._keysDown)return!0;return!1},clearKeys:function(e){var e=s.force(e);for(var t=0,n=e.length;t<n;++t)delete this._keysDown[e[t]]},getKeyAliasByCode:function(e){for(var t in o)if(e===o[t])return t;return null},_handleKeyEvent:function(e){this._capture.indexOf(e.keyCode)!==-1&&e.preventDefault(),e.type==="keydown"?(this._keysDown[e.keyCode]=!0,this._keyHistory.push(e.keyCode),this._keyHistory.length>50&&this._keyHistory.shift(),this.fire("keyDown",[e.keyCode])):e.type==="keyup"&&delete this._keysDown[e.keyCode],this._shiftDown=e.shiftKey},_onClientBlur:function(){this._keysDown={},this._lastKeysDown={}}});n.exports=new u}),n("djinn/math/Vector2",["require","exports","module","../Class"],function(e,t,n){var r=e("../Class"),t=n.exports=r.extend({init:function(e){if(arguments.length===2)this.x=arguments[0],this.y=arguments[1];else if(typeof e=="object")if(e.angle!==undefined){var t=e.magnitude||1;this.x=Math.cos(e.angle)*t,this.y=Math.sin(e.angle)*t}else this.x=e.x||0,this.y=e.y||0;else this.zero()},set:function(e,t){return this.x=e,this.y=t,this},setRadians:function(e,t){var t=t||1;return this.x=Math.sin(e)*t,this.y=-Math.cos(e)*t,this},add:function(e){return this.x+=e.x,this.y+=e.y,this},clone:function(){return new this.constructor({x:this.x,y:this.y})},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},magnitude:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},distance:function(e){return t.distance(this,e)},normalize:function(){var e=this.magnitude();return e===0?this:this.scale(1/e)},snap:function(e){var t=e*Math.round(this.heading/e);return this.x=Math.sin(t),this.y=-Math.cos(t),this},scale:function(e){return this.x*=e,this.y*=e,this},divide:function(e){return this.x/=e,this.y/=e,this},subtract:function(e){return this.x-=e.x,this.y-=e.y,this},dot:function(e){return t.dot(this.x,this.y,e.x,e.y)},zero:function(){return this.x=0,this.y=0,this},rotate:function(e){var t=Math.sin(e),n=-Math.cos(e),r=this.x*n-this.y*t,i=this.x*t+this.y*n;return this.x=r,this.y=i,this}}),i=t.prototype;Object.defineProperty(i,"angle",{get:function(){return Math.atan2(this.y,this.x)}}),Object.defineProperty(i,"heading",{get:function(){return Math.atan2(this.x,-this.y)}}),t.fromAngle=function(e){return t.create(Math.sin(e),-Math.cos(e))},t.makeFromHeading=function(e,n){var n=Number(n)||1;return new t({x:Math.sin(e)*n,y:-Math.cos(e)*n})},t.magnitude=function(e,t){return Math.sqrt(e*e+t*t)},t.distance=function(e,n){var r=t.subtract(n,e);return t.magnitude(r.x,r.y)},t.subtract=function(e,n){return new t(e.x-n.x,e.y-n.y)},t.dot=function(e,t,n,r){return e*n+t*r},t.angle=function(e,t){return Math.atan2(e,-t)},t.angleX=function(e){return Math.sin(e)},t.angleY=function(e){return-Math.cos(e)},t.angleBetween=function(e,n,r,i){var s=t.dot(e,n,r,i),o=t.magnitude(e,n),u=t.magnitude(r,i);return Math.acos(s/(o*u))}}),n("djinn/input/buttons",{dPadUp:12,dPadDown:13,dPadLeft:14,dPadRight:15,face1:0,face2:1,face3:2,face4:3,a:0,b:1,x:2,y:3,lb:4,rb:5,lt:6,rt:7,ls:10,rs:11,shoulderTopLeft:4,shoulderTopRight:5,shoulderBottomLeft:6,shoulderBottomRight:7,select:8,start:9,analogLeft:10,analogRight:11}),n("djinn/platforms/nwf",["require","exports","module","../Emitter","../utils/array","../input/buttons"],function(e,t,n){var r=e("../Emitter"),i=e("../utils/array"),s=e("../input/buttons"),o={12:"GAMEPAD_UP",13:"GAMEPAD_DOWN",14:"GAMEPAD_LEFT",15:"GAMEPAD_RIGHT",0:"GAMEPAD_A",1:"GAMEPAD_B",2:"GAMEPAD_X",3:"GAMEPAD_Y",9:"GAMEPAD_PLUS",8:"GAMEPAD_MINUS",4:"GAMEPAD_L",5:"GAMEPAD_R",6:"GAMEPAD_ZL",7:"GAMEPAD_ZR"},u={up:function(e,t){return e.leftStick.movementY<-t},down:function(e,t){return e.leftStick.movementY>t},left:function(e,t){return e.rightStick.movementX<-t},right:function(e,t){return e.rightStick.movementX>t}},a=r.extend({init:function(e){var e=merge(e,a.defaults);this._super(e),this.analogThreshold=e.analogThreshold,this.threshold=e.threshold,this.analogDeadZoneLeft=e.analogDeadZoneLeft,this.analogDeadZoneRight=e.analogDeadZoneRight,this.buttons=s;var t=nwf.input.WiiUGamePad;this.ControllerButton=nwf.input.ControllerButton,this.gamepad=t.getController(t.GAMEPAD_1),this._buttonsDown={},this._lastButtonsDown={},this._directionsDown={},this._lastDirectionsDown={}},exists:function(){return!!this.gamepad},endFrame:function(){this._lastButtonsDown={};for(var e in this._buttonsDown)this._lastButtonsDown[e]=this._buttonsDown[e];this._lastDirectionsDown={};for(var e in this._directionsDown)this._lastDirectionsDown[e]=this._directionsDown[e]},getAnalogData:function(e){var t={x:0,y:0,magnitude:0,magnitudeNormal:0},n=this.gamepad;if(!n)return t;var r=e==="left",i=r?n.leftStick:n.rightStick,s=r?this.analogDeadZoneLeft:this.analogDeadZoneRight,o=i.movementX,u=i.movementY,a=this.analogThreshold;Math.abs(o)<a&&(o=0),Math.abs(u)<a&&(u=0);var f=Math.sqrt(o*o+u*u),l=o/f,c=u/f;if(f>s){f=Math.min(f,1),f-=s;var h=f/(1-s);t.x=o,t.y=u,t.xNormal=l,t.yNormal=c,t.magnitude=f,t.magnitudeNormal=h}return t},clearButtons:function(e){var e=i.force(e);e.forEach(function(e){delete this._buttonsDown[e]},this)},isButtonDown:function(e,t){var n=this.gamepad;if(!n)return!1;var r=n.buttons[e],i=!1,s=n.buttons,u=this.ControllerButton,a=o[e];s.isButtonPressed(u[a])&&(i=!0);var f=i;return t&&(f=i&&!this._buttonsDown[e]),this._buttonsDown[e]=i,f},isDirectionDown:function(e,t){var n=this.gamepad;if(!n)return!1;var r=u[e](n,this.threshold),i=r;return t&&(i=r&&!this._directionsDown[e]),this._directionsDown[e]=r,i}});a.defaults={threshold:.75,analogThreshold:.25,analogDeadZoneLeft:.3,analogDeadZoneRight:.3},n.exports=a}),n("djinn/input/gamepad",["require","exports","module","../Emitter","../math/Vector2","../utils/array","./buttons","../platforms/nwf"],function(e,t,n){var r=e("../Emitter"),i=e("../math/Vector2"),s=e("../utils/array"),o=e("./buttons");if(window.nwf){var u=e("../platforms/nwf");n.exports=new u;return}var a={up:function(e,t){return e.axes[1]<-t},down:function(e,t){return e.axes[1]>t},left:function(e,t){return e.axes[0]<-t},right:function(e,t){return e.axes[0]>t}},f=navigator.getGamepads||navigator.webkitGetGamepads,l=r.extend({init:function(e){var e=merge(e,l.defaults);this._super(e),this._gamepadIndex=-1,this.binds={},this.ignoreInputThisFrame=!1,this.threshold=e.threshold,this.analogSnapLeft=e.analogSnapLeft,this.analogSnapRight=e.analogSnapRight,this.analogDeadZoneLeft=e.analogDeadZoneLeft,this.analogDeadZoneRight=e.analogDeadZoneRight,this.buttons=o,this._buttonsDown={},this._lastButtonsDown={},this._directionsDown={},this._lastDirectionsDown={},this.bind({accept:"face1",negate:"start"})},bind:function(e){var t=this.binds;for(var n in e)t[n]=e[n]},test:function(e,t){var n=this.binds[e];return n?this.isButtonDown(o[n],t):!1},_getGamepad:function(){if(!f)return;var e=f.call(navigator);if(this._gamepadIndex===-1)for(var t=0;t<e.length;++t){var n=e[t];if(!n||!n.buttons)continue;for(var r=0;r<n.buttons.length;++r){var i=n.buttons[r];if(!isNaN(i)&&i>this.threshold||i&&i.pressed){this._gamepadIndex=t;return}}}return this._gamepadIndex>=0&&e[this._gamepadIndex]?e[this._gamepadIndex]:null},exists:function(){return this._getGamepad()!==null},endFrame:function(){this.ignoreInputThisFrame=!1,this._lastButtonsDown={};for(var e in this._buttonsDown)this._lastButtonsDown[e]=this._buttonsDown[e];this._lastDirectionsDown={};for(var e in this._directionsDown)this._lastDirectionsDown[e]=this._directionsDown[e]},getAnalogData:function(e){var t={x:0,y:0,angle:0,magnitude:0},n=this._getGamepad();if(!n)return t;var r=n.axes,s=e==="left",o=s?this.analogDeadZoneLeft:this.analogDeadZoneRight,u=s?this.analogSnapLeft:this.analogSnapRight,a=s?r[0]:r[2],f=s?r[1]:r[3],l=i.magnitude(a,f);if(l<o)return t;var c=Math.atan2(a,-f);if(u){var h=Math.PI/4;c=h*Math.round(c/h)}return t.x=Math.sin(c),t.y=-Math.cos(c),t.angle=c,t.magnitude=Math.min(l,1),t},clearButtons:function(e){var t=this._getGamepad();if(!t)return!1;var e=s.force(e);e.forEach(function(e){delete this._buttonsDown[e]},this)},isButtonDown:function(e,t){if(this.ignoreInputThisFrame)return!1;var n=this._getGamepad();if(!n)return!1;var r=n.buttons[e];if(r===undefined)return;var i=r;r.value&&(i=r.value);var s=i>this.threshold,o=s;return t&&(o=s&&!this._buttonsDown[e]),this._buttonsDown[e]=s,o},isDirectionDown:function(e,t){var n=this._getGamepad();if(!n)return!1;var r=a[e](n,this.threshold),i=r;return t&&(i=r&&!this._directionsDown[e]),this._directionsDown[e]=r,i}});l.defaults={threshold:.75,analogSnapLeft:!1,analogSnapRight:!1,analogDeadZoneLeft:.3,analogDeadZoneRight:.3},n.exports=new l}),n("djinn/utils/request",["require","exports","module","../client"],function(e,t,n){var r=e("../client");t.params={},r.isBrowser&&location.href.replace(/[?&]+([^=&]+)=([^&#]*)/gi,function(e,n,r){t.params[n]=r})}),n("djinn/stage",["require","exports","module","./Emitter","./client","./math/core","./manifest","./utils/string","./utils/request"],function(e,t,n){var r=e("./Emitter"),i=e("./client"),s=e("./math/core"),o=e("./manifest"),u=e("./utils/string"),a=e("./utils/request"),f=[],l=!1,c=["mousedown","mousemove","mouseup"],h=["touchstart","touchmove","touchend"],p=r.extend({init:function(e){this._super(e),this.eraseBeforeRender=!1,this._maxScale=Infinity,this.maintainAspectRatio=o.scaleMode!=="stretch",this.acceptInput=!1,this.acceptMouseInput=!0,this.acceptTouchInput=!1,this.xInput=0,this.yInput=0,this.inputDown=!1,this.viewportWidth=0,this.viewportHeight=0,this.canvas=null,this.ctx=null,this.xScale=1,this.yScale=1;var t=this.isCocoonJS?"screencanvas":"canvas",n=this.canvas=document.createElement(t);n.width=o.size[0],n.height=o.size[1],o.pixelated&&(n.className="pixelated"),o.cursor===!1&&(n.style.cursor="none"),i.isBrowser&&(n.style.position="absolute",n.style.left=0,n.style.top=0),document.body.appendChild(n),i.on("error",this,"_onError"),this._initInput(),this.ctx=n.getContext("2d"),this._autoSize(),i.on("resize",this,"_autoSize")},localizePoint:function(e,t){return{x:Math.round((e-this.canvas.offsetLeft)*(1/this.xScale)),y:Math.round((t-this.canvas.offsetTop)*(1/this.yScale))}},renderView:function(e){var t=this.canvas,n=this.ctx;this.eraseBeforeRender&&n.clearRect(0,0,t.width,t.height),e.preRender(n)},createBuffer:function(e,t){var n=document.createElement("canvas");return n.width=Number(e),n.height=Number(t),n},getInputEvents:function(){var e=f;return f=[],e},requestFullScreen:function(){document.body.webkitRequestFullScreen()},cancelFullScreen:function(){document.webkitCancelFullScreen()},toggleFullScreen:function(){if(!this.canFullScreen)return;this.isFullScreen?this.cancelFullScreen():this.requestFullScreen()},setViewport:function(e,t){this.viewportWidth=e,this.viewportHeight=t,this._autoSize()},_getEventType:function(e){switch(e.type){case"touchstart":case"mousedown":return"inputStart";case"touchmove":case"mousemove":return"inputMove";case"touchend":case"mouseup":return"inputEnd"}},_handleMouseEvent:function(e){if(!this.acceptInput||!this.acceptMouseInput)return;this._handleInputEvent(e)},_handleTouchEvent:function(e){if(!this.acceptInput||!this.acceptTouchInput)return;this._handleInputEvent(e)},_handleContextEvent:function(e){e.preventDefault()},_handleWheelEvent:function(e){this.fire("wheel",[e.deltaX,e.deltaY])},_handleMouseOutEvent:function(){this.fire("inputEnd")},_handleInputEvent:function(e){if(!this.acceptInput)return;var t=-1,n=0,r=0;if(i.isTouch&&e.touches&&e.changedTouches){var s=e.type==="touchend"?e.changedTouches[0]:e.touches[0];t=s.identifier,n=s.pageX,r=s.pageY}else n=e.pageX,r=e.pageY;var o={id:t,type:this._getEventType(e),point:this.localizePoint(n,r),rightClick:e.button===2?!0:!1};this.xInput=o.point.x,this.yInput=o.point.y,this.inputDown=o.type!=="inputEnd",f.push(o),this.fire(o.type,[o]),this.fire("input",[o]),l||(l=!0,this.fire("initialInput"))},_initInput:function(){var e=this.canvas,t=bind(this,"_handleMouseEvent");c.forEach(function(n){e.addEventListener(n,t,!1)});var n=bind(this,"_handleTouchEvent");h.forEach(function(t){e.addEventListener(t,n,!1)});var r=bind(this,"_handleContextEvent");e.addEventListener("contextmenu",r,!1);var i=bind(this,"_handleWheelEvent");e.addEventListener("wheel",i,!1);var s=bind(this,"_handleMouseOutEvent");e.addEventListener("mouseout",s,!1)},_autoSize:function(){var e=this.canvas,t=Math.min(e.width,e.height),n=Math.max(e.width,e.height),r=o.orientation!=="both"&&o.forceOrientation,f=r?o.orientation:i.orientation;e.width=f=="portrait"?t:n,e.height=f=="portrait"?n:t;var l=this.viewportWidth||i.width,c=this.viewportHeight||i.height,h=l/e.width,p=c/e.height;i.isCocoonJS?(this.xScale=this.yScale=1,e.style.cssText="idtkscale:ScaleAspectFit;"):a.params.scale?this.xScale=this.yScale=Number(a.params.scale):this.maintainAspectRatio?this.xScale=this.yScale=Math.min(h,p):(this.xScale=h,this.yScale=p),i.log("[stage._autoSize] view: %sx%s, canvas: %sx%s, scale: %s, %s",l,c,e.width,e.height,s.round(this.xScale,3),s.round(this.yScale,3));var d="0 0";if(i.isIOS)var v=u.sprintf("scale3d(%s, %s, 1)",this.xScale,this.yScale);else var v=u.sprintf("scale(%s, %s)",this.xScale,this.yScale);if(i.isBrowser){var m=e.style;m.transformOrigin=d,m.transform=v;var g=["webkit","Moz","ms"];for(var y=0,b=g.length;y<b;++y){var w=g[y];m[w+"TransformOrigin"]=d,m[w+"Transform"]=v}m.left=i.width/2-e.width*this.xScale/2+"px",o.yStageAlign==="top"?m.top=0:m.top=i.height/2-e.height*this.yScale/2+"px"}this.fire("resize")},_onError:function(e){var t=this.canvas,n=this.ctx,r=[e.message,e.filename+":"+e.lineno,""].concat(e.error.stack.split("\n")),i=Math.round(t.height*.025),s=Math.round(i*1.35);n.fillStyle="#30346D",n.fillRect(0,0,t.width,t.height),n.fillStyle="#DEEED6",n.font=i+"px monospace",n.textBaseline="top";var o=5;r.forEach(function(e){n.fillText(e,10,o),o+=s})}}),d=p.prototype;Object.defineProperty(d,"canFullScreen",{get:function(){return typeof document.webkitCancelFullScreen=="function"}}),Object.defineProperty(d,"isFullScreen",{get:function(){return document.webkitIsFullScreen}}),Object.defineProperty(d,"maxScale",{get:function(){return this._maxScale},set:function(e){this._maxScale=e,this._autoSize()}}),Object.defineProperty(d,"width",{get:function(){return this.canvas.width}}),Object.defineProperty(d,"height",{get:function(){return this.canvas.height}}),Object.defineProperty(d,"scaleWidth",{get:function(){return this.width*this.xScale}}),Object.defineProperty(d,"scaleHeight",{get:function(){return this.height*this.yScale}}),n.exports=new p}),n("djinn/assets",["require","exports","module","djinn/client","djinn/manifest","djinn/utils/string"],function(e,t,n){var r=e("djinn/client"),i=e("djinn/manifest"),s=e("djinn/utils/string"),o={},u={image:["png","jpg","jpeg","gif"],audio:["mp3","ogg"],font:["ttf"]},a={image:function(e,t,n){var s=new Image;s.onload=function(){s.ready=!0,t&&t(e,s)},s.onerror=function(){n&&n(e,s)};if(r.isBrowser&&e.substring(0,5)!="data:")var e=e+"?v="+i.version;return s.src=e,s},audio:function(e,t){if(typeof Audio=="undefined")return console.warn("[assets] No Audio object: "+e),t&&t(e,null),null;var n=new Audio;if(n.canPlayType("audio/ogg")!=="")e=e.replace(/\.mp3/,".ogg");else if(n.canPlayType("audio/mpeg")==="")return console.warn("[assets] No audio support: "+e),t&&t(e,null),null;return r.isBrowser?(n.addEventListener("canplay",function(){if(n.ready)return;n.ready=!0,t&&t(e,n)},!1),n.src=e):(n.addEventListener("canplaythrough",function(){n.ready=!0,t&&t(e,n)}),n.src=e,n.load()),n},font:function(e,t){if(r.isBrowser){var n=/^.*\/([^\.]+)\.ttf$/.exec(e),i=n[1],o=s.sprintf("@font-face { font-family: '%s'; src: url('%s'); }",i,e),u=document.createElement("style");u&&(u.innerHTML=o,document.head.appendChild(u))}return t&&t(e,null),null}};t.cacheImage=function(e,t){o[e]=a.image(t)},t.load=function(e,n,r){if(!e||e.length<1){r&&r(null,null,0,0,1),n&&n();return}typeof e=="string"&&(e=[e]);var i=e.length,s=0,u=function(e,t){o[e]=t,++s;var u=s/i;r&&r(e,t,s,i,u),s>=i&&n&&n()},f=function(e,t){console.error("[assets.load] Failed to load asset: "+e),u(e,t)};for(var l=0,c=e.length;l<c;++l){var h=e[l];if(typeof h!="string"||h.length<=0)--i,console.info("[assets.load] Skipping empty asset path");if(o[h])u(h,o[h]);else{var p=t.inferAssetType(h);if(p&&a[p]){var d=a[p];o[h]=d(h,u,f)}else--i,console.info("[assets.load] Skipping unknown asset type: "+h)}}},t.unload=function(e){typeof e=="string"&&(e=[e]);for(var t=0,n=e.length;t<n;++t)delete o[e[t]]},t.queryCache=function(e){return o[e]!==undefined},t.get=function(e){return t.queryCache(e)||(console.warn("[assets.get] On-the-fly asset load: "+e),t.load(e)),o[e]},t.inferAssetType=function(e){var t=e.split("."),n=t.length>0?t.pop():"";for(var r in u)if(u[r].indexOf(n)!=-1)return r;return null}}),n("djinn/math/collision",["require","exports","module"],function(e,t,n){var r=function(e,t,n){var r=null;if(Math.abs(e)<1e-6)Math.abs(t)<1e-6?r=Math.abs(n)<1e-6?[0,0]:null:r=[-n/t,-n/t];else{var i=t*t-4*e*n;i>=0&&(i=Math.sqrt(i),e=2*e,r=[(-t-i)/e,(-t+i)/e])}return r};t.intercept=function(e,t,n,i,s,o,u){var a=n-e,f=i-t,l=s*s+o*o-u*u,c=2*(s*a+o*f),h=a*a+f*f,p=r(l,c,h),d=null;if(p){var v=p[0],m=p[1],g=Math.min(v,m);g<0&&(g=Math.max(v,m)),g>0&&(d={x:n+s*g,y:i+o*g})}return d},t.testPointInRect=function(e,t){return e.x>t.x&&e.y>t.y&&e.x<t.x+t.width&&e.y<t.y+t.height},t.testPointCircle=function(e,t,n,r,i){var s=Math.pow(e-n,2)+Math.pow(t-r,2);return s<Math.pow(i,2)},t.testAABB=function(e,t){var n={contacts:[],normal:{x:0,y:0},penetration:0},r={x:t.x+t.width/2-(e.x+e.width/2),y:t.y+t.height/2-(e.y+e.height/2)},i=(e.x+e.width-e.x)/2,s=(e.y+e.height-e.y)/2,o=(t.x+t.width-t.x)/2,u=(t.y+t.height-t.y)/2,a=i+o-Math.abs(r.x),f=s+u-Math.abs(r.y);return a<=0||f<=0?n:(n.contacts.push({x:Math.max(e.x,t.x),y:Math.max(e.y,t.y)}),n.contacts.push({x:Math.min(e.x+e.width,t.x+t.width),y:Math.min(e.y+e.height,t.y+t.height)}),a<f?(n.normal.x=r.x<0?1:-1,n.penetration=a):(n.normal.y=r.y<0?1:-1,n.penetration=f),n)}}),n("djinn/utils/transitions",[],function(){var e={linear:function(e,t,n,r){return n*e/r+t},easeIn:function(e,t,n,r){return n*(e/=r)*e+t},easeOut:function(e,t,n,r){return-n*(e/=r)*(e-2)+t},easeBoth:function(e,t,n,r){return(e/=r/2)<1?n/2*e*e+t:-n/2*(--e*(e-2)-1)+t},inStrong:function(e,t,n,r){return n*(e/=r)*e*e*e+t},outStrong:function(e,t,n,r){return-n*((e=e/r-1)*e*e*e-1)+t},bothStrong:function(e,t,n,r){return(e/=r/2)<1?n/2*e*e*e*e+t:-n/2*((e-=2)*e*e*e-2)+t},elasticIn:function(e,t,n,r,i,s){if(e==0)return t;if((e/=r)==1)return t+n;s||(s=r*.3);if(!i||i<Math.abs(n)){i=n;var o=s/4}else var o=s/(2*Math.PI)*Math.asin(n/i);return-(i*Math.pow(2,10*(e-=1))*Math.sin((e*r-o)*2*Math.PI/s))+t},elasticOut:function(e,t,n,r,i,s){if(e==0)return t;if((e/=r)==1)return t+n;s||(s=r*.3);if(!i||i<Math.abs(n)){i=n;var o=s/4}else var o=s/(2*Math.PI)*Math.asin(n/i);return i*Math.pow(2,-10*e)*Math.sin((e*r-o)*2*Math.PI/s)+n+t},elasticBoth:function(e,t,n,r,i,s){if(e==0)return t;if((e/=r/2)==2)return t+n;s||(s=r*.3*1.5);if(!i||i<Math.abs(n)){i=n;var o=s/4}else var o=s/(2*Math.PI)*Math.asin(n/i);return e<1?-0.5*i*Math.pow(2,10*(e-=1))*Math.sin((e*r-o)*2*Math.PI/s)+t:i*Math.pow(2,-10*(e-=1))*Math.sin((e*r-o)*2*Math.PI/s)*.5+n+t},backIn:function(e,t,n,r,i){return i===undefined&&(i=1.70158),n*(e/=r)*e*((i+1)*e-i)+t},backOut:function(e,t,n,r,i){return i===undefined&&(i=1.70158),n*((e=e/r-1)*e*((i+1)*e+i)+1)+t},backBoth:function(e,t,n,r,i){return i===undefined&&(i=1.70158),(e/=r/2)<1?n/2*e*e*(((i*=1.525)+1)*e-i)+t:n/2*((e-=2)*e*(((i*=1.525)+1)*e+i)+2)+t},bounceIn:function(t,n,r,i){return r-e.bounceOut(i-t,0,r,i)+n},bounceOut:function(e,t,n,r){return(e/=r)<1/2.75?n*7.5625*e*e+t:e<2/2.75?n*(7.5625*(e-=1.5/2.75)*e+.75)+t:e<2.5/2.75?n*(7.5625*(e-=2.25/2.75)*e+.9375)+t:n*(7.5625*(e-=2.625/2.75)*e+.984375)+t},bounceBoth:function(t,n,r,i){return t<i/2?e.bounceIn(t*2,0,r,i)*.5+n:e.bounceOut(t*2-i,0,r,i)*.5+r*.5+n}};return e}),n("djinn/utils/Timer",["require","exports","module"],function(e,t,n){var t=n.exports=function(e,t){this.running=!1,this.elapsed=0,this.interval=e||1e3,this.callback=t},r=t.prototype;r.start=function(e){return e!==undefined&&(this.interval=e),this.elapsed=0,this.running=!0,this},r.stop=function(){this.running=!1},r.update=function(e){if(!this.running)return;this.elapsed+=e,this.elapsed>=this.interval&&(this.elapsed-=this.interval,this.callback&&this.callback())}}),n("djinn/view/utils/canvas",["require","exports","module"],function(e,t,n){t.create=function(e,t){var n=document.createElement("canvas");return n.width=e,n.height=t,n},t.fill=function(e,t){e.fillStyle=t,e.fill()},t.stroke=function(e,t,n){e.strokeStyle=t,e.lineWidth=n,e.stroke()},t.fillAndStroke=function(e,t,n,r){t&&(e.fillStyle=t,e.fill()),n&&r>0&&(e.lineWidth=r,e.strokeStyle=n,e.stroke())},t.drawTailRect=function(e,t,n,r,i,s,o,u,a){var f=Math.round(o*r),l=Math.round(f-u/2),c=Math.round(f+u/2);e.beginPath(),e.moveTo(t+s,n),e.lineTo(t+r-s,n),e.quadraticCurveTo(t+r,n,t+r,n+s),e.lineTo(t+r,n+i-s),e.quadraticCurveTo(t+r,n+i,t+r-s,n+i),e.lineTo(c,n+i),e.lineTo(f,n+i+a),e.lineTo(l,n+i),e.lineTo(t+s,n+i),e.quadraticCurveTo(t,n+i,t,n+i-s),e.lineTo(t,n+s),e.quadraticCurveTo(t,n,t+s,n),e.closePath()},t.drawRect=function(e,n,r,i,s,o,u,a,f){f>0?(e.beginPath(),e.moveTo(n+f,r),e.lineTo(n+i-f,r),e.quadraticCurveTo(n+i,r,n+i,r+f),e.lineTo(n+i,r+s-f),e.quadraticCurveTo(n+i,r+s,n+i-f,r+s),e.lineTo(n+f,r+s),e.quadraticCurveTo(n,r+s,n,r+s-f),e.lineTo(n,r+f),e.quadraticCurveTo(n,r,n+f,r),e.closePath(),t.fillAndStroke(e,o,u,a)):(o&&(e.fillStyle=o,e.fillRect(n,r,i,s)),u&&a>0&&(e.strokeStyle=u,e.lineWidth=a,e.strokeRect(n,r,i,s)))},t.drawCircle=function(e,n,r,i,s,o,u){e.beginPath(),e.arc(n,r,i,0,Math.PI*2),e.closePath(),t.fillAndStroke(e,s,o,u)},t.drawPolygon=function(e,n,r,i,s){e.beginPath(),e.moveTo(n[0],n[1]);for(var o=2,u=n.length;o<u;o+=2)e.lineTo(n[o],n[o+1]);e.closePath(),t.fillAndStroke(e,r,i,s)},t.drawLine=function(e,t,n,r){e.beginPath(),e.moveTo(t[0],t[1]);for(var i=2,s=t.length;i<s;i+=2)e.lineTo(t[i],t[i+1]);e.closePath(),e.strokeStyle=n,e.lineWidth=r,e.stroke()},t.drawText=function(e,t,n,r,i,s,o,u,a,f,l,c,h){e.font=i,a&&(e.textAlign=a),f&&(e.textBaseline=f),l&&(e.fillStyle=l,e.fillText(t,n+c,r+h)),o&&u>0&&(e.lineWidth=u*2,e.strokeStyle=o,e.strokeText(t,n,r)),s&&(e.fillStyle=s,e.fillText(t,n,r))},t.getTextWidth=function(e,t,n){e.font=n;var r=e.measureText(t);return r.width},t.filter=function(e,t,n,r,i,s){var o=e.getImageData(t,n,r,i),u=o.data;s(u),e.putImageData(o,t,n)}}),n("djinn/view/View",["require","exports","module","../Emitter","../assets","../math/core","../math/collision","../utils/array","../utils/transitions","../utils/Timer","./utils/canvas"],function(e,t,n){var r=e("../Emitter"),i=e("../assets"),s=e("../math/core"),o=e("../math/collision"),u=e("../utils/array"),a=e("../utils/transitions"),f=e("../utils/Timer"),l=e("./utils/canvas"),c={a:1,b:0,c:0,d:1,tx:0,ty:0},h=0,p=function(e,t){return e.z===t.z?e.id-t.id:e.z-t.z},t=n.exports=r.extend({init:function(e){var n=++h;e=merge(e,{id:n,tag:"View_"+n},t.defaults),e.parent&&(e.width=e.width||e.parent.width,e.height=e.height||e.parent.height),this._super(e),this.id=e.id,this.tag=e.tag,this.x=e.x,this.y=e.y,this.z=e.z,this.rotation=e.rotation,this.pivotX=e.pivotX,this.pivotY=e.pivotY,this.anchorX=e.anchorX,this.anchorY=e.anchorY,this.width=e.width,this.height=e.height,this.scaleX=e.scaleX,this.scaleY=e.scaleY,this.flipX=e.flipX,this.flipY=e.flipY,e.scale&&(this.scale=e.scale),this.alpha=1,this.transform={a:1,b:0,c:0,d:1,tx:0,ty:0},this.visible=e.visible,this.opacity=e.opacity,this.clip=e.clip,this.backgroundColor=e.backgroundColor,this.overlayColor=e.overlayColor,this.compositeOperation=e.compositeOperation,this.imageSmoothingEnabled=e.imageSmoothingEnabled,this._image=null,this.imageX=e.imageX,this.imageY=e.imageY,this.acceptInputEvents=e.acceptInputEvents,this.captureInputEvents=e.captureInputEvents,this.cancelInputEvents=e.cancelInputEvents,this.paused=e.paused,this.tickSpeed=e.tickSpeed,this.autoSortChildren=e.autoSortChildren,this.buffer=e.buffer,this.bufferPadding=e.bufferPadding,this._buffer=null,this._bufferDirty=!0,this.debug=e.debug,this.children=[],this._removedChildren=[],this._tweenQueue=[],e.image&&(this.image=e.image),e.left!==undefined&&(this.left=e.left),e.top!==undefined&&(this.top=e.top),e.bottom!==undefined&&(this.bottom=e.bottom),e.right!==undefined&&(this.right=e.right),e.parent&&e.parent.addChild(this),this._inputStartID=null},dispose:function(){this._buffer=null,this.removeFromParent(),this.cancelTween(),this.disposeChildren(),this._super()},disposeChildren:function(){var e=this.children;for(var t=0,n=e.length;t<n;++t)e[t].dispose()},set:function(e){for(var t in e)this[t]=e[t];return this},resize:function(e,t){this.width=e,this.height=t},addChild:function(e){e.parent&&e.removeFromParent(),e.parent=this,this.children.push(e)},removeChild:function(e){e.parent==this&&this._removedChildren.indexOf(e)==-1&&(e.parent=null,this._removedChildren.push(e))},getChildByTag:function(e){for(var t=0,n=this.children.length;t<n;++t){var r=this.children[t];if(r.tag==e)return r}return null},removeChildren:function(){for(var e=0,t=this.children.length;e<t;++e){var n=this.children[e];n.removeFromParent()}},removeFromParent:function(){this.parent&&this.parent.removeChild(this),this.fire("removedFromParent",[this])},sortChildren:function(){this.children.sort(p)},show:function(){return this.visible=!0,this},hide:function(){return this.visible=!1,this},toggle:function(){return this.visible?this.hide():this.show()},shrinkwrap:function(e,t){e!==!1&&(this.width=0),t!==!1&&(this.height=0);var n=this.children;for(var r=0,i=n.length;r<i;++r){var s=n[r];if(s.parent!==this||!s.visible)continue;e!==!1&&s.right>this.width&&(this.width=s.right),t!==!1&&s.bottom>this.height&&(this.height=s.bottom)}return this},redrawBuffer:function(){return this._bufferDirty=!0,this},react:function(e){if(!this.canReact)return;if(this.captureInputEvents){var t={x:e.point.x-this.left,y:e.point.y-this.top};for(var n=this.children.length-1;n>=0;--n){var r=this.children[n];!e.cancel&&r.canReact&&o.testPointInRect(t,r.bounds)?(e.point.x=t.x,e.point.y=t.y,r.react(e)):r.endInputHover()}e.target||(e.target=this),e.point.x=t.x,e.point.y=t.y,this.fire(e.type,[e]),e.type==="inputStart"?this._inputStartID=e.id:e.type==="inputEnd"&&this._inputStartID===e.id?(this.fire("inputPress",[e]),this._inputStartID=null):e.type==="inputMove"&&!this._inputHover&&(this._inputHover=!0,this.fire("inputEnter",[e]))}this.cancelInputEvents&&(e.cancel=!0)},endInputHover:function(){if(!this._inputHover)return;this._inputHover=!1,this.fire("inputLeave");var e=this.children;for(var t=e.length-1;t>=0;--t){var n=e[t];n.endInputHover()}},preTick:function(e){if(this.paused||!this.visible)return;var e=e*this.tickSpeed;this._cullChildren(),this._updateTween(e),this._updateTimers(e),this.tick&&this.tick(e),this.fire("tick",[e]);var t=this.children;for(var n=0,r=t.length;n<r;++n)t[n].preTick(e)},preRender:function(e){if(!this.visible||this.opacity<=0)return;this._updateTransform();var t=this.transform;e.setTransform(t.a,t.c,t.b,t.d,t.tx+.5|0,t.ty+.5|0),e.globalAlpha=this.alpha;var n=this.compositeOperation;if(n){var r=e.globalCompositeOperation;e.globalCompositeOperation=n}var i=this.imageSmoothingEnabled;i===!1&&(e.imageSmoothingEnabled=!1),this.clip&&(e.save(),e.beginPath(),e.rect(0,0,this.width,this.height),e.clip()),this.buffer?this._renderBuffer(e):(this.render(e),this.debug&&this._renderDebug(e),this.renderChildren(e)),n&&(e.globalCompositeOperation=r),this.clip&&e.restore()},renderChildren:function(e){this.autoSortChildren&&this.sortChildren();var t=this.children;for(var n=0,r=t.length;n<r;++n){var i=t[n];if(i.parent!==this)continue;i.preRender(e)}},render:function(e){var t=e;this.overlayColor&&(this._makeBuffer(),t=this._bufferContext),this._image&&this._image.ready?t.drawImage(this._image,this.imageX,this.imageY,this.width,this.height,0,0,this.width,this.height):this.backgroundColor&&(t.fillStyle=this.backgroundColor,t.fillRect(0,0,this.width,this.height)),this.overlayColor&&(t.globalCompositeOperation="source-atop",t.fillStyle=this.overlayColor,t.fillRect(0,0,this.width,this.height)),t!==e&&e.drawImage(this._bufferCanvas,0,0,this.width,this.height)},_updateTransform:function(){var e=Math.sin(this.rotation),t=Math.cos(this.rotation),n=this.parent,r=this.transform,i=n?n.transform:c,s=this.pivotX*this.width,o=this.pivotY*this.height,u=this.x,a=this.y,f=this.anchorX*this.width,l=this.anchorY*this.height,h=this.scaleX,p=this.scaleY;this.flipX&&(h*=-1),this.flipY&&(p*=-1);var d=t*h,v=-e*p,m=e*h,g=t*p,y=u+s-d*s-o*v,b=a+o-g*o-s*m,w=i.a,E=i.b,S=i.c,x=i.d;r.a=w*d+E*m,r.b=w*v+E*g,r.c=S*d+x*m,r.d=S*v+x*g,r.tx=w*y+E*b+i.tx-f,r.ty=S*y+x*b+i.ty-l;var T=n?n.alpha:1;this.alpha=this.opacity*T},_makeBuffer:function(){if(this._bufferCanvas){this._bufferCanvas.width=this.width,this._bufferCanvas.height=this.height;return}this._bufferCanvas=l.create(this.width,this.height),this._bufferContext=this._bufferCanvas.getContext("2d")},align:function(e,t,n,r){if(!this.parent)return this;if(e){switch(e){case"left":this.left=0;break;case"right":this.right=this.parent.width;break;case"center":this.centerX=this.parent.width/2}this.left+=n||0}if(t){switch(t){case"top":this.top=0;break;case"bottom":this.bottom=this.parent.height;break;case"center":this.centerY=this.parent.height/2}this.top+=r||0}return this},centerOn:function(e,t,n){return e.centerX!==undefined?(this.centerX=e.centerX+(t||0),this.centerY=e.centerY+(n||0)):e.width!==undefined?(this.centerX=e.x+e.width/2+(t||0),this.centerY=e.y+e.height/2+(n||0)):(this.centerX=e.x+(t||0),this.centerY=e.y+(n||0)),this},tween:function(e,t,n,r){if(e!=null){var e=merge(e);for(var i in e){var s=e[i];typeof s!="object"&&(e[i]={from:null,to:s})}}return this._tweenQueue.push({properties:e,duration:isNaN(t)?1e3:t,transition:n||a.linear,callback:r||null,elapsed:0}),this.visible||this.completeTween(),this},delayTween:function(e,t){return this.tween(null,e,null,t)},cancelTween:function(e){return this._tweenQueue=[],e&&this.set(e),this},completeTween:function(e){var t=this._tweenQueue.length,n=this._tweenQueue.splice(0,t);for(var r=0;r<t;++r){var i=n[r];for(var s in i.properties)this[s]=i.properties[s].to;i.callback&&i.callback()}return e&&this.set(e),this},_updateTween:function(e){var t=this._tweenQueue,n=function(){var e=t.shift();e.callback&&e.callback()};while(e>0&&t.length>0){var r=t[0],i=r.duration-r.elapsed,s=Math.min(e,i);r.elapsed+=s,e-=s;if(r.properties===null){r.elapsed>=r.duration&&n();continue}if(r.elapsed>=r.duration||r.duration<=0){for(var o in r.properties)this[o]=r.properties[o].to;n()}else for(var o in r.properties){var u=r.properties[o];u.from==null&&(u.from=this[o]);var a=r.transition(r.elapsed,u.from,u.to-u.from,r.duration);this[o]=a}}},createTimer:function(e,t){typeof t=="string"&&(t=this[t].bind(this));var n=new f(e,t);return this._timers||(this._timers=[]),this._timers.push(n),n},removeTimer:function(e){u.removeValue(this._timers,e)},_updateTimers:function(e){if(!this._timers)return;for(var t=this._timers.length-1;t>=0;--t)this._timers[t].update(e)},_cullChildren:function(){var e=this._removedChildren,t=e.length;if(t<1)return;var n=this.children;for(var r=0;r<t;++r){var i=e[r],s=n.indexOf(i);s!=-1?n.splice(s,1):console.warn("Tried to remove non-child "+i.tag+" from "+this.tag)}e.splice(0,t)},_resizeBuffer:function(){var e=this._buffer,t=this.bufferPadding;e.width=this.width+t*2,e.height=this.height+t*2},_checkBuffer:function(){},_renderBuffer:function(e){var t=this._buffer;this._bufferDirty||this._checkBuffer();if(this._bufferDirty){t||(t=this._buffer=l.create(1,1)),this._resizeBuffer();var n=t.getContext("2d");n.clearRect(0,0,t.width,t.height);var r=this.bufferPadding,i=this.x,s=this.y,o=this.parent,u=this.anchorX,a=this.anchorY,f=this.opacity;this.x=r,this.y=r,this.parent=null,this.anchorX=0,this.anchorY=0,this.opacity=1,this._updateTransform(),r!==0&&n.translate(r,r),this.render(n),this.debug&&this._renderDebug(n),this.renderChildren(n),this.x=i,this.y=s,this.anchorX=u,this.anchorY=a,this.opacity=f,this.parent=o,this._bufferDirty=!1}var c=Math.round(this.width/2-t.width/2),h=Math.round(this.height/2-t.height/2);e.drawImage(t,0,0,t.width,t.height,c,h,t.width,t.height)},_renderDebug:function(e){l.drawRect(e,0,0,this.width,this.height,null,"blue",1)}});t.transitions=a;var d=t.prototype;Object.defineProperty(d,"left",{get:function(){return this.x-this.anchorX*this.width},set:function(e){this.x=e+this.anchorX*this.width}}),Object.defineProperty(d,"top",{get:function(){return this.y-this.anchorY*this.height},set:function(e){this.y=e+this.anchorY*this.height}}),Object.defineProperty(d,"right",{get:function(){return this.left+this.width},set:function(e){this.left=e-this.width}}),Object.defineProperty(d,"bottom",{get:function(){return this.top+this.height},set:function(e){this.top=e-this.height}}),Object.defineProperty(d,"centerX",{get:function(){return this.left+this.width/2},set:function(e){this.left=e-this.width/2}}),Object.defineProperty(d,"centerY",{get:function(){return this.top+this.height/2},set:function(e){this.top=e-this.height/2}}),Object.defineProperty(d,"bounds",{get:function(){return{x:this.left,y:this.top,width:this.width,height:this.height}}}),Object.defineProperty(d,"scale",{get:function(){return Math.max(this.scaleX,this.scaleY)},set:function(e){this.scaleX=e,this.scaleY=e}}),Object.defineProperty(d,"scaleWidth",{get:function(){return this.width*this.scaleX}}),Object.defineProperty(d,"scaleHeight",{get:function(){return this.height*this.scaleY}}),Object.defineProperty(d,"image",{set:function(e){this._image=i.get(e)}}),Object.defineProperty(d,"center",{get:function(){return{x:this.centerX,y:this.centerY}}}),Object.defineProperty(d,"canReact",{get:function(){return this.acceptInputEvents&&this.visible&&!this.paused}}),Object.defineProperty(d,"imageIndex",{set:function(e){var t=Math.floor(this._image.width/this.width);this.imageX=s.indexToX(e,t)*this.width,this.imageY=s.indexToY(e,t)*this.height}}),t.defaults={parent:null,x:0,y:0,z:1,pivotX:.5,pivotY:.5,anchorX:0,anchorY:0,acceptInputEvents:!1,captureInputEvents:!0,cancelInputEvents:!1,debug:!1,rotation:0,clip:!1,width:0,height:0,scaleX:1,scaleY:1,flipX:!1,flipY:!1,visible:!0,opacity:1,backgroundColor:null,overlayColor:null,compositeOperation:null,image:null,imageX:0,imageY:0,paused:!1,tickSpeed:1,buffer:!1,bufferPadding:0,autoSortChildren:!1}}),n("djinn/TextView",["require","exports","module","./view/View","./utils/string"],function(e,t,n){var r=e("./view/View"),i=e("./utils/string"),t=n.exports=r.extend({init:function(e){e=merge(e,t.defaults),e.parent&&(!e.width||e.width<1)&&(e.width=e.parent.width);if(!e.height||e.height<1)e.height=e.fontSize;this._super(e),this._lineBuffer=null,this._rawText=null,this.color=e.color,this.fontSize=e.fontSize,this.fontFamily=e.fontFamily,this.shadowColor=e.shadowColor,this.shadowX=e.shadowX,this.shadowY=e.shadowY,this.strokeColor=e.strokeColor,this.strokeWidth=e.strokeWidth,this.textAlign=e.textAlign,this.verticalAlign=e.verticalAlign,this.wordWrap=e.wordWrap,this.autoSize=e.autoSize,this.text=e.text},render:function(e){this._super(e);if(this.text===undefined||this.text===null||this.text.length<1)return;this._lineBuffer==null&&this._bufferLines(this.text,e);var t=0,n=0;this.textAlign=="center"&&(t=this.width/2),this.textAlign=="right"&&(t=this.width),this.verticalAlign=="middle"&&(n=this.height/2),this._applyContextSettings(e);var r=e.measureText(this._rawText),i=~~r.width;this.autoSize&&i!==this.width&&(this.width=i,this.height=this.fontSize,this.fire("autoSize"));for(var s=0,o=this._lineBuffer.length;s<o;++s){var u=n+s*this.fontSize,a=this._lineBuffer[s];this.shadowColor&&(e.fillStyle=this.shadowColor,e.fillText(a,t+this.shadowX,u+this.shadowY)),this.strokeColor&&this.strokeWidth&&(e.lineWidth=this.strokeWidth,e.strokeStyle=this.strokeColor,e.strokeText(a,t,u)),e.fillStyle=this.color,e.fillText(a,t,u)}},_applyContextSettings:function(e){var t=i.sprintf("%spx %s",this.fontSize,this.fontFamily);e.font=t,e.textAlign=this.textAlign,e.textBaseline=this.verticalAlign,e.lineWidth=this.strokeWidth},_bufferLines:function(e,t){var e=String(e);this._lineBuffer=[];if(this.wordWrap){this._applyContextSettings(t);var n=e.split(" "),r=0;for(var i=0,s=n.length;i<s;++i){var o=this._lineBuffer[r]||"",u=o.length>0?o+" "+n[i]:n[i];o.length>0&&t.measureText(u).width>this.width?(++r,this._lineBuffer[r]=n[i]):this._lineBuffer[r]=u}}else this._lineBuffer.push(e)}});Object.defineProperty(t.prototype,"text",{get:function(){return this._rawText},set:function(e){this._lineBuffer=null,this._rawText=e===undefined?null:String(e)}}),t.defaults={color:"rgb(0, 0, 0)",fontFamily:"Arial",fontSize:20,shadowColor:null,shadowX:1,shadowY:1,strokeColor:null,strokeWidth:null,text:"",textAlign:"left",verticalAlign:"top",wordWrap:!0,autoSize:!1}}),n("djinn/ui/ProgressBar",["djinn/view/View"],function(e){return e.extend({init:function(e){var e=merge(e,{progress:0});this._super(e),this.progress=Number(e.progress)},render:function(e){this._super(e);var t=this.width*this.progress;e.fillStyle="rgb(100, 100, 100)",e.fillRect(0,0,t,this.height),e.lineWidth=2,e.strokeStyle="rgb(230, 230, 230)",e.strokeRect(0,0,this.width,this.height)}})}),n("djinn/utils/viewEffects",["djinn/math/core","djinn/utils/transitions"],function(e,t){return{alert:function(e,n,r){var n=n||{},i=e.z;e.completeTween({z:Infinity}).tween({scale:n.scale||1.5},(n.duration||500)/2,t.easeBoth,function(){n.midCallback&&n.midCallback()}).tween({scale:1},(n.duration||500)/2,t.easeBoth,function(){e.z=i,r&&r()})},burst:function(e,n,r){e.completeTween({opacity:0,scale:.5}),e.tween({opacity:1,rotation:Math.PI/2,scale:1.5},100,t.linear).tween({opacity:0},100,t.linear,function(){r&&r()})},buttonPress:function(e,n,r){e.completeTween().tween({y:e.y+e.height/10},50,t.linear).tween({y:e.y},50,t.linear,r)},fadeOut:function(e,n,r){var n=n||{};e.completeTween().tween({opacity:0},n.duration||500,t.linear,r)},fadeIn:function(e,n,r){var n=n||{};e.completeTween().tween({opacity:1},n.duration||500,t.linear,r)},fadeInAndOut:function(e,t,n){var t=t||{},r=(t.duration||1e3)/2;e.completeTween({opacity:0,visible:!0}),e.tween({opacity:t.opacity||1},r).tween({opacity:0},r,null,n)},popIn:function(n,r,i){var r=r||{},s=e.random(1,2)==1?2:-2,o=e.clamp(n.x+n.width*s,0,n.parent.width-n.width),u=n.y;n.completeTween({opacity:r.opacity||0,scale:r.scale||.5}),n.y+=n.height/2,n.tween({opacity:1,scale:1,x:o,y:u},200,t.linear).tween({scale:1.25},50,t.linear).tween({scale:1},50,t.linear,i)},popOut:function(e,n,r){e.completeTween({opacity:1}).tween({scale:.75},50,t.linear).tween({opacity:0,scale:2},250,t.linear,r)},shake:function(e,t,n){e.completeTween();var t=t||{},r=t.iterations||10,i=(t.duration||250)/r,s=t.violence||6,o=e.x,u=e.y;for(var a=0;a<r;++a)e.tween({x:e.x+s*(a%2?1:-1)},i);e.delayTween(0,function(){e.x=o,e.y=u,n&&n()})},squishyAppear:function(e,n,r){var n=n||{},i=n.duration||500,s=n.scale||1;e.completeTween({scaleX:2*s,scaleY:0}),e.tween({scaleX:.5*s,scaleY:2*s},i*.3,t.linear).tween({scaleX:s,scaleY:s},i*.7,t.elasticOut,function(){r&&r()})},squishyDisappear:function(e,n,r){var n=n||{},i=n.duration||500,s=n.scale||1;e.completeTween({scaleX:s,scaleY:s}),e.tween({scaleX:.5*s,scaleY:2*s},i*.3,t.linear).tween({scaleX:2*s,scaleY:0},i*.7,t.elasticOut,function(){r&&r()})},vibrate:function(t,n,r){t.completeTween();var n=n||{},i=n.iterations||10,s=(n.duration||250)/i,o=n.violence||6,u=t.x,a=t.y;for(var f=0;f<i;++f)t.tween({x:t.x+e.random(-o,o),y:t.y+e.random(-o,o)},s);t.delayTween(1,function(){t.x=u,t.y=a,r&&r()})}}}),n("djinn/helpers/LoadingScreen",["djinn/manifest","djinn/assets","djinn/view/View","djinn/TextView","djinn/ui/ProgressBar","djinn/utils/viewEffects","djinn/stage"],function(e,t,n,r,i,s,o){var u=merge(e.splash,{fadeDuration:1,displayDuration:0,backgroundColor:"rgb(0, 0, 0)",imageWidth:100,imageHeight:100});return n.extend({init:function(e){Object.defineProperty(this,"loadingProgress",{set:function(e){this._loadingBar.progress=e,this._loadingText.text="LOADING: "+~~(e*100)+"%"}});var e=merge({tag:"LoadingScreen",acceptInputEvents:!0,cancelInputEvents:!0,visible:!1,backgroundColor:u.backgroundColor,z:Infinity},e);this._super(e);if(u.images&&u.images.length>0){var s=u.images[o.sizeIndex];t.load(s.image),this._splashImage=(new n(merge({parent:this},s))).align("center","center")}var a=this.height*.05;this._loadingBar=(new i({parent:this,visible:!1,width:this.width*.8,height:a})).align("center","bottom",0,-a),this._loadingText=(new r({parent:this,visible:!1,text:"LOADING",textAlign:"center",verticalAlign:"middle",color:"rgb(255, 255, 255)",fontSize:~~(a*.75),height:a})).align("center","bottom",0,-a),this._uiDelayTimer=this.createTimer(500,"_onDelayElapsed"),this.on("inputStart",this,"_onInputStart")},show:function(e){this.set({opacity:0,visible:!0}),s.fadeIn(this,{duration:u.fadeDuration}),this.delayTween(u.displayDuration,function(){e&&e()}),this._uiDelayTimer.start()},hide:function(e){this.acceptInputEvents=!1,s.fadeOut(this,{duration:u.fadeDuration},bind(this,function(){this.visible=!1,e&&e()}))},_onDelayElapsed:function(){this._uiDelayTimer.stop(),this._loadingBar.progress<1&&(this._loadingText.visible=!0,this._loadingBar.visible=!0)},_onInputStart:function(e){this._onDelayElapsed(),this.completeTween()}})}),n("djinn/Collection",["require","exports","module","djinn/Emitter","djinn/utils/array"],function(e,t,n){var r=e("djinn/Emitter"),i=e("djinn/utils/array"),t=n.exports=r.extend({init:function(e){this._super(e),this.items=[],this._itemIDSeed=0,this._lookup={},this._length=0,this._indexPool=[]},add:function(e){typeof e.id=="undefined"&&(e.id=++this._itemIDSeed);if(this.has(e.id))return console.warn("[Collection.add] Item ID conflict: "+e.id),null;if(this._indexPool.length>0){var t=this._indexPool.shift();this.items[t]=e}else{this._length=this.items.push(e);var t=this._length-1}return this._lookup[e.id]=t,this.fire("add",[e]),e.id},remove:function(e,t){var n=e.id||e,r=this._getIndex(n);if(!this._isValidIndex(r))return null;var e=this.items[r];return this.items[r]=null,delete this._lookup[n],this._indexPool.push(r),t&&e.removeListeners&&e.removeAllListeners(),this.fire("remove",[e]),e},has:function(e){return this.get(e)!==null},get:function(e){var t=this._getIndex(e);if(isNaN(t)||t>=this._length)return null;var n=this.items[t]||null;return n},forEach:function(e,t){for(var n=0;n<this._length;++n){var r=this.items[n];if(r===null)continue;t?e.call(t,r,this):e(r,this)}},sort:function(){this.items.sort(function(e,t){return e?t?t.id-e.id:-1:1}),this._rebuild()},pickRandom:function(){return i.pickRandom(this.items)},removeAll:function(e){this.forEach(function(t,n){if(!t)return;this.remove(t.id,e)},this),this.items=[],this._lookup={},this._indexPool=[],this._length=0},_getIndex:function(e){return this._lookup[e]},_isValidIndex:function(e){return e>=0&&e<this._length},_rebuild:function(){this._lookup={},this._indexPool=[];for(var e=0,t=this.items.length;e<t;++e){var n=this.items[e];n?this._lookup[n.id]=e:this._indexPool.push(e)}}});Object.defineProperty(t.prototype,"length",{get:function(){return this._length}})}),n("djinn/utils/log",["require","exports","module","../Emitter","./string"],function(e,t,n){var r=e("../Emitter"),i=e("./string"),s=r.extend({init:function(e){this._super(e),this.messages=[]},info:function(e){this.messages.push(e),this.fire("message",[e]),console.info(e)},warn:function(e){this.messages.push(e),this.fire("message",[e]),console.warn(e)},error:function(e){this.messages.push(e),this.fire("message",[e]),console.error(e)}});n.exports=new s}),function(){var e={},t=null,r=!0,i=!1;try{typeof AudioContext!="undefined"?t=new AudioContext:typeof webkitAudioContext!="undefined"?t=new webkitAudioContext:r=!1}catch(s){r=!1}if(!r)if(typeof Audio!="undefined")try{new Audio}catch(s){i=!0}else i=!0;if(r){var o=typeof t.createGain=="undefined"?t.createGainNode():t.createGain();o.gain.value=1,o.connect(t.destination)}var u=function(){this._volume=1,this._muted=!1,this.usingWebAudio=r,this.noAudio=i,this._howls=[]};u.prototype={volume:function(e){var t=this;e=parseFloat(e);if(e>=0&&e<=1){t._volume=e,r&&(o.gain.value=e);for(var n in t._howls)if(t._howls.hasOwnProperty(n)&&t._howls[n]._webAudio===!1)for(var i=0;i<t._howls[n]._audioNode.length;i++)t._howls[n]._audioNode[i].volume=t._howls[n]._volume*t._volume;return t}return r?o.gain.value:t._volume},mute:function(){return this._setMuted(!0),this},unmute:function(){return this._setMuted(!1),this},_setMuted:function(e){var t=this;t._muted=e,r&&(o.gain.value=e?0:t._volume);for(var n in t._howls)if(t._howls.hasOwnProperty(n)&&t._howls[n]._webAudio===!1)for(var i=0;i<t._howls[n]._audioNode.length;i++)t._howls[n]._audioNode[i].muted=e}};var a=new u,f=null;if(!i){f=new Audio;var l={mp3:!!f.canPlayType("audio/mpeg;").replace(/^no$/,""),opus:!!f.canPlayType('audio/ogg; codecs="opus"').replace(/^no$/,""),ogg:!!f.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/,""),wav:!!f.canPlayType('audio/wav; codecs="1"').replace(/^no$/,""),aac:!!f.canPlayType("audio/aac;").replace(/^no$/,""),m4a:!!(f.canPlayType("audio/x-m4a;")||f.canPlayType("audio/m4a;")||f.canPlayType("audio/aac;")).replace(/^no$/,""),mp4:!!(f.canPlayType("audio/x-mp4;")||f.canPlayType("audio/mp4;")||f.canPlayType("audio/aac;")).replace(/^no$/,""),weba:!!f.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/,"")}}var c=function(e){var t=this;t._autoplay=e.autoplay||!1,t._buffer=e.buffer||!1,t._duration=e.duration||0,t._format=e.format||null,t._loop=e.loop||!1,t._loaded=!1,t._sprite=e.sprite||{},t._src=e.src||"",t._pos3d=e.pos3d||[0,0,-0.5],t._volume=e.volume!==undefined?e.volume:1,t._urls=e.urls||[],t._rate=e.rate||1,t._model=e.model||null,t._onload=[e.onload||function(){}],t._onloaderror=[e.onloaderror||function(){}],t._onend=[e.onend||function(){}],t._onpause=[e.onpause||function(){}],t._onplay=[e.onplay||function(){}],t._onendTimer=[],t._webAudio=r&&!t._buffer,t._audioNode=[],t._webAudio&&t._setupAudioNode(),a._howls.push(t),t.load()};c.prototype={load:function(){var t=this,n=null;if(i){t.on("loaderror");return}for(var r=0;r<t._urls.length;r++){var s,o;if(t._format)s=t._format;else{o=t._urls[r].toLowerCase().split("?")[0],s=o.match(/.+\.([^?]+)(\?|$)/),s=s&&s.length>=2?s:o.match(/data\:audio\/([^?]+);/);if(!s){t.on("loaderror");return}s=s[1]}if(l[s]){n=t._urls[r];break}}if(!n){t.on("loaderror");return}t._src=n;if(t._webAudio)h(t,n);else{var f=new Audio;f.addEventListener("error",function(){f.error&&f.error.code===4&&(u.noAudio=!0),t.on("loaderror",{type:f.error?f.error.code:0})},!1),t._audioNode.push(f),f.src=n,f._pos=0,f.preload="auto",f.volume=a._muted?0:t._volume*a.volume(),e[n]=t;var c=function(){t._duration=Math.ceil(f.duration*10)/10,Object.getOwnPropertyNames(t._sprite).length===0&&(t._sprite={_default:[0,t._duration*1e3]}),t._loaded||(t._loaded=!0,t.on("load")),t._autoplay&&t.play(),f.removeEventListener("canplaythrough",c,!1)};f.addEventListener("canplaythrough",c,!1),f.load()}return t},urls:function(e){var t=this;return e?(t.stop(),t._urls=typeof e=="string"?[e]:e,t._loaded=!1,t.load(),t):t._urls},play:function(e,n){var r=this;typeof e=="function"&&(n=e);if(!e||typeof e=="function")e="_default";return r._loaded?r._sprite[e]?(r._inactiveNode(function(i){i._sprite=e;var s=i._pos>0?i._pos:r._sprite[e][0]/1e3,o=0;r._webAudio?(o=r._sprite[e][1]/1e3-i._pos,i._pos>0&&(s=r._sprite[e][0]/1e3+s)):o=r._sprite[e][1]/1e3-(s-r._sprite[e][0]/1e3);var u=!!r._loop||!!r._sprite[e][2],f=typeof n=="string"?n:Math.round(Date.now()*Math.random())+"",l;(function(){var t={id:f,sprite:e,loop:u};l=setTimeout(function(){!r._webAudio&&u&&r.stop(t.id).play(e,t.id),r._webAudio&&!u&&(r._nodeById(t.id).paused=!0,r._nodeById(t.id)._pos=0),!r._webAudio&&!u&&r.stop(t.id),r.on("end",f)},o*1e3),r._onendTimer.push({timer:l,id:t.id})})();if(r._webAudio){var c=r._sprite[e][0]/1e3,h=r._sprite[e][1]/1e3;i.id=f,i.paused=!1,d(r,[u,c,h],f),r._playStart=t.currentTime,i.gain.value=r._volume,typeof i.bufferSource.start=="undefined"?i.bufferSource.noteGrainOn(0,s,o):i.bufferSource.start(0,s,o)}else{if(!(i.readyState===4||!i.readyState&&navigator.isCocoonJS))return r._clearEndTimer(f),function(){var t=r,s=e,o=n,u=i,a=function(){t.play(s,o),u.removeEventListener("canplaythrough",a,!1)};u.addEventListener("canplaythrough",a,!1)}(),r;i.readyState=4,i.id=f,i.currentTime=s,i.muted=a._muted||i.muted,i.volume=r._volume*a.volume(),setTimeout(function(){i.play()},0)}return r.on("play"),typeof n=="function"&&n(f),r}),r):(typeof n=="function"&&n(),r):(r.on("load",function(){r.play(e,n)}),r)},pause:function(e){var t=this;if(!t._loaded)return t.on("play",function(){t.pause(e)}),t;t._clearEndTimer(e);var n=e?t._nodeById(e):t._activeNode();if(n){n._pos=t.pos(null,e);if(t._webAudio){if(!n.bufferSource||n.paused)return t;n.paused=!0,typeof n.bufferSource.stop=="undefined"?n.bufferSource.noteOff(0):n.bufferSource.stop(0)}else n.pause()}return t.on("pause"),t},stop:function(e){var t=this;if(!t._loaded)return t.on("play",function(){t.stop(e)}),t;t._clearEndTimer(e);var n=e?t._nodeById(e):t._activeNode();if(n){n._pos=0;if(t._webAudio){if(!n.bufferSource||n.paused)return t;n.paused=!0,typeof n.bufferSource.stop=="undefined"?n.bufferSource.noteOff(0):n.bufferSource.stop(0)}else isNaN(n.duration)||(n.pause(),n.currentTime=0)}return t},mute:function(e){var t=this;if(!t._loaded)return t.on("play",function(){t.mute(e)}),t;var n=e?t._nodeById(e):t._activeNode();return n&&(t._webAudio?n.gain.value=0:n.muted=!0),t},unmute:function(e){var t=this;if(!t._loaded)return t.on("play",function(){t.unmute(e)}),t;var n=e?t._nodeById(e):t._activeNode();return n&&(t._webAudio?n.gain.value=t._volume:n.muted=!1),t},volume:function(e,t){var n=this;e=parseFloat(e);if(e>=0&&e<=1){n._volume=e;if(!n._loaded)return n.on("play",function(){n.volume(e,t)}),n;var r=t?n._nodeById(t):n._activeNode();return r&&(n._webAudio?r.gain.value=e:r.volume=e*a.volume()),n}return n._volume},loop:function(e){var t=this;return typeof e=="boolean"?(t._loop=e,t):t._loop},sprite:function(e){var t=this;return typeof e=="object"?(t._sprite=e,t):t._sprite},pos:function(e,n){var r=this;if(!r._loaded)return r.on("load",function(){r.pos(e)}),typeof e=="number"?r:r._pos||0;e=parseFloat(e);var i=n?r._nodeById(n):r._activeNode();if(i)return e>=0?(r.pause(n),i._pos=e,r.play(i._sprite,n),r):r._webAudio?i._pos+(t.currentTime-r._playStart):i.currentTime;if(e>=0)return r;for(var s=0;s<r._audioNode.length;s++)if(r._audioNode[s].paused&&r._audioNode[s].readyState===4)return r._webAudio?r._audioNode[s]._pos:r._audioNode[s].currentTime},pos3d:function(e,t,n,r){var i=this;t=typeof t=="undefined"||!t?0:t,n=typeof n=="undefined"||!n?-0.5:n;if(!i._loaded)return i.on("play",function(){i.pos3d(e,t,n,r)}),i;if(e>=0||e<0){if(i._webAudio){var s=r?i._nodeById(r):i._activeNode();s&&(i._pos3d=[e,t,n],s.panner.setPosition(e,t,n),s.panner.panningModel=i._model||"HRTF")}return i}return i._pos3d},fade:function(e,t,n,r,i){var s=this,o=Math.abs(e-t),u=e>t?"down":"up",a=o/.01,f=n/a;if(!s._loaded)return s.on("load",function(){s.fade(e,t,n,r,i)}),s;s.volume(e,i);for(var l=1;l<=a;l++)(function(){var e=s._volume+(u==="up"?.01:-0.01)*l,n=Math.round(1e3*e)/1e3,o=t;setTimeout(function(){s.volume(n,i),n===o&&r&&r()},f*l)})()},fadeIn:function(e,t,n){return this.volume(0).play().fade(0,e,t,n)},fadeOut:function(e,t,n,r){var i=this;return i.fade(i._volume,e,t,function(){n&&n(),i.pause(r),i.on("end")},r)},_nodeById:function(e){var t=this,n=t._audioNode[0];for(var r=0;r<t._audioNode.length;r++)if(t._audioNode[r].id===e){n=t._audioNode[r];break}return n},_activeNode:function(){var e=this,t=null;for(var n=0;n<e._audioNode.length;n++)if(!e._audioNode[n].paused){t=e._audioNode[n];break}return e._drainPool(),t},_inactiveNode:function(e){var t=this,n=null;for(var r=0;r<t._audioNode.length;r++)if(t._audioNode[r].paused&&t._audioNode[r].readyState===4){e(t._audioNode[r]),n=!0;break}t._drainPool();if(n)return;var i;if(t._webAudio)i=t._setupAudioNode(),e(i);else{t.load(),i=t._audioNode[t._audioNode.length-1];var s=navigator.isCocoonJS?"canplaythrough":"loadedmetadata",o=function(){i.removeEventListener(s,o,!1),e(i)};i.addEventListener(s,o,!1)}},_drainPool:function(){var e=this,t=0,n;for(n=0;n<e._audioNode.length;n++)e._audioNode[n].paused&&t++;for(n=e._audioNode.length-1;n>=0;n--){if(t<=5)break;e._audioNode[n].paused&&(e._webAudio&&e._audioNode[n].disconnect(0),t--,e._audioNode.splice(n,1))}},_clearEndTimer:function(e){var t=this,n=0;for(var r=0;r<t._onendTimer.length;r++)if(t._onendTimer[r].id===e){n=r;break}var i=t._onendTimer[n];i&&(clearTimeout(i.timer),t._onendTimer.splice(n,1))},_setupAudioNode:function(){var e=this,n=e._audioNode,r=e._audioNode.length;return n[r]=typeof t.createGain=="undefined"?t.createGainNode():t.createGain(),n[r].gain.value=e._volume,n[r].paused=!0,n[r]._pos=0,n[r].readyState=4,n[r].connect(o),n[r].panner=t.createPanner(),n[r].panner.panningModel=e._model||"equalpower",n[r].panner.setPosition(e._pos3d[0],e._pos3d[1],e._pos3d[2]),n[r].panner.connect(n[r]),n[r]},on:function(e,t){var n=this,r=n["_on"+e];if(typeof t=="function")r.push(t);else for(var i=0;i<r.length;i++)t?r[i].call(n,t):r[i].call(n);return n},off:function(e,t){var n=this,r=n["_on"+e],i=t.toString();for(var s=0;s<r.length;s++)if(i===r[s].toString()){r.splice(s,1);break}return n},unload:function(){var t=this,n=t._audioNode;for(var r=0;r<t._audioNode.length;r++)n[r].paused||t.stop(n[r].id),t._webAudio?n[r].disconnect(0):n[r].src="";for(r=0;r<t._onendTimer.length;r++)clearTimeout(t._onendTimer[r].timer);var i=a._howls.indexOf(t);i!==null&&i>=0&&a._howls.splice(i,1),delete e[t._src],t=null}};if(r)var h=function(n,r){if(r in e)n._duration=e[r].duration,p(n);else{var i=new XMLHttpRequest;i.open("GET",r,!0),i.responseType="arraybuffer",i.onload=function(){t.decodeAudioData(i.response,function(t){t&&(e[r]=t,p(n,t))},function(e){n.on("loaderror")})},i.onerror=function(){n._webAudio&&(n._buffer=!0,n._webAudio=!1,n._audioNode=[],delete n._gainNode,n.load())};try{i.send()}catch(s){i.onerror()}}},p=function(e,t){e._duration=t?t.duration:e._duration,Object.getOwnPropertyNames(e._sprite).length===0&&(e._sprite={_default:[0,e._duration*1e3]}),e._loaded||(e._loaded=!0,e.on("load")),e._autoplay&&e.play()},d=function(n,r,i){var s=n._nodeById(i);s.bufferSource=t.createBufferSource(),s.bufferSource.buffer=e[n._src],s.bufferSource.connect(s.panner),s.bufferSource.loop=r[0],r[0]&&(s.bufferSource.loopStart=r[1],s.bufferSource.loopEnd=r[1]+r[2]),s.bufferSource.playbackRate.value=n._rate};typeof n=="function"&&n.amd&&n("djinn/audio/Howler",[],function(){return{Howler:a,Howl:c}}),typeof exports!="undefined"&&(exports.Howler=a,exports.Howl=c),typeof window!="undefined"&&(window.Howler=a,window.Howl=c)}(),n("djinn/audio/jukebox",["require","exports","module","../Emitter","../client","../math/core","../utils/array","../utils/log","./Howler"],function(e,t,n){var r=e("../Emitter"),i=e("../client"),s=e("../math/core"),o=e("../utils/array"),u=e("../utils/log"),a=e("./Howler"),f=r.extend({init:function(e){this._super(e),this.audioData=null,this.multishotThreshold=100,this.sounds={},this._unmuteOnShow=!1,this._playTimes={},this.gain=1,this.volumeExponent=1,i.on("visibilityChange",this,"_onClientVisibilityChange")},configure:function(e){this.audioData=e},mute:function(){a.Howler.mute(),this.fire("mute")},unmute:function(){a.Howler.unmute(),this.fire("unmute")},toggleMute:function(){this.muted=!this.muted},preloadByType:function(e){var e=o.force(e),t=this.sounds;for(var n in t){var r=this._getAudioData(n),i=r.type||"sound";if(!o.contains(e,i))continue;this.load(n)}},load:function(e,t){var n=this.sounds;if(n[e])return n[e];var r=this._getAudioData(e);if(!r)return;var i=this._getVolume(e),s=n[e]=new a.Howl({urls:r.paths,loop:r.loop,buffer:r.type==="music",onload:function(){this.volume(i),t&&t()},onloaderror:function(){u.warn("[jukebox.load] Failed to load: "+e)}});return s},play:function(e,t){var n=this._getSound(e,!0);if(!n)return;var r=this._playTimes,i=r[e],s=Date.now();if(i&&s-i<this.multishotThreshold)return;r[e]=s,t!==undefined&&n.pos(t),n.play(),n.volume(this._getVolume(e))},pause:function(e){var t=this._getSound(e);if(!t)return;t.pause()},stop:function(e){var t=this._getSound(e);if(!t)return;t.stop()},fadeIn:function(e,t){var n=this._getSound(e,!0);if(!n)return;var r=this._getVolume(e);n.play().fade(0,r,t)},fadeOut:function(e,t){var n=this._getSound(e);if(!n)return;n.fade(n.volume(),0,t,function(){n.stop()})},_getAudioData:function(e){var t=this.audioData;return t&&t.sounds&&t.sounds[e]?t.sounds[e]:(u.warn("[jukebox._getAudioData] No audio data: "+e),null)},_getSound:function(e,t){var n=this.sounds;if(n&&n[e])return n[e];if(t){var r=this.load(e);return r?r:(u.warn("[jukebox._getSound] Unable to load sound: "+e),null)}return null},_getVolume:function(e){var t=this._getAudioData(e);if(!t)return 1;switch(t.type){case"music":var n=this.musicVolume;break;default:var n=this.soundVolume}var r=this.volumeExponent;return r!==1&&(n=(Math.pow(r,n)-1)/(r-1)*this.gain),t.volume!==undefined&&(n*=t.volume),n},_updateVolume:function(){var e=this.sounds;for(var t in e){var n=e[t],r=this._getVolume(t);n.volume()!==r&&n.volume(r)}},_onClientVisibilityChange:function(e){e?this.muted||(this.mute(),this._unmuteOnShow=!0):this._unmuteOnShow&&(this.unmute(),this._unmuteOnShow=!1)}}),l=f.prototype;Object.defineProperty(l,"muted",{get:function(){return a.Howler._muted},set:function(e){e?this.mute():this.unmute()}}),Object.defineProperty(l,"musicVolume",{get:function(){return this._musicVolume},set:function(e){this._musicVolume=s.clamp(e,0,1),this._updateVolume()}}),Object.defineProperty(l,"soundVolume",{get:function(){return this._soundVolume},set:function(e){this._soundVolume=s.clamp(e,0,1),this._updateVolume()}}),n.exports=new f}),n("djinn/Scene",["require","exports","module","./view/View","./audio/jukebox"],function(e,t,n){var r=e("./view/View"),i=e("./audio/jukebox"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.musicKey=e.musicKey,this.fadeDuration=e.fadeDuration,this._isSetup=!1},setup:function(){this.musicKey&&i.load(this.musicKey)},reset:function(){},activate:function(e,t){this.musicKey&&(!t||this.musicKey!==t.musicKey)&&i.fadeIn(this.musicKey,this.fadeDuration),this.captureInputEvents=!0,this.oldSceneId=e},deactivate:function(e,t){this.musicKey&&this.musicKey!==t.musicKey&&i.fadeOut(this.musicKey,this.fadeDuration),this.captureInputEvents=!1},cleanup:function(e,t){this.musicKey&&this.musicKey!==t.musicKey&&i.stop(this.musicKey)},fireSceneEvent:function(e){var t={id:this.id,eventName:e};this.fire(e,[t])}});t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,clip:!0,fadeDuration:500,musicKey:null,opacity:0,visible:!1,tag:"Scene"}}),n("djinn/view/effects/Spotlight",["djinn/view/View","djinn/stage"],function(e,t){var n=["width","height","spotlightX","spotlightY","spotlightRadius"];return e.extend({init:function(e){var e=merge(e,{backgroundColor:"rgb(0, 0, 0)",spotlightX:0,spotlightY:0,spotlightRadius:100});this._super(e),this._buffer=t.createBuffer(this.width,this.height),this._bufferDirty=!0,this.spotlightX=Number(e.spotlightX),this.spotlightY=Number(e.spotlightY),this.spotlightRadius=Number(e.spotlightRadius),this._cachedProps={},t.on("resize",this,function(){this._bufferDirty=!0})},render:function(e){var t=this._buffer;if(t.width!==this.width||t.height!==this.height)t.width=this.width,t.height=this.height,this._bufferDirty=!0;if(!this._bufferDirty)for(var r=0,i=n.length;r<i;++r){var s=n[r];if(this._cachedProps[s]!=this[s]){this._bufferDirty=!0;break}}if(this._bufferDirty){var o=t.getContext("2d");o.save(),o.clearRect(0,0,this.width,this.height),o.fillStyle=this.backgroundColor,o.fillRect(0,0,this.width,this.height),o.globalCompositeOperation="destination-out",o.beginPath(),o.arc(this.spotlightX,this.spotlightY,this.spotlightRadius,0,Math.PI*2,!0),o.fill(),o.closePath(),o.restore();for(var r=0,i=n.length;r<i;++r){var s=n[r];this._cachedProps[s]=this[s]}this._bufferDirty=!1}e.drawImage(this._buffer,0,0,this.width,this.height)}})}),n("djinn/utils/sceneTransitions",["require","exports","module","djinn/utils/transitions","djinn/view/effects/Spotlight"],function(e,t,n){var r=e("djinn/utils/transitions"),i=e("djinn/view/effects/Spotlight"),s=function(e,t){e.completeTween(merge(t,{visible:!0,opacity:1,scale:1,rotation:0,x:0,y:0}))};t.none=function(e,t,n,r){s(t,{visible:!0}),e.visible=!1,r&&r()},t.crossFade=function(e,t,n,r){var n=merge(n,{duration:500});s(e),s(t,{opacity:0}),e.tween({opacity:0},n.duration,null,function(){e.visible=!1,r&&r()}),t.tween({opacity:1},n.duration)},t.fade=function(e,t,n,r){var n=merge(n,{duration:500});s(e),s(t,{opacity:0}),e.tween({opacity:0},n.duration,null,function(){e.visible=!1,t.tween({opacity:1},n.duration,null,r)})},t.rotateIn=function(e,t,n,r){var n=merge(n,{duration:1e3});s(t,{scale:0,rotation:Math.PI}),t.tween({scale:1,rotation:0},n.duration,null,function(){e.visible=!1,r&&r()})},t.slideUp=function(e,t,n,i){var n=merge(n,{duration:500});s(e),s(t,{y:t.parent.height}),e.tween({y:-e.height},n.duration,r.easeIn,function(){e.visible=!1,i&&i()}),t.tween({y:0},n.duration,r.easeIn)},t.slideDown=function(e,t,n,i){var n=merge(n,{duration:500});s(e),s(t,{bottom:0}),e.tween({y:e.height},n.duration,r.easeIn,function(){e.visible=!1,i&&i()}),t.tween({y:0},n.duration,r.easeIn)},t.slideLeft=function(e,t,n,i){var n=merge(n,{duration:500});s(e),s(t,{x:t.width}),e.tween({right:0},n.duration,r.easeIn,function(){e.visible=!1,i&&i()}),t.tween({x:0},n.duration,r.easeIn)},t.slideRight=function(e,t,n,i){var n=merge(n,{duration:500});s(e),s(t,{right:0}),e.tween({x:e.width},n.duration,r.easeIn,function(){e.visible=!1,i&&i()}),t.tween({x:0},n.duration,r.easeIn)};var o=new i({backgroundColor:"black",visible:!1});t.spotlight=function(e,t,n,i){var n=merge(n,{duration:2e3,delay:500});s(e),o.completeTween({width:e.width,height:e.height,visible:!0,spotlightX:e.width/2,spotlightY:e.height/2,spotlightRadius:e.width}),o.removeFromParent(),e.parent.addChild(o),o.tween({spotlightRadius:0},n.duration,r.easeIn,function(){e.visible=!1,s(t),o.delayTween(n.delay).tween({spotlightRadius:e.width},n.duration,r.easeIn,function(){o.visible=!1,o.removeFromParent(),i&&i()})})},t.zoomSpotlight=function(e,t,n,i){var n=merge(n,{duration:2e3,delay:500,scale:2});s(e),o.completeTween({width:e.width,height:e.height,visible:!0,z:Math.max(e.z,t.z)+1,opacity:0,spotlightX:e.width/2,spotlightY:e.height/2,spotlightRadius:0}),o.removeFromParent(),e.parent.addChild(o),e.tween({scale:n.scale},n.duration),o.tween({opacity:1},n.duration,r.easeIn,function(){e.visible=!1,s(t),o.delayTween(n.delay).tween({spotlightRadius:e.width},n.duration,r.easeIn,function(){o.visible=!1,o.removeFromParent(),i&&i()})})}}),n("djinn/SceneDirector",["require","exports","module","djinn/Emitter","djinn/Collection","djinn/Scene","djinn/utils/sceneTransitions"],function(e,t,n){var r=e("djinn/Emitter"),i=e("djinn/Collection"),s=e("djinn/Scene"),o=e("djinn/utils/sceneTransitions"),t=n.exports=r.extend({init:function(e){this._super(e),this.backgroundColor=e.backgroundColor||"black",this.view=e.view},setup:function(e){this._data=e},load:function(){this._activeSceneId=null,this.scenes=new i,this._defaultScene=new s({parent:this.view,backgroundColor:this.backgroundColor,visible:!1});var e=this._data;for(var t in e){var n=e[t],r=new n.ctor({parent:this.view,id:t});for(var o in n.events)r.on(o,this,"_onSceneEvent");this.scenes.add(r)}},ready:function(){},activateScene:function(e,t,n){var r=this.scenes,i=this._activeSceneId,s=r.get(this._activeSceneId)||this._defaultScene,u=r.get(e);this._activeSceneId=e,u.isSetup||(u.setup(),u.isSetup=!0),u.reset(i);var t=o[t||"fade"];this.view.backgroundColor=this.backgroundColor,s&&(s.captureInputEvents=!1,s.deactivate(this._activeSceneId,u)),u.captureInputEvents=!1,t(s,u,n,bind(this,function(){this.view.backgroundColor=null,s.cleanup(e,u),u.activate(i,s)}))},_onSceneEvent:function(e){var t=this._data[e.id].events[e.eventName];this.activateScene(t.id,t.transition,t.conf)}});Object.defineProperty(t.prototype,"activeSceneId",{get:function(){return this._activeSceneId}}),Object.defineProperty(t.prototype,"activeScene",{get:function(){return this.scenes.get(this._activeSceneId)}})}),n("djinn/platforms/steam",["require","exports","module","../utils/log"],function(e,t,n){var r=e("../utils/log");t.init=function(){var e=greenworks.initAPI();r.info("[steam.init] Success? "+e)},t.isCloudEnabled=function(){return greenworks.isCloudEnabledForUser()&&greenworks.isCloudEnabled()},t.getCloudQuota=function(e){greenworks.getCloudQuota(function(t,n){e&&e(t,n)},function(){r.warn("[steam.getCloudData] Failed to get cloud quota")})},t.writeCloudFile=function(e,t,n){greenworks.saveTextToFile(e,t,function(){n&&n()},function(){r.warn("[steam.writeCloudFile] Failed to write cloud file: "+e)})},t.readCloudFile=function(e,t){greenworks.readTextFromFile(e,function(e){t&&t(null,e)},function(){r.warn("[steam.readCloudFile] Failed to read cloud file: "+e),t&&t("Failed to read cloud file",null)})},t.activateAchievement=function(e,t){greenworks.activateAchievement(e,function(){t&&t()},function(){r.warn("[steam.activateAchievement] Failed to activate: "+e)})}}),n("djinn/Game",["require","exports","module","./core/time","./input/keyboard","./input/gamepad","./Emitter","./client","./stage","./helpers/LoadingScreen","./assets","./view/View","./SceneDirector","./platforms/steam"],function(e,t,n){var r=e("./core/time"),i=e("./input/keyboard"),s=e("./input/gamepad"),o=e("./Emitter"),u=e("./client"),a=e("./stage"),f=e("./helpers/LoadingScreen"),l=e("./assets"),c=e("./view/View"),h=e("./SceneDirector"),p=e("./platforms/steam"),t=n.exports=o.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),u.isSteam&&p.init(),this.showLoadingScreen=e.showLoadingScreen,this._splashFinished=!1,this._loadingProgress=0,this.view=new c({tag:"GameRootView",acceptInputEvents:!0,width:a.width,height:a.height}),this._loadingScreen=new f({parent:this.view,visible:!1}),this._sceneDirector=new h({view:this.view}),a.on("resize",this,"_onStageResize")},run:function(){r.start(this._update.bind(this)),this.showLoadingScreen&&(a.eraseBeforeRender=!0,this._loadingScreen.show(bind(this,"_onSplashFinish")))},stop:function(){r.stop()},setupScenes:function(e){this._sceneDirector.setup(e)},getSceneById:function(e){return this._sceneDirector.scenes.get(e)},getActiveSceneId:function(){return this._sceneDirector.activeSceneId},getActiveScene:function(){return this._sceneDirector.activeScene},activateScene:function(e,t,n){this._sceneDirector.activateScene(e,t,n)},preloadAssets:function(e){l.load(e,bind(this,"_onLoadComplete"),bind(this,"_onLoadProgress"))},_onLoadProgress:function(e,t,n,r,i){this._loadingProgress=i,this._loadingScreen.loadingProgress=this._loadingProgress,this._checkGameReady()},_onLoadComplete:function(){a.acceptInput=!0,this._sceneDirector.load(),this.fire("load")},_update:function(e){this._react(),this.update&&this.update(e),this.view.preTick(e),this._render(),i.endFrame(),s.endFrame()},_react:function(){var e=a.getInputEvents(),t=e.length;for(var n=0;n<t;++n)this.view.react(e[n])},_render:function(){a.renderView(this.view)},_onStageResize:function(){this.view.width=a.width,this.view.height=a.height},_onSplashFinish:function(){this._splashFinished=!0,this._checkGameReady()},_checkGameReady:function(){this._splashFinished&&this._loadingProgress===1&&this._loadingScreen.hide(bind(this,function(){a.eraseBeforeRender=!1,this._sceneDirector.ready(),this.fire("ready")}))}});t.defaults={showLoadingScreen:!1}}),n("djinn/utils/storage",["require","exports","module","./log"],function(e,t,n){var r=e("./log");t.set=function(e,t){try{localStorage.setItem(e,t)}catch(n){r.warn("[storage.set] Failed to set localStorage! Quota exceeded?"),r.warn("[storage.set] "+n.message)}},t.get=function(e){var t=null;try{t=localStorage.getItem(e)}catch(n){r.warn("[storage.get] Failed to get: "+e),r.warn("[storage.get] "+n.message)}return t},t.remove=function(e){try{localStorage.removeItem(e)}catch(t){r.warn("[storage.remove] Failed to remove: "+e),r.warn("[storage.remove] "+t.message)}},t.setObject=function(e,n){var r=JSON.stringify(n);return t.set(e,r)},t.getObject=function(e){var n=t.get(e),i=null;try{i=JSON.parse(n)}catch(s){r.warn("[storage.getObject] Could not parse JSON: "+n),r.warn("[storage.getObject] "+s.message)}return i}}),n("djinn/achievements",["require","exports","module","./Emitter","./manifest","./utils/storage","./utils/object","./client","./platforms/steam"],function(e,t,n){var r=e("./Emitter"),i=e("./manifest"),s=e("./utils/storage"),o=e("./utils/object"),u=e("./client"),a=e("./platforms/steam"),f=r.extend({init:function(e){this._super(e),this._progressData={},this._data={},this._storageKey=i.shortName+"_achievements",this.persist=!0},setup:function(e){this._data=e,this._load()},setCount:function(e,t){var n=this._progressData[e];n?n.count=t:this._progressData[e]={earned:t>=1?Date.now():null,progress:0,count:t}},trackProgress:function(e,t){var n=this._data[e],r=this._progressData[e];if(!n){console.info("Invalid achievment: "+e);return}r||(r=this._progressData[e]={earned:null,progress:0,count:0});if(r.count>=1&&!n.multiple)return;r.progress+=t,r.progress>=n.goal&&(r.earned=Date.now(),r.count?r.count+=1:r.count=1,r.progress=0,this.fire("earn",[e,n]),u.isSteam&&a.activateAchievement(e)),this._save()},resetProgress:function(e){var t=this._data[e],n=this._progressData[e];if(!n||n&&n.earned&&!t.multiple)return;n.progress=0,this._save()},list:function(){var e=[];for(var t in this._data){var n=this._data[t],r=this._progressData[t];e.push(merge(r,n))}return e},getById:function(e){var t=this._data[e],n=this._progressData[e];return merge(n,t)},getProgressData:function(){return this._progressData},setProgressData:function(e){if(!e)return;this._progressData=e,this._save()},_load:function(){if(!this.persist)return;var e=s.getObject(this._storageKey);this._progressData=e||{}},_save:function(){if(!this.persist)return;s.setObject(this._storageKey,this._progressData)}}),l=f.prototype;Object.defineProperty(l,"earned",{get:function(){var e=0;for(var t in this._data){var n=this._progressData[t];n&&n.earned&&++e}return e}}),Object.defineProperty(l,"total",{get:function(){return o.getLength(this._data)}}),Object.defineProperty(l,"overallProgress",{get:function(){var e=0,t=0;for(var n in this._data){++t;var r=this._progressData[n];r&&r.earned&&++e}return e/t}}),n.exports=new f}),n("js/competitors",["require","exports","module"],function(e,t,n){n.exports=[{name:"Bounce Bash",developer:"Genero",unlockId:"bouncer",backgroundColor:[89,125,206],clicks:null,darkness:.2,playerPrefab:"playerBoy",price:4.99,rating:null,sales:null,time:7e3,views:null,tiles:[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,9,9,9,9,9,9,9,9,9,9,9,0],[0,0,0,0,0,0,0,0,0,"vTrap",0,9,0,9,0,0],[0,0,"bouncer",0,0,0,0,0,0,0,0,9,0,0,0,0],[8,8,8,0,0,0,0,0,0,0,0,9,0,0,0,0],[0,0,0,0,0,"bouncer",0,0,0,9,0,"vTrap",0,0,0,0],[0,0,0,0,0,9,0,0,0,9,0,0,0,0,"gameGoal",0],[0,"gameStart",0,"bouncer",0,8,0,"bouncer",0,8,9,9,8,"spikes",8,"spikes"],[8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]],playtestData:{left:56,right:187,jump:6},surveyArea:.3,joyCount:16},{name:"Catch a Ride",developer:"Retroladies",unlockId:"hPlatform",playerPrefab:"playerGirl",backgroundColor:[89,125,206],clicks:null,darkness:.5,price:4.99,rating:null,sales:null,time:15e3,views:null,tiles:[[9,9,9,9,0,0,0,0,0,0,0,0,9,9,9,9],[9,0,0,0,0,0,0,0,0,0,9,0,0,0,0,9],[9,9,0,0,0,0,0,0,0,"hPlatform",9,0,0,9,0,9],[9,0,0,0,0,0,8,0,0,0,9,9,8,9,0,9],[0,0,0,0,0,0,0,0,0,0,0,0,8,8,0,8],[0,9,"gameStart",0,0,0,0,0,0,9,9,0,8,0,0,0],[0,9,9,9,0,"hPlatform",0,0,0,0,9,0,"vTrap",0,0,"gameGoal"],[0,0,8,0,0,0,0,0,0,0,8,0,0,"vTrap",0,8],[8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]],playtestData:{left:171,right:308,jump:17},surveyArea:.45,joyCount:22},{name:"Big Bad",boss:!0,unlockId:"sizeMedium",developer:"AD",playerPrefab:"playerJoey",backgroundColor:[128,128,128],clicks:null,darkness:.7,price:29.99,rating:null,sales:null,time:2e4,views:null,tiles:[[13,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,15,15,13],[15,15,15,0,0,0,0,0,0,0,0,"boss",0,0,0,0,0,0,0,0,0,15,15],[15,"vTrap",15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15],[15,0,0,0,0,0,0,0,0,0,0,0,12,12,12,12,12,0,0,0,0,0,15],[15,0,0,0,"gameStart",0,0,0,0,0,0,0,12,12,12,12,12,0,0,0,0,0,15],[15,0,0,0,9,9,0,0,0,0,0,0,12,12,"gameGoal",12,12,0,0,"bouncer",0,0,15],[15,0,0,9,9,0,0,0,0,0,0,0,12,12,12,12,12,0,0,9,0,0,15],[15,0,0,0,0,0,0,0,0,0,0,0,12,12,12,12,12,0,0,9,0,0,15],[15,0,"bouncer",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"bouncer",15],[15,"spikes",15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,15],[15,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15],[15,15,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,15,15],[13,15,15,15,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",15,15,15,15],[13,13,15,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",15,15,13],[13,13,13,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,13,13]],playtestData:null,surveyArea:.5,joyCount:100},{name:"Horizontas",developer:"Genero",unlockId:"hTrap",playerPrefab:"playerBoy",backgroundColor:[89,125,206],clicks:null,darkness:.2,price:4.99,rating:null,sales:null,time:25e3,views:null,tiles:[[9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9],[9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9],[9,9,0,11,11,11,11,11,11,11,11,11,11,11,11,11,0,0,0,0,0,0,9],[9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,9],[9,"hTrap",0,0,0,0,0,0,0,0,0,0,0,0,11,11,11,11,11,11,0,0,9],[10,10,0,0,0,0,0,"hPlatform",0,0,0,0,0,0,11,"vTrap",11,0,0,0,0,0,9],[10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,"hTrap",9,9],[10,0,"gameGoal",0,0,0,0,0,0,0,0,0,"bouncer",0,0,0,11,0,0,0,0,0,9],[10,10,10,10,0,0,0,0,0,0,0,0,9,0,"hTrap",11,11,11,11,11,0,0,9],[10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,9],[9,0,"gameStart",0,0,0,0,0,0,0,0,0,9,9,9,9,11,11,11,11,11,0,9],[9,9,9,9,"hTrap",0,0,0,9,9,9,0,0,0,0,0,0,0,0,0,0,0,9],[9,9,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,"hPlatform",9,9,9],[8,9,9,9,9,9,9,9,9,8,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",9,8],[8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]],playtestData:{left:513,right:405,jump:17},surveyArea:.4,joyCount:52},{name:"Single Signal",developer:"Chronic",unlockId:"pulseBlock",playerPrefab:"playerBoy",backgroundColor:[89,179,206],clicks:null,darkness:.3,price:9.99,rating:null,sales:null,time:36500,views:null,tiles:[[9,9,0,0,0,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[9,0,0,0,0,"vTrap","vTrap","vTrap",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,"pulseBlock","pulseBlock","pulseBlock",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,"pulseBlock","pulseBlock","pulseBlock",0,0,0,0,0,0,0,0,"pulseBlock",0,0,0,0,0,0,0,0,0],[0,0,"pulseBlock",0,"pulseBlock",0,0,0,0,0,0,0,0,"pulseBlock",0,0,0,0,0,0,0,0,0],[0,0,"pulseBlock",0,"pulseBlock","pulseBlock","pulseBlock","pulseBlock",0,0,0,"pulseButton",0,"pulseBlock",0,0,0,0,0,0,0,0,0],[0,0,13,"gameGoal",13,"vTrap","vTrap","vTrap",0,9,9,9,9,9,9,"hPlatform",0,0,0,0,9,0,9],[0,13,13,13,13,9,9,9,9,9,"vTrap",0,0,0,9,"hTrap",0,0,0,0,9,0,9],[0,0,13,13,13,9,9,0,0,0,"pulseBlock",0,0,0,0,0,0,0,0,0,9,0,9],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,8,0,0,0,0,0,0,0,0,0,0,0,"pulseButton",0,0,0,0,0,0,0,0,0],[8,8,8,0,"bouncer",0,0,0,0,13,13,0,0,0,0,0,0,"hPlatform",0,0,13,13,13],[8,8,8,8,8,8,8,8,8,8,13,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",13,"spikes"]],playtestData:{left:391,right:411,jump:27},surveyArea:.4,joyCount:88},{name:"Onandoff",developer:"Genero",unlockId:"intervalRock",playerPrefab:"playerBoy",backgroundColor:[153,128,77],clicks:null,darkness:.3,price:4.99,rating:null,sales:null,time:45e3,views:null,tiles:[[13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],[13,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13],[13,0,0,"gameStart",0,0,0,0,0,0,0,9,9,9,"intervalRock","intervalRock","intervalRock","intervalRock",9,9,9,0,13],[13,0,9,9,9,0,0,"intervalRock","intervalRock",0,0,0,9,0,0,0,0,0,0,9,0,0,13],[13,0,0,9,0,0,0,0,0,0,0,0,9,"spikes","spikes","spikes","spikes","spikes","spikes",9,0,0,13],[13,13,9,9,9,13,13,13,13,13,13,9,9,9,9,9,9,9,9,9,9,0,13],[13,0,0,0,0,0,0,"intervalRock",0,0,0,"intervalRock",0,"intervalRock",0,0,"intervalRock",0,0,"hTrap",9,0,13],[13,0,10,10,10,10,0,"intervalRock",0,"spikes",0,"intervalRock",0,"intervalRock","spikes",0,"intervalRock",0,0,0,0,0,13],[13,0,10,"gameGoal",0,10,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,0,13],[13,0,10,10,0,0,0,0,0,0,0,"intervalRock",0,0,0,0,0,0,0,"hTrap",11,0,13],[13,0,0,0,0,0,0,0,0,0,0,"intervalRock",0,0,0,0,0,"intervalRock",0,0,0,0,13],[13,0,0,0,"intervalRock",0,0,0,"spikes",0,0,"intervalRock",0,0,0,0,0,"intervalRock",0,0,0,0,11],[8,8,0,"intervalRock",13,"intervalRock",0,"intervalRock",13,13,"intervalRock","intervalRock","intervalRock",13,13,"intervalRock","intervalRock","intervalRock","intervalRock","intervalRock",11,11,11],[8,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",11]],playtestData:{left:582,right:514,jump:37},surveyArea:.5,joyCount:100,joyNormal:1,surveyNormal:1},{name:"Dank Dungeon",boss:!0,developer:"Rook",unlockId:"darkness",playerPrefab:"playerGoblin",backgroundColor:[77,77,77],clicks:null,darkness:1,price:29.99,rating:null,sales:null,time:25e3,views:null,tiles:[[8,8,0,0,0,0,0,0,0,0,0,8,0,0,0,12,12,12,12,12,12,12,12],[8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,9,9,9,9,9],[8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,12],[8,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,12],[8,10,10,10,8,0,8,8,8,8,0,0,11,11,0,0,0,0,0,0,0,0,12],[8,8,8,8,8,"spikes",8,8,8,8,"spikes","spikes",11,0,0,0,12,12,12,12,12,0,12],[8,8,8,8,8,8,8,0,0,8,8,11,11,0,0,0,0,12,12,12,9,0,12],[8,8,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,12,0,9,0,12],[8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,8],[8,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,"hTrap",9,"spikes",9,0,8],[9,"gameGoal",9,0,0,0,0,0,0,9,0,"hPlatform",0,0,0,0,0,0,9,9,9,0,8],[9,9,9,0,"intervalRock","intervalRock",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[9,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[8,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,8,8],[8,"spikes","spikes","spikes",8,8,8,8,8,8,8,8,8,"spikes","spikes",8,8,8,"spikes",8,8,8,8]],playtestData:{left:420,right:431,jump:38},surveyArea:.5,joyCount:50},{name:"Tortcher",developer:"Chronic",unlockId:"torch",playerPrefab:"playerBoy",backgroundColor:[179,77,153],clicks:null,darkness:1,price:4.99,rating:null,sales:null,time:15e3,views:null,tiles:[[11,10,10,10,10,10,10,10,10,10,9,10,9,9,9,11],[10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9],[10,"gameStart",0,0,0,0,0,0,0,0,0,0,0,"torch",0,9],[10,"torch",10,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",10,9,9,9,9],[10,10,10,0,10,"spikes","spikes","spikes","spikes","spikes","spikes",10,10,10,10,10],[10,0,10,0,10,10,10,10,10,10,10,10,0,0,0,10],[10,0,0,0,0,0,0,0,0,0,0,0,0,"gameGoal",0,9],[10,0,0,0,0,0,0,0,0,0,0,0,0,9,0,9],[11,12,12,"spikes",12,12,12,12,12,12,9,12,9,9,9,11]],playtestData:{left:116,right:232,jump:18},surveyArea:.4,joyCount:40},{name:"Fragility",developer:"Retroladies",unlockId:"fragileRock",playerPrefab:"playerGirl",backgroundColor:[77,77,77],clicks:null,darkness:.7,price:9.99,rating:null,sales:null,time:25e3,views:null,tiles:[[10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13],[10,10,"torch","fragileRock","torch",0,0,0,0,"torch",0,0,0,0,0,0,0,0,0,"torch",13,0,0],[10,10,10,"fragileRock",10,10,10,10,10,10,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",13,0,0,0],[10,10,10,"fragileRock",10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13],[10,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",0,0,13,0,0,0,0,0,0,0,0,0,"hTrap",11,0,0,0],[10,10,"fragileRock","fragileRock","fragileRock",0,0,0,13,0,0,0,0,0,0,0,0,0,"hTrap","torch","bouncer",0,0],[10,10,0,"fragileRock",0,0,0,13,13,13,0,0,0,0,0,0,0,0,"hPlatform",11,11,0,0],[10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13],[0,9,0,"gameGoal",0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,0,0],[0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[8,9,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13],[8,9,8,"torch",8,"fragileRock","fragileRock","fragileRock","torch","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",13,"torch",13,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",13],[8,9,8,8,8,8,8,8,8,"spikes","spikes","spikes","spikes","spikes","spikes",13,"spikes","spikes","spikes","spikes","spikes","spikes",8]],playtestData:null,surveyArea:.5,joyCount:72,joyNormal:1,surveyNormal:1},{name:"Gravity Kills",developer:"Benzerware Ltd",unlockId:"gravityRock",playerPrefab:"playerBenzer",backgroundColor:[179,179,204],clicks:null,darkness:.3,price:9.99,rating:null,sales:null,time:4e4,views:null,tiles:[[9,9,9,9,9,9,9,9,9,9,9,13,"gravityRock",13,9,9,9,9,9,9,9,9,9],[9,0,0,9,0,0,0,0,0,0,0,13,0,13,0,0,0,0,0,0,0,0,9],[13,0,0,"gravityRock",0,0,0,0,0,0,13,13,0,13,13,0,0,0,0,0,0,13,13],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"gravityRock",9],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9],[8,0,0,"gameStart",0,0,"gravityRock",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9],[8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,8,8,0,0,9],[8,8,8,8,8,8,8,8,"spikes","spikes","spikes","spikes",0,"spikes","spikes","spikes","spikes","spikes",8,0,0,0,9],[8,8,8,8,8,8,8,8,8,8,8,8,0,8,8,8,8,8,8,0,0,8,8],[13,13,13,13,13,0,0,"gravityRock",0,"vTrap",0,0,0,0,0,0,0,8,"hTrap",0,0,0,8],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[13,13,13,0,"gameGoal",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8],[8,8,13,13,13,13,0,0,0,0,"spikes","spikes",0,"spikes","spikes",0,"gravityRock",0,0,0,8,8,13],[8,8,8,8,13,8,8,8,8,8,8,8,"fragileRock",8,8,8,8,8,8,8,8,13,13]],playtestData:{left:589,right:603,jump:36},surveyArea:.5,joyCount:70},{name:"Sky's the Limit",developer:"Retroladies",unlockId:"vPlatform",playerPrefab:"playerGirl",backgroundColor:[102,102,102],clicks:null,darkness:.3,price:9.99,rating:null,sales:null,time:55e3,views:null,tiles:[[13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],[13,0,0,0,13,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,13],[13,0,"gameStart",0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13],[13,0,0,0,13,0,"gameGoal",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13],[13,"fragileRock","fragileRock","fragileRock",13,13,13,13,13,0,"vPlatform",0,13,13,"intervalRock","intervalRock","intervalRock",13,13,0,"fragileRock",0,13],[13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,13,"fragileRock",0,"fragileRock",13],[13,0,0,0,13,13,0,0,0,"hTrap",0,0,0,"hTrap",0,0,0,13,13,0,"fragileRock",0,13],[13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,13,"fragileRock",0,"fragileRock",13],[13,0,0,0,13,13,0,0,0,"hTrap",0,0,0,"hTrap",0,0,0,13,13,0,"fragileRock",0,13],[13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,13,"fragileRock",0,"fragileRock",13],[13,0,0,0,13,13,0,0,0,0,0,0,0,0,0,0,0,13,13,0,0,0,13],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13],[13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"vPlatform",0,13],[14,0,0,0,0,0,0,0,9,"hTrap",0,0,0,0,0,0,0,"hTrap",9,"bouncer","bouncer","bouncer",9],[14,14,14,14,14,14,14,9,9,9,11,14,14,14,14,14,14,9,9,9,9,9,9]],playtestData:{left:675,right:746,jump:56},surveyArea:.5,joyCount:100,joyNormal:2,surveyNormal:.65},{name:"Wings",developer:"Rook",unlockId:"chicken",playerPrefab:"playerGoblin",backgroundColor:[204,204,179],clicks:null,darkness:.2,price:4.99,rating:null,sales:null,time:45e3,views:null,tiles:[[11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11],[11,0,0,0,"hTrap",0,0,0,0,0,"hTrap",0,0,0,0,0,"hTrap",0,0,0,0,0,11],[11,"hTrap",0,0,0,0,0,"hTrap",0,0,0,0,0,"hTrap",0,0,0,0,0,"hTrap",0,0,11],[11,"fragileRock","fragileRock","fragileRock",9,9,9,9,9,9,9,9,9,9,9,9,9,9,11,11,0,0,11],[11,0,0,0,"fragileRock","fragileRock",9,"fragileRock","fragileRock",0,0,0,0,0,0,0,9,0,0,11,0,0,11],[11,0,0,0,"fragileRock","fragileRock",9,"fragileRock",0,0,0,0,0,0,0,0,9,0,0,9,0,"bouncer",11],[11,0,0,0,"fragileRock","fragileRock",9,"fragileRock",9,9,0,0,0,0,0,"hPlatform",9,9,0,9,0,11,11],[9,0,0,0,9,"fragileRock","fragileRock","fragileRock",9,0,0,0,0,0,0,0,0,0,0,9,0,0,11],[9,0,"gameGoal",0,9,"fragileRock","fragileRock","fragileRock",9,0,0,0,0,"chicken",0,0,9,0,0,11,"bouncer",0,11],[9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,11,11,0,11],[9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,"bouncer",8],[8,0,"gameStart",0,0,0,0,0,13,0,13,0,0,0,0,0,13,0,"vPlatform",0,0,8,8],[8,8,8,8,0,"chicken",0,13,13,0,13,13,0,"chicken",0,0,8,8,0,8,8,8,8],[8,8,8,8,8,8,8,13,"spikes","spikes","spikes",13,8,8,8,8,8,8,8,8,8,8,8]],playtestData:{left:494,right:425,jump:44},surveyArea:.34,joyCount:50},{name:"Chiaroscuro",developer:"DreamGere",unlockId:"lightSwitch",playerPrefab:"playerTiger",backgroundColor:[102,179,255],clicks:null,darkness:1,price:14.99,rating:null,sales:null,time:64e3,views:null,tiles:[[9,9,9,9,9,13,13,9,13,9,13,13,13,9,13,13,13,9,13,13,9,13,13,9,13,13,9,13,9,9,9,9,9],[9,"lightSwitch",0,"hPlatform",9,0,0,9,0,9,0,0,0,9,0,0,0,"vTrap",0,0,9,0,0,"vTrap",0,0,9,0,0,9,"vTrap",9,9],[9,9,9,9,9,0,0,9,0,"vTrap",0,0,0,"vTrap",0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,9],[14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[14,0,"gameStart",0,0,8,0,0,0,0,0,"spikes",0,0,0,0,0,"spikes",0,0,0,0,0,"spikes",0,0,0,0,0,0,"spikes",0,8],[14,0,8,0,0,14,0,0,0,0,0,8,0,0,0,0,0,8,0,0,0,0,0,8,0,0,"hTrap",0,0,0,14,0,8],[14,14,14,14,14,14,14,14,14,9,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,0,8],[8,8,0,0,0,0,0,0,0,"vTrap",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[8,0,0,0,0,0,0,0,0,9,9,0,0,0,0,"hTrap",0,9,9,0,0,0,0,8,0,0,0,0,0,0,0,"gameKey",11],[8,0,0,0,13,13,13,0,0,9,0,0,0,0,0,0,0,9,0,0,0,0,"spikes",8,"hPlatform",0,0,0,0,0,0,11,11],[8,0,0,0,0,13,0,0,0,14,0,0,0,0,0,"chicken",0,14,0,0,"chicken",0,8,8,"spikes","spikes","spikes","spikes","spikes","spikes",0,"spikes",11],[8,0,"vPlatform",0,0,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,8,8,8,8,14,14,14,11,11,0,11,11],[8,0,0,0,0,13,0,0,0,0,0,0,0,"vTrap",10,10,14,14,0,0,0,0,0,0,0,0,0,"hTrap",0,0,0,0,11],[8,0,0,0,0,0,0,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",0,"gameGoal",10,14,14,0,0,0,0,0,0,0,0,0,0,"hTrap",0,0,0,8],[8,0,0,0,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",0,"fragileRock",0,10,10,"hTrap","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",14],[14,8,0,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",0,0,"fragileRock",0,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",14],[14,14,8,"fragileRock",0,0,0,0,0,0,0,0,"fragileRock",8,8,8,8,8,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",14,14],[8,8,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",8,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",8]],playtestData:{left:665,right:811,jump:50},surveyArea:.5,joyCount:233},{name:"BRT",developer:"Chronic",unlockId:"teleporter",playerPrefab:"playerBoy",backgroundColor:[77,153,153],clicks:null,darkness:.2,price:9.99,rating:null,sales:null,time:25e3,views:null,tiles:[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"vTrap",0,0,0,0,0,0],[0,0,0,"teleporter",0,12,12,12,12,12,12,12,12,0,0,0,0,"vTrap",0,"teleporter",0,0,0],[0,10,0,0,0,0,0,0,0,0,0,0,12,12,0,"teleporter",0,0,"vTrap",0,0,0,0],[0,10,"gameGoal",0,0,0,0,0,0,0,0,0,0,12,"vTrap",0,0,0,0,0,11,0,0],[0,10,10,10,10,10,"intervalRock","intervalRock","intervalRock",12,12,0,0,12,"spikes","spikes","spikes","spikes","spikes","spikes",11,0,11],[0,0,10,0,0,0,0,0,0,0,12,0,12,12,12,12,12,12,12,12,11,"teleporter",0],[0,0,0,0,0,0,0,0,0,0,12,0,0,0,12,12,12,12,12,12,11,11,11],[0,0,12,12,12,12,12,13,13,0,12,"intervalRock",0,0,0,0,0,12,0,0,11,0,0],[0,12,12,0,0,0,13,0,0,0,12,0,0,0,0,0,0,0,0,0,0,"teleporter",0],[0,12,0,0,"teleporter",0,13,13,0,0,12,12,12,12,"intervalRock","intervalRock","intervalRock",12,"intervalRock","intervalRock",12,12,12],[0,12,"gameStart",0,0,0,13,13,0,0,0,"teleporter",0,12,"hTrap",0,0,12,0,0,12,0,0],[0,12,12,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,12,12,12,12,12,13,13,0,0,0,0,0,0,0,0,0,0,0,0,"teleporter",0],[0,0,0,0,0,0,0,0,0,0,0,8,8,8,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock"],["spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",8,8,8,8,8,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes"]],playtestData:{left:322,right:252,jump:21},surveyArea:.25,joyCount:54},{name:"Where Are My Keys?",developer:"AD",unlockId:"gameKey",playerPrefab:"playerJoey",backgroundColor:[89,125,255],clicks:null,darkness:.6,price:9.99,rating:null,sales:null,time:35e3,views:null,tiles:[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"teleporter",0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,13,0,13,0,"hTrap",0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0],[0,13,"torch","fragileRock","torch",13,0,0,0,0,0,0,0,0,0,0,0,0,"hPlatform",13,"torch",13,0],[0,0,13,"fragileRock",13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0],[0,0,"fragileRock","fragileRock","fragileRock",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,"fragileRock","fragileRock","fragileRock",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"teleporter",0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,"torch",13,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"gameKey",0,0,0,9,0,0],[0,0,0,"gameStart",0,0,0,0,"gameGoal",0,0,0,0,0,0,11,"torch",13,0,0,9,0,0],[0,0,13,"torch",13,0,0,13,"torch",11,0,0,"fragileRock",0,0,0,9,0,0,0,9,0,0],[0,0,0,9,0,0,0,0,9,0,0,0,0,0,0,0,9,0,0,0,9,0,0],["spikes","spikes","spikes",9,"spikes","spikes","spikes","spikes",9,"spikes","spikes","spikes","spikes","spikes","spikes","spikes",9,"spikes","spikes","spikes",9,"spikes","spikes"]],playtestData:{left:290,right:429,jump:28},surveyArea:.3,joyCount:54},{name:"Jumpslime",developer:"Rook",unlockId:"jumper",playerPrefab:"playerGoblin",backgroundColor:[179,128,102],clicks:null,darkness:.5,price:9.99,rating:null,sales:null,time:4e4,views:null,tiles:[[11,11,"hTrap",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"hTrap",9,9,9,0],[11,0,0,0,0,0,0,11,0,0,0,0,11,0,0,0,0,11,0,0,9,0,0],[0,0,0,"gameGoal",0,0,11,11,0,"jumper",0,0,11,0,"jumper",0,0,11,11,0,0,0,0],[0,0,10,"torch",10,0,0,11,11,11,11,11,11,11,11,11,11,11,11,11,0,0,0],[0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[9,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0],[9,9,"hPlatform",0,0,0,0,0,0,9,"torch",0,0,0,0,0,9,0,0,0,0,0,0],[9,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",9,0,"jumper",0,0,0,9,9,9,9,0,0,0],[9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0],[9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"torch"],[8,0,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8],[8,0,8,8,8,0,0,0,0,0,0,0,0,0,"torch",0,0,0,0,0,"vPlatform",8,8],[8,8,8,8,0,0,0,0,0,0,0,"jumper",0,0,8,0,0,0,"jumper",0,0,8,8],[8,8,8,8,8,8,13,13,13,13,13,13,13,13,8,8,8,8,8,8,8,8,8]],playtestData:{left:466,right:520,jump:34},surveyArea:.4,joyCount:100},{name:"pewpewpew",developer:"Retroladies",unlockId:"cannon",playerPrefab:"playerGirl",backgroundColor:[102,128,204],clicks:null,darkness:.2,price:9.99,rating:null,sales:null,time:6e4,views:null,tiles:[[9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,9],[9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9],[9,0,0,"gameGoal",0,0,0,0,0,0,0,"cannon",0,0,0,0,0,0,0,0,0,0,9],[0,0,10,10,10,0,0,0,0,0,0,11,0,0,0,0,13,"cannon",0,0,0,0,9],[0,0,0,0,0,0,0,0,"cannon",0,0,0,0,0,0,0,13,13,0,0,0,0,0],[0,13,13,13,13,13,13,11,11,11,13,13,13,13,13,13,13,13,0,13,13,13,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,13,"vPlatform"],[9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"hPlatform",13,0,0,0],[9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,9,9],[0,0,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,9,0],[0,0,8,8,8,0,0,0,0,0,"cannon",0,0,0,0,9,"cannon",0,0,0,0,9,0],[0,8,8,8,8,8,0,0,0,0,8,0,0,0,0,9,9,0,0,0,0,9,0],[8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,"spikes","spikes","spikes","spikes",9,9]],playtestData:{left:1213,right:1106,jump:51},surveyArea:.6,joyCount:140},{name:"MOAR",developer:"DreamGere",unlockId:"spawner",playerPrefab:"playerTiger",backgroundColor:[77,102,128],clicks:null,darkness:.7,price:14.99,rating:null,sales:null,time:3e4,views:null,tiles:[[10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10],[10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10],[10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,0,10],[10,0,"gameStart",0,0,0,0,0,0,0,"pulseButton",0,0,0,0,0,0,0,0,0,9,0,10],[10,"spikes",10,0,0,0,"spawner",0,0,0,9,"chicken",0,0,"pulseBlock",0,0,"spawner",0,0,9,0,10],[10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,0,10],[12,12,0,0,10,0,0,0,0,10,0,0,"pulseBlock",0,0,9,0,0,0,"hTrap",9,0,10],[12,0,0,0,"spawner",0,0,0,0,"spawner",0,0,"pulseBlock",0,0,"hTrap",0,0,0,0,0,0,10],[12,0,0,0,"spawner",0,0,0,0,"spawner",0,0,"pulseBlock",0,0,"hTrap",0,0,0,0,0,0,10],[12,0,0,"vTrap",13,13,13,13,13,13,13,13,13,13,13,13,13,11,11,0,"pulseButton",0,10],[12,0,0,13,13,"hTrap",0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,10],[12,"fragileRock","gameGoal","fragileRock","fragileRock",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9],[12,"fragileRock",8,"fragileRock","fragileRock",0,0,0,"spawner",0,0,0,0,0,"spawner",0,0,0,0,0,0,"hPlatform",9],[12,"fragileRock","fragileRock","fragileRock",12,0,0,0,9,0,0,0,0,0,9,0,0,0,0,0,0,0,9],[12,"spikes","spikes","spikes",12,"spikes","spikes","spikes",9,"spikes","spikes","spikes","spikes","spikes",9,"spikes","spikes","spikes","spikes","spikes","spikes","spikes",9]],playtestData:{left:407,right:500,jump:22},surveyArea:.4,joyCount:100},{name:"Squidish",developer:"Retroladies",unlockId:"squid",playerPrefab:"playerGirl",backgroundColor:[128,77,204],clicks:null,darkness:.5,price:14.99,rating:null,sales:null,time:48e3,views:null,tiles:[[12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,11,12,11,11,11,11,11,11,11,11],[12,12,0,0,0,12,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,11],[12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11],[12,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,11,0,11],[9,9,9,9,9,9,0,0,"squid",0,0,9,9,9,0,0,"squid",0,0,9,9,"squid",0,0,0,0,0,0,"squid",11,11,0,11],[12,12,0,0,9,9,0,0,0,0,0,9,"torch",9,0,0,0,0,"spikes",9,"spikes","spikes","spikes","spikes",0,0,"spikes","spikes","spikes","spikes",11,0,11],[12,0,0,0,0,9,9,9,9,9,9,9,13,9,9,9,9,9,9,9,9,9,9,9,0,0,11,11,11,11,11,0,11],[12,0,"gameGoal",0,0,0,"fragileRock","fragileRock",0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,11,0,11],[9,9,9,9,9,0,"fragileRock","fragileRock",0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,13,"torch","torch",13,0,0,0,9,0,12],[12,12,0,9,0,0,"fragileRock",9,9,9,9,9,9,9,9,9,9,0,9,9,0,0,0,0,13,13,0,0,0,0,9,0,11],[12,0,0,0,0,0,9,9,0,0,0,0,0,0,0,0,0,0,0,9,"hTrap",0,0,0,0,0,0,0,0,"hTrap",9,0,12],[12,0,"squid",0,0,0,9,0,0,0,0,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,9,9,9,9,9,0,12],[12,0,0,0,0,9,9,0,0,0,0,0,0,0,0,0,"squid",0,0,9,0,0,0,9,0,0,9,0,0,0,9,0,12],[12,0,0,"spikes",0,0,9,"spikes",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,12],[12,0,"squid",9,0,0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,0,0,"hPlatform",0,0,0,0,9,9,0,12],[12,0,0,0,0,0,0,0,0,0,0,0,0,"hTrap",9,9,0,0,9,9,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",9,0,12],[12,0,0,0,0,"hPlatform",9,9,0,0,0,0,0,0,9,"vTrap",0,0,0,9,9,9,9,9,9,9,9,9,9,9,9,0,12],[12,0,0,0,0,0,9,"hTrap",0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12],[12,"spikes","spikes","spikes","spikes","spikes",9,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12]],playtestData:{left:631,right:628,jump:47},surveyArea:.6,joyCount:200},{name:"Bigger, Badder",boss:!0,unlockId:"sizeLarge",developer:"AD",playerPrefab:"playerJoey",backgroundColor:[89,102,102],clicks:null,darkness:.7,price:59.99,rating:null,sales:null,time:4e4,views:null,tiles:[[15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15],[15,15,0,0,0,0,0,0,15,0,0,0,0,0,0,15,15,15,0,0,0,0,0,0,15,0,0,0,0,0,0,15,15],[15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15],[15,0,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15],[15,0,"bossBlock","bossBlock","bossBlock",0,0,0,0,0,0,0,0,0,0,0,0,0,0,"bouncer",0,0,0,0,0,0,0,0,"bouncer",0,0,0,15],[15,0,13,13,13,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13,13,0,0,0,0,0,0,13,13,13,0,0,15],[15,0,0,0,0,0,0,0,0,0,0,"bouncer",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15],[15,0,0,0,0,0,0,0,0,0,13,13,13,0,0,0,0,0,0,0,0,0,0,"bouncer",0,0,0,0,0,0,0,0,15],[15,0,0,0,"bouncer",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13,13,0,0,0,0,0,0,0,15],[15,15,0,13,13,13,0,0,0,0,0,0,0,0,0,0,"boss",0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,15],[15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,10,10,10,0,0,15],[15,0,0,0,0,0,0,"bouncer",0,0,0,0,0,0,0,0,0,0,"bouncer",0,0,0,0,0,0,10,0,0,0,10,0,0,15],[15,0,0,0,0,0,13,13,13,0,0,0,0,0,0,0,0,13,13,13,0,0,0,0,0,10,0,0,0,10,0,0,15],[15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,"gameGoal",0,10,0,0,15],[15,0,0,"bouncer",0,0,0,0,0,0,0,"bouncer",0,0,0,0,"vPlatform",0,0,0,0,0,0,0,0,10,10,10,10,10,0,0,15],[15,0,13,13,13,0,0,0,0,0,13,13,13,0,0,0,"hPlatform",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15],[15,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",9,"torch",9,"fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock","fragileRock",15],[15,15,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",9,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",15,15],[15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,9,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]],playtestData:null,surveyArea:.4,joyCount:150},{name:"Chicken Wrangler",developer:"Genero",playerPrefab:"playerBoy",backgroundColor:[89,204,206],clicks:null,darkness:.4,price:9.99,rating:null,sales:null,time:75e3,views:null,tiles:[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0],[0,9,9,0,0,0,0,9,0,0,0,0,0,9,0,0,0,0,0,9,0,0,0,0,0,9,0,0,0,0,9,9,0],[0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0],[0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0],[0,9,9,0,"gameStart",0,0,0,0,0,"pulseButton",0,0,0,0,0,0,0,0,0,0,0,"pulseButton",0,0,0,0,0,0,9,0,9,0],[0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,9,0],[0,13,0,"chicken",0,0,0,"pulseBlock",0,0,0,0,0,"pulseBlock",0,0,0,0,0,"pulseBlock",0,0,0,0,0,0,0,0,0,0,0,9,0],[0,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,"pulseBlock","pulseBlock","pulseBlock",13,13,13,0,9,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,"spikes","spikes","spikes",13,0,13,0,9,0],[0,0,"gameGoal",0,0,0,0,0,0,0,"pulseButton",0,0,0,0,0,0,0,0,0,0,0,0,13,13,13,13,13,0,0,0,9,0],[0,10,"torch",10,10,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,13,0,0,0,9,0],[0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,9,0,0,"pulseButton",0,0,0,0,0,0,9,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,9,9,0,0,0,0,0,9,0],[0,0,0,0,0,0,0,"bouncer",0,0,0,0,0,0,0,"pulseBlock",0,0,0,0,0,0,0,0,0,"pulseBlock",0,0,0,0,0,0,0],[0,0,0,13,13,13,13,13,"pulseBlock","pulseBlock","pulseBlock",13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,0,0],[0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,13,0,0,0,0,13,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],["spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes"]],playtestData:{left:901,right:873,jump:53},surveyArea:.4,joyCount:75},{name:"Cannon't Do It",developer:"Benzerware Ltd",playerPrefab:"playerBenzer",backgroundColor:[90,130,210],clicks:null,darkness:.1,price:9.99,rating:null,sales:null,time:1e4,views:null,tiles:[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,"gameStart",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,9,0,0,"cannon",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,9,0,0,13,"cannon",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,9,0,0,13,13,"cannon",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,9,0,0,13,13,13,0,0,0,0,0,0,0,0,0,0,0,0,"gameGoal",0,0],[0,0,9,0,9,9,9,9,9,0,0,0,0,0,0,0,0,0,10,10,10,10,0],[0,0,9,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0],["spikes","spikes",9,"spikes","spikes","spikes","spikes",9,"spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes","spikes",10,"spikes","spikes"]],playtestData:null,surveyArea:.25,joyCount:50}]}),n("js/products",["require","exports","module"],function(e,t,n){t.dropper={name:"Dropper",description:"Right-click support",category:"features",avatar:{image:"media/images/objects.png",imageX:112,imageY:80},price:0,flag:"dropper"},t.marketAnalysis={name:"Market Analysis",description:"Analyze your games for $",category:"features",avatar:{image:"media/images/objects.png",imageX:112,imageY:64},price:1e3,flag:"marketAnalysis"},t.backgroundColor={name:"Background Color",description:"Express yo'self hey hey",category:"features",avatar:{image:"media/images/objects.png",imageX:32,imageY:64},price:25e3,flag:"backgroundColor"},t.spikes={name:"Spikes",description:"Deadly",category:"entities",avatar:{image:"media/images/objects.png",imageX:80,imageY:0},price:2e3,editEntity:"spikes"},t.pulseButton={name:"Beacon",description:"Signals other entities",category:"entities",avatar:{image:"media/images/objects.png",imageX:32,imageY:96},price:1e4,editEntity:"pulseButton"},t.bossBlock={name:"Boss Block",description:"Increases boss power",category:"entities",avatar:{image:"media/images/objects.png",imageX:96,imageY:112},price:15e3,editEntity:"bossBlock"},t.playerGirl={name:"Annie",description:"Just a girl",category:"players",avatar:{image:"media/images/actors.png",imageX:0,imageY:16},price:5e3,flag:"playerGirl"},t.playerBoy={name:"Matt",description:"Just a boy",category:"players",avatar:{image:"media/images/actors.png",imageX:0,imageY:0},price:5e3,flag:"playerBoy"},t.rockTile={name:"Rock Tile",description:"Solid as a rock",category:"tiles",avatar:{image:"media/images/env.png",imageX:16,imageY:16},price:1e3,tileIndex:9},t.sandTile={name:"Sand Tile",description:"Goldish",category:"tiles",avatar:{image:"media/images/env.png",imageX:32,imageY:16},price:2e3,tileIndex:10},t.brickTile={name:"Brick Tile",description:"Reddest",category:"tiles",avatar:{image:"media/images/env.png",imageX:48,imageY:16},price:4e3,tileIndex:11},t.iceTile={name:"Blue Tile",description:"Only in color, Michael",category:"tiles",avatar:{image:"media/images/env.png",imageX:64,imageY:16},price:8e3,tileIndex:12},t.woodTile={name:"Wooden Tile",description:"A boat is wooden",category:"tiles",avatar:{image:"media/images/env.png",imageX:80,imageY:16},price:16e3,tileIndex:13},t.plantTile={name:"Overgrown Tile",description:"Foliage not foilage",category:"tiles",avatar:{image:"media/images/env.png",imageX:96,imageY:16},price:32e3,tileIndex:14},t.scaryTile={name:"Scary Tile",description:"EEEEEEEEK!",category:"tiles",avatar:{image:"media/images/env.png",imageX:112,imageY:16},price:64e3,tileIndex:15},t.securityCamera={name:"Security Camera",description:"Watch your property",category:"luxuries",avatar:{image:"media/images/objects.png",imageX:80,imageY:16},price:3e3,flag:"securityCamera"},t.rlMotorcycle={name:"Motorcycle",description:"Looks good in your garage",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:64,imageY:0},price:2e4,flag:"rlMotorcycle"},t.rlCar={name:"Car",description:"I'll never use it",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:80,imageY:0},price:4e4,flag:"rlCar"},t.rlGarage={name:"Garage",description:"Protects your cars",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:32,imageY:0},price:15e4,flag:"rlGarage"},t.rlHouse={name:"House",description:"Safe as houses",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:48,imageY:0},price:35e4,flag:"rlHouse"},t.rlTree={name:"The Giving Tree",description:"For hanging stuff!",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:96,imageY:0},price:1e5,flag:"rlTree"},t.rlBeehive={name:"Beehive",description:"(Hangs from the treeeeee)",category:"luxuries",avatar:{image:"media/images/property.png",imageX:160,imageY:32},price:1e4,flag:"rlBeehive"},t.rlWaterslide={name:"Waterslide",description:"I legit want one",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:144,imageY:0},price:25e4,flag:"rlWaterslide"},t.rlChopperPad={name:"Helicopter Pad",description:"notch probably has one",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:128,imageY:0},price:1e6,flag:"rlChopperPad"},t.rlChopper={name:"Helicopter",description:"(Buy the pad first)",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:112,imageY:0},price:1e6,flag:"rlChopper"},t.rlAirship={name:"Airship",description:"Floats above your house",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:16,imageY:0},price:3e6,flag:"rlAirship"},t.rlTower={name:"Tower of Id",description:"A tower in your backyard",category:"luxuries",avatar:{image:"media/images/property2.png",imageX:0,imageY:0},price:1e7,flag:"rlTower"}}),n("js/unlocks",["require","exports","module"],function(e,t,n){t.bouncer={name:"Bouncer",avatar:{image:"media/images/objects.png",imageX:48,imageY:64},editEntity:"bouncer"},t.hPlatform={name:"Horizontal Platform",avatar:{image:"media/images/objects.png",imageX:96,imageY:48},editEntity:"hPlatform"},t.sizeMedium={name:"Medium Games",avatar:{image:"media/images/objects.png",imageX:80,imageY:80}},t.hTrap={name:"Horizontal Spikes",avatar:{image:"media/images/objects.png",imageX:64,imageY:16},editEntity:"hTrap"},t.pulseBlock={name:"Signal Block",avatar:{image:"media/images/objects.png",imageX:96,imageY:96},editEntity:"pulseBlock"},t.intervalRock={name:"Interval Rock",avatar:{image:"media/images/objects.png",imageX:96,imageY:32},editEntity:"intervalRock"},t.darkness={name:"Darkness",avatar:{image:"media/images/actors.png",imageX:0,imageY:32}},t.torch={name:"Torch",avatar:{image:"media/images/objects.png",imageX:48,imageY:112},editEntity:"torch"},t.fragileRock={name:"Fragile Rock",avatar:{image:"media/images/objects.png",imageX:16,imageY:32},editEntity:"fragileRock"},t.gravityRock={name:"Gravity Sphere",avatar:{image:"media/images/objects.png",imageX:96,imageY:16},editEntity:"gravityRock"},t.vPlatform={name:"Vertical Platform",avatar:{image:"media/images/objects.png",imageX:80,imageY:96},editEntity:"vPlatform"},t.chicken={name:"Chicken",avatar:{image:"media/images/actors.png",imageX:0,imageY:160},editEntity:"chicken"},t.lightSwitch={name:"Light Switch",avatar:{image:"media/images/objects.png",imageX:0,imageY:64},editEntity:"lightSwitch"},t.teleporter={name:"Teleporter",avatar:{image:"media/images/objects.png",imageX:48,imageY:96},editEntity:"teleporter"},t.gameKey={name:"Key",avatar:{image:"media/images/objects.png",imageX:48,imageY:80},editEntity:"gameKey"},t.jumper={name:"Jumper",avatar:{image:"media/images/actors.png",imageX:80,imageY:16},editEntity:"jumper"},t.cannon={name:"Cannon",avatar:{image:"media/images/objects.png",imageX:0,imageY:48},editEntity:"cannon"},t.spawner={name:"Copycat",avatar:{image:"media/images/objects.png",imageX:16,imageY:16},editEntity:"spawner"},t.squid={name:"Squiddy",avatar:{image:"media/images/actors.png",imageX:128,imageY:0},editEntity:"squid"},t.sizeLarge={name:"Large Games",avatar:{image:"media/images/objects.png",imageX:96,imageY:80}}}),n("js/buildCosts",["require","exports","module"],function(e,t,n){n.exports={boss:5e3,bossBlock:500,bouncer:100,cannon:500,chicken:250,fragileRock:50,gameKey:250,gravityRock:1e3,hPlatform:200,hTrap:100,intervalRock:200,jumper:500,lightSwitch:1e3,pulseBlock:250,pulseButton:500,spawner:1e3,spikes:100,squid:500,teleporter:500,torch:300,vPlatform:200,9:10,10:20,11:40,12:80,13:160,14:320,15:640}}),n("js/reviewers",["require","exports","module","djinn/manifest","djinn/utils/array","djinn/math/random"],function(e,t,n){var r=e("djinn/manifest"),i=e("djinn/utils/array"),s=e("djinn/math/random"),o=[],u=[],a=[],f=[],l=["10% pizza","307","Acerbusilva","AdmiralDock","Affordable Desk","Aggroblakh","AI","altrewin","andraconda","Andrea Abney","anonymous","Antarok","Arcaeda","Aron","Asabrasa","Ass Crack Bandit","AyekaLooter","Baphomet","BelieveInDragons","Benzer","Bliss","Brazil Josh","Brdwaydog","Caius","cg_destro","cheersphilip","Chombers","Chongo","CissyDC","cojoha","Conjus","Cool_Hand_Flash","CueZero","Da5id","DaavPuke","Daniel Sun","DarkMist","Deejaypaul","Delano","DesertPogono","Dfrag","Dom2d","Dovah","DragonPupps","Drakenseng","Elite","ENCROACHER","Enoch","eric.lifka","Etosaurus","Fang","fLx","gentlerabbit","Geoff Blair","Gest","gmstino","goblin girl","GrangerX","Greg Love","Hawk Zombie","help-14","Hyze","icrockets","ifman1","InvisaWizard","IWroteEct","Jaune","JohnR","Josh","Joshua Morse","justinR","Kar","Kate","Kaz","kingphilip55","kl beenz","Koopa","Kristy Blackclaw","Kubik","Land Walrus","LazerApple","LDG","lightshow","Loki","LordXenophon","Losian Rooke","Lunch Box","MadUnicorn","Markifier","MartyrA2J","Matt Hackett","Melissa","Melly","Meruiti","MicoJive","mikker","milk_crust","mjenso","Mojito","MrLuigide","MrZalgo","NotSoysause","Novibear","nuclearpants","owyoow","Palette Swap","Paradise Decay","Pinkie Pyro","Pocok","Pretentieux","puppies","qFox","Raeldon","Raka","Rammkey","RaptorTwitch","rebelkixar","redpunda","Reji627","Renegade","richtaur","rob","Rock Holiday","Ron","Rothana","royfire123","RPG Gamer Man","ryguydavis","SaintDam","salmonmoose","sans_seraph","Sdric","Seneschul","Ser Pounce","Shaka","Shandy","ShinyFarret","Silenus","SkepticRaven","Skr0ll d0wn","Skytower","SnipesXP","Solid Snake","Solotalento","talk lewd to me","TeamDawnLight","ThePCGamer101","Thrill","Tibbnak","TokyoDan","triplebooyah","Troll-Stolle","Vasae","Vivi","Vox","Warspawn","Warspawn","Whippering","wickedpants","xaanz","yourkey64","Zalkore"],c=["10/10 would fap again","10/10","4/5","7.8/10","8/10","a bit bulky","a clone but harder","a good clone","a pretty great game","Addictive","an interesting little game","basically a clone but good","blew my face RIGHT OFF","charming","check out my YouTube!!!","Cool game","cool little game.","die more. 9/10","doesn't suck that much","Easily addictive","Exquisite! What a blast!","FANTASTIC GAME!","feels badly put together","Fun game. Great dev.","fun if you can stand it","Funny, but too short.","Good action game.","great for killing time","Great game.","Had a lot of fun with it.","had tons o fun","High-fives all around!","Hm, above average game.","hours of fun","I can't wait for sequel.","I died. 10/10","i got a coupon","I personally like it.","I want to go to there.","it's a bad clone","it's cool try it","it's like mario meet sonic","Its an ok game.","Little hard, but good.","Made me cry it's so good.","mario marker cloen!!1","most fun since NES days","my first lil review","my hovercraft has eels","My new favorite game!","nice game to have.","not good","Nothing quite like it!","Oh wow! So much fun!","OSfrog pliz","prettty gooodd","really enjoyed this","recommend this to anyone","Reminds me of elephants","richtig nice idee","SO GOOD","supah fun","superb","sweet game if a bit grindy","TAKE MY MONEY","THANKS FOR MAKING IT","This game is worth a play.","This is an excellent game!","Truly a difficult game","v frustrating!","Very fun game.","worth $5 maybe $10","Wouldn't change a thing!","Your face is nice."],h=["1337Gamer69","13loodReign","akarik77","alanisman1","Andros","baseballfan11","BetterThenYou","bowling","BrofessorOak","BrotherGRim","Bruceybaby","Captain Fun","Chromie","Corjoa","Croak90","crow inc.","DaiSemper","Darksol","Darkwel","Dorkoski","DrSykk","EvilLost","FaaJun","Fancylad99","Fauxesune","Flexo","Forecast Octopus","Frorwardesque","GameranxHD","Gargamel","Gassey","Greed","hawaiooo","Honeycone","Honeycone","Horch","horsereviews","Illidan","indiesuck","Isaac","Jackal","James","jarjar","Jess Crees","JFKraken","Jin","Joshu","KCGemini","Kefka","Leuphe","LOLYOU1337","Long Lad","MajorGamer","Manslaughter","marko_ceez","Mech","melon farmer","Mightyelk","Monstercade","Mr.GreenSuit","Newman","Nihohit","oiB","Olmec","Oxynia","Peredur","Quadadvance","Radiant","revengeracer","ScarletInk","se05239","Searanox","Sephiroth","seymour47","shbouwhuis","Shedu","Shipin Desu","Silk","spiderwalker","Tasselli","Taumkat","Terkala","That One Guy","thelastmonte","TorchMySoul","Tracer","Tubesock","ultros","Vidavis Prime","VLA","Wedge","Welkin","Zen Tractor"],p=["!@#% the devs","2.5/10","4/10","a disgusting disapointment","a really crappy game","A very mediocre game.","Another failure","BOOOOORING","Boring and repetitive.","didn't really wow me","didn't run! GARBAGE!","DO NOT BUY","dont trust these devs","GARBAGE","got a refund","has potential","how are there any sales??","I DEFAND REMUND","I regret buying this..","I want my money back, plz?","I'd pass.","I'd rather eat glass","i'm a scaly i guess","is this the devs 1st game?","It's a bad game","It's not bad, but not good","It's really bad.","its k","its not evn a lisard","jhbvm","made me throw up","Needs more explosions.","no linux version","NO","Nope","not even worth $1","Not much going on here..","Not that fun.","obviously a clone","On the same level as E.T.","Play any other game!","pretty good","really dont like it.","really stupid?","Score: 4/10","somebody shoot me","srsly?","SUCKS","these devs are lousy","This is actually good","Totaly unbalanced","ugh, i hate the dev","uninspired boring nonsense","uninstalled","Very dull.","Waste of time DO NOT BUY.","What a RIPOFF!!","what a waste of time","who was this even made for","who is buying this???","whoever made this is dumb","why does this even exist","why?","worst game i ever played","yeah i liked it","zzz"];if(r.pirates)for(var d=0;d<10;++d)p.push("ARRRRRRRR!"),p.push("N'arrrrrrrr!"),c.push("AYE MATEY"),c.push("SHIVER MA TIMBAS ETC"),l.push("Blackbeard"),l.push("Beardo"),l.push("Pirate McBeardy"),h.push("ar pirate"),h.push("lazypirate"),h.push("arr");t.generate=function(e,n){if(e===1)var r=n,s=0;else var r=Math.round(n*e),s=n-r;var o=[];for(var u=0;u<r;++u)o.push({name:t.getPositiveName(),reco:!0,text:t.getPositiveReview()});for(var u=0;u<s;++u)o.push({name:t.getNegativeName(),reco:!1,text:t.getNegativeReview()});return i.shuffle(o)},t.getPositiveName=function(){return o.length===0&&(o=i.clone(l)),s.choice(o,!0)},t.getPositiveReview=function(){return u.length===0&&(u=i.clone(c)),s.choice(u,!0)},t.getNegativeName=function(){return a.length===0&&(a=i.clone(h)),s.choice(a,!0)},t.getNegativeReview=function(){return f.length===0&&(f=i.clone(p)),s.choice(f,!0)}}),n("js/templates",["require","exports","module"],function(e,t,n){var r="gameStart",i="gameGoal";t.get=function(e){var n={small:t.getSmall(),medium:t.getMedium(),large:t.getLarge()};return n[e]},t.getKeyByHeight=function(e){var n={small:t.getSmall(),medium:t.getMedium(),large:t.getLarge()};for(var r in n){var i=n[r];if(e===i.length)return r}return null},t.getSmall=function(){return[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,r,0,0,0,0,0,0,0,0,i,0,0,0],[0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]]},t.getMedium=function(){return[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,r,0,0,0,0,0,0,0,0,i,0,0,0,0,0,0,0,0,0,0],[0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]]},t.getLarge=function(){return[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,r,0,0,0,0,0,0,0,0,0,0,0,0,i,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]]}}),n("js/players",["require","exports","module"],function(e,t,n){n.exports=["playerBenzer","playerBird","playerBoy","playerChicken","playerFranklin","playerGirl","playerGoblin","playerJanitor","playerLars","playerLuna","playerRaga","playerTiger","playerWizard","playerXam","playerZombie"]}),n("js/doubt",["require","exports","module"],function(e,t,n){t.hello={text:["Hello.","Do you know me?"],choices:[{text:"Nope.",key:"helloNo",color:"negative"},{text:"It doesn't matter.",key:"helloYes",color:"positive"}]},t.helloNo={text:["You will. You're just one","person out of billions, but","you think you're special ..."],choices:[{text:"You're scaring me ...",key:"helloNoNo",color:"negative"},{text:"Everyone is kinda special.",key:"helloNoYes",color:"positive"}]},t.helloNoNo={text:["You scare easily. I have a","gift for you that I feel is","appropriate. Good luck. Ha!"],mood:"happy",unlock:{flag:"playerChicken"}},t.helloNoYes={text:["We shall see. For now you're","just a fleshy sack of meat","like everyone else."],unlock:{flag:"playerGoblin"}},t.helloYes={text:["YOU KNOW NOTHING!","You think you're so smart,","don't you?"],choices:[{text:"Not really ...",key:"helloYesNo",color:"negative"},{text:"So what if I do?",key:"helloYesYes",color:"positive"}]},t.helloYesNo={text:["That's what I thought.","You seem like a generic human","so have a generic gift."],unlock:{flag:"playerGoblin"}},t.helloYesYes={text:["Your naivety is noble, like a","gladiator sent to die in","battle. Enjoy your gift, fool."],mood:"bothered",unlock:{flag:"playerXam"}},t.medium={text:["At it again, are we? Pathetic.","Did you even notice how bad","your last game was?"],choices:[{text:"Yeah, I saw ..",key:"mediumNo",color:"negative"},{text:"Haters gonna hate.",key:"mediumYes",color:"positive"}]},t.mediumNo={text:["Clearly you're not good at","this. Why continue?"],choices:[{text:"Maybe I won't ...",key:"mediumNoNo",color:"negative"},{text:"Because I want to.",key:"mediumNoYes",color:"positive"}]},t.mediumNoNo={text:["Good. The world is filled with","enough mediocrity as it is.","Stop creating and be a zombie."],mood:"happy",unlock:{flag:"playerZombie"}},t.mediumNoYes={text:["So you'll selfishly fill the","world with your mediocrity.","What a child."],unlock:{flag:"playerBenzer"}},t.mediumYes={text:["So why do this, anyway?","Why make your own games?"],choices:[{text:"I'm ... not sure.",key:"mediumYesNo",color:"negative"},{text:"It's important to me.",key:"mediumYesYes",color:"positive"}]},t.mediumYesNo={text:["Great. Another creator with no","real vision. I'm sure you'll","do well, kid."],unlock:{flag:"playerBenzer"}},t.mediumYesYes={text:["Important? You're making","digital entertainment.","Sigh, go play with your toys."],mood:"bothered",unlock:{flag:"playerLars"}},t.darkness={text:["I'm here again.","Did you miss me?"],choices:[{text:"Ugh, you again.",key:"darknessNo",color:"negative"},{text:"Hello, old friend.",key:"darknessYes",color:"positive"}]},t.darknessNo={text:["Still at it, I see.","Are you becoming comfortable","with your mediocrity?"],choices:[{text:"... no ...",key:"darknessNoNo",color:"negative"},{text:"We all start somewhere.",key:"darknessNoYes",color:"positive"}]},t.darknessNoNo={text:["And you never will ... I have","for you an old, pixelated","loser. You two should relate."],mood:"happy",unlock:{flag:"playerFranklin"}},t.darknessNoYes={text:["While you're kidding yourself,","here's a tiger, because you","don't know what you're doing."],unlock:{flag:"playerTiger"}},t.darknessYes={text:["So, are you comfortable with","your mediocrity yet?"],choices:[{text:"... uh, not really ...",key:"darknessYesNo",color:"negative"},{text:"Just you wait.",key:"darknessYesYes",color:"positive"}]},t.darknessYesNo={text:["That's what I thought.","Here's a tiger to keep you","company while you fail."],unlock:{flag:"playerTiger"}},t.darknessYesYes={text:["I can wait forever. Can you?","Ugh, your positivity is awful!","Take this and get outta here."],mood:"bothered",unlock:{flag:"playerLuna"}},t.indifference={text:["Oh. It's you ... since you're","here, I guess I'll just say:","I don't care about you :)"]},t.death={text:["Let's get to know each other.","Have you experienced the death","of a loved one?"],choices:[{text:"None of your business",key:"death2",color:"positive",sound:"choice2"},{text:"You already know ...",key:"death2",color:"positive",sound:"choice2"}]},t.death2={text:["On an unrelated note, do you","think losing something makes","you stronger or weaker?"],choices:[{text:"It hurts sometimes ...",key:"death2No",color:"negative",sound:"choice2"},{text:"Who knows? Back to work.",key:"death2Yes",color:"positive",sound:"choice2"}]},t.death2No={text:["I understand ...","I'm not your friend.","But I do have gifts for you."],unlock:{flag:"playerMother"}},t.death2Yes={text:["Yes, yes! Must get back to it!","Must not think about mortality","or other pending concerns ...!"],unlock:{flag:"playerFather"}},t.large={text:["So now you can make large","games. I'm looking forward to","your LARGE disaster. Hah!"],choices:[{text:"It'll be OK ...",key:"largeNo",color:"negative"},{text:"I'm going to rock it!",key:"largeYes",color:"positive"}]},t.largeNo={text:["Sure it will. Shouldn't you be","contributing to society","instead of this selfishness?"],choices:[{text:"Probably ...",key:"largeNoNo",color:"negative"},{text:"This drives me.",key:"largeNoYes",color:"positive"}]},t.largeNoNo={text:["Well then go get a job.","May I suggest janitor?"],mood:"happy",unlock:{flag:"playerJanitor"}},t.largeNoYes={text:["I suppose. But this industry","is hard, and you are not","exactly a prodigy."],unlock:{flag:"playerWizard"}},t.largeYes={text:["We'll see. If you're so great,","shouldn't you be putting your","time towards helping others?"],choices:[{text:"I ... could do charity ...",key:"largeYesNo",color:"negative"},{text:"Games make people happy.",key:"largeYesYes",color:"positive"}]},t.largeYesNo={text:["Sure, but our time is limited","and you could spend yours more","wisely. You don't know magic."],unlock:{flag:"playerWizard"}},t.largeYesYes={text:["Maybe they do.","But you might just be trying","to make YOURSELF happy."],mood:"bothered",unlock:{flag:"playerRaga"}},t.finalBoss={text:["So ... You've unlocked","everything. Think you're a","game dev expert now?"],choices:[{text:"Nope!",sound:"choice1",scene:"computer"},{text:"I'm more confident ...",sound:"choice2",scene:"finalBoss"}]},t.ending={text:["Well ...","You did it. Congratulations.","Do you think it's over?"],mood:"bothered",choices:[{text:"Pretty much.",key:"endingNo",color:"negative"},{text:"It's never really over.",key:"endingYes",color:"positive"}]},t.endingNo={text:["Shows how little you know.","It's never over.","So do you know who I am now?"],mood:"bothered",choices:[{text:"Maybe?",key:"endingNoNo",color:"negative"},{text:"Obviously.",key:"endingNoYes",color:"positive"}]},t.endingNoNo={text:["You are slow. And weak.","Enjoy your temporary victory,","and this, my final gift."],mood:"happy",unlock:{flag:"boss",editEntity:"boss"}},t.endingNoYes={text:["Oh look who knows so much!","Little do you realize I'll","always challenge you."],mood:"bothered",unlock:{flag:"boss",editEntity:"boss"}},t.endingYes={text:["True, you know that at least.","But do you know who I am?"],mood:"bothered",choices:[{text:"Not reeeeally ...",key:"endingYesNo",color:"negative"},{text:"Obviously.",key:"endingYesYes",color:"positive"}]},t.endingYesNo={text:["Thought so.","I'll be back to haunt you,","and forever challenge you."],mood:"bothered",unlock:{flag:"boss",editEntity:"boss"}},t.endingYesYes={text:["Damn you. Does nothing weaken","your resolve?? You might just","make it ... Good luck, fool."],mood:"sad",unlock:{flag:"boss",editEntity:"boss"}},t.demo={text:["So that was the demo. Have you","got what it takes to buy the","game now or are we done here?"],choices:[{text:"We're about done ...",key:"demoNo",color:"negative"},{text:"Fine, I'll buy it.",key:"demoYes",color:"positive"}]},t.demoNo={text:["Almost nobody buys it, making","you just like everyone else.","What'll you do instead?"],choices:[{text:"IDK something else ...",key:"demoNoNo",color:"negative"},{text:"Make my own games!",key:"demoNoYes",color:"positive"}]},t.demoNoNo={text:["Hah! Well, off you go on your","endless search for meaning.","Good luck with that."],mood:"happy"},t.demoNoYes={text:["At least there's that ...","Maybe someday someone will not","buy YOUR mediocre game!"]},t.demoYes={text:["Well, look who's up to the","challenge! Pick your poison:","Humble or Steam?"],choices:[{text:"Humble.",key:"demoYesNo",color:"positive",sound:"choice2"},{text:"Steam.",key:"demoYesYes",color:"positive",sound:"choice2"}]},t.demoYesNo={text:["Humble. Where giving a small","cut to charity lessens our","guilt. Cheers!"],mood:"happy",url:"https://www.humblebundle.com/g/indie-game-sim"},t.demoYesYes={text:["Steam. Where our disdain for","mediocrity is manifested in","our massive backlogs. Cheers!"],mood:"bothered",url:"http://store.steampowered.com/app/549740"}}),n("js/gameData",["require","exports","module","djinn/Emitter","djinn/client","djinn/achievements","djinn/manifest","djinn/platforms/steam","djinn/utils/storage","djinn/utils/object","djinn/utils/string","djinn/math/core","djinn/math/random","./competitors","./products","./unlocks","./buildCosts","./reviewers","./templates","./players","./doubt"],function(e,t,n){var r=e("djinn/Emitter"),i=e("djinn/client"),s=e("djinn/achievements"),o=e("djinn/manifest"),u=e("djinn/platforms/steam"),a=e("djinn/utils/storage"),f=e("djinn/utils/object"),l=e("djinn/utils/string"),c=e("djinn/math/core"),h=e("djinn/math/random"),p=e("./competitors"),d=e("./products"),v=e("./unlocks"),m=e("./buildCosts"),g=e("./reviewers"),y=e("./templates"),b=e("./players"),w=e("./doubt");const E="igs.json";var S=o.shortName;o.demo?S+="_demo":o.entry==="share"&&(S+="_share");var x=8,T=100,N={developer:null,developers:{},gameIndex:0,oauth:{},editGameIndex:0,editTileKey:8,editEntityKey:null,saveTime:0},C=r.extend({init:function(e){this._super(e),this.data=f.clone(N)},load:function(){var e=a.getObject(S);e&&(this.data=merge(e,this.data)),i.isSteam&&u.isCloudEnabled()?(console.info("[gameData.load] Load data from Steam Cloud"),u.readCloudFile(E,this._onReadSteamCloud.bind(this))):this._completeLoad()},save:function(){this.data.saveTime=Date.now(),a.setObject(S,this.data)},restoreDefaults:function(){this.data=f.clone(N),this.save()},getGamesList:function(){return this.getDeveloper().gamesList},getEditGame:function(){var e=this.getGamesList();return e[this.data.editGameIndex]},getDeveloper:function(){var e=this.data;return e.developers[e.developer]},addDeveloperEditEntity:function(e){var t=this.getDeveloper().editEntities;t.indexOf(e)===-1&&(t.push(e),this.save())},developerHasEditEntity:function(e){var t=this.getDeveloper().editEntities;return t.indexOf(e)>-1},getDevelopers:function(){return this.data.developers},getDeveloperCount:function(){return f.getLength(this.getDevelopers())},hasRolledCredits:function(){var e=this.getDevelopers();for(var t in e){var n=e[t];if(n.flags.credits)return!0}return!1},getDeveloperMoney:function(){var e=this.getDeveloper(),t=e.money;return c.round(t,2)},setDeveloper:function(e){this.data.developer=e,this.save()},addDeveloper:function(e){var t=this.data.developers;return e in t?!1:(t[e]={backgroundColor:"windowsBG",editTiles:[8],editEntities:["trashCan","gameStart","gameGoal","vTrap"],fanData:{Genero:25100,Retroladies:50500,Rook:250250,Chronic:10100,"Benzerware Ltd":1e6,DreamGere:25e5,AD:500500},flags:{},money:0,productsOwned:[],competitorIndex:0,competitorFranchise:1,gamesList:[],sceneTime:{}},this.save(),!0)},removeDeveloper:function(e){var t=this.data.developers;delete t[e],this.save()},getDeveloperFlag:function(e,t){var n=this.getDeveloper(),r=n.flags;return e in r?r[e]:t},setDeveloperFlag:function(e,t){var n=this.data,r=n.developers[n.developer];r.flags[e]=t,this.save()},developerHasProduct:function(e){var t=this.getDeveloper();return t.productsOwned.indexOf(e)>-1},developerUnlockById:function(e){if(this.getDeveloperFlag(e))return;var t=v[e];if(!t)return;var n=this.getDeveloper();t.editEntity?n.editEntities.push(t.editEntity):t.tileIndex&&n.editTiles.push(t.tileIndex),this.setDeveloperFlag(e,!0)},developerAddProduct:function(e){if(this.developerHasProduct(e))return;var t=this.getDeveloper();t.productsOwned.push(e);var n=d[e];n.editEntity?t.editEntities.push(n.editEntity):n.flag?this.setDeveloperFlag(n.flag,!0):n.tileIndex&&t.editTiles.push(n.tileIndex)},developerBuyProduct:function(e){if(this.developerHasProduct(e))return;var t=this.getDeveloper(),n=d[e];t.money-=n.price,this.developerAddProduct(e),this.save()},developerShouldPlayGames:function(){var e=this.getPublishedGames(),t=!1;return e.forEach(bind(this,function(e){e.unlockId&&!this.getDeveloperFlag(e.unlockId)&&(t=!0)})),t},hasDeveloperBoughtSomething:function(){var e=this.getDeveloper();return e.productsOwned.length>0},hasDeveloperBoughtEverything:function(){var e=this.getDeveloper();return e.productsOwned.length>=this.getProductCount()},hasDeveloperBeatAllGames:function(){for(var e=0;e<p.length;++e){var t=p[e];if(t.unlockId&&!this.getDeveloperFlag(t.unlockId))return!1}return!0},developerHasAllTools:function(){var e=this.getDeveloper();for(var t in d){var n=d[t];if(n.category!=="luxuries"&&!this.developerOwnsProduct(t))return!1}return!0},hasDeveloperWon:function(){return this.developerHasAllTools()&&this.hasDeveloperBeatAllGames()},getDeveloperProductCount:function(){var e=this.getDeveloper();return e.productsOwned.length},getProductCount:function(){return f.getLength(d)},developerOwnsProduct:function(e){var t=this.getDeveloper();return t.productsOwned.indexOf(e)>-1},developerCanBuySomeProduct:function(){var e=this.getDeveloper();for(var t in d){var n=d[t];if(!this.developerOwnsProduct(t)&&e.money>=n.price)return!0}return!1},developerBoughtGame:function(e){var t=this.getGameByIndex(e);return t.bought},developerCanAffordGame:function(e){var t=this.getGameByIndex(e),n=this.getDeveloperMoney();return n>=t.price},developerBuyGame:function(e){var t=this.getDeveloper(),n=this.getGameByIndex(e);t.money-=n.price,n.bought=!0,this.save()},developerHasGameReadyToPublish:function(){var e=this.data.developer,t=this.getGames(function(t){return t.developer===e&&!t.published&&t.tested});return t.length>0},developerHasExpensiveEntity:function(){var e=this.getDeveloper().editEntities;for(var t=0;t<e.length;++t){var n=e[t];if(m[n])return!0}return!1},getGames:function(e){var t=this.getGamesList(),n=[];for(var r=0,i=t.length;r<i;++r){var s=t[r];e(s)&&(s.gameIndex=r,n.push(s))}return n.reverse(),n},getGamesByDeveloper:function(e){return this.getGames(function(t){return t.developer===e})},getGameTotalCost:function(e){var t=0,n=e.tiles;for(var r=0;r<n.length;++r)for(var i=0;i<n[r].length;++i){var s=n[r][i],o=m[s]||0;t+=o}return t},getPublishedGames:function(){return this.getGames(function(e){return e.published})},developerHasPublishedGames:function(){return this.getPublishedGamesByDeveloper(this.data.developer).length>0},getPublishedGamesByDeveloper:function(e){return this.getGames(function(t){return t.developer===e&&t.published})},getUnpublishedGamesByDeveloper:function(e){return this.getGames(function(t){return t.developer===e&&!t.published})},getTopGames:function(){var e=this.getPublishedGames();return e.sort(function(e,t){return t.gross-e.gross}),e.length>5&&(e.length=5),e},getGameChartIndex:function(e){var t=this.getPublishedGames();t.sort(function(e,t){return t.gross-e.gross});for(var n=0;n<t.length;++n){var r=t[n];if(r===e)return n}return-1},setGameValue:function(e,t,n){var r=this.getGamesList();r[e][t]=n,this.save()},setGameTestState:function(e,t){this.setGameValue(e,"tested",t),t||this.setGamePlaytestData(e,null)},setGamePlaytestData:function(e,t){this.setGameValue(e,"playtestData",t)},setGameSurvey:function(e,t){var n=t.getEntitiesByType("survey"),r=t.width/16*(t.height/16),i=0;n.forEach(function(e){e.meta.joyCount&&(i+=e.meta.joyCount)});var s=n.length/r;this.setGameValue(e,"surveyArea",s),this.setGameValue(e,"joyCount",i)},setGameTime:function(e,t){this.setGameValue(e,"time",t)},canMakeNewGame:function(){var e=this.data.developer;return this.getGamesByDeveloper(e).length<T},canMakeNewDeveloper:function(){var e=this.data.developers;return f.getLength(e)<x},checkBestTime:function(e,t){var n=this.getGameByIndex(e);return n.bestTime||(n.bestTime=Infinity),t<n.bestTime?(n.bestTime=t,this.save(),!0):!1},makeGame:function(e,t,n){var r=this.getGamesList();return r.push({name:t.name,developer:e,player:!0,playerPrefab:t.playerPrefab,backgroundColor:t.backgroundColor,clicks:null,darkness:t.darkness,deaths:0,price:null,rating:null,sales:null,time:null,views:null,tiles:y.get(n),bestTime:null}),this.save(),n==="medium"&&s.trackProgress("mediumDev",1),r.length-1},publishGame:function(e){var t=this.getGamesList(),n=t[e];n.published=!0,n.devCost=this.getGameTotalCost(n),n.rating=this.getGameRating(n);var r=this.getFansByProfile(n.developer),i=25e3+r;this.simulateTraffic(n,i),this.addReviews(n),n.gross=n.price*n.sales,n.net=c.round(n.gross*.7,2);var o=this.getGameFanDelta(n);this.addFansByProfile(n.developer,o),n.newFans=o;if(n.player){var u=this.getDeveloper();u.money+=n.net}this.save();if(n.player){var a=this.getPublishedGamesByDeveloper(this.data.developer);a.length>=10&&s.trackProgress("prolificPublisher",1);var f=y.getKeyByHeight(n.tiles.length);f==="large"&&s.trackProgress("largeDev",1)}},getGameFanDelta:function(e){var t=c.lerp(-1,1,e.rating);return Math.floor(e.sales/3*t)},publishCompetitor:function(){var e=this.getDeveloper();e.competitorIndex>=p.length&&(e.competitorIndex=0,e.competitorFranchise++);var t=f.clone(p[e.competitorIndex]);e.competitorFranchise>1&&this.sequelizeGame(t,e.competitorFranchise);var n=this.getGamesList(),r=n.push(t);this.publishGame(r-1),e.competitorIndex++,this.save()},sequelizeGame:function(e,t){e.name+=" "+t;var n=e.backgroundColor;n[0]=c.clamp(n[0]+h.range(-25,25),0,255),n[1]=c.clamp(n[0]+h.range(-25,25),0,255),n[2]=c.clamp(n[0]+h.range(-25,25),0,255);var r=["playerBenzer","playerBoy","playerFranklin","playerGirl","playerGoblin","playerJoey","playerTiger","playerZombie"];do var i=h.choice(r);while(i===e.playerPrefab);e.playerPrefab=i;var s=e.tiles;for(var o=0;o<s.length;++o)for(var u=0;u<s[o].length;++u){var a=s[o][u];if(isNaN(a)||a===0||a>=13)continue;s[o][u]=a+1}},publishAllCompetitors:function(){var e=this.getDeveloper();while(e.competitorIndex<p.length)this.publishCompetitor()},moveGameToEnd:function(e){var t=this.getGamesList(),n=t[e];return t.splice(e,1),t.push(n)-1},isGameDevelopersFirst:function(e){var t=this.getPublishedGamesByDeveloper(this.data.developer);return e===t[t.length-1]},isGameDevelopersTopEarner:function(e){var t=this.getPublishedGamesByDeveloper(this.data.developer);return t.length<2?!0:(t.sort(function(e,t){return e.net<t.net}),t[0].name===e.name)},isDefaultColor:function(e){return e[0]===89&&e[1]===125&&e[2]===206},getGameContentCount:function(e){var t=e.tiles,n=0;for(var r=0;r<t.length;++r)for(var i=0;i<t[r].length;++i)t[r][i]&&++n;return e.darkness>0&&++n,this.isDefaultColor(e.backgroundColor)||++n,e.playerPrefab!=="playerDog"&&++n,n},getGameUniqueContentCount:function(e){var t={},n=e.tiles;for(var r=0;r<n.length;++r)for(var i=0;i<n[r].length;++i){var s=String(n[r][i]);s in t?t[s]++:t[s]=1}return e.darkness>0&&(t.darkness=1),this.isDefaultColor(e.backgroundColor)||(t.background=1),f.getLength(t)},getAverageGameUniqueContentCount:function(){var e=this.getPublishedGames(),t=e.length,n=0;for(var r=0;r<t;++r){var i=e[r],s=this.getGameUniqueContentCount(i);n+=s}return n/t},getAverageGameSurveyArea:function(){var e=this.getPublishedGames(),t=e.length,n=0;for(var r=0;r<t;++r){var i=e[r];n+=i.surveyArea}return n/t},getAverageGameJoyCount:function(){var e=this.getPublishedGames(),t=e.length,n=0;for(var r=0;r<t;++r){var i=e[r];n+=i.joyCount}return n/t},getGameRating:function(e){var t=this.getAverageGameJoyCount(),n=c.clamp(e.joyCount/t,0,1);e.joyNormal=n;var r=this.getAverageGameSurveyArea(),i=c.clamp(e.surveyArea/r,0,1);e.surveyNormal=i;var s=this.getGameAverageContentCount(e),o=this.getGameContentCount(e),u=c.clamp(o/s,0,1);e.contentNormal=u;var a=this.getAverageGameUniqueContentCount(),f=this.getGameUniqueContentCount(e),l=c.clamp(f/a,0,1);e.uniqueNormal=l;var h=i*.25+n*.25+u*.25+l*.25;return c.clamp(h,0,1)},getGamePlaytestNormal:function(e){var t=e.playtestData;if(!t)return 0;var n=.6;return t.left>0&&(n+=.1),t.right>0&&(n+=.1),t.jump>0&&(n+=.1),t.jump>1&&(n+=.1),n},getGameAverageContentCount:function(e){var t=this.getPublishedGames(),n=t.length,r=0;for(var i=0;i<n;++i){var e=t[i],s=this.getGameContentCount(e);r+=s}return r/n},simulateTraffic:function(e,t){var n=e.rating,r=0,i=0,s=this.getGameClickChance(e),u=this.getGameBuyChance(e);o.pirates&&e.player&&(u*=.07);for(var a=0;a<t;++a)h.chance(s)&&(++r,h.chance(u)&&++i);e.views=t,e.clicks=r,e.sales=i},addReviews:function(e){var t=c.clamp(Math.floor(e.sales/100),10,50),n=g.generate(e.rating,t);e.reviews=n},getGameClickChance:function(e){return e.uniqueNormal*.35},getGameBuyChance:function(e){var t=10,n=(Math.pow(t,e.rating)-1)/(t-1),r=y.getKeyByHeight(e.tiles.length),i={small:4.99,medium:9.99,large:14.99},s=i[r],o=c.lerp(.1,.35,s/e.price);return n*o},getGameByIndex:function(e){var t=this.getGamesList();return t[e]},getGameAnalysisCost:function(e){var t=y.getKeyByHeight(e.tiles.length);return{small:100,medium:500,large:1e3}[t]},getFansByProfile:function(e){var t=this.getDeveloper().fanData;return t[e]===undefined&&(t[e]=0),t[e]},addFansByProfile:function(e,t){var n=this.getFansByProfile(e),r=this.getDeveloper().fanData;r[e]=n+t,r[e]<0&&(r[e]=0),this.save()},removeGame:function(e){var t=this.getGamesList();t.splice(e,1),this.save()},buyAllProducts:function(){var e=this.getDeveloper();for(var t in d){var n=d[t];e.money+=n.price,this.developerBuyProduct(t)}},unlockAllGameUnlocks:function(){for(var e=0;e<p.length;++e){var t=p[e];t.unlockId&&this.developerUnlockById(t.unlockId)}},unlockAllDoubts:function(){for(var e in w){var t=w[e],n=t.unlock;n&&n.flag&&this.setDeveloperFlag(n.flag,!0),n&&n.editEntity&&this.addDeveloperEditEntity(n.editEntity)}},updateGameMap:function(e,t,n,r){var i=this.getGamesList(),s=i[e].tiles;s[n][t]=r,this.save()},updateGamePrice:function(e,t){var n=this.getGamesList();n[e].price=t,this.save()},updateEditGameName:function(e){var t=this.getGamesList(),n=t[this.data.editGameIndex];n.name=e,this.save()},updateEditGamePlayer:function(e){var t=this.getGamesList(),n=t[this.data.editGameIndex];n.playerPrefab=e,this.save()},getSceneTime:function(e){var t=this.getDeveloper();if(!t)return 0;var n=t.sceneTime;return n[e]||0},updateSceneTime:function(e,t){var n=this.getDeveloper();if(!n)return 0;var r=n.sceneTime;e in r?r[e]+=t:r[e]=t,this.save()},getPlayerPrefabs:function(){var e=["playerDog"];for(var t=0;t<b.length;++t){var n=b[t];this.getDeveloperFlag(n)&&e.push(n)}return e},cleanGame:function(e){var t=f.clone(e);return delete t.clicks,delete t.contentNormal,delete t.deaths,delete t.devCost,delete t.gameIndex,delete t.gross,delete t.joyCount,delete t.net,delete t.newFans,delete t.player,delete t.playtestData,delete t.price,delete t.published,delete t.rating,delete t.reviews,delete t.sales,delete t.surveyArea,delete t.tested,delete t.uniqueNormal,delete t.unlockId,delete t.views,t},encodeGame:function(e){var t=this.cleanGame(e);return t},decodeGame:function(e){return e},_completeLoad:function(){this.fire("load")},_onReadSteamCloud:function(e,t){if(t){console.info("[gameData._onReadSteamCloud] Got Steam Cloud data");var t=JSON.parse(t);t.saveTime>this.data.saveTime&&(console.info("[gameData._onReadSteamCloud] Steam Cloud data is newer"),this.data=merge(t,this.data))}this._completeLoad()}});n.exports=new C}),n("js/view/style",["require","exports","module","djinn/math/core","djinn/utils/string"],function(e,t,n){var r=e("djinn/math/core"),i=e("djinn/utils/string"),s={black:"rgba(20, 12, 28, %s)",blue:"rgba(89, 125, 206, %s)",brown:"rgba(133, 76, 48, %s)",darkBlue:"rgba(48, 52, 109, %s)",darkGreen:"rgba(52, 101, 36, %s)",gold:"rgba(216, 186, 79, %s)",green:"rgba(109, 170, 44, %s)",gray:"rgba(78, 74, 78, %s)",maroon:"rgba(68, 36, 62, %s)",orange:"rgba(210, 125, 44, %s)",pink:"rgba(210, 170, 153, %s)",purple:"rgba(159, 76, 208, %s)",qbBlue:"rgba(0, 0, 170, %s)",red:"rgba(133, 19, 20, %s)",silver:"rgba(133, 149, 161, %s)",teal:"rgba(109, 194, 202, %s)",white:"rgba(222, 238, 214, %s)",yellow:"rgba(241, 237, 121, %s)",marketBG:"rgba(27, 40, 56, %s)",windowsBG:"rgba(0, 128, 129, %s)"},o={8:"brown",9:"silver",10:"gold",11:"red",12:"teal",13:"brown",14:"green",15:"black",bouncer:"red",chicken:"white",fragileRock:"gray",gameGoal:"gold",gameKey:"gold",gameStart:"white",gravityRock:"blue",hPlatform:"white",hTrap:"silver",intervalRock:"silver",jumper:"green",lightSwitch:"yellow",pulseBlock:"blue",pulseButton:"brown",spawner:"brown",spikes:"silver",squid:"white",teleporter:"teal",torch:"yellow",vPlatform:"white",vTrap:"silver"},u={a:"green",b:"red",x:"blue",y:"gold"},a=function(e){return i.sprintf("rgb(%s, %s, %s)",e[0],e[1],e[2])},f=function(e,t){return t===undefined?t=1:t=r.clamp(t,0,1),s[e]?i.sprintf(s[e],t):null},l=function(e){return e<.6?"red":e<.8?"gold":"green"},c=function(e,t){return e>.5?f("green",t):e>.25?f("orange",t):f("red",t)},h=function(e){return i.sprintf(e?"white":"gray")},p=function(e){return f(u[e]||"gray")};n.exports={fromRGBArray:a,getColor:f,getColorFromNormal:l,getProgressColor:c,getTextColor:h,getGamepadButtonColor:p,rectangleUIDefaults:{fillColor:f("black",.8),strokeColor:f("white"),strokeWidth:4,borderRadius:4},screenshotColors:o}}),n("js/textData",{0:{x:0,y:0},1:{x:16,y:0},2:{x:32,y:0},3:{x:48,y:0},4:{x:64,y:0},5:{x:80,y:0},6:{x:96,y:0},7:{x:112,y:0},8:{x:128,y:0},9:{x:144,y:0},A:{x:0,y:16},B:{x:16,y:16},C:{x:32,y:16},D:{x:48,y:16},E:{x:64,y:16},F:{x:80,y:16},G:{x:96,y:16},H:{x:112,y:16},I:{x:128,y:16},J:{x:144,y:16},K:{x:0,y:32},L:{x:16,y:32},M:{x:32,y:32},N:{x:48,y:32},O:{x:64,y:32},P:{x:80,y:32},Q:{x:96,y:32},R:{x:112,y:32},S:{x:128,y:32},T:{x:144,y:32},U:{x:0,y:48},V:{x:16,y:48},W:{x:32,y:48},X:{x:48,y:48},Y:{x:64,y:48},Z:{x:80,y:48},$:{x:96,y:48},"@":{x:112,y:48},"(":{x:128,y:48},")":{x:144,y:48},a:{x:0,y:64},b:{x:16,y:64},c:{x:32,y:64},d:{x:48,y:64},e:{x:64,y:64},f:{x:80,y:64},g:{x:96,y:64},h:{x:112,y:64},i:{x:128,y:64},j:{x:144,y:64},k:{x:0,y:80},l:{x:16,y:80},m:{x:32,y:80},n:{x:48,y:80},o:{x:64,y:80},p:{x:80,y:80},q:{x:96,y:80},r:{x:112,y:80},s:{x:128,y:80},t:{x:144,y:80},u:{x:0,y:96},v:{x:16,y:96},w:{x:32,y:96},x:{x:48,y:96},y:{x:64,y:96},z:{x:80,y:96},"?":{x:96,y:96},"!":{x:112,y:96},".":{x:128,y:96},",":{x:144,y:96},"#":{x:0,y:112},"%":{x:16,y:112},"&":{x:32,y:112},"'":{x:48,y:112},":":{x:64,y:112},";":{x:80,y:112},"/":{x:96,y:112},"+":{x:112,y:112},"-":{x:128,y:112},_:{x:144,y:112}}),n("js/view/Typer",["require","exports","module","djinn/view/View","djinn/utils/string","./style","../textData"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/string"),s=e("./style"),o=e("../textData"),u=7,a=8,t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.color=e.color,this.text=e.text},render:function(e){var t=this.text,n=t.split(" "),r=0,i=0;for(var s=0,o=n.length;s<o;++s){var u=n[s];(r+u.length)*a>this.width&&(r=0,++i);for(var f=0,l=u.length;f<l;++f){var c=u[f];this._drawLetter(e,c,r,i),++r}++r}},shrinkwrap:function(){return this.width=this.text.length*a,this},underline:function(e){this._underline&&this._underline.dispose();if(e===!1)return;this._underline=(new r({parent:this,backgroundColor:s.getColor(this.color),height:1})).align(null,"bottom")},_drawLetter:function(e,t,n,r){var i=o[t];if(!i)return;e.drawImage(this._image,i.x,i.y,8,8,n*8,r*8,8,8)}});Object.defineProperty(t.prototype,"color",{get:function(){return this._color},set:function(e){this._color=e,this.image=i.sprintf("media/images/text/%s.png",e),this.redrawBuffer()}}),Object.defineProperty(t.prototype,"text",{get:function(){return this._text},set:function(e){e===undefined?this._text="":this._text=String(e),this.redrawBuffer()}}),t.defaults={buffer:!0,color:"white",height:a}}),n("js/view/scenes/Scene",["require","exports","module","djinn/stage","djinn/Scene","djinn/view/View","djinn/input/keyboard","djinn/input/gamepad","djinn/utils/viewEffects","../Typer","../../gameData"],function(e,t,n){var r=e("djinn/stage"),i=e("djinn/Scene"),s=e("djinn/view/View"),o=e("djinn/input/keyboard"),u=e("djinn/input/gamepad"),a=e("djinn/utils/viewEffects"),f=e("../Typer"),l=e("../../gameData"),c=u.buttons,h=o.keys,p=h.left,d=h.right,v=h.up,m=h.down,t=n.exports=i.extend({init:function(e){this._super(merge(e,t.defaults)),this._y=0},setup:function(){this._super(),r.on("wheel",this,"_onWheel")},reset:function(){this._y=0},activate:function(e,t){this._super(e,t),this._elapsed=Date.now()},deactivate:function(e,t){this._super(e,t);if(this.timeTrackId){var n=Date.now()-this._elapsed;l.updateSceneTime(this.timeTrackId,n)}},addQuitX:function(e){var t=new f({parent:this,text:"X",color:e,acceptInputEvents:!0});return t.shrinkwrap(),t.align("right","top",-4,4),t.on("inputPress",this,"_onQuit"),t},addSettingsGear:function(){var e=new s({parent:this,acceptInputEvents:!0,image:"media/images/objects.png",imageY:32,width:16,height:16});return e.align("right","bottom",-4,-4),e},getInput:function(e,t){switch(e){case"negate":return o.test("negate",t)||u.test("negate",t);case"action":return o.test("action",t)||u.test("action",t);case"left":return o.test("moveLeft",t)||o.isDown(p,t)||u.isButtonDown(c.dPadLeft,t)||u.isDirectionDown("left");case"right":return o.test("moveRight",t)||o.isDown(d,t)||u.isButtonDown(c.dPadRight,t)||u.isDirectionDown("right");case"down":return o.test("moveDown",t)||o.isDown(m,t)||u.isButtonDown(c.dPadDown,t)||u.isDirectionDown("down");case"up":return o.test("moveUp",t)||o.isDown(v,t)||u.isButtonDown(c.dPadUp,t)||u.isDirectionDown("up")}},shake:function(){a.shake(this)},_addLine:function(e,t){var n=this._container;if(e){var r=new f({parent:n,text:e,acceptInputEvents:!0,color:t,width:this.width-32,y:this._y});r.shrinkwrap()}return this._y+=8,n.shrinkwrap(),r},_onWheel:function(e,t){var n=this._scrollbar;if(!n||!this.captureInputEvents||!this.visible)return;t<0?n.scroll(-1,160):n.scroll(1,160)}});t.defaults={fadeDuration:250}}),n("js/view/Star",["require","exports","module","djinn/view/View","djinn/math/random"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),t=n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults))},tick:function(e){var t=e/1e3;this.x-=t*this.speed;if(this.x<-1){var n=this.parent;this.x=n.width+1,this.y=i.range(0,n.height)}}});t.defaults={width:1,height:1}}),n("js/view/Starfield",["require","exports","module","djinn/view/View","djinn/math/random","./Star","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=e("./Star"),o=e("./style"),t=n.exports=r.extend({init:function(e){this._super(e);for(var t=0;t<100;++t){var n=new s({parent:this});switch(i.range(1,3)){case 1:n.speed=i.range(5,10),n.backgroundColor=o.getColor("darkBlue");break;case 2:n.speed=i.range(20,30),n.backgroundColor=o.getColor("silver");break;case 3:n.speed=i.range(50,100),n.backgroundColor=o.getColor("teal")}n.x=i.range(0,this.width-1),n.y=i.range(0,this.height-1)}}})}),n("js/view/Slider",["require","exports","module","djinn/view/View","djinn/math/core","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=this.width-2,i=this.height-2,s=this._background=(new r({parent:this,acceptInputEvents:!0,backgroundColor:e.barColor,width:n,height:i})).align("center","center"),o=n<i?n:i;this.cursor=new r({parent:s,backgroundColor:e.cursorColor,width:o,height:o}),this._input=!1,this._value=null,this.on("inputStart",this,"_onInputStart"),this.on("inputMove",this,"_onInputMove"),this.on("inputEnd",this,"_onInputEnd")},setValue:function(e){var t=this._background,n=this.cursor;if(this.width>this.height){var r=t.width-n.width;n.x=i.lerp(0,r,e)}else{var r=t.height-n.height;n.y=i.lerp(0,r,e)}var s=this._value;return this._value=e,s},stopInput:function(){this._input=!1},_onInputStart:function(){this._input=!0},_onInputMove:function(e){if(!this._input)return;if(this.width>this.height)var t=e.point.x/this.width;else var t=e.point.y/this.height;t=Math.round(t*10)/10;var n=this.setValue(t);this.fire("change",[t,n])},_onInputEnd:function(){this.stopInput()}});Object.defineProperty(t.prototype,"value",{get:function(){return this._value},set:function(e){this.setValue(e)}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:s.getColor("silver"),barColor:s.getColor("black"),cursorColor:s.getColor("white")}}),n("js/view/Scrollbar",["require","exports","module","djinn/math/core","./Slider"],function(e,t,n){var r=e("djinn/math/core"),i=e("./Slider"),t=n.exports=i.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.scrollSpeed=e.scrollSpeed},attach:function(e){this._container=e},setValue:function(e){this._super(e);var t=this._container;if(!t)return;if(this.width>this.height){var n=t.parent.width-t.width;t.x=r.lerp(0,n,e)}else{var n=t.parent.height-t.height;t.y=r.lerp(0,n,e)}},reset:function(){this._input=!1,this.setValue(0);var e=this._container;this.width>this.height?e.width>e.parent.width?this.show():this.hide():e.height>e.parent.height?this.show():this.hide()},scroll:function(e,t){if(!this.visible)return;var n=t/1e3,r=100/this._container.height;this.value+=e*n*r*this.scrollSpeed,this.value<0?this.value=0:this.value>1&&(this.value=1)}});t.defaults={scrollSpeed:1.5}}),n("js/view/scenes/AchievementsScene",["require","exports","module","djinn/view/View","djinn/achievements","djinn/audio/jukebox","./Scene","../Typer","../Starfield","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/audio/jukebox"),o=e("./Scene"),u=e("../Typer"),a=e("../Starfield"),f=e("../Scrollbar"),l=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new a({parent:this}),new u({parent:this,text:"Achievements v0.3",color:"silver",x:8,y:8}),new u({parent:this,text:"-----------------",color:"gray",x:8,y:16}),this.addQuitX(),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:32,width:240,height:104}),this._container=new r({parent:this._window,acceptInputEvents:!0});var e=this._scrollbar=(new f({parent:this._window,barColor:l.getColor("black"),cursorColor:l.getColor("silver"),width:8})).align("right");e.attach(this._container),this.sortChildren()},reset:function(){this._super(),this.parent.mouse.show();var e=this._container;e.disposeChildren();var t=i.list(),n=0;for(var s=0,o=t.length;s<o;++s){var u=t[s];if(u.earned)var a="white",f="gold",l=48;else var a="silver",f="silver",l=64;var c=new r({parent:e,image:"media/images/ui.png",imageX:96,imageY:l,x:0,y:this._y,width:16,height:16}),h=this._addLine(u.title,a);h.x+=24;var h=this._addLine(u.description,f);h.x+=24,this._addLine()}},tick:function(e){if(!this.captureInputEvents)return;(this.getInput("negate",!0)||this.getInput("accept",!0))&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onQuit:function(){s.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)}});t.defaults={backgroundColor:l.getColor("black"),musicKey:"streets"}}),n("js/view/BackButton",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)}});t.defaults={acceptInputEvents:!0,image:"media/images/ui.png",imageX:48,imageY:16,width:16,height:16}}),n("js/view/Screenshot",["require","exports","module","djinn/view/View","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./style"),s=i.screenshotColors;n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},render:function(e){var t=this.tiles;if(!t)return;e.fillStyle=this.backgroundColor,e.fillRect(0,0,this.width,this.height);var n=t[0].length,r=t.length,o=Math.floor(this.width/n)||1,u=Math.floor(this.height/r)||1;for(var a=0;a<r;++a)for(var f=0;f<n;++f){var l=String(t[a][f]),c=s[l];c&&(e.fillStyle=i.getColor(c),e.fillRect(f*o,a*u,o,u))}this.overlayColor&&(e.fillStyle=this.overlayColor,e.fillRect(0,0,this.width,this.height))},setGame:function(e){this.tiles=e.tiles,e.backgroundColor&&(this.backgroundColor=i.fromRGBArray(e.backgroundColor)),this.redrawBuffer()}}),t.defaults={backgroundColor:i.getColor("black"),buffer:!0}}),n("js/view/scenes/AnalyticsScene",["require","exports","module","djinn/view/View","djinn/achievements","djinn/manifest","djinn/utils/string","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../BackButton","../Screenshot","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/manifest"),o=e("djinn/utils/string"),u=e("djinn/audio/jukebox"),a=e("./Scene"),f=e("../../gameData"),l=e("../Typer"),c=e("../BackButton"),h=e("../Screenshot"),p=e("../Scrollbar"),d=e("../style"),t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=new c({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit");var t=8;new l({parent:this,text:"Vaultworks Game Analytics",x:24,y:t}),t+=8,this._developerName=new l({parent:this,color:"silver",x:24,y:t}),t+=8,this._br=new l({parent:this,text:"------------------------------",x:8,y:t}),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:96});var n=this._container=new r({parent:this._window,acceptInputEvents:!0}),i=this._scrollbar=(new p({parent:this._window,barColor:d.getColor("marketBG"),cursorColor:d.getColor("white"),width:8})).align("right");i.attach(this._container),this.sortChildren()},reset:function(){this._super();var e=f.data.analyticsIndex,t=f.getGamesList(),n=this.game=t[e];this._developerName.text=n.developer;var r=this._container;r.disposeChildren(),this._y=0,f.isGameDevelopersFirst(n)?(this._addLine("YOUR FIRST GAME!","gold"),this._addLine()):f.isGameDevelopersTopEarner(n)&&(this._addLine("YOUR TOP EARNER!","gold"),this._addLine()),this._addLine("--- DETAILS ----------------","silver"),this._addLine();var i=new h({parent:r,y:this._y,width:n.tiles[0].length*3,height:n.tiles.length*3});i.setGame(n);var u=i.right+8,a=8,c=new l({parent:r,text:n.name,x:u,y:i.y});new l({parent:r,text:o.sprintf("$%s",n.price),x:u,y:c.y+16}),a=i.bottom+12,new l({parent:r,text:"--- PERFORMANCE ------------",color:"silver",y:a}),a+=16,s.pirates&&(new l({parent:r,text:"YOUR GAME GOT PIRATED!",color:"gold",y:a}),a+=16,new l({parent:r,text:"Sales reduced by: 93%",color:"red",y:a}),a+=16);var p=f.getGameChartIndex(n);new l({parent:r,text:o.sprintf("#%s on the top seller chart",p),color:p===0?"gold":"silver",y:a}),a+=16;var v=(new l({parent:r,text:"Views:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:o.formatNumber(n.views),x:v.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Clicks:",color:"silver",y:a})).shrinkwrap(),m=(new l({parent:r,text:o.formatNumber(n.clicks),x:v.right+8,y:a})).shrinkwrap(),g=Math.round(n.clicks/n.views*100);new l({parent:r,text:o.sprintf("(%s%)",g),color:"silver",x:m.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Sales:",color:"silver",y:a})).shrinkwrap(),m=(new l({parent:r,text:o.formatNumber(n.sales),x:v.right+8,y:a})).shrinkwrap(),g=Math.round(n.sales/n.clicks*100);new l({parent:r,text:o.sprintf("(%s%)",g),color:"silver",x:m.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Net:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:"$"+o.formatMoney(n.net),color:"green",x:v.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Dev cost:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:"$"+o.formatNumber(n.devCost),x:v.right+8,y:a}),a+=16;var y=n.net-n.devCost,b=y>0,v=(new l({parent:r,text:b?"Profit:":"Loss:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:"$"+o.formatMoney(y),color:b?"green":"red",x:v.right+8,y:a}),a+=16,new l({parent:r,text:"--- RATING -----------------",color:"silver",y:a}),a+=16;var v=(new l({parent:r,text:"Rating:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:Math.round(n.rating*100)+"%",color:d.getColorFromNormal(n.rating),x:v.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Fun:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:Math.round(n.joyNormal*100)+"%",color:d.getColorFromNormal(n.joyNormal),x:v.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Gameplay:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:Math.round(n.surveyNormal*100)+"%",color:d.getColorFromNormal(n.surveyNormal),x:v.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Content:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:Math.round(n.contentNormal*100)+"%",color:d.getColorFromNormal(n.contentNormal),x:v.right+8,y:a}),a+=16;var v=(new l({parent:r,text:"Originality:",color:"silver",y:a})).shrinkwrap();new l({parent:r,text:Math.round(n.uniqueNormal*100)+"%",color:d.getColorFromNormal(n.uniqueNormal),x:v.right+8,y:a}),a+=16,new l({parent:r,text:"--- FEEDBACK ---------------",color:"silver",y:a}),a+=16;var w=n.newFans;if(w>0)var E="New fans:",S="green";else var E="Lost fans:",S="red";var v=(new l({parent:r,text:E,color:"silver",y:a})).shrinkwrap();new l({parent:r,text:o.formatNumber(n.newFans),color:S,x:v.right+8,y:a}),a+=16;var x=new l({parent:r,text:"Read reviews ...",acceptInputEvents:!0,y:a});x.on("inputStart",this,"_onReviews"),a+=8,this._container.shrinkwrap(),this._scrollbar.reset()},activate:function(e,t){var n=this.oldSceneId;this._super(e,t),e==="reviews"?this.oldSceneId=n:e==="party"&&(f.data.gameIndex=f.data.analyticsIndex,this.oldSceneId="marketGame");var r=f.data.analyticsIndex,s=f.getGamesList(),o=this.game=s[r];i.trackProgress("selfPublisher",1),o.net>=1e4&&i.trackProgress("solidEffort",1),o.net>=1e5&&i.trackProgress("hitGame",1),f.getDeveloperMoney()>=1e6&&i.trackProgress("bigTime",1),o.devCost>=5e4&&i.trackProgress("bigSpender",1),o.newFans>=1e3&&i.trackProgress("newUsers",1);var u=f.getFansByProfile(o.developer);u>=1e4&&i.trackProgress("fanClub",1)},tick:function(e){if(!this.captureInputEvents)return;this.getInput("action",!0)&&this._onReviews(),this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onReviews:function(){u.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("reviews")},_onQuit:function(){u.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId||"marketGame")}});t.defaults={backgroundColor:d.getColor("marketBG"),musicKey:"streets"}}),n("js/view/TextBox",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/input/keyboard","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/input/keyboard"),o=e("./Typer"),u=e("./style"),a=s.keys,f=1,l=[];for(var c=65;c<=90;++c)l.push(c);for(var c=97;c<=122;++c)l.push(c);for(var c=48;c<=57;++c)l.push(c);l.push(a.space),n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.maxLength=e.maxLength,(new r({parent:this,backgroundColor:u.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center");var n=this._header=new o({parent:this,anchorX:.5});this.setHeaderText("Game Name");var i=(new o({parent:this,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-4,4);i.on("inputPress",this,"_onClose"),this._value=(new o({parent:this,width:this.maxLength*8})).align("center","center");var s=this._done=new o({parent:this,text:"Save",acceptInputEvents:!0,anchorX:.5,y:48,width:32});s.align("center"),s.on("inputPress",this,"_onDone"),this._cursor=new o({parent:this,text:"_",y:this._value.y,width:8}),this._cursorTimer=this.createTimer(500,"_onCursorTimer").start()},reset:function(e){this._value.text=e||"",this._updateCursor(),this._updateButton()},setHeaderText:function(e){var t=this._header;t.text=e,t.shrinkwrap(),t.align("center","top",0,4)},tick:function(e){var t=this.maxLength;for(var n=0,r=l.length;n<r;++n){var o=l[n];if(!s.isDown(o,!0))continue;var u=this._value.text;u.length<t?(i.play("type"+f,0),f=f===1?2:1,u+=String.fromCharCode(o),this._value.text=u,this._updateCursor(),this._updateButton()):i.play("negate",0)}s.isDown(a.enter,!0)&&this._onDone();if(s.isDown(a.backspace,!0)){f=f===1?2:1;var u=this._value.text;u.length>0?(i.play("backspace"+f,0),this._value.text=u.slice(0,-1),this._updateCursor(),this._updateButton()):i.play("negate",0)}},_onDone:function(){var e=this._value.text.trim();e?this.fire("done",[e]):i.play("negate",0)},_onClose:function(){this.fire("close")},_onCursorTimer:function(){var e=this._cursor;e.visible=!e.visible},_updateCursor:function(){var e=this._value;this._cursor.x=e.x+e.text.length*8},_updateButton:function(){var e=this._value.text.trim();this._done.color=e?"white":"gray"}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:u.getColor("white"),maxLength:8,width:192,height:64}}),n("js/view/scenes/AuthScene",["require","exports","module","djinn/view/View","djinn/utils/string","djinn/utils/request","djinn/math/random","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../TextBox","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/string"),s=e("djinn/utils/request"),o=e("djinn/math/random"),u=e("djinn/audio/jukebox"),a=e("./Scene"),f=e("../../gameData"),l=e("../Typer"),c=e("../TextBox"),h=e("../style"),p=["twert","twip","twimage","tweetle","twiggle","twatch"],t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this._overlay=new r({parent:this,backgroundColor:h.getColor("black",.75)}),this.addQuitX(),this._container=new r({parent:this,acceptInputEvents:!0,x:8});var e=this._tweetText=(new c({parent:this,maxLength:22})).align("center","center");e.on("done",this,"_onTweetTextDone"),e.on("close",this,"_onTweetTextClose"),e.setHeaderText("Tweet"),this.sortChildren()},reset:function(){this._super(),this._tweetText.hide();var e=new Image;e.src=f.data.previewData,e.ready=!0,this._image=e,this._container.disposeChildren(),this._addLine(),this._addLine("Authentication"),this._addLine("--------------","silver"),this._addLine()},activate:function(e,t){this.parent.mouse.show(),this._super(e,t);if(!window.nw){this._addLine("nw not found","red");return}var n=nw.process.mainModule.exports,r=f.data.oauth;if(s.params.oauth_verifier){this._addLine("Fetching access token ...","silver"),n.getOAuthAccessToken(r.requestToken,r.requestTokenSecret,s.params.oauth_verifier,bind(this,function(e){e.error?this._onError(e.error,"getOAuthAccessToken"):(r.accessToken=e.oauthAccessToken,r.accessTokenSecret=e.oauthAccessTokenSecret,f.save(),this._done(e))}));return}var i=r.accessToken,o=r.accessTokenSecret;this._addLine("Verifying credentials ...","silver"),n.verifyCredentials(i,o,bind(this,function(e){if(e.error){console.error("[error] verifyCredentials",e.error),this._addLine("Not logged in","silver");var t=this._addLine("Click to login");t.on("inputStart",this,"_getRequestToken")}else this._done(e)}))},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&(this._tweetText.visible?this._onTweetTextClose():this._onQuit())},_getRequestToken:function(){u.play("start",0);var e=nw.process.mainModule.exports;this._addLine("Fetching request token ...","silver"),e.getOAuthRequestToken(bind(this,function(e){if(e.error)this._onError(e.error,"getOAuthRequestToken");else{var t=f.data.oauth;t.requestToken=e.oauthToken,t.requestTokenSecret=e.oauthTokenSecret,f.save(),this._addLine("Redirecting ... bye!"),location.href=e.redirect}}))},_done:function(e){this._addLine("Authenticated!","silver");if(e.data){var t=JSON.parse(e.data);this._addLine("Welcome, "+t.screen_name,"silver")}this._addLine();var n=this._addLine("Tweet this screenshot");n.on("inputStart",this,"_showTextBox")},_showTextBox:function(){u.play("select",0),this._tweetText.reset(),this._tweetText.show()},_tweet:function(e){u.play("select",0),this._addLine("Tweeting ...","silver");var t=f.data.tweetData;t=t.replace(/^data:image\/(png|jpg);base64,/,"");var n=nw.process.mainModule.exports,r=f.data.oauth;n.tweetImage(e,t,r,bind(this,function(e){e.error&&this._onError(e.error,"tweetImage")}),bind(this,function(e){if(e.error)this._onError(e.error,"tweetImage (post)");else{u.play("start",0),f.data.tweetData=null,f.data.previewData=null;var t=o.choice(p);this._addLine("Twitter success!","silver"),this._addLine(i.sprintf("Thanks for the %s.",t),"silver");var n=f.getDeveloperFlag("tweets",0)+1;f.setDeveloperFlag("tweets",n),this._addLine(i.sprintf("You've tweeted %s times.",n),"silver");if(n===1)this._addLine("You got a bird character!","gold"),f.setDeveloperFlag("playerBird",!0);else{var r=500+n*10;this._addLine(i.sprintf("You got $%s!",r),"gold");var s=f.getDeveloper();s.money+=r}f.save(),this._addLine();var a=this._addLine("Back to game");a.on("inputStart",this,"_onQuit")}}))},_onError:function(e,t){u.play("negate",0),console.error("[error] "+t,e),this._addLine("Error, sorry!","red")},_onTweetTextDone:function(e){u.play("create",0),this._tweetText.hide(),this._tweet(e)},_onTweetTextClose:function(){u.play("negate",0),this._tweetText.hide()},_onQuit:function(){u.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("edit")}});t.defaults={backgroundColor:h.getColor("black"),musicKey:"holdPlease"}}),n("djinn/view/shapes/Pinwheel",["require","exports","module","../View","../utils/canvas"],function(e,t,n){var r=e("../View"),i=e("../utils/canvas"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.rays=e.rays,this.rayOffset=0,this.rayAngle=e.rayAngle,this.rayRotationSpeed=e.rayRotationSpeed,this.rayColor=e.rayColor,this.fillColor=e.fillColor},tick:function(e){this.rayRotationSpeed!==0&&(this.rayOffset+=e*this.rayRotationSpeed,this.redrawBuffer())},render:function(e){this.fillColor&&i.drawRect(e,0,0,this.width,this.height,this.fillColor);var t=this.rays,n=Math.PI*2/t*2,r=Math.round(this.width/2),s=Math.round(this.height/2),o=this.rayAngle/2,u=this.width/2+this.height/2;for(var a=0;a<this.rays;++a){var f=this.rayOffset+a*n,l=Math.sin(f-o)*u,c=-Math.cos(f-o)*u,h=Math.sin(f+o)*u,p=-Math.cos(f+o)*u;i.drawPolygon(e,[r,s,r+l,s+c,r+h,s+p],this.rayColor)}}});t.defaults={clip:!0,buffer:!0,rays:20,rayOffset:0,rayRotationSpeed:0,rayAngle:Math.PI/10,rayColor:"black",fillColor:"white"}}),n("js/view/Dialog",["require","exports","module","djinn/audio/jukebox","djinn/math/random","./Typer"],function(e,t,n){var r=e("djinn/audio/jukebox"),i=e("djinn/math/random"),s=e("./Typer");n.exports=s.extend({init:function(e){this._super(merge(e,t.defaults)),this._animateTimer=this.createTimer(25,"_onAnimateTimer")},animate:function(e){this._dialogText=e,this.text="",this._typeIndex=0,this._animateTimer.start()},_onAnimateTimer:function(){r.play("dialog"+i.range(1,4),0);var e=this._dialogText;this.text=e.substr(0,this._typeIndex),++this._typeIndex,this._typeIndex>e.length&&(this.fire("done"),this._animateTimer.stop())}}),t.defaults={}}),n("js/view/scenes/BillboardScene",["require","exports","module","djinn/view/View","djinn/math/random","djinn/view/shapes/Pinwheel","djinn/manifest","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../Starfield","../Dialog","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=e("djinn/view/shapes/Pinwheel"),o=e("djinn/manifest"),u=e("djinn/audio/jukebox"),a=e("./Scene"),f=e("../../gameData"),l=e("../Typer"),c=e("../Starfield"),h=e("../Dialog"),p=e("../style"),t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this.starfield=new c({parent:this}),this._header1=new h({parent:this,x:50,y:50,width:256,height:8}),this._header2=new h({parent:this,x:50,y:70,width:256,height:8}),this.sortChildren()},activate:function(e,t){this._super(e,t),this.completeTween().delayTween(1e3,bind(this,function(){this._header1.animate("Shop in the store")})).delayTween(1,bind(this,function(){this._header2.animate("to unlock new tools")})).delayTween(3e3,bind(this,function(){}))},tick:function(e){if(!this.captureInputEvents)return}});t.defaults={backgroundColor:p.getColor("black")}}),n("js/view/Alert",["require","exports","module","djinn/view/View","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Typer"),s=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),(new i({parent:this,text:"!",width:8,height:8})).align("center","center"),this._pulseTimer=this.createTimer(1e3,"_onPulseTimer")},pulse:function(){this._pulseTimer.start(),this._onPulseTimer()},_onPulseTimer:function(){this.completeTween().tween({opacity:.5},500).tween({opacity:1},500)}});t.defaults={backgroundColor:s.getColor("orange"),width:12,height:12}}),n("js/view/Shortcut",["require","exports","module","djinn/view/View","./Alert","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Alert"),s=e("./Typer"),o=e("./style"),u={dev:{text:"Editor",imageX:7,imageY:1},market:{text:"Vault",imageX:1,imageY:0},news:{text:"News",imageX:4,imageY:0},settings:{text:"Settings",imageX:0,imageY:2},stats:{text:"Stats",imageX:5,imageY:2},quit:{text:"Sign out",imageX:3,imageY:2},store:{text:"Store",imageX:7,imageY:0}},t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=u[e.key];this._icon=(new r({parent:this,image:"media/images/objects.png",imageX:n.imageX*16,imageY:n.imageY*16,width:16,height:16})).align("center"),this._typer=(new s({parent:this,text:n.text})).shrinkwrap().align("center","bottom")},polish:function(e){this.opacity=0,this.delayTween(1e3,e).tween({opacity:1},1e3,r.transitions.bounceOut)},showAlert:function(){if(this._alert)return;this._alert=(new i({parent:this})).align("right",null,-6),this._alert.pulse()}});t.defaults={acceptInputEvents:!0,width:64,height:32}}),n("djinn/view/Sprite",["require","exports","module","./View","../math/core"],function(e,t,n){var r=e("./View"),i=e("../math/core"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this._animations=e.animations,this._animating=!1,this._currentAnimation=null,this._frameElapsed=0,this._frameIndex=0,this.frameOffsetX=e.frameOffsetX,this.frameOffsetY=e.frameOffsetY;for(var n in this._animations)this._animations[n]=merge(this._animations[n],{frames:[],frameRate:12,flipX:!1,flipY:!1,loop:!0})},tick:function(e){if(!this._animating||!this._currentAnimation)return;var t=this._animations[this._currentAnimation];if(!t)return;this._frameElapsed+=e;if(this._frameElapsed>=1e3/t.frameRate){this._frameElapsed=0,++this._frameIndex;var n=t.frames.length-1;this._frameIndex>n&&(t.loop==0?(this._frameIndex=n,this._animating=!1,this.fire("animationEnd")):this._frameIndex=0),this._showFrame()}},playAnimation:function(e,t){if(this._currentAnimation!=e||t!==!1)this._animating=!0,this._currentAnimation=e,this._frameIndex=0,this._frameElapsed=0,this._showFrame();return this._animating=!0,this},resumeAnimation:function(e){this._animating=!0,this._currentAnimation=e,this._showFrame()},stopAnimation:function(){return this._animating=!1,this},_showFrame:function(){var e=this._animations[this._currentAnimation];if(e===undefined){console.warn("Animation not defined: ",this._currentAnimation);return}var t=e.frames[this._frameIndex];this.imageX=this.frameOffsetX+t[0],this.imageY=this.frameOffsetY+t[1]}}),s=t.prototype;Object.defineProperty(s,"currentAnimation",{get:function(){return this._currentAnimation}}),Object.defineProperty(s,"frame",{get:function(){return this._frameIndex},set:function(e){this._frameIndex=i.clamp(e,0,this.frameCount-1)}}),Object.defineProperty(s,"frameCount",{get:function(){var e=this._animations[this._currentAnimation];return e&&e.frames&&e.frames.length||0}}),t.defaults={animations:{},frameOffsetX:0,frameOffsetY:0}}),n("js/view/Titan",["require","exports","module","djinn/audio/jukebox","djinn/view/Sprite","djinn/view/View","./style"],function(e,t,n){var r=e("djinn/audio/jukebox"),i=e("djinn/view/Sprite"),s=e("djinn/view/View"),o=e("./style"),t=n.exports=s.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.on("inputStart",this,"_onInputStart"),this.darkness=new s({parent:this,backgroundColor:o.getColor("black"),opacity:.25}),this.titan=(new i({parent:this,animations:{idle:{frameRate:2,frames:[[0,32],[16,32]]}},image:"media/images/actors.png",imageSmoothingEnabled:!1,width:16,height:16})).align("center","center"),this.titan.playAnimation("idle")},advance:function(){var e=this.titan;e.scale+=1,this.darkness.opacity+=.2,r.play("doubt"+e.scale,0),e.scale>=5&&this.fire("done")},_onInputStart:function(){this.advance()}});t.defaults={acceptInputEvents:!0,captureInputEvents:!0,cancelInputEvents:!0}}),n("js/view/StartMenu",["require","exports","module","djinn/view/View","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Typer"),s=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults)),(new r({parent:this,backgroundColor:"rgb(192, 192, 192)",width:this.width-2,height:this.height-2})).align("center","center"),(new i({parent:this,color:"gray",anchorX:.5})).align("center","top",0,4);var n=new i({parent:this,acceptInputEvents:!0,text:"Sign out",color:"black",x:4,y:4});n.on("inputPress",this,"_onQuit")},_onQuit:function(){this.fire("quit")}}),t.defaults={acceptInputEvents:!0,backgroundColor:s.getColor("black"),width:80,height:16}}),n("js/view/scenes/ComputerScene",["require","exports","module","djinn/manifest","djinn/achievements","djinn/view/View","djinn/audio/jukebox","djinn/utils/string","./Scene","../../gameData","../Typer","../Shortcut","../Titan","../StartMenu","../style"],function(e,t,n){var r=e("djinn/manifest"),i=e("djinn/achievements"),s=e("djinn/view/View"),o=e("djinn/audio/jukebox"),u=e("djinn/utils/string"),a=e("./Scene"),f=e("../../gameData"),l=e("../Typer"),c=e("../Shortcut"),h=e("../Titan"),p=e("../StartMenu"),d=e("../style"),t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=(new s({parent:this,backgroundColor:"rgb(192, 192, 192)",height:15})).align(null,"bottom");new s({parent:e,backgroundColor:"rgb(246, 246, 246)",height:1});var t=this._footerText=new l({parent:this,acceptInputEvents:!0,color:"black"});t.align("left","bottom",8,-3),t.on("inputStart",this,"_toggleStartMenu"),this._container=new s({parent:this,acceptInputEvents:!0});var n=this.addSettingsGear();n.align("right","bottom",-4,-19),n.on("inputStart",this,"_onSettings");var r=this._trophy=new s({parent:this,acceptInputEvents:!0,image:"media/images/ui.png",imageX:96,width:16,height:16});r.right=n.x-4,r.y=n.y,r.on("inputStart",this,"_onAchievements");var i=this._securityCamera=new s({parent:this,acceptInputEvents:!0,image:"media/images/objects.png",imageX:80,imageY:16,width:16,height:16});i.right=r.x-4,i.y=r.y,i.on("inputStart",this,"_onSecurityCamera");var o=this.startMenu=new p({parent:this});o.align("left","bottom",1,-12),o.on("quit",this,"_onQuit")},reset:function(){this._super(),this.parent.mouse.show(),this._footerText.text=f.data.developer,this._titan&&this._titan.dispose(),this._titan=null,this.backgroundColor=d.getColor(f.data.developers[f.data.developer].backgroundColor),this.startMenu.hide(),i.overallProgress===1?this._trophy.imageY=48:this._trophy.imageY=64,this._securityCamera.visible=f.getDeveloperFlag("securityCamera");var e=this._container;e.disposeChildren();var t=[];t.push("news"),f.getDeveloperFlag("dev")&&t.push("dev"),f.getDeveloperFlag("store")&&t.push("store"),f.getDeveloperFlag("market")&&t.push("market"),f.getDeveloperFlag("stats")&&t.push("stats");var n=16,r=8,s=n;for(var a=0,l=t.length;a<l;++a){var h=t[a],p=new c({parent:e,key:h,x:r,y:s}),v="_on"+u.ucfirst(h);p.on("inputStart",this,v);var m=f.data.developer,g=f.getGamesByDeveloper(m),y=g.length>0,b=f.getPublishedGamesByDeveloper(m),w=f.hasDeveloperBoughtSomething();h==="news"&&(f.getDeveloperFlag("dev")?y&&!f.getDeveloperFlag("store")?p.showAlert():w&&!f.getDeveloperFlag("market")?p.showAlert():f.developerHasPublishedGames()&&!f.getDeveloperFlag("stats")&&p.showAlert():p.showAlert());var E=f.developerHasGameReadyToPublish();h==="dev"&&(y?E||p.showAlert():p.showAlert()),h==="store"&&(w?f.developerCanBuySomeProduct()&&p.showAlert():p.showAlert()),h==="market"&&(b.length<1?p.showAlert():E?p.showAlert():f.developerShouldPlayGames()&&p.showAlert()),h===f.newApp&&(p.showAlert(),p.polish(function(){o.play("add",0)}),delete f.newApp),r+=p.width+n,r>=this.width-p.width+n&&(r=8,s+=p.height+n)}this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._toggleStartMenu()},_onDev:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("dev")},_onMarket:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("market")},_onNews:function(){if(f.hasDeveloperWon()&&!f.developerHasEditEntity("boss")){var e=f.getPublishedGamesByDeveloper(f.data.developer);if(e.length>0){o.play("doubt1",0),f.setDeveloperFlag("doubtKey","finalBoss"),this._titan?this._titan.advance():this._titan=(new h({parent:this})).on("done",this,"_onDoubt");return}}o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("news")},_onStore:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("store")},_onStats:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("stats")},_onSettings:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("settings")},_onAchievements:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("achievements")},_onSecurityCamera:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("property")},_onDoubt:function(){this.captureInputEvents=!1,this.fireSceneEvent("doubt")},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")},_toggleStartMenu:function(){this.startMenu.visible?(o.play("close",0),this.startMenu.hide()):(o.play("open",0),this.startMenu.show())}});t.defaults={backgroundColor:d.getColor("windowsBG"),musicKey:"streets"}}),n("djinn/view/shapes/Circle",["require","exports","module","../View","../utils/canvas"],function(e,t,n){var r=e("../View"),i=e("../utils/canvas"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.radius=e.radius,this.fillColor=e.fillColor,this.strokeColor=e.strokeColor,this.strokeWidth=e.strokeWidth},render:function(e){var t=this._radius;i.drawCircle(e,t,t,t,this.fillColor,this.strokeColor,this.strokeWidth)}}),s=t.prototype;Object.defineProperty(s,"radius",{get:function(){return this._radius},set:function(e){this._radius=e,this.width=this.height=e*2,this.redrawBuffer()}}),t.defaults={buffer:!0,bufferPadding:10,radius:100,fillColor:"white",strokeColor:null,strokeWidth:1}}),n("js/view/SunsetShip",["require","exports","module","djinn/view/View","djinn/math/random"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},reset:function(){var e=this.parent;this.x=i.range(0,e.width-this.width),this.y=i.range(e.height/2,e.height)-this.height,this.speed=i.range(8,16),this.imageX=i.range(0,1)*32},tick:function(e){this.x+=this.speed*e/1e3,this.x>this.parent.width&&(this.reset(),this.right=0)}});t.defaults={image:"media/images/ui.png",imageY:96,width:32,height:32}}),n("js/view/SunsetSparkles",["require","exports","module","djinn/view/View","djinn/math/random","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);for(var n=0;n<10;++n)this.makeSparkle();var r=this.createTimer(100,"_onSparkleTimer");r.start()},makeSparkle:function(){var e=new r({parent:this,backgroundColor:s.getColor("yellow"),x:i.range(0,this.width-1),y:i.range(0,this.height-1),width:1,height:1}),t=e.x;e.tween({x:t+3},1e3,null,function(){e.dispose()})},_onSparkleTimer:function(){this.makeSparkle()}});t.defaults={}}),n("js/view/Quitting",["require","exports","module","djinn/audio/jukebox","./Typer"],function(e,t,n){var r=e("djinn/audio/jukebox"),i=e("./Typer"),s=1e3,o="Quitting ...";n.exports=i.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.shrinkwrap()},reset:function(){this._quitElapsed=0,this.visible=!1},activate:function(e){this.visible||r.play("negate",0),this.visible=!0,this._quitElapsed+=e;var t=this._quitElapsed/s,n=Math.round(o.length*t);this.text=o.substr(0,n),this._quitElapsed>s&&(this._quitElapsed=0,this.fire("quit"))}}),t.defaults={text:o}}),n("js/view/scenes/CreditsScene",["require","exports","module","djinn/view/View","djinn/achievements","djinn/utils/string","djinn/math/core","djinn/manifest","djinn/audio/jukebox","djinn/view/shapes/Pinwheel","djinn/view/shapes/Circle","./Scene","../../gameData","../Typer","../SunsetShip","../SunsetSparkles","../Quitting","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/utils/string"),o=e("djinn/math/core"),u=e("djinn/manifest"),a=e("djinn/audio/jukebox"),f=e("djinn/view/shapes/Pinwheel"),l=e("djinn/view/shapes/Circle"),c=e("./Scene"),h=e("../../gameData"),p=e("../Typer"),d=e("../SunsetShip"),v=e("../SunsetSparkles"),m=e("../Quitting"),g=e("../style"),t=n.exports=c.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this.pinwheel=(new f({parent:this,fillColor:g.getColor("red"),rayColor:"rgb(167, 65, 31)",rayRotationSpeed:1e-4})).align("center","center"),(new l({parent:this,radius:18,fillColor:g.getColor("yellow")})).align("center","center"),(new r({parent:this,backgroundColor:g.getColor("red"),height:this.height/2})).align(null,"bottom");var e=1,t=this.height/2;for(var n=0;n<10;++n)new r({parent:this,backgroundColor:"rgb(167, 65, 31)",height:e+1,y:t}),e+=1,t+=e*2;(new v({parent:this,width:48,height:32})).align("center","center",0,16),(new v({parent:this,width:16,height:16})).align("center","center",0,8),(new v({parent:this,width:32,height:8})).align("center","center",0,4);for(var n=0;n<3;++n)(new d({parent:this})).reset();new r({parent:this,image:"media/images/credits.png",opacity:.75}),this._quit=(new m({parent:this})).align("center","bottom",0,-16),this._quit.on("quit",this,"_onQuit");var i=this._container=new r({parent:this,acceptInputEvents:!0});this._addLine(u.title.toUpperCase()),this._addLine(),this._addLine(),this._addLine(),this._addLine(),this._addLine("PROGRAM","silver"),this._addLine(),this._addLine("Matt Hackett"),this._addLine(),this._addLine(),this._addLine(),this._addLine("MUSIC","silver"),this._addLine(),this._addLine("Joshua Morse"),this._addLine(),this._addLine("Alligators","silver"),this._addLine("Corridor","silver"),this._addLine("Flux","silver"),this._addLine("Funk Bump","silver"),this._addLine("Fusion Factory","silver"),this._addLine("Hold, Please","silver"),this._addLine("Streets","silver"),this._addLine("You Got Me","silver"),this._addLine(),this._addLine(),this._addLine(),this._addLine("PLAYTESTERS","silver"),this._addLine(),this._addLine("Joseph McCormick"),this._addLine("James Simonson"),this._addLine("Wynand Prinsloo"),this._addLine("Kevin Williams"),this._addLine(),this._addLine(),this._addLine(),this._addLine("SPECIAL THANKS","silver"),this._addLine();var s=this._addLine("Andrea Abney");this._addLine("Geoff Blair"),this._addLine("Greg Love"),this._addLine(),this._addLine(),this._addLine(),s.acceptInputEvents=!0,s.on("inputStart",this,function(){var e=new r({parent:this._container,image:"media/images/ui.png",imageX:64,imageY:16,x:s.x-16,y:s.y-6,width:16,height:16})}),this._addLine("TOTAL DEV TIME","silver"),this._addLine(),this._totalTime=this._addLine("Calculating ..."),this._addLine(),this._addLine(),this._addLine(),this._addLine("THANKS FOR PLAYING"),this._addLine(),this._addLine("-Matt","silver"),i.children.forEach(function(e){e.align("center")}),i.align("center"),(new r({parent:this,image:"media/images/palm.png",width:85,height:92})).align("left","bottom",-10,12),(new r({parent:this,flipX:!0,image:"media/images/palm.png",width:85,height:92})).align("right","bottom"),this.on("inputMove",this,"_onInputMove"),this.on("inputStart",this,"_onInputStart"),this.on("inputEnd",this,"_onInputEnd"),this.sortChildren()},reset:function(){this._done=!1,this._quit.reset(),this._container.completeTween({y:this.height});var e=h.getSceneTime("research"),t=h.getSceneTime("playtest"),n=h.getSceneTime("edit"),r=n+t+e;this._totalTime.text=s.formatTime(r),this._totalTime.shrinkwrap(),this._totalTime.align("center")},activate:function(e,t){this._super(e,t);var n=this._container;n.tween({bottom:-8},25e3,null,bind(this,function(){this._done=!0}))},tick:function(e){if(!this.captureInputEvents)return;if(this._input)return;this.getInput("negate")||this.getInput("action")?this._done?this._quit.activate(e):this._container.tickSpeed=5:(this._container.tickSpeed=1,this._quit.reset())},_onInputMove:function(e){var t=this.center,n=e.point,r=o.distance(n.x,n.y,t.x,t.y),i=o.distance(t.x,t.y,this.width,this.height),s=r/i;this.pinwheel.rayRotationSpeed=o.lerp(5e-4,1e-4,s)},_onInputStart:function(e){this._input=!0,this._container.tickSpeed=5},_onInputEnd:function(e){this._input=!1,this._container.tickSpeed=1},_onQuit:function(){a.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("title"),i.trackProgress("rollCredits",1)}});t.defaults={backgroundColor:g.getColor("orange"),musicKey:"youGotMe"}}),n("js/view/scenes/DeleteDataScene",["require","exports","module","djinn/view/View","djinn/view/Sprite","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/view/Sprite"),s=e("djinn/audio/jukebox"),o=e("./Scene"),u=e("../../gameData"),a=e("../Typer"),f=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=new a({parent:this,text:"DELETE ALL DATA?",color:"black",y:8});e.shrinkwrap(),e.align("center");var t=new a({parent:this,acceptInputEvents:!0,text:"Yes, DELETE!"});t.shrinkwrap(),t.align("center","center",0,-8),t.on("inputPress",this,"_onDeleteData");var n=new a({parent:this,text:"No, nevermind",acceptInputEvents:!0,color:"silver"});n.shrinkwrap(),n.align("center","center",0,16),n.on("inputPress",this,"_onQuit");var r=this._titan=new i({parent:this,acceptInputEvents:!0,cancelInputEvents:!0,animations:{idle:{frameRate:2,frames:[[0,32],[16,32]]}},image:"media/images/actors.png",imageSmoothingEnabled:!1,width:16,height:16});r.align("right","bottom",-4,-4),r.playAnimation("idle"),r.on("inputStart",this,"_onTitan"),this.sortChildren()},reset:function(){this._super(),this._titan.completeTween()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit()},_onDeleteData:function(){s.play("clear",0),u.restoreDefaults(),this.captureInputEvents=!1,this.fireSceneEvent("deleteData")},_onTitan:function(){s.play("doubt1",0);var e=this._titan;e.completeTween({scale:8}).align("center","center").delayTween(1e3,function(){e.scale=1,e.align("right","bottom",-4,-4)})},_onQuit:function(){s.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)}});t.defaults={backgroundColor:f.getColor("red")}}),n("js/view/scenes/DevelopersScene",["require","exports","module","djinn/view/View","djinn/math/core","djinn/utils/string","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../BackButton","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("djinn/utils/string"),o=e("djinn/audio/jukebox"),u=e("./Scene"),a=e("../../gameData"),f=e("../Typer"),l=e("../BackButton"),c=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=new l({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),new f({parent:this,text:"Welcome to Vaultworks",x:24,y:8}),new f({parent:this,text:"Game publishing tools",color:"silver",x:24,y:16}),new f({parent:this,text:"---------------------------",x:8,y:24}),this._container=new r({parent:this,acceptInputEvents:!0,y:16}),this.sortChildren()},reset:function(){this._super();var e=this._container;e.disposeChildren();var t=i.round(a.data.developers[a.data.developer].money,2);new f({parent:e,text:"Money: $"+s.formatMoney(t),color:"silver",x:8,y:24});var n=a.getFansByProfile(a.data.developer);new f({parent:e,text:"Fans: "+s.formatNumber(n),color:"silver",x:8,y:32});var r=(new f({parent:e,text:"- Analytics",acceptInputEvents:!0,x:8,y:48})).on("inputPress",this,"_onPublishedGames");if(a.developerHasGameReadyToPublish())var o="gold";else var o="silver";var u=(new f({parent:e,text:"- Publish new game",acceptInputEvents:!0,color:o,x:8,y:64})).on("inputPress",this,"_onPublish")},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit()},_onPublishedGames:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("publishedGames")},_onPublish:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("unpublishedGames")},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")}});t.defaults={backgroundColor:c.getColor("marketBG"),musicKey:"streets"}}),n("djinn/sim/shared/position",["require","exports","module","djinn/math/Vector2","../../math/collision"],function(e,t,n){var r=e("djinn/math/Vector2"),i=e("../../math/collision");t.centerOnPoint=function(e,t,n){var r=e.position,i=e.size;r.x=t-i.width/2,r.y=n-i.height/2},t.centerOnEntity=function(e,n){var r=t.getCenter(n);t.centerOnPoint(e,r.x,r.y)},t.centerOnTile=function(e,n,r,i){t.centerOnPoint(e,r*n.tileWidth+n.tileWidth/2,i*n.tileHeight+n.tileHeight/2)},t.getAimVector=function(e,n){var i=t.getCenter(e),s=t.getCenter(n);return(new r(s)).subtract(i).normalize()},t.getBounds=function(e){var t=e.position,n=e.size;return!t||!n?null:{x:t.x,y:t.y,width:n.width,height:n.height}},t.getCenter=function(e){var t=e.position,n=e.size;return!t||!n?null:{x:t.x+n.width/2,y:t.y+n.height/2}},t.getDistance=function(e,n){var i=t.getCenter(e),s=t.getCenter(n);return r.distance(i,s)},t.getTile=function(e,n){var r=t.getCenter(e);return{x:Math.floor(r.x/n.tileWidth),y:Math.floor(r.y/n.tileHeight)}},t.withinRadius=function(e,n,r){var s=t.getCenter(e),o=t.getCenter(n);return i.testPointCircle(o.x,o.y,s.x,s.y,r)}}),n("djinn/core/Collection",["require","exports","module","../Class"],function(e,t,n){var r=e("../Class"),t=n.exports=r.extend({init:function(){this.items=[],this._indexPool=[]},dispose:function(){this.disposeItems(),this._super()},disposeItems:function(){this.forEach(function(e){this.remove(e),e&&e.dispose&&e.dispose()},this),this.items=[],this._indexPool=[]},add:function(e){var t=this._indexPool;if(t.length>0){var n=t.shift();this.items[n]=e}else this.items.push(e)},remove:function(e){var t=this.items.indexOf(e);if(t===-1)return;this.items[t]=undefined,this._indexPool.push(t)},removeAll:function(){this.forEach(function(e){this.remove(e)},this)},get:function(e,t,n){var r=[],i=this.items;for(var s=0,o=i.length;s<o;++s){var u=i[s];if(u===undefined)continue;if(t)var a=e.call(t,u,s);else var a=e(u,s);a&&r.push(u)}return n?r.length>0?r[0]:null:r},forEach:function(e,t){var n=this.items;for(var r=0,i=n.length;r<i;++r){var s=n[r];if(s===undefined)continue;t?e.call(t,s,r):e(s,r)}}}),i=t.prototype;Object.defineProperty(i,"length",{get:function(){return this.items.length}})}),n("djinn/sim/Entity",["require","exports","module","djinn/Emitter","djinn/sim/shared/position"],function(e,t,n){var r=e("djinn/Emitter"),i=e("djinn/sim/shared/position"),t=n.exports=r.extend({init:function(e){this._super(e);for(var t in e)this[t]=e[t]},spawn:function(e,t){var n=this.world,r=n.createEntity(e,t);return n.spawnEntity(r),i.centerOnEntity(r,this),r}})}),n("djinn/sim/TileMap",["require","exports","module","../Class","../math/random"],function(e,t,n){var r=e("../Class"),i=e("../math/random"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this.width=e.width,this.height=e.height,this.tileWidth=e.tileWidth,this.tileHeight=e.tileHeight,this.values=[]},resize:function(e,t){this.width=e,this.height=t},get:function(e,t){return e<0||t<0||e>this.width-1||t>this.height-1?undefined:this.getByIndex(this.xyToIndex(e,t))},getByIndex:function(e){return this.values[e]},getSegmentsByRect:function(e,t,n,r){var i=[],s=this.getTilesByRect(e,t,n,r),o=this.tileWidth,u=this.tileHeight;for(var a=0,f=s.length;a<f;++a){var l=s[a],c=l.x*o,h=c+o,p=l.y*u,d=p+u;this.get(l.x,l.y-1)===0&&i.push([c,p,h,p]),this.get(l.x+1,l.y)===0&&i.push([h,p,h,d]),this.get(l.x,l.y+1)===0&&i.push([c,d,h,d]),this.get(l.x-1,l.y)===0&&i.push([c,p,c,d])}return i},getTilesByRect:function(e,t,n,r){var i=~~(e/this.tileWidth),s=~~(t/this.tileHeight),o=Math.ceil((e+n)/this.tileWidth),u=Math.ceil((t+r)/this.tileHeight),a=[];for(var t=s;t<=u;++t)for(var e=i;e<=o;++e){var f=this.get(e,t);if(f===0)continue;a.push({x:e,y:t})}return a},set:function(e,t,n){this.setByIndex(this.xyToIndex(e,t),n)},setByIndex:function(e,t){this.values[e]=t},setRect:function(e,t,n,r,i){for(var s=t;s<t+r;++s)for(var o=e;o<e+n;++o)this.set(o,s,i)},fill:function(e){var t=this.values;for(var n=0,r=this.size;n<r;++n)t[n]=e},forEach:function(e,t){var n=this.values;for(var r=0,i=n.length;r<i;++r){var s=this.indexToX(r),o=this.indexToY(r);t?e.call(t,n[r],s,o,this):e(n[r],s,o,this)}},indexToX:function(e){return e%this.width},indexToY:function(e){return Math.floor(e/this.width)},xyToIndex:function(e,t){return t*this.width+e},unitToTile:function(e,t){return{x:~~(e/this.tileWidth),y:~~(t/this.tileHeight)}},tileToUnit:function(e,t){return{x:e*this.tileWidth,y:t*this.tileHeight}},getGrid:function(){var e=[],t=this.width,n=this.height;for(var r=0;r<n;++r)e[r]=[];var i=0,r=0,s=this.values;for(var o=0,u=s.length;o<u;++o)e[r][i]=s[o],++i,i>=t&&(i=0,++r);return e},autoMap:function(e,t){this.resize(e.width,e.height),e.forEach(function(n,r,s){var o=t.invalid,u=t[n];if(u.edge){var a=e.getBitmask(r,s),f=u.values[String(a.value)];f?o=i.choice(f):(console.warn("No edge value for:",n,a.value),u.fallback!==undefined&&(o=u.fallback))}else o=i.choice(u.values);this.set(r,s,o)},this)}}),s=t.prototype;Object.defineProperty(s,"size",{get:function(){return this.width*this.height}}),Object.defineProperty(s,"unitWidth",{get:function(){return this.width*this.tileWidth}}),Object.defineProperty(s,"unitHeight",{get:function(){return this.height*this.tileHeight}}),t.defaults={width:0,height:0,tileWidth:100,tileHeight:100}}),n("djinn/sim/World",["require","exports","module","../Emitter","../math/core","../core/Collection","../utils/log","./Entity","./TileMap","./shared/position"],function(e,t,n){var r=e("../Emitter"),i=e("../math/core"),s=e("../core/Collection"),o=e("../utils/log"),u=e("./Entity"),a=e("./TileMap"),f=e("./shared/position"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.running=!1,this.elapsed=0,this.deltaPool=0,this.deltaStep=e.deltaStep,this.width=e.width,this.height=e.height,this.systems=[],this.entities=s.create(),this._entityIdSeed=0,this._prefabs={},this.camera={x:0,y:0},this._cameraTarget=null,this.map=new a},resizeToMap:function(){this.width=this.map.unitWidth,this.height=this.map.unitHeight},reset:function(){this.stop(),this.elapsed=0,this.deltaPool=0,this.triggerSystems("reset");var e=this.entities.items;for(var t=0,n=e.length;t<n;++t){var r=e[t];if(r===undefined)continue;this.triggerSystems("entityReset",[e[t]])}},start:function(){this.running=!0,this.triggerSystems("start")},stop:function(){this.running=!1,this.triggerSystems("stop")},addSystem:function(e){this.systems.push(e)},triggerSystems:function(e,t){var n=this.systems;for(var r=0,i=n.length;r<i;++r)this._triggerSystem(n[r],e,t)},definePrefabs:function(e){for(var t in e)this._prefabs[t]=e[t]},createEntity:function(e,t){if(!this._prefabs[e])return o.warn("[World.createEntity] Invalid prefab type: %s",e),null;var n=merge(t,this._prefabs[e]),r=new u(n);return r.type=e,r.world=this,r},clean:function(){var e=this.entities.items;for(var t=0,n=e.length;t<n;++t){var r=e[t];r&&this.despawnEntity(r)}this._entityIdSeed=0},spawnEntity:function(e){e.id=++this._entityIdSeed,this.entities.add(e),this.triggerSystems("entitySpawn",[e]),this.fire("entitySpawn",[e])},despawnEntity:function(e,t){this.triggerSystems("entityDespawn",[e,t]),this.fire("entityDespawn",[e,t]),e.fire("despawn",[t]),this.entities.remove(e),e.dispose()},getEntities:function(e){var t=[],n=this.entities.items;for(var r=0,i=n.length;r<i;++r){var s=n[r];s&&e(s)&&t.push(s)}return t},getEntityById:function(e){var t=this.entities.items;for(var n=0,r=t.length;n<r;++n){var i=t[n];if(i&&i.id===e)return i}return null},getEntitiesByType:function(e){var t=[],n=this.entities.items;for(var r=0,i=n.length;r<i;++r){var s=n[r];s&&s.type===e&&t.push(s)}return t},getEntitiesByRect:function(e){var t=[],n=this.entities.items;for(var r=0,s=n.length;r<s;++r){var o=n[r];o&&i.intersects(e,f.getBounds(o))&&t.push(o)}return t},getEntitiesByRadius:function(e,t){var n=f.getCenter(e),r=[],s=this.entities.items;for(var o=0,u=s.length;o<u;++o){var a=s[o];if(a){var l=f.getCenter(a);i.distance(n.x,n.y,l.x,l.y)<=t&&r.push(a)}}return r},getEntitiesByTile:function(e,t){var n=this.map;return this.getEntities(function(r){var i=f.getTile(r,n);return i.x===e&&i.y===t})},update:function(e){if(!this.running)return;this.deltaPool+=e;var t=this.deltaStep;while(this.deltaPool>=t)this.deltaPool-=t,this._update(t),this.elapsed+=t},updateCamera:function(){var e=this._cameraTarget;if(!e)return;var t=f.getCenter(e);this.camera.x=t.x,this.camera.y=t.y},setCameraTarget:function(e){this._cameraTarget=e,this.updateCamera()},_triggerSystem:function(e,t,n){if(!e[t])return;return e[t].apply(this,n)},_update:function(e){this.triggerSystems("update",[e]);var t=this.entities.items;for(var n=0,r=t.length;n<r;++n){var i=t[n];if(i===undefined)continue;this.triggerSystems("entityUpdate",[i,e])}this.triggerSystems("postUpdate"),this.updateCamera()}});t.defaults={deltaStep:16,width:1e3,height:1e3}}),n("djinn/sim/systems/state",["require","exports","module","djinn/utils/string"],function(e,t,n){var r=e("djinn/utils/string"),i={};t.define=function(e){for(var t in e)i[t]=e[t]},t.triggerHook=function(e,t,n,r){if(!i[e]||!i[e][t])return;i[e][t].apply(r,n)},t.entitySpawn=function(e){var t=e.state;if(!t)return;t.active===undefined&&(t.active={}),t.queue===undefined&&(t.queue=[])},t.entityUpdate=function(e,n){var s=e.state;if(!s)return;for(var o=0,u=s.queue.length;o<u;++o){var a=merge({},s.queue[o]),f=a.key;i[f]&&i[f].conf&&(a.conf=merge(a.conf,i[f].conf)),a.elapsed=0,a.intervalElapsed=0,s.active[f]=a,t.triggerHook(f,"add",[e,a],this);var l="stateAdd"+r.ucfirst(f);e.fire(l,[a])}s.queue.length=0;for(var f in s.active){var a=s.active[f];a.elapsed+=n,a.duration&&a.elapsed>a.duration&&(a.elapsed=a.duration),a.intervalElapsed+=n,t.triggerHook(f,"update",[e,a,n],this),a.interval&&a.intervalElapsed>=a.interval&&(t.triggerHook(f,"interval",[e,a],this),a.intervalElapsed-=a.interval);if(a.duration&&a.elapsed>=a.duration){delete s.active[f],t.triggerHook(f,"expire",[e,a],this);var l="stateExpire"+r.ucfirst(f);e.fire(l,[a])}}}}),n("djinn/sim/systems/physics",["require","exports","module","../../math/core"],function(e,t,n){var r=e("../../math/core"),i=function(e,t){var n=e.bounce,i=e.position,s=e.velocity;if(!s)return;var o=t.normal;o.x!==0?(i.x+=o.x*t.penetration,o.x===-r.sign(s.x)&&(s.x=n?-s.x*n.x:0)):(i.y+=o.y*t.penetration,o.y===-r.sign(s.y)&&(s.y=n?-s.y*n.y:0))};t.entityUpdate=function(e,t){var n=e.acceleration,r=e.drag,i=e.gravity,s=e.position,o=e.velocity;if(!o||!s||s.immovable)return;if(i){var u=i.value*t/2;o.y+=u}r&&(o.x-=r.x*o.x,o.y-=r.y*o.y),n&&(o.x+=n.x,o.y+=n.y),s.x+=o.x*t,s.y+=o.y*t,i&&(o.y+=u)},t.entityCollide=function(e,t,n){if(e.position.immovable||!t.collision.solid)return;if(n.normal.x!==0){if(e.physics!==undefined&&t.physics!==undefined&&e.physics.massX>t.physics.massX)return}else if(e.physics!==undefined&&t.physics!==undefined&&e.physics.massY>t.physics.massY)return;i(e,n)},t.entityMapCollide=function(e,t,n,r){i(e,r)},t.entityWorldCollide=function(e,t,n){var i=e.velocity,s=e.bounce;r.sign(i.x)===t&&(i.x=s?-i.x*s.x:0),r.sign(i.y)===n&&(i.y=s?-i.y*s.y:0)}}),n("djinn/math/QuadTree",["require","exports","module","djinn/Class","djinn/math/core","djinn/utils/array"],function(e,t,n){var r=e("djinn/Class"),i=e("djinn/math/core"),s=e("djinn/utils/array"),o=[],u={parent:-1,topLeft:0,topRight:1,bottomLeft:2,bottomRight:3},a=function(e){if(o.length>0){var t=o.pop();return t.set(e),t}return new f(e)},f=r.extend({init:function(e){var e=merge(e,{x:0,y:0,width:0,height:0,depth:0,maxChildren:2,maxDepth:4});this._nodes=[],this._children=[],this.set(e)},set:function(e){for(var t in e)this[t]=e[t]},insert:function(e){var t=this._nodes,n=this._children;if(t.length>0){var r=this._findInsertNode(e);r===u.parent?n.push(e):t[r].insert(e)}else n.push(e),n.length>this.maxChildren&&this.depth<this.maxDepth&&this.divide()},retrieve:function(e){var t=[],n=this._children;for(var r=0,i=n.length;r<i;++r)t.push(n[r]);if(this._nodes.length>0){var s=this._findIntersectNodes(e);for(var r=0,i=s.length;r<i;++r)t=t.concat(s[r].retrieve(e))}return t},divide:function(){var e=~~(this.width/2),t=~~(this.height/2),n=this._children;this._addNode(this.x,this.y,e,t),this._addNode(this.x+e,this.y,e,t),this._addNode(this.x,this.y+t,e,t),this._addNode(this.x+e,this.y+t,e,t),this._children=[];for(var r=0,i=n.length;r<i;++r)this.insert(n[r])},clear:function(){var e=this._nodes;while(e.length>0){var t=e.pop();t.clear(),o.push(t)}this._children=[],this._nodes=[]},_addNode:function(e,t,n,r){this._nodes.push(a({x:e,y:t,width:n,height:r,depth:this.depth+1,maxChildren:this.maxChildren,maxDepth:this.maxDepth}))},_findInsertNode:function(e){var t=this.x+this.width/2,n=this.y+this.height/2;return e.x+e.width<t?e.y+e.height<n?u.topLeft:e.y>=n?u.bottomLeft:u.parent:e.x>=t?e.y+e.height<n?u.topRight:e.y>=n?u.bottomRight:u.parent:u.parent},_findIntersectNodes:function(e){var t=[],n=this._nodes,r=this.x+this.width/2,i=this.y+this.height/2;return e.x<r&&(e.y<i&&t.push(n[u.topLeft]),e.y+e.height>=i&&t.push(n[u.bottomLeft])),e.x+e.width>=r&&(e.y<i&&t.push(n[u.topRight]),e.y+e.height>=i&&t.push(n[u.bottomRight])),t}}),l=n.exports=r.extend({init:function(e){this.rootNode=a(e)},insert:function(e){var t=this.rootNode;if(s.isArray(e))for(var n=0,r=e.length;n<r;++n)t.insert(e[n]);else t.insert(e)},retrieve:function(e){return this.rootNode.retrieve(e)},clear:function(){this.rootNode.clear()},resize:function(e,t){this.width=e,this.height=t}});Object.defineProperty(l.prototype,"width",{get:function(){return this.rootNode.width},set:function(e){this.clear(),this.rootNode.width=e}}),Object.defineProperty(l.prototype,"height",{get:function(){return this.rootNode.height},set:function(e){this.clear(),this.rootNode.height=e}})}),n("djinn/sim/systems/collision",["require","exports","module","../../math/QuadTree","../../math/collision","../../utils/array","../shared/position"],function(e,t,n){var r=e("../../math/QuadTree"),i=e("../../math/collision"),s=e("../../utils/array"),o=e("../shared/position"),u=new r,a=[],f={},l=[];t.quadTree=u,t.penetrationThreshold=0,t.defineGroupTargets=function(e,t){f[e]=t},t.defineWalkableTile=function(e){l.push(e)},t.reset=function(){u.resize(this.width,this.height)},t.update=function(){u.clear()},t.entityUpdate=function(e,n){var r=e.collision;if(!r)return;t.checkMapCollision(this,e),t.checkWorldCollision(this,e);var i=o.getBounds(e);i.id=e.id,u.insert(i),a.push(e)},t.postUpdate=function(){for(var e=0,n=a.length;e<n;++e){var r=a[e],l=o.getBounds(r),c=u.retrieve(l);for(var h=0,p=c.length;h<p;++h){var d=c[h];if(d.id===r.id)continue;var v=f[r.collision.group];if(!v)continue;var m=this.getEntityById(d.id);if(!m||!m.collision||!s.contains(v,m.collision.group))continue;var g=i.testAABB(l,d);g.penetration>t.penetrationThreshold&&this.triggerSystems("entityCollide",[r,m,g])}}a.length=0},t.checkMapCollision=function(e,n){var r=n.collision,u=n.position,a=n.size;if(!r.map)return;var f=e.map,u=n.position,a=n.size,c={x:0,y:0,width:f.tileWidth,height:f.tileHeight},h=f.getTilesByRect(u.x,u.y,a.width,a.height);for(var p=0,d=h.length;p<d;++p){var v=h[p],m=f.get(v.x,v.y);if(s.contains(l,m))continue;var g=o.getBounds(n);c.x=v.x*f.tileWidth,c.y=v.y*f.tileHeight;var y=i.testAABB(g,c);y.penetration>t.penetrationThreshold&&e.triggerSystems("entityMapCollide",[n,v.x,v.y,y])}},t.checkWorldCollision=function(e,t){var n=t.collision,r=t.position,i=t.size;if(!n.world)return;var s=0,o=0;r.x<0?(r.x=0,s=-1):r.x+i.width>e.width&&(r.x=e.width-i.width,s=1),r.y<0?(r.y=0,o=-1):r.y+i.height>e.height&&(r.y=e.height-i.height,o=1),(s!==0||o!==0)&&e.triggerSystems("entityWorldCollide",[t,s,o,t.velocity.x,t.velocity.y])}}),n("djinn/sim/systems/control",["require","exports","module","../../math/Vector2"],function(e,t,n){var r=e("../../math/Vector2"),i=new r;t.entityUpdate=function(e,t){var n=e.control,r=e.velocity;if(!r||!n||!n.active)return;i.x=n.x,i.y=n.y,i.normalize(),e.facing&&i.magnitude()>0&&(e.facing.angle=i.heading),r.x=i.x*n.power,e.gravity||(r.y=i.y*n.power)}}),n("djinn/sim/systems/jump",["require","exports","module","djinn/math/core"],function(e,t,n){var r=e("djinn/math/core");t.fallThreshold=.05,t.entityUpdate=function(e,n){var i=e.jump,s=e.velocity;if(!s||!i)return;var o=r.sign(e.gravity.value);if(o>0)var u=s.y>t.fallThreshold;else var u=s.y<-t.fallThreshold;if(u){i.grounded=!1,i.request=!1;return}if(!i.grounded){i.request=!1;return}if(!i.request)return;i.grounded=!1,i.request=!1,s.y=i.power*o,e.fire("jump"),this.fire("jump",[e])},t.entityCollide=function(e,t,n){if(!e.jump||!t.collision.solid)return;var i=r.sign(e.gravity.value);e.jump&&n.normal.y===-i&&(e.jump.grounded=!0)},t.entityMapCollide=function(e,t,n,i){if(!e.jump)return;var s=r.sign(e.gravity.value);e.jump&&i.normal.y===-s&&(e.jump.grounded=!0)},t.entityWorldCollide=function(e,t,n){if(!e.jump)return;var i=r.sign(e.gravity.value);e.jump&&n===i&&(e.jump.grounded=!0)}}),n("djinn/sim/shared/state",["require","exports","module"],function(e,t,n){t.add=function(e,t,n,r,i){var s=e.state;if(!s)return!1;s.queue.push({key:t,duration:n,interval:r,conf:i})},t.remove=function(e,t){var n=e.state;delete n.active[t];var r=n.queue;for(var i=0,s=r.length;i<s;++i)if(r[i].key===t){r.splice(i,1);break}},t.addBatch=function(e,n,r){var i=e.state;if(!i)return!1;for(var s=0,o=n.length;s<o;++s){var i=n[s];t.add(e,i.key,i.duration,i.interval,merge(i.conf,r))}},t.exists=function(e,t){var n=e.state;if(!n)return!1;if(t in n.active)return!0;var r=n.queue;for(var i=0,s=r.length;i<s;++i)if(r[i].key===t)return!0;return!1},t.getDuration=function(e,t){var n=e.state.active;return t in n?n[t].duration:0},t.getElapsed=function(e,t){var n=e.state.active;return t in n?n[t].elapsed:0}}),n("djinn/sim/systems/hazard",["require","exports","module","../shared/state","../shared/position"],function(e,t,n){var r=e("../shared/state"),i=e("../shared/position");t.entityCollide=function(e,t,n){var s=e.hazard,o=t.mortal;if(!s||!o)return;if(s.owner===t)return;var u=s.groups;if(u&&u.indexOf(t.collision.group)<0)return;if(r.exists(t,"grace"))return;r.add(t,"grace",s.graceDuration||o.graceDuration);var a=s.damage;o.health-=a,s.states&&r.addBatch(t,s.states,{normal:i.getAimVector(e,t)}),this.triggerSystems("entityDamage",[t,a,e]),this.fire("entityDamage",[t,a,e]),e.fire("harm",[a,t]),t.fire("damage",[a,e]),e.mortal&&s.killOnDealDamage&&(e.mortal.health=0)},t.entityDie=function(e){e.hazard&&delete e.hazard}}),n("djinn/sim/systems/mortal",["require","exports","module","../shared/position","../shared/state"],function(e,t,n){var r=e("../shared/position"),i=e("../shared/state");t.entityCollide=function(e,t){var n=e.mortal;if(!n)return;if(e.owner===t)return;n.killOnEntityCollide&&(n.health=0),n.killOnSolidEntityCollide&&t.collision.solid&&(n.health=0)},t.entityWorldCollide=function(e){var t=e.mortal;if(!t)return;t.killOnWorldCollide&&(t.health=0)},t.entityMapCollide=function(e){var t=e.mortal;if(!t)return;t.killOnMapCollide&&(t.health=0)},t.entityDamage=function(e,t,n){var r=e.mortal;if(!r)return;r.killOnDealDamage&&(r.health=0)},t.postUpdate=function(){this.entities.forEach(function(e){var t=e.mortal;if(t&&t.alive&&t.health<=0){t.alive=!1;if(t.soul){var n=this.createEntity(t.soul);r.centerOnEntity(n,e),this.spawnEntity(n)}this.triggerSystems("entityDie",[e]),this.fire("entityDie",[e]),t.despawnOnDeath&&this.despawnEntity(e)}},this)}}),n("djinn/sim/systems/behavior",["require","exports","module","djinn/utils/array"],function(e,t,n){var r=e("djinn/utils/array"),i={};t.define=function(e){for(var t in e)i[t]=e[t]},t.entitySpawn=function(e){var n=e.behavior;if(!n)return;n.states===undefined&&(n.states=[]),n.stateData===undefined&&(n.stateData=[]),n.initState&&(t.pushState(e,n.initState,n.initData),delete n.initState,delete n.initData),t.triggerState(e,"entitySpawn")},t.entityReset=function(e){var n=e.behavior;if(!n)return;t.triggerState(e,"entityReset")},t.entityUpdate=function(e,n){var r=e.behavior;if(!r)return;e.behavior.elapsed+=n,e.behavior.enter?t.triggerState(e,"entityUpdate",[n]):(e.behavior.enter=!0,t.triggerState(e,"enter")),e.behavior.popAfterUpdate&&(t.popState(e),e.behavior.popAfterUpdate=!1)},t.entityCollide=function(e,n,r){var i=e.behavior;if(!i)return;t.triggerState(e,"entityCollide",[n,r])},t.entityMapCollide=function(e,n,r,i){var s=e.behavior;if(!s)return;t.triggerState(e,"entityMapCollide",[n,r,i])},t.entityWorldCollide=function(e,n,r){var i=e.behavior;if(!i)return;t.triggerState(e,"entityWorldCollide",[n,r])},t.entityDespawn=function(e,n){var r=e.behavior;if(!r)return;t.triggerState(e,"entityDespawn",[e,n])},t.getStateData=function(e,t,n){var i=e.behavior;if(n)return i.data[t];var s=r.last(i.stateData);return s[t]},t.setStateData=function(e,t,n,i){var s=e.behavior;if(i)s.data[t]=n;else{var o=r.last(s.stateData);o[t]=n}},t.pushState=function(e,n,r,i){var s=e.behavior;if(!s)return;var o=s.states;i?t.popState(e):(s.elapsed=0,s.enter=!1),o.push(n),s.stateData.push(r||{}),t.triggerState(e,"push")},t.popState=function(e){var n=e.behavior,r=n.states,i=r.pop();return n.stateData.pop(),t.triggerStateByKey(e,i,"pop"),n.elapsed=0,n.enter=!1,i},t.triggerState=function(e,n,i){var s=e.behavior.states;if(s.length<1)return;var o=r.last(s);t.triggerStateByKey(e,o,n,i)},t.triggerStateByKey=function(e,t,n,r){var s=i[t];s&&s[n]&&s[n].apply(e,r)},t.entityDie=function(e){var n=e.behavior;if(!n)return;t.triggerState(e,"entityDie")}}),n("djinn/sim/states/common",["require","exports","module"],function(e,t,n){t.ttl={expire:function(e,t){this.despawnEntity(e,"ttl")}}}),n("djinn/sim/shared/physics",["require","exports","module"],function(e,t,n){t.stop=function(e){var t=e.velocity;if(!t)return;t.x=0,t.y=0}}),n("djinn/sim/states/effects",["require","exports","module","../shared/physics"],function(e,t,n){var r=e("../shared/physics");t.stun={add:function(e){r.stop(e),e.control&&(e.control.active=!1)},expire:function(e){e.control&&(e.control.active=!0)}},t.knockback={add:function(e,t){var n=e.velocity;if(!n)return;var r=t.conf,i=r.normal,s=.1;n.x=i.x*s,n.y=i.y*s},expire:function(e){r.stop(e)}}}),n("js/gravity",{value:75e-5}),n("js/sim/prefabs/playerBenzer",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerBird",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.075,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerBoy",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerChicken",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerDog",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.075,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerDoubt",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.075,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerFather",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.075,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerFranklin",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerGirl",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerGoblin",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerJanitor",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerJoey",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerLars",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerLuna",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerMother",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.075,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerRaga",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerTiger",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerWizard",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerXam",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/playerZombie",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/banner",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{queue:[{key:"ttl",duration:1e3}]},position:{x:0,y:0,z:4,immovable:!0},size:{width:16,height:16}}}),n("js/sim/prefabs/boss",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0,goalBlocker:!0,trail:!0},state:{},position:{x:0,y:0,z:2},facing:{angle:0},size:{width:14,height:14},velocity:{x:0,y:0},drag:{x:.1,y:.1},collision:{group:"objects",world:!0,map:!0},hazard:{groups:["players"],damage:1,states:[{key:"stun",duration:500}]},mortal:{alive:!0,health:1,soul:"explosionSpawner"},behavior:{initState:"boss"},light:{intensity:1,radius:32},sounds:{attack:"beam",damage:"damage",move:"woosh"}}}),n("js/sim/prefabs/boss2x2",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0,goalBlocker:!0,trail:!0},state:{},position:{x:0,y:0,z:2},facing:{angle:0},size:{width:28,height:28},velocity:{x:0,y:0},drag:{x:.1,y:.1},collision:{group:"objects",world:!0,map:!0},hazard:{groups:["players"],damage:1,states:[{key:"stun",duration:500}]},mortal:{alive:!0,health:5,soul:"explosionSpawner"},behavior:{initState:"boss",initData:{cooldown:500}},light:{intensity:1,radius:32},sounds:{attack:"beam",damage:"damage",move:"woosh"}}}),n("js/sim/prefabs/bossBlock",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{},position:{x:0,y:0,z:1},size:{width:16,height:16},physics:{massX:2,massY:0},velocity:{x:0,y:0},gravity:r,collision:{group:"objects",world:!0,map:!0,solid:!0},light:{intensity:1,radius:32}}}),n("js/sim/prefabs/bouncer",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{},position:{x:0,y:0,z:1},facing:{angle:-1},size:{width:10,height:6},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!1},gravity:r,behavior:{initState:"launcher",initData:{velocity:{x:0,y:-0.275}}},sounds:{launch:"bounce"}}}),n("js/sim/prefabs/buster",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0,trail:!0},state:{},position:{x:0,y:0,z:4},facing:{angle:0},size:{width:6,height:6},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0},hazard:{groups:["objects","players"],damage:1,states:[{key:"stun",duration:500},{key:"knockback",duration:500,conf:{speed:.25}}]},mortal:{alive:!0,killOnDealDamage:!0,killOnSolidEntityCollide:!0,killOnWorldCollide:!0,killOnMapCollide:!0,soul:"explosion",despawnOnDeath:!0},behavior:{initState:"digger"},light:{intensity:1,radius:16}}}),n("js/sim/prefabs/cannon",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:14,height:14},physics:{massX:2,massY:0},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!0},gravity:r,behavior:{initState:"turret",initData:{axisThreshold:32,cooldown:1e3,horizontal:!0,offsetY:2,range:128,spawnType:"shell",speed:.1,targetGroup:"players",vertical:!1}},sounds:{attack:"cannon"}}}),n("js/sim/prefabs/chicken",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:1,y:0},collision:{group:"objects",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:32},behavior:{initState:"walker",initData:{speed:.05}},sounds:{damage:"damage"}}}),n("js/sim/prefabs/explosion",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{queue:[{key:"ttl",duration:1e3}]},position:{x:0,y:0,z:3,immovable:!0},size:{width:16,height:16},light:{intensity:1,radius:32},behavior:{initState:"flash"}}}),n("js/sim/prefabs/explosionSpawner",["require","exports","module"],function(e,t,n){n.exports={meta:{},position:{x:0,y:0,z:0,immovable:!0},size:{width:16,height:16},behavior:{initState:"intervalSpawner",initData:{interval:100,queue:["explosion","explosion","explosion","explosion","explosion","explosion","explosion","explosion"],rangeX:8,rangeY:8}}}}),n("js/sim/prefabs/flash",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{queue:[{key:"ttl",duration:250}]},position:{x:0,y:0,z:3,immovable:!0},size:{width:16,height:16},light:{intensity:1,radius:32},behavior:{initState:"flash"}}}),n("js/sim/prefabs/fragileRock",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:16,height:16},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!0},behavior:{initState:"fragileRock",initData:{ttl:500}},sounds:{warn:"fragileWarn"}}}),n("js/sim/prefabs/fragileRockCorpse",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:16,height:16}}}),n("js/sim/prefabs/funWatcher",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:0,immovable:!0},size:{width:16,height:16},behavior:{initState:"funWatcher"}}}),n("js/sim/prefabs/gameGoal",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},position:{x:0,y:0,z:1},size:{width:12,height:12},physics:{massX:2,massY:0},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!0},gravity:r,behavior:{initState:"gameGoal"},light:{intensity:1,radius:16}}}),n("js/sim/prefabs/gameKey",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{goalBlocker:!0},position:{x:0,y:0,z:1},size:{width:16,height:16},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"objects",world:!0,map:!0},gravity:r,behavior:{initState:"collect"},light:{intensity:1,radius:16}}}),n("js/sim/prefabs/gameStart",["require","exports","module"],function(e,t,n){n.exports={meta:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:16,height:16},light:{intensity:1,radius:16}}}),n("js/sim/prefabs/glitter",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{queue:[{key:"ttl",duration:1e3}]},position:{x:0,y:0,z:3},size:{width:16,height:16},light:{intensity:1,radius:16}}}),n("js/sim/prefabs/gravityRock",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:12,height:12},velocity:{x:0,y:0},drag:{x:.1,y:.1},bounce:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!1},behavior:{initState:"gravityRock",initData:{ttl:500}}}}),n("js/sim/prefabs/hPlatform",["require","exports","module"],function(e,t,n){n.exports={meta:{top:!0},state:{},position:{x:0,y:0,z:3},size:{width:14,height:14},physics:{massX:1,massY:1},velocity:{x:0,y:0},drag:{x:0,y:.1},bounce:{x:1,y:1},collision:{group:"objects",world:!0,map:!0,solid:!0},behavior:{initState:"hPlatform"}}}),n("js/sim/prefabs/hTrap",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},position:{x:0,y:0,z:1},size:{width:8,height:8},velocity:{x:0,y:0},drag:{x:0,y:.1},collision:{group:"objects",world:!0,map:!0,solid:!1},hazard:{groups:["objects","players"],damage:1,states:[{key:"stun",duration:500}]},bounce:{x:1,y:1},behavior:{initState:"trap",initData:{horizontal:!0}}}}),n("js/sim/prefabs/intervalRock",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:16,height:16},drag:{x:.1,y:.1},bounce:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!0},behavior:{initState:"intervalRock",initData:{interval:1e3}},sounds:{appear:"appear",disappear:"disappear"}}}),n("js/sim/prefabs/jumper",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{},position:{x:0,y:0,z:1},facing:{angle:-1},size:{width:8,height:8},velocity:{x:0,y:0},bounce:{x:1,y:0},collision:{group:"objects",world:!0,map:!0},gravity:r,hazard:{groups:["players"],damage:1,states:[{key:"stun",duration:500}]},mortal:{alive:!0,health:1},behavior:{initState:"jumper",initData:{warning:500,cooldown:1500,velocity:{x:.12,y:.2}}},light:{intensity:1,radius:32},sounds:{damage:"damage",warning:"warning",jump:"jump2"}}}),n("js/sim/prefabs/lightSwitch",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:12,height:12},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!1},behavior:{initState:"lightSwitch"},light:{intensity:1,radius:16},sounds:{pulse:"lights"}}}),n("js/sim/prefabs/pirate",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{action:"jump",role:"player"},state:{},control:{active:!0,power:.1,x:-1,y:0},jump:{power:-0.225},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:10,height:10},velocity:{x:0,y:0},bounce:{x:0,y:0},collision:{group:"players",world:!0,map:!0},gravity:r,mortal:{alive:!0,health:1},light:{intensity:1,radius:40},sounds:{damage:"damage",despawn:"death",jump:"jump"}}}),n("js/sim/prefabs/puff",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{queue:[{key:"ttl",duration:250}]},position:{x:0,y:0,z:3,immovable:!0},size:{width:16,height:16}}}),n("js/sim/prefabs/pulseBlock",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:16,height:16},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!0},behavior:{initState:"pulseBlock"},light:{intensity:1,radius:32},sounds:{pulseBlock:"pulseBlock",pulseBlockSolid:"pulseBlockSolid"}}}),n("js/sim/prefabs/pulseButton",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:12,height:12},velocity:{x:0,y:0},drag:{x:.1,y:.1},bounce:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!1},behavior:{initState:"pulser"},light:{intensity:1,radius:16},sounds:{pulse:"pulse"}}}),n("js/sim/prefabs/shell",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:2},facing:{angle:-1},size:{width:10,height:10},velocity:{x:0,y:0},drag:{x:0,y:.1},collision:{group:"objects",world:!0,map:!0},hazard:{groups:["objects","players"],damage:1,killOnDealDamage:!0,states:[{key:"stun",duration:500},{key:"knockback",duration:250}]},mortal:{alive:!0,health:1,killOnSolidEntityCollide:!0,killOnMapCollide:!0,killOnWorldCollide:!0,despawnOnDeath:!0,soul:"explosion"},behavior:{initState:"stompee"}}}),n("js/sim/prefabs/shellLights",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:2},facing:{angle:-1},size:{width:10,height:10},velocity:{x:0,y:0},drag:{x:0,y:.1},collision:{group:"objects",world:!0,map:!0},hazard:{groups:["objects","players"],damage:1,killOnDealDamage:!0,states:[{key:"stun",duration:500},{key:"knockback",duration:500}]},mortal:{alive:!0,health:1,killOnSolidEntityCollide:!0,killOnMapCollide:!0,killOnWorldCollide:!0,despawnOnDeath:!0,soul:"explosion"},behavior:{initState:"stompee"},light:{intensity:1,radius:32}}}),n("js/sim/prefabs/smoke",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{queue:[{key:"ttl",duration:500}]},position:{x:0,y:0,z:3},velocity:{x:0,y:0},gravity:{value:-0.00005},size:{width:16,height:16}}}),n("js/sim/prefabs/spawner",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{},position:{x:0,y:0,z:1},size:{width:12,height:12},physics:{massX:2,massY:0},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!0},gravity:r,behavior:{initState:"spawner"},sounds:{warning:"spawnWarning",spawn:"spawn"}}}),n("js/sim/prefabs/spikes",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},position:{x:0,y:0,z:2},size:{width:8,height:8},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!1},gravity:r,hazard:{groups:["objects","players"],damage:1,states:[{key:"stun",duration:500}]}}}),n("js/sim/prefabs/squid",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:2},facing:{angle:1},size:{width:12,height:12},velocity:{x:0,y:0},bounce:{x:1,y:0},collision:{group:"objects",world:!0,map:!0},mortal:{alive:!0,health:1},behavior:{initState:"walker",initData:{speed:.05}},sounds:{damage:"damage"}}}),n("js/sim/prefabs/survey",["require","exports","module"],function(e,t,n){n.exports={meta:{},position:{x:0,y:0,z:0,immovable:!0},size:{width:16,height:16}}}),n("js/sim/prefabs/teleporter",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},state:{},position:{x:0,y:0,z:1,immovable:!0},size:{width:12,height:12},velocity:{x:0,y:0},drag:{x:.1,y:.1},bounce:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!1},behavior:{initState:"teleporter"}}}),n("js/sim/prefabs/torch",["require","exports","module","../../gravity"],function(e,t,n){var r=e("../../gravity");n.exports={meta:{},state:{},position:{x:0,y:0,z:1},size:{width:16,height:16},physics:{massX:2,massY:0},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!0},gravity:r,behavior:{initState:"torch"},light:{intensity:1,radius:32}}}),n("js/sim/prefabs/vPlatform",["require","exports","module"],function(e,t,n){n.exports={meta:{},state:{},position:{x:0,y:0,z:3},size:{width:16,height:16},physics:{massX:0,massY:2},velocity:{x:0,y:0},bounce:{x:1,y:1},collision:{group:"objects",world:!0,map:!0,solid:!0},behavior:{initState:"vPlatform"}}}),n("js/sim/prefabs/vTrap",["require","exports","module"],function(e,t,n){n.exports={meta:{center:!0},position:{x:0,y:0,z:1},size:{width:8,height:8},physics:{massX:0,massY:2},velocity:{x:0,y:0},collision:{group:"objects",world:!0,map:!0,solid:!1},hazard:{groups:["objects","players"],damage:1,states:[{key:"stun",duration:500}]},bounce:{x:1,y:1},behavior:{initState:"trap",initData:{vertical:!0}}}}),n("js/sim/prefabs/index",["require","exports","module","./playerBenzer","./playerBird","./playerBoy","./playerChicken","./playerDog","./playerDoubt","./playerFather","./playerFranklin","./playerGirl","./playerGoblin","./playerJanitor","./playerJoey","./playerLars","./playerLuna","./playerMother","./playerRaga","./playerTiger","./playerWizard","./playerXam","./playerZombie","./banner","./boss","./boss2x2","./bossBlock","./bouncer","./buster","./cannon","./chicken","./explosion","./explosionSpawner","./flash","./fragileRock","./fragileRockCorpse","./funWatcher","./gameGoal","./gameKey","./gameStart","./glitter","./gravityRock","./hPlatform","./hTrap","./intervalRock","./jumper","./lightSwitch","./pirate","./puff","./pulseBlock","./pulseButton","./shell","./shellLights","./smoke","./spawner","./spikes","./squid","./survey","./teleporter","./torch","./vPlatform","./vTrap"],function(e,t){t.playerBenzer=e("./playerBenzer"),t.playerBird=e("./playerBird"),t.playerBoy=e("./playerBoy"),t.playerChicken=e("./playerChicken"),t.playerDog=e("./playerDog"),t.playerDoubt=e("./playerDoubt"),t.playerFather=e("./playerFather"),t.playerFranklin=e("./playerFranklin"),t.playerGirl=e("./playerGirl"),t.playerGoblin=e("./playerGoblin"),t.playerJanitor=e("./playerJanitor"),t.playerJoey=e("./playerJoey"),t.playerLars=e("./playerLars"),t.playerLuna=e("./playerLuna"),t.playerMother=e("./playerMother"),t.playerRaga=e("./playerRaga"),t.playerTiger=e("./playerTiger"),t.playerWizard=e("./playerWizard"),t.playerXam=e("./playerXam"),t.playerZombie=e("./playerZombie"),t.banner=e("./banner"),t.boss=e("./boss"),t.boss2x2=e("./boss2x2"),t.bossBlock=e("./bossBlock"),t.bouncer=e("./bouncer"),t.buster=e("./buster"),t.cannon=e("./cannon"),t.chicken=e("./chicken"),t.explosion=e("./explosion"),t.explosionSpawner=e("./explosionSpawner"),t.flash=e("./flash"),t.fragileRock=e("./fragileRock"),t.fragileRockCorpse=e("./fragileRockCorpse"),t.funWatcher=e("./funWatcher"),t.gameGoal=e("./gameGoal"),t.gameKey=e("./gameKey"),t.gameStart=e("./gameStart"),t.glitter=e("./glitter"),t.gravityRock=e("./gravityRock"),t.hPlatform=e("./hPlatform"),t.hTrap=e("./hTrap"),t.intervalRock=e("./intervalRock"),t.jumper=e("./jumper"),t.lightSwitch=e("./lightSwitch"),t.pirate=e("./pirate"),t.puff=e("./puff"),t.pulseBlock=e("./pulseBlock"),t.pulseButton=e("./pulseButton"),t.shell=e("./shell"),t.shellLights=e("./shellLights"),t.smoke=e("./smoke"),t.spawner=e("./spawner"),t.spikes=e("./spikes"),t.squid=e("./squid"),t.survey=e("./survey"),t.teleporter=e("./teleporter"),t.torch=e("./torch"),t.vPlatform=e("./vPlatform"),t.vTrap=e("./vTrap")}),n("js/sim/joy",["require","exports","module","djinn/utils/intl","djinn/sim/shared/position","djinn/sim/shared/state","../gameData"],function(e,t,n){var r=e("djinn/utils/intl"),i=e("djinn/sim/shared/position"),s=e("djinn/sim/shared/state"),o=e("../gameData");t.addState=function(e,t,n){if(e.meta.role!=="player")return;if(s.exists(e,t))return;s.add(e,t,n);if(!o.playtest)return;var u=e.world,a=u.createEntity("banner",{meta:{text:r.get(t),color:"white"}});i.centerOnEntity(a,e),u.spawnEntity(a)}}),n("js/sim/stomp",["require","exports","module","djinn/math/core","djinn/sim/systems/behavior","djinn/sim/shared/position","./joy"],function(e,t,n){var r=e("djinn/math/core"),i=e("djinn/sim/systems/behavior"),s=e("djinn/sim/shared/position"),o=e("./joy");t.entityCollide=function(e,t,n){if(e.mortal&&!e.mortal.alive)return!1;if(!t.velocity)return!1;if(t.meta.role!=="player")return!1;var i=s.getCenter(t),u=s.getCenter(e);if(e.gravity){if(e.gravity.value>0){if(i.y>u.y)return!1}else if(i.y<u.y)return!1}else if(i.y>u.y)return!1;o.addState(t,"zoom",1e3),t.velocity.y=.275*-r.sign(t.gravity.value),e.velocity.x=0;var a=1;e.mortal.health-=a;var f=e.world;f.triggerSystems("entityDamage",[e,a,t]),f.fire("entityDamage",[e,a,t]),t.fire("harm",[a,e]),e.fire("damage",[a,t]);var l=e.spawn("puff"),c=n.contacts[0];return s.centerOnPoint(l,c.x,c.y),!0}}),n("js/sim/behaviors/boss",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/state","../stomp","../../gravity"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/state"),i=e("../stomp"),s=e("../../gravity");t.entityCollide=function(e,t){i.entityCollide(this,e,t)&&delete this.hazard},t.entityUpdate=function(){if(r.exists(this,"cooldown"))return;var e=n.getStateData(this,"cooldown")||1e3;r.add(this,"cooldown",e);var t=this.world.getEntitiesByType("bossBlock"),i=t.length||1;for(var s=0;s<i;++s)n.pushState(this,"bossAttack",{cooldown:e});for(var s=0;s<i;++s)n.pushState(this,"bossMove",{cooldown:e})},t.entityDie=function(){this.gravity=s,delete this.behavior}}),n("js/sim/behaviors/bossAttack",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/position","djinn/sim/shared/state","../stomp","../../gravity"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/position"),i=e("djinn/sim/shared/state"),s=e("../stomp"),o=e("../../gravity");t.enter=function(){var e=this.world.player;if(!e)return;var t=r.getAimVector(this,e),s=this.spawn("buster");s.hazard.owner=this,s.position.x+=t.x*s.size.width,s.position.y+=t.y*s.size.height,s.velocity.x=t.x*.1,s.velocity.y=t.y*.1;var o=this.spawn("puff");r.centerOnEntity(o,s),s.facing.angle=t.heading,i.add(this,"cooldown",n.getStateData(this,"cooldown")),this.fire("attack")},t.entityCollide=function(e,t){s.entityCollide(this,e,t)&&delete this.hazard},t.entityUpdate=function(){if(i.exists(this,"cooldown"))return;n.popState(this)},t.entityDie=function(){this.gravity=o,delete this.behavior}}),n("js/sim/behaviors/bossMove",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/position","djinn/sim/shared/state","../stomp","../../gravity"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/position"),i=e("djinn/sim/shared/state"),s=e("../stomp"),o=e("../../gravity");t.enter=function(){var e=this.world.player;if(!e)return;var t=r.getAimVector(this,e);this.velocity.x=t.x*.2,this.velocity.y=t.y*.2,i.add(this,"cooldown",n.getStateData(this,"cooldown")),this.fire("move")},t.entityCollide=function(e,t){s.entityCollide(this,e,t)&&delete this.hazard},t.entityUpdate=function(){if(i.exists(this,"cooldown"))return;n.popState(this)},t.entityDie=function(){this.gravity=o,delete this.behavior}}),n("js/sim/behaviors/chase",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/position","djinn/sim/shared/state"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/position"),i=e("djinn/sim/shared/state");t.entityUpdate=function(){if(i.exists(this,"cooldown"))return;i.add(this,"cooldown",n.getStateData(this,"cooldown"));var e=this.control,t=this.world,s=t.player,o=r.getCenter(this),u=r.getCenter(s);o.x<u.x?e.x=1:o.x>u.x&&(e.x=-1),o.y<u.y?e.y=1:o.y>u.y&&(e.y=-1)}}),n("js/sim/behaviors/collect",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/state","../joy"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/state"),i=e("../joy");t.entityCollide=function(e,t){if(e.meta.role!=="player")return;i.addState(e,"bling",1e3);var n=this.world;this.spawn("glitter"),n.despawnEntity(this),n.fire("entityCollect",[this])}}),n("js/sim/behaviors/collideEvent",["require","exports","module","djinn/sim/systems/behavior"],function(e,t){var n=e("djinn/sim/systems/behavior");t.entityCollide=function(e,t){if(e.meta.role!=="player")return;var r=this.world;r.fire(n.getStateData(this,"eventName"))}}),n("js/sim/behaviors/digger",["require","exports","module","djinn/sim/shared/position"],function(e,t){var n=e("djinn/sim/shared/position");t.entityMapCollide=function(e,t,r){var i=this.world;i.map.set(e,t,0);var s=i.createEntity("puff");n.centerOnTile(s,i.map,e,t),i.spawnEntity(s);var o=i.createEntity("smoke");n.centerOnTile(o,i.map,e,t),i.spawnEntity(o)},t.entityDie=function(){delete this.behavior}}),n("js/sim/behaviors/flash",["require","exports","module","djinn/sim/shared/state"],function(e,t){var n=e("djinn/sim/shared/state");t.entityUpdate=function(){var e=n.getDuration(this,"ttl");if(!e)return;var t=n.getElapsed(this,"ttl"),r=t/e,i=this.light;i.intensity=1-r}}),n("js/sim/behaviors/fragileRock",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/state","../joy"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/state"),i=e("../joy");t.entityCollide=function(e,t){if(r.exists(this,"ttl"))return;i.addState(e,"cool",1e3);var s=n.getStateData(this,"ttl");r.add(this,"ttl",s)},t.entityDespawn=function(e,t){if(t==="ttl"){var n=this.spawn("fragileRockCorpse");r.add(n,"ttl",500)}}}),n("js/sim/behaviors/funWatcher",["require","exports","module","djinn/utils/intl","djinn/sim/shared/position","djinn/sim/shared/state","../joy"],function(e,t){var n=e("djinn/utils/intl"),r=e("djinn/sim/shared/position"),i=e("djinn/sim/shared/state"),s=e("../joy"),o=["bling","cool","danger","ride","zoom"],u=function(){var e=this.world,t=e.map,n=e.player,r=e.getEntitiesByRadius(n,32);for(var i=0,o=r.length;i<o;++i){var u=r[i];if(u.hazard&&u.owner!==n){s.addState(n,"danger",1e3);return}}},a=function(){var e=this.world,t=e.map,s=e.player,u=r.getTile(s,t),a=u.x,f=u.y,l=e.getEntities(function(e){var n=r.getTile(e,t);return e.type==="survey"&&n.x===a&&n.y===f});if(l.length>0)return;var c=0;for(var h=0,p=o.length;h<p;++h){var d=o[h];i.exists(s,d)&&(c+=1)}var v=e.createEntity("survey",{meta:{joyCount:c}});r.centerOnTile(v,t,a,f),e.spawnEntity(v);if(c>1){var m=e.createEntity("banner",{meta:{text:n.get("FUN",c),color:"gold"}});r.centerOnEntity(m,s),e.spawnEntity(m)}};t.entityUpdate=function(){if(i.exists(this,"cooldown"))return;i.add(this,"cooldown",50),u.call(this),a.call(this)}}),n("js/sim/behaviors/gameGoal",["require","exports","module","djinn/sim/systems/behavior"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=function(){var e=this.world.getEntities(function(e){if(e.meta&&e.meta.goalBlocker)return e.mortal?e.mortal.alive:!0});e.length>0?n.setStateData(this,"active",!1):n.setStateData(this,"active",!0),this.fire("activeStateChange",[n.getStateData(this,"active")])},i=function(e){if(!e.meta||!e.meta.goalBlocker)return;var t=n.getStateData(this,"active");r.call(this);var i=n.getStateData(this,"active");i&&!t&&this.world.fire("goalOpen")};t.entitySpawn=function(){this.world.on("entityCollect",this,i),this.world.on("entityDie",this,i)},t.entityReset=function(){r.call(this)},t.entityCollide=function(e,t){if(e.meta.role!=="player")return;if(!n.getStateData(this,"active"))return;var r=this.world;r.fire("goal")}}),n("js/sim/behaviors/gravityRock",["require","exports","module","djinn/sim/shared/state","../joy"],function(e,t){var n=e("djinn/sim/shared/state"),r=e("../joy");t.entityCollide=function(e,t){if(!e.gravity)return;if(n.exists(this,"cooldown"))return;n.add(this,"cooldown",1e3);if(n.exists(e,"gravityCooldown"))return;n.add(e,"gravityCooldown",250),r.addState(e,"cool",1e3),e.gravity.value=-e.gravity.value,e.fire("gravityChange",[e.gravity.value]),this.fire("gravityEffect")}}),n("js/sim/behaviors/hPlatform",["require","exports","module","djinn/sim/shared/position","djinn/sim/shared/state","../joy"],function(e,t){var n=e("djinn/sim/shared/position"),r=e("djinn/sim/shared/state"),i=e("../joy"),s=.05;t.entityReset=function(){this.velocity.x=-s},t.entityUpdate=function(e){var t=n.getBounds(this);t.width-=4,t.height=1,t.x+=2,t.y-=1;var s=this.world.getEntitiesByRect(t);if(s.length)for(var o=0,u=s.length;o<u;++o){var a=s[o],f=a.position;if(f&&!f.immovable){var l=a.gravity;l&&l.value>0&&(r.exists(a,"platforming")||(r.add(a,"platforming",1),f.x+=this.velocity.x*e,i.addState(a,"ride",1e3)))}}var t=n.getBounds(this);t.width-=4,t.height=1,t.x+=2,t.y+=this.size.height;var s=this.world.getEntitiesByRect(t);if(s.length)for(var o=0,u=s.length;o<u;++o){var a=s[o],f=a.position;if(f&&!f.immovable){var l=a.gravity;l&&l.value<0&&(r.exists(a,"platforming")||(r.add(a,"platforming",1),f.x+=this.velocity.x*e,r.add(a,"ride",100)))}}}}),n("js/sim/behaviors/intervalRock",["require","exports","module","djinn/sim/systems/behavior","../joy"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("../joy");t.entityCollide=function(e){if(e.meta.role!=="player")return;r.addState(e,"cool",1e3)},t.entityUpdate=function(){var e=n.getStateData(this,"interval");if(this.behavior.elapsed<e)return;this.behavior.elapsed=0,this.collision.solid=!this.collision.solid,this.fire("toggle",[this.collision.solid])}}),n("js/sim/behaviors/intervalSpawner",["require","exports","module","djinn/math/random","djinn/sim/systems/behavior"],function(e,t){var n=e("djinn/math/random"),r=e("djinn/sim/systems/behavior");t.entityUpdate=function(){var e=r.getStateData(this,"interval");if(this.behavior.elapsed<e)return;this.behavior.elapsed=0;var t=r.getStateData(this,"queue"),i=t.shift(),s=this.spawn(i),o=r.getStateData(this,"rangeX");o&&(s.position.x+=n.range(-o,o));var u=r.getStateData(this,"rangeY");u&&(s.position.y+=n.range(-u,u)),t.length===0&&this.world.despawnEntity(this)}}),n("js/sim/behaviors/jumper",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/position","djinn/sim/shared/state","../stomp"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/position"),i=e("djinn/sim/shared/state"),s=e("../stomp");t.enter=function(){i.add(this,"cooldown",n.getStateData(this,"cooldown"))},t.entityCollide=function(e,t){t.normal.y===-1&&e.collision&&e.collision.solid&&this.mortal.alive&&this.mortal.health>0&&(this.velocity.x*=.5,this.fire("land")),s.entityCollide(this,e,t)&&delete this.hazard},t.entityMapCollide=function(e,t,n){this.velocity.x*=.5,this.fire("land")},t.entityWorldCollide=function(e,t){this.velocity.x*=.5,this.fire("land")},t.entityUpdate=function(){if(i.exists(this,"cooldown"))return;i.add(this,"cooldown",n.getStateData(this,"cooldown"));var e=this.world.player;if(!e)return;var t=r.getCenter(this),s=r.getCenter(e);t.x<s.x?this.facing.angle=-1:this.facing.angle=1,n.pushState(this,"jumperWarning",{velocity:n.getStateData(this,"velocity"),warning:n.getStateData(this,"warning")}),this.fire("warning")},t.entityDie=function(){delete this.behavior}}),n("js/sim/behaviors/jumperWarning",["require","exports","module","djinn/math/core","djinn/sim/systems/behavior","djinn/sim/shared/state","../stomp"],function(e,t){var n=e("djinn/math/core"),r=e("djinn/sim/systems/behavior"),i=e("djinn/sim/shared/state"),s=e("../stomp");t.enter=function(){i.add(this,"warning",r.getStateData(this,"warning"))},t.entityCollide=function(e,t){s.entityCollide(this,e,t)&&delete this.hazard},t.entityUpdate=function(){if(i.exists(this,"warning"))return;var e=r.getStateData(this,"velocity");this.facing.angle===-1?this.velocity.x=e.x:this.velocity.x=-e.x,this.velocity.y=e.y*-n.sign(this.gravity.value),this.fire("jump"),r.popState(this)},t.entityDie=function(){delete this.behavior}}),n("js/sim/behaviors/launcher",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/position","../joy"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/position"),i=e("../joy"),s=function(){var e=n.getStateData(this,"velocity");e.y=-e.y,n.setStateData(this,e)};t.entitySpawn=function(){this.on("gravityChange",this,s)},t.entityUpdate=function(e){var t=r.getBounds(this);t.height=1,t.y-=1;var s=this.world.getEntitiesByRect(t);if(!s.length)return;var o=n.getStateData(this,"velocity");for(var u=0,a=s.length;u<a;++u){var f=s[u],l=f.position;l&&!l.immovable&&(i.addState(f,"zoom",1e3),o.x!==0&&(f.velocity.x=o.x),o.y!==0&&(f.velocity.y=o.y),o.y<0&&f.jump&&(f.jump.grounded=!1),this.fire("launch"))}}}),n("js/sim/behaviors/lightSwitch",["require","exports","module","../joy","djinn/sim/shared/state"],function(e,t){var n=e("../joy"),r=e("djinn/sim/shared/state");t.entityCollide=function(e,t){if(r.exists(this,"cooldown"))return;r.add(this,"cooldown",1e3),n.addState(e,"cool",1e3),this.fire("pulse"),this.world.fire("lightToggle")}}),n("js/sim/behaviors/oob",["require","exports","module"],function(e,t){t.entityUpdate=function(){this.position.x<=-16&&this.world.despawnEntity(this)}}),n("js/sim/behaviors/pickup",["require","exports","module","djinn/sim/systems/behavior"],function(e,t){var n=e("djinn/sim/systems/behavior");t.entityCollide=function(e,t){if(e.meta.role!=="player")return;e.meta.action=n.getStateData(this,"action");var r=this.world;r.despawnEntity(this)}}),n("js/sim/behaviors/pulseBlock",["require","exports","module"],function(e,t){t.entitySpawn=function(){this.world.on("pulse",this,function(){this.collision.solid=!this.collision.solid,this.fire("toggle",[this.collision.solid])})}}),n("js/sim/behaviors/pulser",["require","exports","module","../joy","djinn/sim/shared/state"],function(e,t){var n=e("../joy"),r=e("djinn/sim/shared/state");t.entityCollide=function(e,t){if(r.exists(this,"cooldown"))return;r.add(this,"cooldown",1e3),n.addState(e,"cool",1e3),this.fire("pulse"),this.world.fire("pulse")}}),n("js/sim/behaviors/spawner",["require","exports","module","djinn/sim/shared/state","djinn/sim/systems/behavior"],function(e,t){var n=e("djinn/sim/shared/state"),r=e("djinn/sim/systems/behavior");t.entityCollide=function(e,t){if(e.type===this.type)return;if(e.type==="gameGoal")return;if(e.meta.role==="player")return;if(n.exists(this,"cooldown"))return;n.add(this,"cooldown",3e3),this.fire("warning"),r.pushState(this,"spawnerSpawn",{spawnType:e.type})}}),n("js/sim/behaviors/spawnerSpawn",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/state"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/state");t.enter=function(){r.add(this,"cooldown",1e3)},t.entityUpdate=function(){if(r.exists(this,"cooldown"))return;var e=n.getStateData(this,"spawnType"),t=this.spawn(e),i=this.world;i.triggerSystems("entityReset",[t]),this.spawn("puff"),this.spawn("smoke"),this.fire("spawn"),i.despawnEntity(this)}}),n("js/sim/behaviors/stompee",["require","exports","module","../stomp"],function(e,t){var n=e("../stomp");t.entityCollide=function(e,t){n.entityCollide(this,e,t)&&delete this.hazard}}),n("js/sim/behaviors/teleporter",["require","exports","module","djinn/math/core","djinn/sim/shared/position","djinn/sim/shared/state","../joy"],function(e,t){var n=e("djinn/math/core"),r=e("djinn/sim/shared/position"),i=e("djinn/sim/shared/state"),s=e("../joy"),o=function(){var e=this.id;return this.world.getEntities(function(t){return t.type==="teleporter"&&t.id!==e})};t.entityReset=function(){o.call(this).length<1&&this.fire("deactivate")},t.entityCollide=function(e,t){if(i.exists(this,"cooldown"))return;if(e.position.immovable)return;var u=o.call(this);if(u.length<1)return;s.addState(e,"ride",1e3),i.add(this,"cooldown",1e3);var a=r.getCenter(this);u.sort(function(e,t){var i=r.getCenter(e),s=r.getCenter(t);return n.distance(a.x,a.y,i.x,i.y)>n.distance(a.x,a.y,s.x,s.y)});var f=u[0];r.centerOnEntity(e,f),i.add(f,"cooldown",1e3),this.fire("teleport"),f.fire("teleport"),e.fire("teleported")}}),n("js/sim/behaviors/torch",["require","exports","module"],function(e,t){t.entitySpawn=function(){var e=this.light;this.world.on("pulse",this,function(){e.intensity=e.intensity?0:1,this.fire("lightChange",[e.intensity])})}}),n("js/sim/behaviors/trap",["require","exports","module","djinn/sim/systems/behavior","djinn/sim/shared/position"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("djinn/sim/shared/position");t.entityReset=function(){var e=this.world,t=e.map,i=r.getTile(this,t),s=t.getTilesByRect(i.x,i.y),o=[];n.getStateData(this,"horizontal")&&(o.push({x:-1,y:0}),o.push({x:1,y:0})),n.getStateData(this,"vertical")&&(o.push({x:0,y:-1}),o.push({x:0,y:1}));var u=[];for(var a=0,f=o.length;a<f;++a){var l=o[a];t.get(i.x+l.x,i.y+l.y)===0&&u.push(l)}if(u.length>0){u.sort(function(e,t){return Math.abs(e.y)<Math.abs(t.y)});var c=u[0],h=.075;this.velocity.x=c.x*h,this.velocity.y=c.y*h}}}),n("js/sim/behaviors/turret",["require","exports","module","djinn/math/core","djinn/sim/shared/position","djinn/sim/shared/state","djinn/sim/systems/behavior"],function(e,t){var n=e("djinn/math/core"),r=e("djinn/sim/shared/position"),i=e("djinn/sim/shared/state"),s=e("djinn/sim/systems/behavior");t.entityUpdate=function(){if(i.exists(this,"cooldown"))return;var e=s.getStateData(this,"horizontal"),t=s.getStateData(this,"vertical"),o=this.world,u=this,a=o.getEntities(function(n){if(u.id===n.id)return;var i=s.getStateData(u,"targetGroup");if(!n.collision||n.collision.group!==i)return;var o=s.getStateData(u,"range");if(r.getDistance(u,n)>o)return;var a=s.getStateData(u,"axisThreshold"),f=r.getCenter(u),l=r.getCenter(n),c=f.x-l.x,h=f.y-l.y;return t&&Math.abs(c)<=a||e&&Math.abs(h)<=a});if(a.length<1)return;var f=a[0],l=r.getAimVector(this,f);l.snap(Math.PI/2);if(!n.approximately(l.x,0)&&!e)return;if(!n.approximately(l.y,0)&&!t)return;this.facing.angle=l.x;var c=s.getStateData(this,"spawnType"),h=r.getTile(this,o.map),p=o.getEntities(function(e){if(e.light&&e.light.intensity>0){var t=r.getTile(e,o.map);h.x===t.x&&h.y+1===t.y&&(c="shellLights")}}),d=this.size,v=this.spawn(c);v.position.x+=l.x*d.width,v.position.y+=l.y*d.height;var m=this.spawn("smoke");m.position.x+=l.x*m.size.width/2,m.position.y+=l.y*m.size.height/2,m.velocity.x=l.x*.01;var g=this.spawn("flash");g.position.x+=l.x*g.size.width/2,g.position.y+=l.y*g.size.height/2;var y=s.getStateData(this,"offsetX");y&&(v.position.x+=y);var b=s.getStateData(this,"offsetY");b&&(v.position.y+=b);var w=s.getStateData(this,"speed");v.facing.angle=l.heading,v.velocity.x=l.x*w,v.velocity.y=l.y*w,i.add(this,"cooldown",s.getStateData(this,"cooldown")),this.fire("attack")}}),n("js/sim/behaviors/vPlatform",["require","exports","module","djinn/math/core","djinn/sim/shared/state","../joy"],function(e,t){var n=e("djinn/math/core"),r=e("djinn/sim/shared/state"),i=e("../joy"),s=.05;t.entityReset=function(){this.velocity.y=-s},t.entityCollide=function(e){if(e.meta.role!=="player")return;i.addState(e,"ride",1e3)},t.entityUpdate=function(e){if(r.exists(this,"cooldown"))return;r.add(this,"cooldown",100);var t=this.velocity,i=n.sign(t.y),s=this.world,o=s.map,u=this.position,a=u.y+(i>0?14:0),f={x:Math.floor(u.x/o.tileWidth),y:Math.floor(a/o.tileHeight)+i},l=!1;if(i<0&&u.y<16||i>0&&u.y>s.height-16)l=!0;else if(o.get(f.x,f.y)>0)l=!0;else{var c=s.getEntitiesByTile(f.x,f.y);for(var h=0,p=c.length;h<p;++h){var d=c[h];if(d.collision&&d.collision.solid&&d.position.immovable||d.physics&&d.physics.massY>this.physics.massY){l=!0;break}}}if(l){var v=this.bounce;t.y=-t.y*v.y}}}),n("js/sim/behaviors/walker",["require","exports","module","djinn/sim/systems/behavior","../stomp","../../gravity"],function(e,t){var n=e("djinn/sim/systems/behavior"),r=e("../stomp"),i=e("../../gravity");t.entitySpawn=function(){this.velocity.x=n.getStateData(this,"speed")},t.entityCollide=function(e,t){r.entityCollide(this,e,t)},t.entityUpdate=function(){this.velocity.x<0?this.facing.angle=-Math.PI/2:this.facing.angle=Math.PI/2},t.entityDie=function(){this.gravity=i,delete this.behavior}}),n("js/sim/behaviors/index",["require","exports","module","./boss","./bossAttack","./bossMove","./chase","./collect","./collideEvent","./digger","./flash","./fragileRock","./funWatcher","./gameGoal","./gravityRock","./hPlatform","./intervalRock","./intervalSpawner","./jumper","./jumperWarning","./launcher","./lightSwitch","./oob","./pickup","./pulseBlock","./pulser","./spawner","./spawnerSpawn","./stompee","./teleporter","./torch","./trap","./turret","./vPlatform","./walker"],function(e,t){t.boss=e("./boss"),t.bossAttack=e("./bossAttack"),t.bossMove=e("./bossMove"),t.chase=e("./chase"),t.collect=e("./collect"),t.collideEvent=e("./collideEvent"),t.digger=e("./digger"),t.flash=e("./flash"),t.fragileRock=e("./fragileRock"),t.funWatcher=e("./funWatcher"),t.gameGoal=e("./gameGoal"),t.gravityRock=e("./gravityRock"),t.hPlatform=e("./hPlatform"),t.intervalRock=e("./intervalRock"),t.intervalSpawner=e("./intervalSpawner"),t.jumper=e("./jumper"),t.jumperWarning=e("./jumperWarning"),t.launcher=e("./launcher"),t.lightSwitch=e("./lightSwitch"),t.oob=e("./oob"),t.pickup=e("./pickup"),t.pulseBlock=e("./pulseBlock"),t.pulser=e("./pulser"),t.spawner=e("./spawner"),t.spawnerSpawn=e("./spawnerSpawn"),t.stompee=e("./stompee"),t.teleporter=e("./teleporter"),t.torch=e("./torch"),t.trap=e("./trap"),t.turret=e("./turret"),t.vPlatform=e("./vPlatform"),t.walker=e("./walker")}),n("js/sim/actions",["require","exports","module","djinn/math/Vector2","djinn/math/core","djinn/sim/shared/position","djinn/sim/shared/state"],function(e,t,n){var r=e("djinn/math/Vector2"),i=e("djinn/math/core"),s=e("djinn/sim/shared/position"),o=e("djinn/sim/shared/state");t.jump=function(e){return e.jump.request=!0,!0},t.shooter=function(e){if(o.exists(e,"cooldown"))return!1;o.add(e,"cooldown",200);var t=this.createEntity("buster"),n=e.facing.angle,u=r.makeFromHeading(n);return i.approximately(u.x,0)&&(u.x=-1),t.facing.angle=n,s.centerOnEntity(t,e),t.position.x+=u.x*e.size.width,t.velocity.x=u.x*.3,e.position.x-=u.x*2,t.owner=e,this.spawnEntity(t),!0}}),n("js/sim/Level",["require","exports","module","djinn/sim/World","djinn/sim/shared/position","djinn/sim/systems/state","djinn/sim/systems/physics","djinn/sim/systems/collision","djinn/sim/systems/control","djinn/sim/systems/jump","djinn/sim/systems/hazard","djinn/sim/systems/mortal","djinn/sim/systems/behavior","djinn/sim/states/common","djinn/sim/states/effects","./prefabs/index","./behaviors/index","../gameData","./actions"],function(e,t,n){var r=e("djinn/sim/World"),i=e("djinn/sim/shared/position"),s=e("djinn/sim/systems/state"),o=e("djinn/sim/systems/physics"),u=e("djinn/sim/systems/collision"),a=e("djinn/sim/systems/control"),f=e("djinn/sim/systems/jump"),l=e("djinn/sim/systems/hazard"),c=e("djinn/sim/systems/mortal"),h=e("djinn/sim/systems/behavior"),p=e("djinn/sim/states/common"),d=e("djinn/sim/states/effects"),v=e("./prefabs/index"),m=e("./behaviors/index"),g=e("../gameData"),y=e("./actions");u.penetrationThreshold=.85,f.fallThreshold=.125,n.exports=r.extend({init:function(e){this._super(e),this.width=256,this.height=144,this.addSystem(s),this.addSystem(o),this.addSystem(u),this.addSystem(a),this.addSystem(f),this.addSystem(h),this.addSystem(l),this.addSystem(c),this.definePrefabs(v),s.define(p),s.define(d),h.define(m),u.defineGroupTargets("players",["objects"]),u.defineGroupTargets("objects",["players","objects"]),u.defineWalkableTile(0)},addEntityAtTile:function(e,t,n){var r=this.createEntity(e),s=this.map,o=r.meta;if(o&&o.center)i.centerOnTile(r,s,t,n);else if(o&&o.top){var u=r.size;r.position.x=t*s.tileWidth+s.tileWidth/2-u.width/2,r.position.y=n*s.tileHeight}else{var u=r.size;r.position.x=t*s.tileWidth+s.tileWidth/2-u.width/2,r.position.y=n*s.tileHeight+s.tileHeight-u.height}return this.spawnEntity(r),r},loadMap:function(e,t,n,r){var s=this.map;s.tileWidth=16,s.tileHeight=16;var o=e.tiles,u=o[0].length,a=o.length;this.width=u*s.tileWidth,this.height=a*s.tileHeight;var f=[];for(var l=0;l<a;++l){f[l]=[];for(var c=0;c<u;++c)f[l][c]=o[l][c]}if(g.enableFinalBoss)for(var l=0;l<a;++l)f[l].reverse();s.resize(u,a),s.fill(e.floorIndex||0);for(var l=0;l<a;++l)for(var c=0;c<u;++c){var h=f[l][c];if(isNaN(h)){r&&h==="boss"&&c<u-1&&l<a-1&&f[l][c+1]==="boss"&&f[l+1][c]==="boss"&&f[l+1][c+1]==="boss"&&(h="boss2x2",f[l][c+1]=0,f[l+1][c]=0,f[l+1][c+1]=0);var p=this.addEntityAtTile(h,c,l);if(h==="gameStart"){var d=i.getTile(p,s);t=d.x,n=d.y}}else s.set(c,l,h)}if(g.playtest||!g.editing){var v=e.playerPrefab;g.enableFinalBoss&&(v="playerDoubt"),this.player=this.addEntityAtTile(v,t,n),this.setCameraTarget(this.player)}return this.on("jump",this,"_onJump"),e},playerAction:function(){var e=this.player;if(!e.meta.action)return!1;if(!e.mortal.alive)return!1;if(y[e.meta.action]){var t=y[e.meta.action].call(this,e);return t&&e.fire("action"),t}},_onJump:function(e){e.spawn("puff")}})}),n("js/view/TyperBadge",["require","exports","module","./Typer"],function(e,t,n){var r=e("./Typer"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.createTimer(1e3,"_onPulse").start(),this._onPulse()},_onPulse:function(){this.completeTween().tween({opacity:.5},500).tween({opacity:1},500)}});t.defaults={color:"gold"}}),n("js/view/GameListItem",["require","exports","module","djinn/view/View","./Screenshot","./Typer","./TyperBadge","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Screenshot"),s=e("./Typer"),o=e("./TyperBadge"),u=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},setGame:function(e){this.disposeChildren(),this.developer=e.developer;var t=new i({parent:this,acceptInputEvents:!0,y:4,width:16,height:9});t.on("inputStart",this,"_onSelectGame"),t.setGame(e),this._name=(new s({parent:this,text:e.name,acceptInputEvents:!0,x:24,y:0})).on("inputStart",this,"_onSelectGame"),this._details=(new s({parent:this,text:"by "+e.developer,color:"silver",acceptInputEvents:!0,captureInputEvents:!0,x:24,y:8})).on("inputStart",this,"_onSelectDetails")},addDeleteButton:function(){this._deleteButton&&this._deleteButton.dispose();var e=this._deleteButton=new s({parent:this,text:"X",color:"white",acceptInputEvents:!0,cancelInputEvents:!0,captureInputEvents:!0});e.shrinkwrap(),e.align("right","top"),e.on("inputStart",this,"_onDeleteGame")},addLabel:function(e,t){this._details.text=e,t&&(this._details.color=t)},setNameColor:function(e){this._name.color=e},markAsUnplayed:function(){var e=this._name,t=new o({parent:this,text:"NEW!",x:e.x,y:e.y});e.x+=40},_onSelectGame:function(){this.fire("selectGame",[this.gameIndex])},_onSelectDetails:function(){this.fire("selectDetails",[this.gameIndex,this.developer])},_onDeleteGame:function(){this.fire("deleteGame",[this.gameIndex])}});t.defaults={acceptInputEvents:!0,height:16,width:224}}),n("js/view/Menu",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/utils/string","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/utils/string"),o=e("./Typer"),u=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults)),(new r({parent:this,backgroundColor:u.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center");var n=new o({parent:this,text:"PAUSED",color:"silver",anchorX:.5,imageSmoothingEnabled:!1,scale:2});n.shrinkwrap(),n.align("center","top",0,8);var i=new o({parent:this,text:"Continue",acceptInputEvents:!0,color:"green"});i.shrinkwrap(),i.align("left","bottom",16,-8),i.on("inputPress",this,"_onClose");var s=new o({parent:this,text:"Quit",acceptInputEvents:!0,color:"red"});s.shrinkwrap(),s.align("right","bottom",-16,-8),s.on("inputPress",this,"_onQuit")},reset:function(){},_onQuit:function(){this.fire("quit")},_onClose:function(){this.fire("close")}}),t.defaults={acceptInputEvents:!0,backgroundColor:u.getColor("white"),width:192,height:64}}),n("js/view/Color",["require","exports","module","djinn/view/View","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=this.width-2,i=this.height-2,s=this._background=(new r({parent:this,width:n,height:i})).align("center","center")},setColor:function(e){this._background.backgroundColor=i.fromRGBArray(e)}});t.defaults={acceptInputEvents:!0,backgroundColor:i.getColor("white")}}),n("djinn/utils/Factory",["require","exports","module","../Class"],function(e,t,n){var r=e("../Class");n.exports=r.extend({init:function(e,t){this._fallback=e,this._extensions=t},create:function(e,t){var n=this._extensions,t=merge(t,{type:e});return e in n?n[e].create(t):this._fallback.create(t)}})}),n("js/view/avatars/Default",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),i=16,s={bossBlock:{image:"media/images/objects.png",imageX:96,imageY:112},cannon:{image:"media/images/objects.png",imageX:0,imageY:48},shell:{image:"media/images/objects.png",imageX:1*i,imageY:3*i},shellLights:{image:"media/images/objects.png",imageX:1*i,imageY:4*i},gameKey:{image:"media/images/objects.png",imageX:3*i,imageY:5*i},hPlatform:{image:"media/images/objects.png",imageX:6*i,imageY:3*i},spikes:{image:"media/images/objects.png",imageX:5*i,imageY:0*i},pushBlock:{image:"media/images/objects.png",imageX:7*i,imageY:4*i},actionPickup:{image:"media/images/objects.png",imageX:1*i,imageY:1*i},gameStart:{image:"media/images/objects.png",imageX:5*i,imageY:3*i},computer:{image:"media/images/objects.png",imageX:7*i,imageY:1*i},bed:{image:"media/images/objects.png",imageX:3*i,imageY:1*i},axe:{image:"media/images/objects.png",imageX:2*i,imageY:1*i},mom:{image:"media/images/actors.png",imageX:1*i,imageY:10*i},grass:{image:"media/images/objects.png",imageX:6*i,imageY:2*i},home:{image:"media/images/objects.png",imageX:2*i,imageY:2*i},doug:{image:"media/images/actors.png",imageX:0*i,imageY:10*i},hTrap:{image:"media/images/objects.png",imageX:4*i,imageY:1*i},vTrap:{image:"media/images/objects.png",imageX:3*i,imageY:1*i},trashCan:{image:"media/images/objects.png",imageX:3*i,imageY:2*i},pressurePlate:{image:"media/images/objects.png",imageX:4*i,imageY:2*i}},t=n.exports=r.extend({init:function(e){var e=merge(e,s[e.type],t.defaults);this._super(e)}});t.defaults={width:i,height:i}}),n("js/view/avatars/Banner",["require","exports","module","../Typer"],function(e,t,n){var r=e("../Typer"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},setText:function(e){this.text=e,this.shrinkwrap(),this.align("center","center")},setColor:function(e){this.color=e}});t.defaults={width:16,height:16}}),n("js/view/avatars/Boss",["require","exports","module","djinn/view/Sprite","djinn/view/View"],function(e,t,n){var r=e("djinn/view/Sprite"),i=e("djinn/view/View"),s=64,o=48,t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},attach:function(e){e.type==="boss2x2"&&(this.imageSmoothingEnabled=!1,this.scale=2),this.playAnimation("idle")},attack:function(){this.stopAnimation(),this.imageX=96,this.delayTween(500,bind(this,function(){this.playAnimation("idle")}))},select:function(){this.completeTween({imageX:96}).delayTween(250,bind(this,function(){this.imageX=s}))},showDamage:function(){this.completeTween(),this.stopAnimation(),this.imageX=112}});t.defaults={animations:{idle:{frameRate:2,frames:[[s,o],[s+16,o]]}},image:"media/images/actors.png",imageX:s,imageY:o,width:16,height:16}}),n("js/view/avatars/Bouncer",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},launch:function(){this.completeTween({imageY:64}).delayTween(250,bind(this,function(){this.imageY=t.defaults.imageY}))}});t.defaults={image:"media/images/objects.png",imageX:48,imageY:48,width:16,height:16}}),n("js/view/avatars/Buster",["require","exports","module","djinn/view/Sprite"],function(e,t,n){var r=e("djinn/view/Sprite"),i=64,s=72,t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},attach:function(){this.playAnimation("blink")}});t.defaults={image:"media/images/actors.png",animations:{blink:{frameRate:24,frames:[[i,s],[i+8,s]]}},imageX:i,imageY:s,width:8,height:8}}),n("js/view/avatars/Explosion",["require","exports","module","djinn/view/shapes/Circle","djinn/math/random","../style"],function(e,t,n){var r=e("djinn/view/shapes/Circle"),i=e("djinn/math/random"),s=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.radius=i.range(12,18)},attach:function(){(new r({parent:this,fillColor:s.getColor("white"),radius:i.range(this.radius/2,this.radius/2+4)})).align("center","center")}});t.defaults={fillColor:s.getColor("yellow")}}),n("js/view/avatars/FragileRock",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),i=[-1,0,1,0],t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this._warnTimer=this.createTimer(25,"_onWarnTimer")},warn:function(e){this._index=0,this._xStart=this.x,this.imageX+=16,this._warnTimer.start(),this._onWarnTimer()},_onWarnTimer:function(){var e=i[this._index];this.x=this._xStart+e,this._index++,this._index>=i.length&&(this._index=0)}});t.defaults={image:"media/images/objects.png",imageX:16,imageY:32,width:16,height:16}}),n("js/view/avatars/FragileRockCorpse",["require","exports","module","djinn/view/View","djinn/math/random"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},attach:function(){var e=32,t=32,n=(new r({parent:this,image:"media/images/objects.png",imageX:e,imageY:t,width:9,height:9})).tween({x:i.range(-10,-2),y:i.range(16,24)},500),s=(new r({parent:this,image:"media/images/objects.png",imageX:e+8,imageY:t,x:8,width:8,height:9})).tween({x:i.range(12,18),y:i.range(16,24)},500),o=(new r({parent:this,image:"media/images/objects.png",imageX:e,imageY:t+8,y:8,width:8,height:8})).tween({x:i.range(-10,-2),y:i.range(24,32)},500),u=(new r({parent:this,image:"media/images/objects.png",imageX:e+7,imageY:t+8,x:8,y:8,width:9,height:8})).tween({x:i.range(12,18),y:i.range(24,32)},500)}});t.defaults={width:16,height:16}}),n("js/view/avatars/GameGoal",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},activate:function(){this.imageY=48},deactivate:function(){this.imageY=80},goal:function(){this.imageY=64}});t.defaults={image:"media/images/objects.png",imageX:64,imageY:48,width:16,height:16}}),n("js/view/avatars/Glitter",["require","exports","module","djinn/view/View","djinn/math/random"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=[[0,0],[1,0],[0,1],[1,1]],t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},attach:function(){var e=80,t=16;for(var n=0;n<5;++n){var o=i.choice(s),u=new r({parent:this,image:"media/images/ui.png",imageX:o[0]*8+e,imageY:o[1]*8+t,x:i.range(0,16),y:i.range(0,16),width:8,height:8});u.tween({y:u.y-8},1e3)}}});t.defaults={width:16,height:16}}),n("js/view/avatars/GravityRock",["require","exports","module","djinn/view/View","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.overlay=new r(merge({parent:this,opacity:0,overlayColor:i.getColor("white")},t.defaults))},changeGravity:function(){this.overlay.completeTween({opacity:1}).tween({opacity:0},1e3)}});t.defaults={image:"media/images/objects.png",imageX:96,imageY:16,width:16,height:16}}),n("js/view/avatars/IntervalRock",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},toggle:function(e){this.imageX=(e?6:7)*16}});t.defaults={image:"media/images/objects.png",imageX:96,imageY:32,width:16,height:16}}),n("js/view/avatars/Jumper",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},attach:function(){this.imageX=80},warning:function(e){this.imageX=80,this.flipX=e},jump:function(){this.imageX=96},land:function(){this.imageX=64},select:function(){this.completeTween({imageX:96}).delayTween(250,bind(this,function(){this.imageX=80}))},showDamage:function(){this.imageX=112},showGrid:function(){this.imageX=80}});t.defaults={image:"media/images/actors.png",imageX:64,imageY:16,width:16,height:16}}),n("js/view/avatars/LightSwitch",["require","exports","module","djinn/view/View","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.overlay=new r(merge({parent:this,opacity:0,overlayColor:i.getColor("white")},t.defaults))},pulse:function(){this.overlay.completeTween({opacity:1}).tween({opacity:0},1e3)}});t.defaults={image:"media/images/objects.png",imageX:0,imageY:64,width:16,height:16}}),n("js/view/avatars/Player",["require","exports","module","djinn/view/Sprite"],function(e,t,n){var r=e("djinn/view/Sprite"),i={playerBoy:{x:0,y:0},playerGirl:{x:0,y:1},playerDoubt:{x:4,y:0},playerDog:{x:0,y:3},playerXam:{x:0,y:4},playerGoblin:{x:0,y:5},playerFranklin:{x:0,y:6},playerJoey:{x:0,y:7},playerBenzer:{x:4,y:7},playerBird:{x:0,y:8},playerChicken:{x:4,y:8},chicken:{x:4,y:8},playerLars:{x:0,y:9},playerLuna:{x:4,y:9},playerZombie:{x:0,y:10},playerRaga:{x:4,y:10},playerTiger:{x:0,y:11},playerWizard:{x:4,y:11},pirate:{x:4,y:12},playerJanitor:{x:0,y:12},playerMother:{x:0,y:13},playerFather:{x:4,y:13},squid:{x:8,y:0}},t=n.exports=r.extend({init:function(e){var n=i[e.type],r=e.imageX=n.x*16,s=e.imageY=n.y*16;e.animations={walk:{frameRate:3,frames:[[r,s],[r+16,s]]},celebrate:{frameRate:3,frames:[[r+32,s],[r,s],[r+32,s],[r+16,s]]},idle:{frames:[[r,s]],loop:!1},death:{frames:[[r+48,s]],loop:!1}};var e=merge(e,t.defaults);this._super(e)},attach:function(){this.playAnimation("walk")},select:function(){this.playAnimation("celebrate"),this.completeTween().delayTween(250,bind(this,function(){this.playAnimation("idle")}))},showDamage:function(){this.playAnimation("death")}});t.defaults={image:"media/images/actors.png",width:16,height:16}}),n("djinn/view/shapes/Star",["require","exports","module","../View","../utils/canvas"],function(e,t,n){var r=e("../View"),i=e("../utils/canvas"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.points=e.points,this.radius=e.radius,this.offset=e.offset,this.fillColor=e.fillColor,this.strokeColor=e.strokeColor,this.strokeWidth=e.strokeWidth},render:function(e){var t=this.width/2,n=this.height/2,r=[],s=Math.PI/this.points;for(var o=0,u=this.points*2;o<u;++o){var a=s*(this.offset+o),f=Math.sin(a),l=-Math.cos(a),c=o%2===0?1:this.radius;r.push(t+f*c*t),r.push(n+l*c*n)}i.drawPolygon(e,r,this.fillColor,this.strokeColor,this.strokeWidth)}});t.defaults={buffer:!0,bufferPadding:10,width:100,height:100,points:5,radius:.5,offset:0,fillColor:"white",strokeColor:null,strokeWidth:1}}),n("js/view/avatars/Puff",["require","exports","module","djinn/view/shapes/Star","djinn/math/random","../style"],function(e,t,n){var r=e("djinn/view/shapes/Star"),i=e("djinn/math/random"),s=e("../style"),o=0,t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.flipY=o=!o}});t.defaults={fillColor:s.getColor("yellow"),radius:4,width:6,height:6}}),n("js/view/avatars/PulseBlock",["require","exports","module","djinn/view/View","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.clone=new r(merge({parent:this,opacity:0},t.defaults))},toggle:function(e){this.imageX=(e?6:7)*16,e?this.clone.completeTween({opacity:1,overlayColor:i.getColor("white"),scale:1}).tween({opacity:0},500):this.clone.completeTween({opacity:1,overlayColor:null,scale:1}).tween({opacity:0,scale:0},100)}});t.defaults={image:"media/images/objects.png",imageX:96,imageY:96,width:16,height:16}}),n("js/view/avatars/PulseButton",["require","exports","module","djinn/view/View","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.overlay=new r(merge({parent:this,opacity:0,overlayColor:i.getColor("white")},t.defaults))},pulse:function(){this.overlay.completeTween({opacity:1}).tween({opacity:0},1e3)}});t.defaults={image:"media/images/objects.png",imageX:32,imageY:96,width:16,height:16}}),n("js/view/avatars/Smoke",["require","exports","module","djinn/view/shapes/Circle","../style"],function(e,t,n){var r=e("djinn/view/shapes/Circle"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)}});t.defaults={compositeOperation:"overlay",fillColor:i.getColor("black"),radius:8}}),n("js/view/avatars/Spawner",["require","exports","module","djinn/view/View","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.overlay=new r(merge({parent:this,imageX:16,opacity:0,overlayColor:i.getColor("white")},t.defaults))},spawn:function(){this.imageX=16,this.overlay.completeTween({opacity:1}).tween({opacity:0},1e3)}});t.defaults={image:"media/images/objects.png",imageX:0,imageY:16,width:16,height:16}}),n("js/view/avatars/Survey",["require","exports","module","djinn/view/View","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},setJoy:function(e){this.completeTween({opacity:0,imageY:16*(e+1),scale:1.75}).tween({opacity:1,scale:1},250)}});t.defaults={image:"media/images/ui.png",imageX:112,width:16,height:16}}),n("js/view/avatars/Teleporter",["require","exports","module","djinn/view/View","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.overlay=new r(merge({parent:this,opacity:0,overlayColor:i.getColor("white")},t.defaults))},deactivate:function(){this.imageX=64},teleport:function(){this.overlay.completeTween({opacity:1}).tween({opacity:0},1e3)}});t.defaults={image:"media/images/objects.png",imageX:48,imageY:96,width:16,height:16}}),n("js/view/avatars/Torch",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},lightChange:function(e){this.imageX=(e?3:4)*16}});t.defaults={image:"media/images/objects.png",imageX:48,imageY:112,width:16,height:16}}),n("js/view/avatars/VPlatform",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},up:function(){this.imageY=96},down:function(){this.imageY=112}});t.defaults={image:"media/images/objects.png",imageX:80,imageY:96,width:16,height:16}}),n("js/view/avatarFactory",["require","exports","module","djinn/utils/Factory","./avatars/Default","./avatars/Banner","./avatars/Boss","./avatars/Bouncer","./avatars/Buster","./avatars/Explosion","./avatars/FragileRock","./avatars/FragileRockCorpse","./avatars/GameGoal","./avatars/Glitter","./avatars/GravityRock","./avatars/IntervalRock","./avatars/Jumper","./avatars/LightSwitch","./avatars/Player","./avatars/Puff","./avatars/PulseBlock","./avatars/PulseButton","./avatars/Smoke","./avatars/Spawner","./avatars/Survey","./avatars/Teleporter","./avatars/Torch","./avatars/VPlatform"],function(e,t,n){var r=e("djinn/utils/Factory"),i=e("./avatars/Default"),s=e("./avatars/Banner"),o=e("./avatars/Boss"),u=e("./avatars/Bouncer"),a=e("./avatars/Buster"),f=e("./avatars/Explosion"),l=e("./avatars/FragileRock"),c=e("./avatars/FragileRockCorpse"),h=e("./avatars/GameGoal"),p=e("./avatars/Glitter"),d=e("./avatars/GravityRock"),v=e("./avatars/IntervalRock"),m=e("./avatars/Jumper"),g=e("./avatars/LightSwitch"),y=e("./avatars/Player"),b=e("./avatars/Puff"),w=e("./avatars/PulseBlock"),E=e("./avatars/PulseButton"),S=e("./avatars/Smoke"),x=e("./avatars/Spawner"),T=e("./avatars/Survey"),N=e("./avatars/Teleporter"),C=e("./avatars/Torch"),k=e("./avatars/VPlatform");n.exports=new r(i,{playerBenzer:y,playerBird:y,playerBoy:y,playerChicken:y,playerDog:y,playerDoubt:y,playerFather:y,playerFranklin:y,playerGirl:y,playerGoblin:y,playerJanitor:y,playerJoey:y,playerLars:y,playerLuna:y,playerMother:y,playerRaga:y,playerTiger:y,playerWizard:y,playerXam:y,playerZombie:y,chicken:y,squid:y,banner:s,boss:o,boss2x2:o,bouncer:u,buster:a,explosion:f,fragileRock:l,fragileRockCorpse:c,gameGoal:h,glitter:p,gravityRock:d,intervalRock:v,jumper:m,lightSwitch:g,pirate:y,puff:b,pulseBlock:w,pulseButton:E,smoke:S,spawner:x,survey:T,teleporter:N,torch:C,vPlatform:k})}),n("js/view/GameSettings",["require","exports","module","djinn/view/View","./Typer","./Slider","./Color","./style","./avatarFactory","../gameData","../templates"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Typer"),s=e("./Slider"),o=e("./Color"),u=e("./style"),a=e("./avatarFactory"),f=e("../gameData"),l=e("../templates");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults));var n=(new r({parent:this,acceptInputEvents:!0,backgroundColor:u.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center"),a=(new i({parent:n,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-4,4);a.on("inputPress",this,"_onClose");var f=this._header=new i({parent:n,text:"Options",color:"gray",anchorX:.5});f.shrinkwrap(),f.align("center","top",0,4);var l=(new i({parent:this,text:"Name",color:"silver",x:8,y:20})).shrinkwrap();this._name=(new i({parent:this,acceptInputEvents:!0,x:l.right+8,y:l.y})).on("inputStart",this,"_onName");var c=this._playerBox=new r({parent:this,acceptInputEvents:!0,cancelInputEvents:!0,width:48,height:32});c.align("right",null,-16),c.y=l.y,c.on("inputStart",this,"_onPlayerBox"),this._playerBoxText=(new i({parent:c,text:"Change",color:"gray"})).shrinkwrap().align("center","bottom",0,-4),this._darknessHeader=new i({parent:n,text:"Lights",x:8,y:l.bottom+8});var h=this._darknessSlider=new s({parent:n,x:64,y:this._darknessHeader.y,width:64,height:8});h.on("change",this,"_onDarknessChange"),this._colorHeader=new i({parent:n,text:"Background",x:8,y:this._darknessHeader.bottom+8}),this._color=(new o({parent:n,x:96,y:this._colorHeader.y,width:8,height:8})).on("inputStart",this,"_onOpenColorPicker");var p=this._sizeHeader=(new i({parent:this,text:"Size",x:8,y:this._colorHeader.bottom+8})).shrinkwrap();this._small=(new i({parent:this,text:"(S)",acceptInputEvents:!0,x:p.right+8,y:p.y})).shrinkwrap().on("inputStart",this,"_onSize"),this._small.size="small",this._medium=(new i({parent:this,text:"(M)",acceptInputEvents:!0,x:this._small.right+8,y:p.y})).shrinkwrap().on("inputStart",this,"_onSize"),this._medium.size="medium",this._large=(new i({parent:this,text:"(L)",acceptInputEvents:!0,x:this._medium.right+8,y:p.y})).shrinkwrap().on("inputStart",this,"_onSize"),this._large.size="large";var d=this._create=new i({parent:n,text:"Create",acceptInputEvents:!0,y:p.bottom+8});d.shrinkwrap(),d.align("center"),d.on("inputStart",this,"_onCreate"),this._tweet=new i({parent:n,text:"Tweet a screenshot",acceptInputEvents:!0,color:"blue",x:8,y:104})},reset:function(e,t){if(e)var n=this.game={name:t.name,developer:f.data.developer,player:!0,playerPrefab:t.playerPrefab,backgroundColor:[89,125,206],clicks:null,darkness:0,price:null,rating:null,sales:null,time:null,views:null,tiles:l.getSmall()};else var n=this.game=f.getEditGame();this.updateGameName(n.name),this.updateGamePlayer(n.playerPrefab),f.getDeveloperFlag("backgroundColor")?(this._colorHeader.color="silver",this._color.visible=!0,this._color.setColor(n.backgroundColor)):(this._colorHeader.color="gray",this._color.visible=!1),f.getDeveloperFlag("darkness")?(this._darknessHeader.color="silver",this._darknessSlider.visible=!0,this._darknessSlider.value=n.darkness):(this._darknessHeader.color="gray",this._darknessSlider.visible=!1);var r=n.tiles.length,i=l.getKeyByHeight(r);this.updateSize(e,i),this._create.visible=e,this._tweet.visible=!e&&Boolean(window.nw)},updateGamePlayer:function(e){this._avatar&&this._avatar.dispose();var t=this._avatar=a.create(e,{parent:this._playerBox,flipX:!0});t.align("center"),t.attach()},updateGameName:function(e){this._name.text=e,e?this._create.color="white":this._create.color="gray"},updateBackgroundColor:function(e){this._color.setColor(e)},updateSize:function(e,t){e?(this._sizeHeader.color="silver",this._small.color="silver",this._medium.color=f.getDeveloperFlag("sizeMedium")?"silver":"gray",this._large.color=f.getDeveloperFlag("sizeLarge")?"silver":"gray",this["_"+t].color="white"):(this._sizeHeader.color="gray",this._small.color="gray",this._medium.color="gray",this._large.color="gray",this["_"+t].color="silver")},_onClose:function(){this.fire("close")},_onName:function(){this.fire("openName")},_onPlayerBox:function(){this.fire("openPlayer")},_onDarknessChange:function(e,t){this.fire("darkness",[e,t])},_onOpenColorPicker:function(){this.fire("openColorPicker")},_onSize:function(e){this.fire("size",[e.target.size])},_onCreate:function(){this.fire("save")}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:u.getColor("silver"),width:210,height:98}}),n("js/view/ColorPicker",["require","exports","module","djinn/view/View","djinn/utils/string","./Typer","./Slider","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/string"),s=e("./Typer"),o=e("./Slider"),u=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=(new r({parent:this,backgroundColor:u.getColor("black"),acceptInputEvents:!0,width:this.width-4,height:this.height-4})).align("center","center");(new s({parent:n,text:"Color Picker",color:"silver",y:2})).shrinkwrap().align("center");var a=(new s({parent:n,text:"X",acceptInputEvents:!0,color:"white"})).shrinkwrap().align("right","top",-2,2);a.on("inputPress",this,"_onClose");var f=["red","green","blue"],l=2;for(var c=0,h=f.length;c<h;++c){var p=f[c],d=i.ucfirst(p);new s({parent:n,text:d,color:p,x:8,y:l*8});var p=this["_"+p]=new o({parent:n,x:56,y:l*8+1,width:64,height:8});p.on("change",this,"_onChange"+d),l+=2}},setColor:function(e){this._rgb=e,this.backgroundColor=u.fromRGBArray(e),this._red.value=e[0]/255,this._green.value=e[1]/255,this._blue.value=e[2]/255},_setRGB:function(e,t,n){if(t===n)return;var r=this._rgb;r[e]=Math.round(t*255),this.setColor(r),this.fire("change",[r])},_onChangeRed:function(e,t){this._setRGB(0,e,t)},_onChangeGreen:function(e,t){this._setRGB(1,e,t)},_onChangeBlue:function(e,t){this._setRGB(2,e,t)},_onClose:function(){this.fire("close")}});t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,width:132,height:68}}),n("js/view/Confirmation",["require","exports","module","djinn/view/View","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Typer"),s=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=this.width-2,o=this.height-2,u=this._background=(new r({parent:this,acceptInputEvents:!0,backgroundColor:s.getColor("red"),width:n,height:o})).align("center","center"),a=this._header=new i({parent:u,color:"white",anchorX:.5});a.align("center","top",0,4);var f=this._confirmButton=new i({parent:u,text:"Yes",acceptInputEvents:!0,color:"white"});f.on("inputStart",this,"_onConfirm"),this.setConfirmButton("Yes");var l=new i({parent:u,text:"Cancel",acceptInputEvents:!0,color:"white"});l.shrinkwrap(),l.align("right","bottom",-8,-4),l.on("inputStart",this,"_onCancel")},setBackgroundColor:function(e){this._background.backgroundColor=s.getColor(e)},setHeader:function(e){this._header.text=e,this._header.shrinkwrap()},setContentConf:function(e){this._content&&this._content.dispose();if(!e)return;this._content=(new r(merge({parent:this._background,width:16,height:16},e))).align("center","center")},setContentText:function(e){this._content&&this._content.dispose();if(!e)return;this._content=(new i({parent:this._background,text:e,color:"white"})).shrinkwrap().align("center","center")},setConfirmButton:function(e){var t=this._confirmButton;t.text=e,t.shrinkwrap(),t.align("left","bottom",8,-4)},_onConfirm:function(){this.fire("confirm")},_onCancel:function(){this.fire("cancel")}});t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:s.getColor("white"),width:160,height:64}}),n("js/view/Tile",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults));var n=e.tile;if(n===0)return;var r=8,i=n%r,s=Math.floor(n/r);this.imageX=i*16,this.imageY=s*16}}),t.defaults={width:16,height:16}}),n("js/view/Grid",["require","exports","module","djinn/view/View","./Tile","./avatarFactory","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Tile"),s=e("./avatarFactory"),o=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults)),this.type=e.type,this.cursor=new r({parent:this,image:"media/images/ui.png",width:16,height:16,z:10})},reset:function(){for(var e in this.grid)this.grid[e].dispose();this.grid={}},setCursor:function(e){var t=this.cursor,n=this.grid,r=n[e];r?(t.centerOn(r),t.visible=!0):t.visible=!1;var n=this.grid;for(var i in n)r=n[i],i==e?(r.opacity=1,r.select&&r.select()):r.opacity=.4},setObjects:function(e){var t=0,n=0;for(var r=0,o=e.length;r<o;++r){var u=e[r];if(this.type==="entity")var a=s.create(u,{parent:this,x:t,y:n});else if(this.type==="tile")var a=new i({parent:this,image:"media/images/env.png",tile:u,x:t,y:n});a.acceptInputEvents=!0,a.key=u,a.on("inputPress",this,"_onAvatarPress"),a.showGrid&&a.showGrid(),this.grid[u]=a,t+=16,t+16>this.width&&(t=0,n+=16)}this.sortChildren()},_onAvatarPress:function(e){var t=e.target.key;this.setCursor(t),this.fire("select",[t])}}),t.defaults={acceptInputEvents:!0,backgroundColor:o.getColor("black")}}),n("js/view/PlayerPicker",["require","exports","module","djinn/view/View","../gameData","./Typer","./Grid","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../gameData"),s=e("./Typer"),o=e("./Grid"),u=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults));var n=(new r({parent:this,backgroundColor:u.getColor("black"),acceptInputEvents:!0,width:this.width-2,height:this.height-2})).align("center","center"),i=this._playerGrid=new o({parent:n,type:"entity",backgroundColor:null,width:48,height:48});i.align("center","center"),i.on("select",this,"_onPlayerGridSelect");var a=(new s({parent:n,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-1,1);a.on("inputPress",this,"_onClose")},reset:function(e){var t=this._playerGrid;t.reset();var n=i.getPlayerPrefabs();t.setObjects(n),t.setCursor(e)},_onPlayerGridSelect:function(e){this.fire("select",[e])},_onClose:function(){this.fire("close")}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:u.getColor("white"),width:68,height:68}}),n("js/view/scenes/DevScene",["require","exports","module","djinn/view/View","djinn/manifest","djinn/view/Sprite","djinn/audio/jukebox","djinn/input/keyboard","djinn/sim/shared/position","./Scene","../../sim/Level","../../gameData","../GameListItem","../Menu","../Dialog","../Typer","../TextBox","../GameSettings","../ColorPicker","../Scrollbar","../Confirmation","../PlayerPicker","../Titan","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/manifest"),s=e("djinn/view/Sprite"),o=e("djinn/audio/jukebox"),u=e("djinn/input/keyboard"),a=e("djinn/sim/shared/position"),f=e("./Scene"),l=e("../../sim/Level"),c=e("../../gameData"),h=e("../GameListItem"),p=e("../Menu"),d=e("../Dialog"),v=e("../Typer"),m=e("../TextBox"),g=e("../GameSettings"),y=e("../ColorPicker"),b=e("../Scrollbar"),w=e("../Confirmation"),E=e("../PlayerPicker"),S=e("../Titan"),x=e("../style"),t=n.exports=f.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this.addQuitX();var e=0;e+=8,new v({parent:this,text:"Djinn Game Editor",x:8,y:e}),e+=8,new v({parent:this,text:"--------------------------------",y:e}),e+=16;var t=this._newGameButton=new r({parent:this,acceptInputEvents:!0,image:"media/images/ui.png",imageY:48,x:8,y:e-6,width:54,height:14});t.on("inputStart",this,"_onNew"),this._newGameText=(new v({parent:t,text:"New",acceptInputEvents:!0})).shrinkwrap().align("center","center"),e+=16,this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:48,width:240,height:88}),this._container=new r({parent:this._window,acceptInputEvents:!0});var n=this._scrollbar=(new b({parent:this._window,barColor:x.getColor("qbBlue"),width:8})).align("right");n.attach(this._container);var i=this._gameSettings=(new g({parent:this})).align("center","center");i.on("close",this,"_onGameSettingsClose"),i.on("darkness",this,"_onGameSettingsDarkness"),i.on("openColorPicker",this,"_onOpenColorPicker"),i.on("openName",this,"_onOpenName"),i.on("openPlayer",this,"_onOpenPlayer"),i.on("size",this,"_onGameSettingsSize"),i.on("save",this,"_onGameSettingsSave");var s=this._gameName=(new m({parent:this,maxLength:12})).align("center","center");s.on("done",this,"_onGameNameDone"),s.on("close",this,"_onGameNameClose");var o=this._gamePlayer=(new E({parent:this})).align("center","center");o.on("select",this,"_onGamePlayerSelect"),o.on("close",this,"_onGamePlayerClose");var u=this._colorPicker=(new y({parent:this})).align("center","center");u.on("change",this,"_onColorChange"),u.on("close",this,"_onColorPickerClose");var a=this._confirmation=(new w({parent:this})).align("center","center");a.on("confirm",this,"_onConfirmDelete"),a.on("cancel",this,"_onConfirmCancel"),a.setHeader("Really delete?"),a.setConfirmButton("DELETE!"),this.sortChildren()},reset:function(){this._super(),this._titan&&this._titan.dispose(),this._titan=null,this._gameSettings.hide(),this._gameName.hide(),this._gamePlayer.hide(),this._colorPicker.hide(),this._confirmation.hide(),this._updateMakeNewGame();var e=this._container;e.disposeChildren();var t=c.getGamesByDeveloper(c.data.developer),n=0;for(var r=0,i=t.length;r<i;++r){var s=new h({parent:e,y:n});s.on("selectGame",this,"_onSelectGame");var o=t[r];s.setGame(o),o.published?s.addLabel("Published"):o.tested?c.getDeveloperFlag("market")?(s.on("selectDetails",this,"_onSelectDetails"),s.addLabel("Ready to publish","green")):s.addLabel("Tested","green"):s.addLabel("Untested","red"),s.addDeleteButton(),s.on("deleteGame",this,"_onDeleteGame"),s.gameIndex=o.gameIndex,n+=s.height+8}e.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&(this._confirmation.visible?this._onConfirmCancel():this._colorPicker.visible?this._onColorPickerClose():this._gameName.visible?this._onGameNameClose():this._gamePlayer.visible?this._onGamePlayerClose():this._gameSettings.visible?this._onGameSettingsClose():this._onQuit()),this._gameName.visible||(this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e))},_onNew:function(){var e=c.getDeveloperFlag("playerChicken"),t=c.getDeveloperFlag("playerGoblin"),n=c.getDeveloperFlag("playerXam");if(!e&&!t&&!n){this._startDoubt("hello");return}var r=c.getDeveloperFlag("playerZombie"),s=c.getDeveloperFlag("playerBenzer"),u=c.getDeveloperFlag("playerLars");if(c.getDeveloperFlag("sizeMedium")&&!r&&!s&&!u){this._startDoubt("medium");return}var a=c.getDeveloperFlag("playerFranklin"),f=c.getDeveloperFlag("playerTiger"),l=c.getDeveloperFlag("playerLuna");if(c.getDeveloperFlag("darkness")&&!a&&!f&&!l){i.demo?this._startDoubt("demo"):this._startDoubt("darkness");return}if(c.developerHasEditEntity("vPlatform")&&!c.getDeveloperFlag("indifference")){this._startDoubt("indifference");return}var h=c.getDeveloperFlag("playerMother"),p=c.getDeveloperFlag("playerFather");if(c.developerHasEditEntity("gameKey")&&!h&&!p){this._startDoubt("death");return}var d=c.getDeveloperFlag("playerJanitor"),v=c.getDeveloperFlag("playerWizard"),m=c.getDeveloperFlag("playerRaga");if(c.getDeveloperFlag("sizeLarge")&&!d&&!v&&!m){this._startDoubt("large");return}c.canMakeNewGame()?(o.play("open",0),this._name="",this._playerPrefab="playerDog",this._backgroundColor=[89,125,206],this._darkness=0,this._size="small",this._gameSettings.reset(!0,{name:this._name,playerPrefab:this._playerPrefab}),this._gameSettings.show(),this._gameName.reset(this._name),this._gameName.show()):o.play("negate",0)},_onDoubt:function(){this.captureInputEvents=!1,this.fireSceneEvent("doubt")},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")},_onGameSettingsClose:function(){o.play("close",0),this._gameSettings.hide(),this._gameName.hide()},_onGameSettingsDarkness:function(e,t){if(e>t)o.play("backspace1",0);else{if(!(e<t))return;o.play("type1",0)}this._darkness=e},_onOpenName:function(){o.play("open",0),this._gameName.reset(this._name),this._gameName.show()},_onOpenPlayer:function(){o.play("open",0),this._gamePlayer.reset(this._playerPrefab),this._gamePlayer.show()},_onOpenColorPicker:function(){o.play("open",0),this._colorPicker.setColor(this._backgroundColor),this._colorPicker.show()},_onGameSettingsSize:function(e){if(e==="medium"&&!c.getDeveloperFlag("sizeMedium")){o.play("negate",0);return}if(e==="large"&&!c.getDeveloperFlag("sizeLarge")){o.play("negate",0);return}o.play("select",0),this._size=e,this._gameSettings.updateSize(!0,e)},_onGameSettingsSave:function(){if(!this._name){o.play("negate",0);return}o.play("create",0);var e=c.data.developer,t=c.makeGame(e,{name:this._name,playerPrefab:this._playerPrefab,backgroundColor:this._backgroundColor,darkness:this._darkness},this._size);c.data.editGameIndex=t,this.captureInputEvents=!1,this.fireSceneEvent("edit")},_onGameNameDone:function(e){o.play("create",0),this._name=e,this._gameSettings.updateGameName(e),this._gameName.hide()},_onGameNameClose:function(){o.play("close",0),this._gameName.hide(),this._name===""&&this._gameSettings.hide()},_onGamePlayerSelect:function(e){o.play("select",0),this._playerPrefab=e,this._gameSettings.updateGamePlayer(e)},_onGamePlayerClose:function(){o.play("close",0),this._gamePlayer.hide()},_onColorChange:function(e){o.play("select",0),this._backgroundColor=e,this._gameSettings.updateBackgroundColor(e)},_onSelectGame:function(e){o.play("select",0),c.data.editGameIndex=e,this.captureInputEvents=!1,this.fireSceneEvent("edit")},_onSelectDetails:function(e,t){o.play("select",0),c.data.publishGameIndex=e,this.captureInputEvents=!1,this.fireSceneEvent("publishGame")},_onDeleteGame:function(e){o.play("negate",0),this._removeGameIndex=e,this._confirmation.show()},_onConfirmDelete:function(){o.play("remove",0),c.removeGame(this._removeGameIndex),this._confirmation.hide(),this.reset()},_onConfirmCancel:function(){o.play("close",0),this._confirmation.hide()},_onColorPickerClose:function(){o.play("close",0),this._colorPicker.hide()},_startDoubt:function(e){o.play("doubt1",0),c.setDeveloperFlag("doubtKey",e),this._titan?this._titan.advance():this._titan=(new S({parent:this})).on("done",this,"_onDoubt")},_updateMakeNewGame:function(){c.canMakeNewGame()?c.developerHasGameReadyToPublish()?(this._newGameButton.imageX=0,this._newGameButton.imageY=48,this._newGameText.color="white"):(this._newGameButton.imageX=0,this._newGameButton.imageY=62,this._newGameText.color="white"):(this._newGameButton.imageX=54,this._newGameButton.imageY=34,this._newGameText.color="black")}});t.defaults={backgroundColor:x.getColor("qbBlue"),musicKey:"holdPlease"}}),n("djinn/utils/Pattern",["require","exports","module","djinn/view/View","djinn/stage"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/stage"),t=n.exports=r.extend({init:function(e){this._super(e),this._bufferDirty=!0,this._width=this.width,this._height=this.height,this._tileView=new r(merge({parent:this},e.tileConf)),this._buffer=i.createBuffer(this.width,this.height)},render:function(e){this._bufferDirty&&this._renderBuffer(),e.drawImage(this._buffer,this.imageX,this.imageY,this.width,this.height,0,0,this.width,this.height)},_renderBuffer:function(){if(this.width!=this._buffer.width||this.height!=this._buffer.height)this._buffer.width=this.width,this._buffer.height=this.height;var e=this._tileView;if(!e._image||!e._image.ready)return;var t=this._buffer.getContext("2d"),n=Math.ceil(this._buffer.width/e.width),r=Math.ceil(this._buffer.height/e.height);for(var i=0;i<r;++i)for(var s=0;s<n;++s)t.drawImage(e._image,e.imageX,e.imageY,e.width,e.height,s*e.width,i*e.height,e.width,e.height);this._bufferDirty=!1}});Object.defineProperty(t.prototype,"width",{set:function(e){this._width=Number(e),this._bufferDirty=!0},get:function(){return this._width}}),Object.defineProperty(t.prototype,"height",{set:function(e){this._height=Number(e),this._bufferDirty=!0},get:function(){return this._height}})}),n("js/view/Field",["require","exports","module","djinn/view/View","djinn/utils/Pattern","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/Pattern"),s=e("./style"),t=n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults)),this.roll1=new i({parent:this,tileConf:{image:"media/images/doubt.png",width:16,height:16},width:this.width*2,height:16}),this.roll1.right=this.width,this.roll2=new i({parent:this,tileConf:{image:"media/images/doubt.png",imageY:16,width:16,height:16},width:this.width*2,height:16,y:16}),this.roll2.right=this.width,this.roll3=new i({parent:this,tileConf:{image:"media/images/doubt.png",imageY:32,width:16,height:16},width:this.width*2,height:16,y:32}),this.roll3.right=this.width,this.bg=new r({parent:this,y:48}),this.roll4=(new i({parent:this,tileConf:{image:"media/images/doubt.png",imageY:48,width:16,height:16},width:this.width*2,height:16,y:32})).align("right","bottom")},tick:function(e){var t=e/1e3;this.roll1.x+=20*t,this.roll1.x>0&&(this.roll1.right=this.width),this.roll2.x+=40*t,this.roll2.x>0&&(this.roll2.right=this.width),this.roll3.x+=80*t,this.roll3.x>0&&(this.roll3.right=this.width),this.roll4.x+=160*t,this.roll4.x>0&&(this.roll4.right=this.width)},setStyle:function(e){var t=0;switch(e){case"negative":t=16,this.bg.backgroundColor=s.getColor("brown");break;case"positive":t=32,this.bg.backgroundColor=s.getColor("darkGreen");break;case"gold":t=48,this.bg.backgroundColor=s.getColor("orange");break;default:this.bg.backgroundColor="rgb(34, 32, 68)"}this.roll1._tileView.imageX=t,this.roll2._tileView.imageX=t,this.roll3._tileView.imageX=t,this.roll4._tileView.imageX=t,this.roll1.redrawBuffer(),this.roll2.redrawBuffer(),this.roll3.redrawBuffer(),this.roll4.redrawBuffer()}});t.defaults={backgroundColor:s.getColor("green")}}),n("djinn/utils/Color",["require","exports","module","../Class","../math/random","./string"],function(e,t,n){var r=e("../Class"),i=e("../math/random"),s=e("./string"),o=/rgba\(([0-9]+),\s?([0-9]+),\s?([0-9]+),\s?([0-9\.]+)\)/,t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this.r=e.r,this.g=e.g,this.b=e.b,this.a=e.a},clone:function(){return t.create(this.r,this.g,this.b,this.a)},toRGB:function(){return s.sprintf("rgb(%s, %s, %s)",this.r,this.g,this.b)},toRGBA:function(e){var e=e!==undefined?e:this.a;return s.sprintf("rgba(%s, %s, %s, %s)",this.r,this.g,this.b,e)},darken:function(e){var e=1-e;return this.r=Math.floor(this.r*e),this.g=Math.floor(this.g*e),this.b=Math.floor(this.b*e),this},lighten:function(e){return this.r+=Math.floor((255-this.r)*e),this.g+=Math.floor((255-this.g)*e),this.b+=Math.floor((255-this.b)*e),this}});t.create=function(e,n,r,i){return new t({r:e,g:n,b:r,a:i===undefined?1:i})},t.fromRGBA=function(e){var n=e.match(o);return!n||n.length!==5?(console.warn("[Color] Failed to parse RGBA string: "+e),null):t.create(Number(n[1]),Number(n[2]),Number(n[3]),Number(n[4]))},t.random=function(e){return t.create(i.integer(255),i.integer(255),i.integer(255),e)},t.defaults={r:0,g:0,b:0,a:1}}),n("djinn/utils/gradient",["djinn/stage","djinn/utils/Color"],function(e,t){var n={},r=function(r,i,s,o){var u=i*2,a=e.createBuffer(u,u),f=a.getContext("2d");n[r]=a;var l=t.fromRGBA(s),c=f.createRadialGradient(i,i,o,i,i,i);return c.addColorStop(0,l.toRGBA()),c.addColorStop(1,l.toRGBA(0)),f.fillStyle=c,f.fillRect(0,0,u,u),a},i=function(e,t,i){var i=i||0,s=[e,t,i].join("-");return n[s]?n[s]:r(s,e,t,i)};return{drawRadial:function(e,t,n,r,s,o){var u=i(r,s,o);e.drawImage(u,0,0,u.width,u.height,t-r,n-r,u.width,u.height)}}}),n("js/view/Darkness",["require","exports","module","djinn/view/View","djinn/math/core","djinn/utils/gradient","djinn/stage","djinn/sim/shared/position","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("djinn/utils/gradient"),o=e("djinn/stage"),u=e("djinn/sim/shared/position"),a=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this._buffer=o.createBuffer(this.width,this.height)},render:function(e){var t=this._buffer,n=t.getContext("2d"),r=this.width,o=this.height;n.globalCompositeOperation="source-over",n.clearRect(0,0,t.width,t.height),n.drawImage(this._image,0,this.imageY,r,o,0,0,r,o);var f=this.level;f&&(n.globalCompositeOperation="destination-out",f.entities.forEach(bind(this,function(e){var t=e.light;if(!t)return;var l=f.camera,c=i.clamp(l.x-this.width/2,0,f.width-this.width),h=i.clamp(l.y-this.height/2,0,f.height-this.height),p=u.getCenter(e),d=t.radius,v=p.x-c,m=p.y-h;if(t.intensity<=0||v<-d||v>r+d||m<-d||m>o+d)return;s.drawRadial(n,v,m,d,a.getColor("black",t.intensity),~~(t.radius/10))}))),e.globalAlpha=this.opacity,e.drawImage(t,0,0,t.width,t.height,0,0,r,o)}});t.defaults={compositeOperation:"darken",image:"media/images/darkness.png",width:256,height:144}}),n("js/view/Reward",["require","exports","module","djinn/view/View","./Typer","./avatarFactory","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Typer"),s=e("./avatarFactory"),o=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=this.width-2,s=this.height-2,u=this._background=(new r({parent:this,acceptInputEvents:!0,backgroundColor:o.getColor("gold"),width:n,height:s})).align("center","center"),a=this._header=new i({parent:u,color:"black",anchorX:.5});a.align("center","top",0,4);var f=new i({parent:u,text:"OK",color:"black"});f.shrinkwrap(),f.align("center","bottom",0,-4),this.on("inputStart",this,"_onOK")},setHeader:function(e){this._header.text=e,this._header.shrinkwrap()},setContentAvatar:function(e){this._content&&this._content.dispose();if(!e)return;this._content=s.create(e,{parent:this._background}).align("center","center")},setContentText:function(e){this._content&&this._content.dispose();if(!e)return;this._content=(new i({parent:this._background,text:e,color:"black"})).shrinkwrap().align("center","center")},setContentConf:function(e){this._content&&this._content.dispose();if(!e)return;this._content=(new r(merge({parent:this._background,width:16,height:16},e))).align("center","center")},_onOK:function(){this.fire("ok")}});t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:o.getColor("white"),width:144,height:64}}),n("js/view/Doubt",["require","exports","module","djinn/view/Sprite"],function(e,t,n){var r=e("djinn/view/Sprite");n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)}}),t.defaults={animations:{idle:{frameRate:2,frames:[[0,32],[16,32]]},sad:{frameRate:2,frames:[[32,32],[48,32]]},happy:{frameRate:2,frames:[[64,32],[80,32]]},bothered:{frameRate:2,frames:[[96,32],[112,32]]},celebrate:{frames:[[112,0]],loop:!1}},image:"media/images/actors.png",imageSmoothingEnabled:!1,width:16,height:16}}),n("js/view/scenes/DoubtScene",["require","exports","module","djinn/view/View","djinn/math/random","djinn/achievements","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../Field","../Darkness","../Dialog","../Reward","../Doubt","../style","../../doubt"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=e("djinn/achievements"),o=e("djinn/audio/jukebox"),u=e("./Scene"),a=e("../../gameData"),f=e("../Typer"),l=e("../Field"),c=e("../Darkness"),h=e("../Dialog"),p=e("../Reward"),d=e("../Doubt"),v=e("../style"),m=e("../../doubt"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this.field=new l({parent:this}),this.darkness=new c({parent:this});var e=this._titan=new d({parent:this,scale:4});e.align("center","center",0,-40),this._container=new r({parent:this,acceptInputEvents:!0,x:8,y:64,width:240,height:72}),this._reward=(new p({parent:this,backgroundColor:v.getColor("black")})).align("center","center"),this._reward.on("ok",this,"_onRewardOK"),this.on("inputStart",this,"_onInputStart"),this.overlay=new r({parent:this,backgroundColor:v.getColor("white")}),this.sortChildren()},reset:function(){this.darkness.opacity=.75,this.overlay.opacity=0,this.field.setStyle(),this.resetDialog()},resetDialog:function(){var e=this._container;e.disposeChildren(),this.doubtKey=a.getDeveloperFlag("doubtKey"),this._reward.hide(),this.parent.mouse.hide(),this.doubtIndex=0,this._y=0;var t=m[this.doubtKey];t.mood?this._titan.playAnimation(t.mood):this._titan.playAnimation("idle")},advanceDialog:function(){var e=m[this.doubtKey],t=e.text;if(this.doubtIndex>=t.length){this.finishText();return}var n=this._container,r=new h({parent:n,y:this._y});r.animate(t[this.doubtIndex]),r.on("done",this,"advanceDialog"),this._y+=8,this.doubtIndex+=1},finishText:function(){var e=m[this.doubtKey];e.choices?this.showChoices():e.unlock?this.delayTween(250,bind(this,function(){this.captureInputEvents=!0,this.parent.mouse.show()})):(this.captureInputEvents=!0,this.parent.mouse.show())},showChoices:function(){var e=this._container,t=m[this.doubtKey];this.delayTween(1e3,bind(this,function(){o.play("error",0),this._y+=8;var n=t.choices[0],r=new f({parent:e,acceptInputEvents:!0,text:n.text,x:16,y:this._y});r.sound=n.sound||"choice1",r.scene=n.scene,r.style=n.color,r.key=n.key,r.on("inputStart",this,"_onChoiceSelect"),this._y+=16;var s=t.choices[1],u=new f({parent:e,acceptInputEvents:!0,text:s.text,x:16,y:this._y});u.sound=s.sound||"choice2",u.scene=s.scene,u.style=s.color,u.key=s.key,u.on("inputStart",this,"_onChoiceSelect"),this.captureInputEvents=!0,this.parent.mouse.show();if(i.chance(.5)){var a=r.y;r.y=u.y,u.y=a}}))},showReward:function(){o.play("increase",0);var e=m[this.doubtKey],t=this._reward,n=e.unlock;t.setHeader("UNLOCK!"),t.setContentAvatar(n.flag),n.editEntity&&a.addDeveloperEditEntity(n.editEntity),t.show(),a.setDeveloperFlag(n.flag,!0),s.trackProgress(n.flag,1)},activate:function(e,t){this._super(e,t),this.captureInputEvents=!1,this.delayTween(500,bind(this,function(){this.advanceDialog()}))},tick:function(e){if(!this.captureInputEvents)return;(this.getInput("action",!0)||this.getInput("negate",!0))&&this._onInputStart()},_onChoiceSelect:function(e){var t=e.target;o.play(t.sound,0),this.overlay.completeTween({opacity:1}).tween({opacity:0},500),t.style&&(this.field.setStyle(t.style),t.style==="gold"&&(this.darkness.opacity=.25)),this.captureInputEvents=!1;if(t.scene){this.fireSceneEvent(t.scene);return}a.setDeveloperFlag("doubtKey",t.key),this.resetDialog(),this.advanceDialog()},_onInputStart:function(){if(!this.captureInputEvents)return;var e=m[this.doubtKey];e.choices||(e.unlock?this._reward.visible||this.showReward():e.url?(o.play("choice2",0),this.overlay.completeTween({opacity:1}).tween({opacity:0},500),location.href=e.url,this.captureInputEvents=!1):(a.setDeveloperFlag(this.doubtKey,!0),this._onRewardOK()))},_onRewardOK:function(){o.play("done",0),this.captureInputEvents=!1,this.oldSceneId==="finalBoss"&&(this.oldSceneId="credits"),this.fireSceneEvent(this.oldSceneId||"computer")}});t.defaults={backgroundColor:v.getColor("maroon")}}),n("djinn/view/Pawn",["require","exports","module","./View"],function(e,t,n){var r=e("./View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},attachEntity:function(e){this.entity=e,this.sync()},detachEntity:function(){this.entity=null},attachAvatar:function(e){this.avatar=e,this.addChild(e),this.alignAvatar()},alignAvatar:function(){this.avatar.align("center","center")},despawn:function(){this.dispose()},sync:function(){var e=this.entity;if(!e)return;var t=e.size,n=e.position,r=this.avatar;this.x=Math.round(n.x),this.y=Math.round(n.y),n.z===undefined?(this.z=this.y,r?this.z+=r.y+r.height:this.z+=this.height):this.z+=n.z,this.width=t.width,this.height=t.height},tick:function(e){this.sync()}});t.defaults={tag:"Pawn",width:32,height:32}}),n("djinn/view/TileMapRenderer",["require","exports","module","./View","../math/core","./utils/canvas","../utils/array","../assets"],function(e,t,n){var r=e("./View"),i=e("../math/core"),s=e("./utils/canvas"),o=e("../utils/array"),u=e("../assets"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.offsetX=e.offsetX,this.offsetY=e.offsetY,this._tileMap=null,this.tileImage=e.tileImage,this._highlights=[],this._highlightRadians=0,this.highlightColor=e.highlightColor,this.highlightPulseSpeed=e.highlightPulseSpeed},attach:function(e){this._tileMap=e},detach:function(){this._tileMap=null},setOffset:function(e,t){var n=this._tileMap;if(!n)return;var r=Math.max(n.unitWidth-this.width,0),s=Math.max(n.unitHeight-this.height,0);this.offsetX=i.clamp(e,0,r),this.offsetY=i.clamp(t,0,s)},scroll:function(e,t){this.setOffset(this.offsetX+e,this.offsetY+t)},addHighlight:function(e,t){var n=this._tileMap.xyToIndex(e,t);this._highlights.push(n)},clearHighlights:function(){this._highlights=[]},tick:function(e){this._highlightRadians+=e*this.highlightPulseSpeed,this._highlightRadians=i.wrapRadians(this._highlightRadians);var t=Math.sin(this._highlightRadians)*.1;this._highlightAlpha=.25+t},render:function(e){var t=this._tileMap,n=this._tileImage;if(!t||!n)return;var r=u.get(n);if(!r.ready)return;var i=~~this.offsetX,a=~~this.offsetY,f=t.tileWidth,l=t.tileHeight,c=~~(r.width/f),h=this._highlights,p=t.unitToTile(i,a),d={x:Math.ceil((i+this.width)/f),y:Math.ceil((a+this.height)/l)},v={x:i%f,y:a%l};for(var m=p.y;m<=d.y;++m)for(var g=p.x;g<=d.x;++g){var y=t.get(g,m);if(y===undefined)continue;var b=y%c*f,w=~~(y/c)*l,E={x:(g-p.x)*f-v.x,y:(m-p.y)*l-v.y};e.drawImage(r,b,w,f,l,E.x,E.y,f,l);var S=t.xyToIndex(g,m);h.length>0&&o.contains(h,S)&&(e.globalAlpha=this._highlightAlpha,s.drawRect(e,E.x,E.y,f,l,this.highlightColor),e.globalAlpha=1)}}});t.defaults={offsetX:0,offsetY:0,tileImage:null,highlightColor:"white",highlightPulseSpeed:Math.PI*2/1e3};var a=t.prototype;Object.defineProperty(a,"tileImage",{set:function(e){this._tileImage=e,u.load(e)}})}),n("djinn/view/WorldRenderer",["require","exports","module","./View","./Pawn","./TileMapRenderer","../math/core"],function(e,t,n){var r=e("./View"),i=e("./Pawn"),s=e("./TileMapRenderer"),o=e("../math/core"),t=n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults)),this.world=null,this.pawns={},this._pawnFactory=null,this._avatarFactory=null,this.mapRenderer=new s({parent:this,visible:!1}),this._pawnContainer=new r({parent:this,autoSortChildren:!0,tag:this.tag+".PawnContainer"})},attach:function(e){var t=e.entities.items;for(var n=0,r=t.length;n<r;++n){var i=t[n];i&&this._onWorldEntitySpawn(i)}e.on("reset",this,"_onWorldReset"),e.on("entitySpawn",this,"_onWorldEntitySpawn"),e.on("entityDespawn",this,"_onWorldEntityDespawn"),e.map&&e.map.size>0&&(this.mapRenderer.attach(e.map),this.mapRenderer.visible=!0),this.world=e},detach:function(){var e=this.world;this.world=null,e&&e.removeListenersByContext(this),this.mapRenderer.detach(),this.clean()},clean:function(){this._pawnContainer.disposeChildren()},setPawnFactory:function(e){this._pawnFactory=e},setAvatarFactory:function(e){this._avatarFactory=e},render:function(e){this.updateCamera(),this._super(e)},updateCamera:function(){var e=this.world,t=e.camera,n=o.clamp(t.x-this.width/2,0,e.width-this.width),r=o.clamp(t.y-this.height/2,0,e.height-this.height);n=Math.round(n),r=Math.round(r),this._pawnContainer.x=-n,this._pawnContainer.y=-r,this.mapRenderer.setOffset(n,r)},_onWorldReset:function(){this.clean()},_onWorldEntitySpawn:function(e){if(!this._pawnFactory||!this._avatarFactory){log.warn("[WorldRenderer._onWorldEntitySpawn] Missing pawn or avatar factory");return}var t=this._pawnFactory.create(e.type);t.attachEntity(e);var n=this._avatarFactory.create(e.type);return t.attachAvatar(n),this._pawnContainer.addChild(t),this.pawns[e.id]=t,t.spawn&&t.spawn(e),t},_onWorldEntityDespawn:function(e){var t=this.pawns,n=t[e.id];n&&n.despawn&&n.despawn(),delete t[e.id]}});t.defaults={tag:"WorldRenderer"}}),n("js/view/pawns/Pawn",["require","exports","module","djinn/view/Pawn","djinn/audio/jukebox","../../gameData","../avatarFactory","../style"],function(e,t,n){var r=e("djinn/view/Pawn"),i=e("djinn/audio/jukebox"),s=e("../../gameData"),o=e("../avatarFactory"),u=e("../style"),t=n.exports=r.extend({alignAvatar:function(){var e=this.entity;e?e.meta.center?this._super():e.gravity&&e.gravity.value<0?this.avatar.align("center","top"):this.avatar.align("center","bottom"):this._super()},attachAvatar:function(e){this._super(e);var t=this.entity;e.attach&&e.attach(t),t.on("damage",this,"_onDamage"),t.on("harm",this,"_onHarm"),t.on("despawn",this,"_onDespawn"),t.on("gravityChange",this,"_onGravityChange"),t.on("stateAddTtl",this,"_onStateAddTtl"),t.on("teleported",this,"_onTeleported"),t.meta&&t.meta.trail&&this.startTail(),s.enableFinalBoss&&(t.type==="gameGoal"||t.type==="gameKey"?e.overlayColor=u.getColor("white"):t.type!=="playerDoubt"&&(e.overlayColor=u.getColor("black")))},startTail:function(){this._trailTimer||(this._trailTimer=this.createTimer(100,"_onTrailTimer")),this._trailTimer.start()},_onTrailTimer:function(){var e=this.entity,t=e.velocity;if(Math.abs(t.x)<.01&&Math.abs(t.y)<.01)return;if(e.mortal&&!e.mortal.alive)return;var n=o.create(e.type,{parent:this.parent,opacity:.5});n.centerOn(this),n.tween({opacity:0},250,null,function(){n.dispose()})},_playSound:function(e){var t=this.entity.sounds;t&&t[e]&&i.play(t[e],0)},_onDamage:function(e,t){e>0&&(this._playSound("damage"),this._showDamage&&this._showDamage())},_onHarm:function(e,t){this._playSound("harm")},_onDespawn:function(){this._playSound("despawn")},_onGravityChange:function(e){i.play(e<0?"gravity1":"gravity2",0);var t=this.avatar;t.completeTween({flipY:e<0,overlayColor:u.getColor("white",.75)}).delayTween(500,function(){t.overlayColor=null}),this.alignAvatar()},_onTeleported:function(e){i.play("teleport",0);var t=this.avatar;t.completeTween({overlayColor:u.getColor("white",.75)}).delayTween(500,function(){t.overlayColor=null})},_onStateAddTtl:function(e){this.avatar.completeTween().tween({opacity:0},e.duration)}})}),n("js/view/pawns/Banner",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e),this.avatar.setText(this.entity.meta.text),this.avatar.setColor(this.entity.meta.color)},_onStateAddTtl:function(e){var t=this.avatar;t.completeTween().tween({opacity:0,y:t.y-4},e.duration)}})}),n("js/view/pawns/Boss",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("attack",this,"_onAttack"),t.on("move",this,"_onMove")},_onAttack:function(){this._playSound("attack"),this.avatar.attack()},_onMove:function(e){this._playSound("move")},_showDamage:function(){this.avatar.showDamage()}})}),n("js/view/pawns/Bouncer",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("launch",this,"_onLaunch")},_onLaunch:function(){this._playSound("launch"),this.avatar.launch()}})}),n("js/view/pawns/SideFacer",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({tick:function(e){this._super(e);var t=this.entity;t.facing?this.avatar.flipX=t.facing.angle<1:t.velocity&&(this.avatar.flipX=t.velocity.x>0)}})}),n("js/view/pawns/Cannon",["require","exports","module","./SideFacer"],function(e,t,n){var r=e("./SideFacer"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e),this.entity.on("attack",this,"_onAttack")},_onAttack:function(){this._playSound("attack")}})}),n("js/view/pawns/FragileRock",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({_onStateAddTtl:function(e){this._playSound("warn"),this.avatar.warn(e.duration)}})}),n("js/view/pawns/GameGoal",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e),this.entity.world.on("goal",this,"_onGoal"),this.entity.on("activeStateChange",this,"_onActiveStateChange")},_onGoal:function(){this.avatar.goal()},_onActiveStateChange:function(e){e?this.avatar.activate():this.avatar.deactivate()}})}),n("js/view/pawns/GravityRock",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("gravityEffect",this,"_onGravityEffect")},_onGravityEffect:function(){this.avatar.changeGravity()}})}),n("js/view/pawns/IntervalRock",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e),this.entity.on("toggle",this,"_onToggle")},_onToggle:function(){var e=this.entity.collision.solid;this._playSound(e?"appear":"disappear"),this.avatar.toggle(e)}})}),n("js/view/pawns/Jumper",["require","exports","module","./SideFacer"],function(e,t,n){var r=e("./SideFacer"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("warning",this,"_onWarning"),t.on("jump",this,"_onJump"),t.on("land",this,"_onLand")},_onWarning:function(){this._playSound("warning"),this.avatar.warning(this.entity.facing.angle)},_onJump:function(){this._playSound("jump"),this.avatar.jump()},_onLand:function(){this.avatar.land()},_showDamage:function(){this.avatar.showDamage()}})}),n("js/view/pawns/Player",["require","exports","module","./SideFacer"],function(e,t,n){var r=e("./SideFacer"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("action",this,"_onAction"),t.world.on("goal",this,"_onGoal"),t.on("jump",this,"_onJump")},_onAction:function(){this._playSound("action")},_onGoal:function(){if(!this.entity.mortal.alive)return;this.avatar.playAnimation("celebrate")},_onJump:function(){this._playSound("jump")},_showDamage:function(){this.avatar.showDamage()}})}),n("js/view/pawns/Pointer",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({tick:function(e){this._super(e),this.avatar.rotation=this.entity.facing.angle}})}),n("js/view/pawns/PulseBlock",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("toggle",this,"_onToggle")},_onToggle:function(){var e=this.entity.collision.solid;this._playSound(e?"pulseBlockSolid":"pulseBlock"),this.avatar.toggle(e)}})}),n("js/view/pawns/PulseButton",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("pulse",this,"_onPulse")},_onPulse:function(){this._playSound("pulse"),this.avatar.pulse()}})}),n("js/view/pawns/Spawner",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e),this.entity.on("warning",this,"_onWarning"),this.entity.on("spawn",this,"_onSpawn")},_onWarning:function(){this._playSound("warning"),this.avatar.spawn()},_onSpawn:function(){this._playSound("spawn")}})}),n("js/view/pawns/Survey",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;this.avatar.setJoy(t.meta.joyCount)}})}),n("js/view/pawns/Teleporter",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e);var t=this.entity;t.on("deactivate",this,"_onDeactivate"),t.on("teleport",this,"_onTeleport")},_onDeactivate:function(){this.avatar.deactivate()},_onTeleport:function(){this.avatar.teleport()}})}),n("js/view/pawns/Torch",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({attachAvatar:function(e){this._super(e),this.entity.on("lightChange",this,"_onLightChange")},_onLightChange:function(e){this.avatar.lightChange(e)}})}),n("js/view/pawns/VPlatform",["require","exports","module","./Pawn"],function(e,t,n){var r=e("./Pawn"),t=n.exports=r.extend({tick:function(e){this._super(e);var t=this.entity;t.velocity.y>0?this.avatar.down():this.avatar.up()}})}),n("js/view/pawnFactory",["require","exports","module","djinn/utils/Factory","./pawns/Pawn","./pawns/Banner","./pawns/Boss","./pawns/Bouncer","./pawns/Cannon","./pawns/FragileRock","./pawns/GameGoal","./pawns/GravityRock","./pawns/IntervalRock","./pawns/Jumper","./pawns/Player","./pawns/Pointer","./pawns/PulseBlock","./pawns/PulseButton","./pawns/SideFacer","./pawns/Spawner","./pawns/Survey","./pawns/Teleporter","./pawns/Torch","./pawns/VPlatform"],function(e,t,n){var r=e("djinn/utils/Factory"),i=e("./pawns/Pawn"),s=e("./pawns/Banner"),o=e("./pawns/Boss"),u=e("./pawns/Bouncer"),a=e("./pawns/Cannon"),f=e("./pawns/FragileRock"),l=e("./pawns/GameGoal"),c=e("./pawns/GravityRock"),h=e("./pawns/IntervalRock"),p=e("./pawns/Jumper"),d=e("./pawns/Player"),v=e("./pawns/Pointer"),m=e("./pawns/PulseBlock"),g=e("./pawns/PulseButton"),y=e("./pawns/SideFacer"),b=e("./pawns/Spawner"),w=e("./pawns/Survey"),E=e("./pawns/Teleporter"),S=e("./pawns/Torch"),x=e("./pawns/VPlatform");n.exports=new r(i,{playerBenzer:d,playerBird:d,playerBoy:d,playerChicken:d,playerDog:d,playerDoubt:d,playerFather:d,playerFranklin:d,playerGirl:d,playerGoblin:d,playerJanitor:d,playerJoey:d,playerLars:d,playerLuna:d,playerMother:d,playerRaga:d,playerTiger:d,playerWizard:d,playerXam:d,playerZombie:d,chicken:d,squid:d,banner:s,boss:o,boss2x2:o,bouncer:u,cannon:a,fragileRock:f,gameGoal:l,gravityRock:c,hPlatform:y,intervalRock:h,jumper:p,lightSwitch:g,pulseBlock:m,pulseButton:g,shell:y,shellLights:y,spawner:b,survey:w,teleporter:E,torch:S,vPlatform:x})}),n("js/view/LevelRenderer",["require","exports","module","djinn/view/WorldRenderer","./pawnFactory","./avatarFactory"],function(e,t,n){var r=e("djinn/view/WorldRenderer"),i=e("./pawnFactory"),s=e("./avatarFactory");n.exports=r.extend({init:function(e){this._super(e),this.setPawnFactory(i),this.setAvatarFactory(s)}})}),n("js/view/EditMenu",["require","exports","module","djinn/stage","djinn/view/View","djinn/audio/jukebox","../gameData","../buildCosts","./Typer","./Grid","./Scrollbar","./style"],function(e,t,n){var r=e("djinn/stage"),i=e("djinn/view/View"),s=e("djinn/audio/jukebox"),o=e("../gameData"),u=e("../buildCosts"),a=e("./Typer"),f=e("./Grid"),l=e("./Scrollbar"),c=e("./style");n.exports=i.extend({init:function(e){this._super(merge(e,t.defaults)),r.on("wheel",this,"_onWheel"),this.on("inputMove",this,"_onInputMove"),this._gameName=new a({parent:this,color:"silver",width:64,x:2,y:2});var n=this._close=(new a({parent:this,acceptInputEvents:!0,text:"X",width:8})).align("right","top",0,1);n.on("inputPress",this,"_onHide");var s=this._tileGrid=new f({parent:this,type:"tile",x:8,y:16,width:64,height:32});s.on("select",this,"_onTileGridSelect");var o=this._entityContainer=new i({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:s.bottom+4,width:64,height:32}),u=this._entityGrid=new f({parent:o,type:"entity",width:64,height:48});u.on("select",this,"_onEntityGridSelect");var h=this._scrollbar=new l({parent:this,barColor:c.getColor("black"),x:o.x,y:o.bottom,width:o.width,height:8});h.attach(u),this._cost=new a({parent:this,color:"silver",x:h.x,y:h.bottom+1}),this._playtest=(new i({parent:this,acceptInputEvents:!0,image:"media/images/objects.png",imageX:16,imageY:112,x:8,y:this._cost.bottom+4,width:16,height:16})).on("inputPress",this,"_onPlay");var p=(new i({parent:this,acceptInputEvents:!0,image:"media/images/objects.png",imageX:0,imageY:32,x:this._playtest.right+8,y:this._playtest.y,width:16,height:16})).on("inputPress",this,"_onSettings"),d=this._finances=(new i({parent:this,acceptInputEvents:!0,image:"media/images/ui.png",imageX:80,x:p.right+8,y:p.y+4,width:16,height:8})).on("inputPress",this,"_onFinances"),v=(new i({parent:this,acceptInputEvents:!0,image:"media/images/objects.png",imageX:48,imageY:0,x:8,y:p.bottom+4,width:16,height:16})).on("inputPress",this,"_onQuit"),m=(new i({parent:this,acceptInputEvents:!0,image:"media/images/objects.png",imageX:64,imageY:32,x:v.right+8,y:v.y,width:16,height:16})).on("inputPress",this,"_onShare"),g=this._analyze=(new i({parent:this,acceptInputEvents:!0,image:"media/images/objects.png",imageX:112,imageY:64,x:m.right+8,y:m.y,width:16,height:16})).on("inputPress",this,"_onAnalyze")},reset:function(){var e=o.getGamesList(),t=e[o.data.editGameIndex];this.updateGameName(t.name);var n=this._tileGrid;n.reset();var r=o.getDeveloper().editTiles,i=o.getDeveloper().editEntities,s=o.data;if(s.editTileKey&&r.indexOf(s.editTileKey)<0||s.editEntityKey&&i.indexOf(s.editEntityKey)<0)s.editTileKey=null,s.editEntityKey="gameGoal";n.setObjects(r),n.setCursor(s.editTileKey);var u=this._entityGrid;u.reset();var a=this._entityContainer,f=a.height/16,l=Math.ceil(i.length/f);u.width=Math.max(64,l*16),u.setObjects(i),u.setCursor(s.editEntityKey),this._finances.visible=o.developerHasExpensiveEntity(),this.updateFinances(),this._analyze.visible=o.getDeveloperFlag("marketAnalysis"),this.updateCost(),this._scrollbar.reset(),this.updateTestedState()},setTile:function(e){this._onTileGridSelect(e),this._tileGrid.setCursor(e),this.updateCost(e)},setEntity:function(e){this._onEntityGridSelect(e),this._entityGrid.setCursor(e),this.updateCost(e)},stopInput:function(){this._scrollbar.stopInput()},updateCost:function(){if(o.data.editEntityKey)var e=o.data.editEntityKey;else var e=o.data.editTileKey;var t=u[e];t?this._cost.text="$"+t:this._cost.text=""},updateGameName:function(e){e.length>8?this._gameName.text=e.substr(0,3)+".."+e.substr(-3):this._gameName.text=e},updateTestedState:function(){var e=o.getGamesList(),t=e[o.data.editGameIndex];t.tested?this._playtest.imageX=16:this._playtest.imageX=32},updateFinances:function(){var e=o.getGamesList(),t=e[o.data.editGameIndex],n=o.getDeveloperMoney(),r=o.getGameTotalCost(t);r>n?this._finances.imageY=56:this._finances.imageY=48},show:function(){this.x=0,this.hidden=!1,this._close.visible=!0},hide:function(){this.right=4,this.hidden=!0,this._close.visible=!1},_onTileGridSelect:function(e){s.play("select",0),o.data.editTileKey=e,o.data.editEntityKey=null,o.save(),this._entityGrid.setCursor(null),this.stopInput(),this.updateCost(),this.fire("selectTile",[e])},_onEntityGridSelect:function(e){s.play("select",0),o.data.editTileKey=null,o.data.editEntityKey=e,o.save(),this._tileGrid.setCursor(null),this._scrollbar.stopInput(),this.updateCost(),this.fire("selectEntity",[e])},_onWheel:function(e,t){if(!this.captureInputEvents||!this.visible)return;t<0?this._scrollbar.scroll(-1,160):this._scrollbar.scroll(1,160)},_onPlay:function(){s.play("play",0),this.fire("playtest")},_onFinances:function(){s.play("select",0),this.stopInput(),this.fire("finances")},_onShare:function(){s.play("select",0),this.stopInput(),this.fire("share")},_onAnalyze:function(){this.stopInput(),this.fire("analyze")},_onQuit:function(){s.play("negate",0),this.fire("quit")},_onHide:function(){s.play("close",0),this.hide()},_onSettings:function(){s.play("select",0),this.stopInput(),this.fire("settings")},_onInputMove:function(){if(!this.hidden)return;s.play("open",0),this.reset(),this.show()}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:c.getColor("black",.75),width:80,height:144}}),n("js/view/Finances",["require","exports","module","djinn/view/View","djinn/utils/string","./Typer","./style","../gameData"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/string"),s=e("./Typer"),o=e("./style"),u=e("../gameData");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults));var n=(new r({parent:this,acceptInputEvents:!0,backgroundColor:o.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center"),i=(new s({parent:n,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-4,4);i.on("inputPress",this,"_onClose");var u=new s({parent:n,text:"Finances",color:"gray",anchorX:.5});u.shrinkwrap(),u.align("center","top",0,4);var a=this._moneyHeader=(new s({parent:this,color:"silver",x:8,y:u.bottom+8})).shrinkwrap(),f=this._devMoney=new s({parent:n,y:a.y}),l=(new s({parent:this,text:"Game:",color:"silver",x:8,y:a.bottom+8})).shrinkwrap();this._name=new s({parent:n,x:l.right+8,y:l.y});var c=(new s({parent:this,text:"Dev cost:",color:"silver",x:8,y:l.bottom+8})).shrinkwrap(),h=this._totalCost=new s({parent:n,x:c.right+8,y:c.y})},reset:function(){var e=u.getEditGame();this.updateGameName(e.name);var t=this._moneyHeader;t.text=u.data.developer+":",t.shrinkwrap();var n=this._devMoney,r=u.getDeveloperMoney();n.text="$"+i.formatMoney(r),n.x=t.right+8;var s=u.getGameTotalCost(e);this._totalCost.text="$"+i.formatMoney(s),r>=s?this._totalCost.color="green":this._totalCost.color="red"},updateGameName:function(e){this._name.text=e},_onClose:function(){this.fire("close")}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:o.getColor("silver"),width:210,height:66}}),n("js/view/Share",["require","exports","module","djinn/view/View","../gameData","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("../gameData"),s=e("./Typer"),o=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults));var n=(new r({parent:this,acceptInputEvents:!0,backgroundColor:o.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center"),i=(new s({parent:n,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-4,4);i.on("inputPress",this,"_onClose");var u=new s({parent:n,text:"Share",color:"gray",anchorX:.5});u.shrinkwrap(),u.align("center","top",0,4);var a=this._copy=new s({parent:n,text:"Copy URL",acceptInputEvents:!0,x:8,y:u.bottom+8});a.on("inputStart",this,"_onCopy")},reset:function(){var e=this._copy,t=i.getEditGame();t.tested?(e.color="white",e.text="Copy URL"):(e.color="gray",e.text="Copy URL (untested)")},_onClose:function(){this.fire("close")},_onCopy:function(){this.fire("share")}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:o.getColor("silver"),width:210,height:42}}),n("js/view/Minimap",["require","exports","module","djinn/view/View","djinn/math/core","../templates"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("../templates"),o={medium:{imageX:64,imageY:64,width:23,height:15},large:{imageX:64,imageY:80,width:33,height:19}},t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.viewport=new r({parent:this,image:"media/images/ui.png",imageX:64,imageY:48,width:16,height:9})},setSizeByHeight:function(e){var t=s.getKeyByHeight(e);t&&this.set(o[t])},reset:function(){this.completeTween({opacity:0})},ping:function(e,t){var n=this.parent,r=t.x-n.width/2,s=t.y-n.height/2,o=this.viewport;o.x=i.clamp(Math.floor(r/16),0,this.width-o.width),o.y=i.clamp(Math.floor(s/16),0,this.height-o.height),this.completeTween({opacity:1}).tween({opacity:0},500)}});t.defaults={image:"media/images/ui.png",overlayColor:"silver"}}),n("js/view/ConfirmAnalysis",["require","exports","module","djinn/view/View","djinn/math/core","djinn/utils/string","./Typer","./style","../gameData"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("djinn/utils/string"),o=e("./Typer"),u=e("./style"),a=e("../gameData"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=this.width-2,i=this.height-2,s=this._background=(new r({parent:this,acceptInputEvents:!0,backgroundColor:u.getColor("black"),width:n,height:i})).align("center","center"),a=new o({parent:s,text:"Perform a",color:"gray",anchorX:.5});a.shrinkwrap(),a.align("center","top",0,4);var f=new o({parent:s,text:"Market Analysis?",color:"gray",anchorX:.5});f.shrinkwrap(),f.align("center","top",0,12),this._developerHeader=new o({parent:s,color:"silver",x:8,y:32}),this._developerMoney=new o({parent:s,color:"white",y:32});var l=new o({parent:s,text:"Analysis cost:",color:"silver",x:8,y:40});l.shrinkwrap(),this._cost=new o({parent:s,color:"white",x:l.right+8,y:40});var c=this._confirmButton=new o({parent:s,text:"Purchase",acceptInputEvents:!0});c.on("inputStart",this,"_onConfirm"),c.shrinkwrap(),c.align("center","bottom",0,-4);var h=new o({parent:s,acceptInputEvents:!0,text:"X",width:8});h.align("right","top",-4,4),h.on("inputPress",this,"_onClose")},setCost:function(e,t){var n=this._cost,r=t>=e;n.text="$"+s.formatMoney(e),r?n.color="white":n.color="red",this._developerHeader.text=a.data.developer+":",this._developerHeader.shrinkwrap(),this._developerMoney.x=this._developerHeader.right+8,this._developerMoney.text="$"+s.formatMoney(t),this._confirmButton.color=r?"white":"gray"},_onConfirm:function(){this.fire("confirm")},_onClose:function(){this.fire("cancel")}});t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:u.getColor("white"),width:224,height:72}}),n("js/view/Parallax",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},update:function(e,t){if(e.width===256){this.align("center","center");return}var n=t._pawnContainer,r=.5;this.x=~~(n.x*r),this.y=~~(n.y*r)}});t.defaults={image:"media/images/parallax.png",opacity:.1,width:512,height:288}}),n("js/view/Reticle",["require","exports","module","djinn/view/View","./Tile","./avatarFactory"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Tile"),s=e("./avatarFactory"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.cursor=new r({parent:this,image:"media/images/ui.png",z:99})},setEntity:function(e){this._content&&this._content.dispose(),this._content=s.create(e,{parent:this,opacity:.5}),this.sortChildren()},setTile:function(e){this._content&&this._content.dispose(),this._content=new i({parent:this,image:"media/images/env.png",opacity:.5,tile:e}),this.sortChildren()}});t.defaults={width:16,height:16}}),n("js/view/scenes/EditScene",["require","exports","module","djinn/view/View","djinn/manifest","djinn/utils/Pattern","djinn/stage","djinn/math/core","djinn/math/random","djinn/client","djinn/input/keyboard","djinn/audio/jukebox","djinn/utils/object","djinn/sim/shared/position","./Scene","../../sim/Level","../../gameData","../../buildCosts","../LevelRenderer","../Typer","../EditMenu","../TextBox","../GameSettings","../Finances","../Share","../ColorPicker","../Darkness","../Minimap","../PlayerPicker","../ConfirmAnalysis","../Parallax","../Reticle","../Reward","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/manifest"),s=e("djinn/utils/Pattern"),o=e("djinn/stage"),u=e("djinn/math/core"),a=e("djinn/math/random"),f=e("djinn/client"),l=e("djinn/input/keyboard"),c=e("djinn/audio/jukebox"),h=e("djinn/utils/object"),p=e("djinn/sim/shared/position"),d=e("./Scene"),v=e("../../sim/Level"),m=e("../../gameData"),g=e("../../buildCosts"),y=e("../LevelRenderer"),b=e("../Typer"),w=e("../EditMenu"),E=e("../TextBox"),S=e("../GameSettings"),x=e("../Finances"),T=e("../Share"),N=e("../ColorPicker"),C=e("../Darkness"),k=e("../Minimap"),L=e("../PlayerPicker"),A=e("../ConfirmAnalysis"),O=e("../Parallax"),M=e("../Reticle"),_=e("../Reward"),D=e("../style"),P=l.keys,H={gameStart:"Med",gameGoal:"Med",cannon:"Neg",hTrap:"Neg",jumper:"Neg",spikes:"Neg",vTrap:"Neg"},B=D.screenshotColors,j=1,t=n.exports=d.extend({init:function(e){this._super(merge(e,t.defaults)),this.timeTrackId="edit"},setup:function(){this._super(),o.on("inputEnd",this,"_onMapEnd"),this._tweetBuffer=o.createBuffer(this.width,this.height),this.parallax=new O({parent:this});var e=this.levelRenderer=new y({parent:this,acceptInputEvents:!0});e.on("inputStart",this,"_onMapStart"),e.on("inputMove",this,"_onMapMove"),e.on("inputEnd",this,"_onMapEnd"),this.darkness=new C({parent:this});var t=this.minimap=new k({parent:this}),n=this.menu=new w({parent:this});n.on("playtest",this,"_onMenuPlaytest"),n.on("settings",this,"_onMenuSettings"),n.on("finances",this,"_onMenuFinances"),n.on("share",this,"_onMenuShare"),n.on("analyze",this,"_onAnalyze"),n.on("inputMove",this,"_onMenuInputMove"),n.on("selectEntity",this,"_onMenuSelectEntity"),n.on("selectTile",this,"_onMenuSelectTile"),n.on("quit",this,"_onMenuQuit");var r=this._gameSettings=(new S({parent:this})).align("center","center");r.on("close",this,"_onGameSettingsClose"),r.on("darkness",this,"_onGameSettingsDarkness"),r.on("openColorPicker",this,"_onOpenColorPicker"),r.on("openName",this,"_onOpenName"),r.on("openPlayer",this,"_onOpenPlayer");var i=this._finances=(new x({parent:this})).align("center","center");i.on("close",this,"_onFinancesClose");var s=this._share=(new T({parent:this})).align("center","center");s.on("close",this,"_onShareClose"),s.on("share",this,"_onShare");var u=this._colorPicker=(new N({parent:this})).align("center","center");u.on("change",this,"_onColorChange"),u.on("close",this,"_onColorPickerClose");var a=this._gameName=(new E({parent:this,maxLength:12})).align("center","center");a.on("done",this,"_onGameNameDone"),a.on("close",this,"_onGameNameClose");var f=this._gamePlayer=(new L({parent:this})).align("center","center");f.on("select",this,"_onGamePlayerSelect"),f.on("close",this,"_onGamePlayerClose");var l=this._confirmAnalysis=(new A({parent:this,backgroundColor:D.getColor("white")})).align("center","center");l.on("confirm",this,"_onConfirmPurchase"),l.on("cancel",this,"_onConfirmCancel");var c=this._reward=(new _({parent:this})).align("center","center");c.setHeader("Copy buffer!"),c.setContentConf({image:"media/images/actors.png",imageX:0,imageY:32}),c.on("ok",this,"_onRewardOK"),this.on("inputMove",this,"_onInputMove"),this.sortChildren()},reset:function(){this._super(),this._inputActive=!1,m.editing=!0,m.playtest=!1,this.loadGame(m.data.editGameIndex),this.menu.reset(),this.menu.show(),this._reticle.hide(),this._reward.hide(),this._gameName.hide(),this._gamePlayer.hide(),this._confirmAnalysis.hide(),this._gameSettings.hide(),this._finances.hide(),this._share.hide(),this._colorPicker.hide(),this.parent.mouse.show(),this.updateCamera(),this.parallax.update(this.level,this.levelRenderer),this.grid&&this.grid.dispose(),this.grid=new s({parent:this.levelRenderer._pawnContainer,tileConf:{image:"media/images/ui.png",imageY:80,width:16,height:16},width:this.level.width,height:this.level.height}),this.minimap.reset(),m.data.editEntityKey?this._reticle.setEntity(m.data.editEntityKey):this._reticle.setTile(m.data.editTileKey)},activate:function(e,t){this._super(e,t);var n=this.level;this.minimap.ping(n,n.camera)},loadGame:function(e,t,n){this.level&&this.level.dispose(),this._reticle&&this._reticle.dispose();var r=this.levelRenderer;r.detach();var i=this.level=new v,s=m.getGamesList(),o=s[e],u=i.loadMap(o,t,n,!1);r.attach(i),r.mapRenderer.tileImage="media/images/env.png",o.backgroundColor&&(this.backgroundColor=D.fromRGBArray(o.backgroundColor)),this.darkness.level=i,o.darkness?(this.darkness.opacity=o.darkness,this.darkness.visible=!0):this.darkness.visible=!1,this._reticle=new M({parent:r._pawnContainer,z:99999});var a=this.minimap;a.setSizeByHeight(o.tiles.length),a.align("right","top",-4,4),a.visible=i.width>this.width||i.height>this.height},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&(this._gameName.visible?this._onGameNameClose():this._gamePlayer.visible?this._onGamePlayerClose():this._confirmAnalysis.visible?this._onConfirmCancel():this._colorPicker.visible?this._onColorPickerClose():this._gameSettings.visible?this._onGameSettingsClose():this._finances.visible?this._onFinancesClose():this._share.visible?this._onShareClose():this.menu.hidden?(c.play("open",0),this.menu.reset(),this.menu.show()):(c.play("close",0),this.menu.hide()));if(this._gameSettings.visible)return;this.getInput("action",!0)&&(c.play("play",0),this._onMenuPlaytest());var t=this._input;this.getInput("left")?this._scroll(-1,0,e):this.getInput("right")&&this._scroll(1,0,e),this.getInput("up")?this._scroll(0,-1,e):this.getInput("down")&&this._scroll(0,1,e);var n=this.level,r=n.camera,i=this.width/2,s=this.height/2;r.x=u.clamp(r.x,i,n.width-i),r.y=u.clamp(r.y,s,n.height-s)},cleanup:function(e,t){this._super(e,t),this.levelRenderer.detach()},_draw:function(e){var t=this.getTileByPoint(e.point),n=this._removeEntitiesByTile(t.x,t.y);if(m.data.editTileKey)var r=this._drawTile(t.x,t.y);else var r=this._drawEntity(t.x,t.y);r&&m.data.editEntityKey==="trashCan"&&(r=!1,n=!0),n===m.data.editEntityKey&&(r=!1,n=!1);if(r){var i=String(m.data.editTileKey||m.data.editEntityKey),s=H[i]||"Pos";c.play("place"+s+j,0),j=j===1?2:1,this._polishDraw()}else n&&(c.play("trash"+j,0),j=j===1?2:1,this._polishDraw());if(r||n)m.setGameTestState(m.data.editGameIndex,!1),this.menu.updateTestedState(),this.menu.updateFinances(),this.menu.stopInput()},getTileByPoint:function(e){var t=this.level,n=t.camera,r=u.clamp(n.x-this.width/2,0,t.width-this.width),i=u.clamp(n.y-this.height/2,0,t.height-this.height);return{x:Math.floor((e.x+r)/16),y:Math.floor((e.y+i)/16)}},updateCamera:function(){var e=this.level;e.updateCamera(),m.camera&&(e.camera.x=m.camera.x,e.camera.y=m.camera.y,delete m.camera);var t=this.levelRenderer;t.updateCamera()},_drawTile:function(e,t){var n=m.data.editTileKey,r=this.level.map,i=r.get(e,t)!==n;return r.set(e,t,n),m.updateGameMap(m.data.editGameIndex,e,t,n),i},_drawEntity:function(e,t){var n=this.level,r=m.data.editEntityKey,i=m.data.editGameIndex,s=n.map,o=s.get(e,t)!==0;s.set(e,t,0),m.updateGameMap(i,e,t,0);if(r==="gameStart"||r==="gameGoal"){var u=n.getEntities(function(e){return e.type===r});for(var a=0,f=u.length;a<f;++a){var l=u[a];n.despawnEntity(l);var c=p.getTile(l,s);m.updateGameMap(i,c.x,c.y,0),o=!0}}if(r!=="trashCan"){var l=n.addEntityAtTile(r,e,t);s.set(e,t,0),m.updateGameMap(i,e,t,r),o=!0}return o},_dropper:function(e){var t=this.level,n=t.map,r=this.getTileByPoint(e.point),i=t.getEntitiesByTile(r.x,r.y);if(i.length){var s=i[0].type;this.menu.setEntity(s),this._reticle.setEntity(s)}else{var o=n.get(r.x,r.y);o===0?(this.menu.setEntity("trashCan"),this._reticle.setEntity("trashCan")):(this.menu.setTile(o),this._reticle.setTile(o))}},_onMapStart:function(e){e.rightClick?m.getDeveloperFlag("dropper")?this._dropper(e):c.play("negate",0):(this._inputActive=!0,this._draw(e))},_onMapMove:function(e){this._inputActive&&this._draw(e)},_onMapEnd:function(e){this._inputActive=!1},_onMenuPlaytest:function(){m.playtest=!0,this.captureInputEvents=!1,this.fireSceneEvent("playtest")},_onMenuSettings:function(){this._gameSettings.reset(!1),this._gameSettings.show()},_onMenuFinances:function(){this._finances.reset(),this._finances.show()},_onMenuShare:function(){this._share.reset(),this._share.show()},_onMenuInputMove:function(){this._onMapEnd(),this._reticle.hide(),this._hideReticle=!0},_onMenuSelectEntity:function(e){this._reticle.setEntity(e)},_onMenuSelectTile:function(e){this._reticle.setTile(e)},_onMenuQuit:function(){m.editing=!1,m.playtest=!1,this.captureInputEvents=!1,this.fireSceneEvent("quit")},_onGameNameDone:function(e){c.play("create",0),m.updateEditGameName(e),this.menu.updateGameName(e),this._gameSettings.updateGameName(e),this._gameName.hide()},_onGameNameClose:function(){c.play("close",0),this._gameName.hide()},_onGamePlayerSelect:function(e){c.play("select",0),m.updateEditGamePlayer(e),this._gameSettings.updateGamePlayer(e);var t=m.data.editGameIndex;m.setGameTestState(t,!1),m.save(),this.menu.updateTestedState()},_onGamePlayerClose:function(){c.play("close",0),this._gamePlayer.hide()},_onConfirmPurchase:function(){var e=m.getEditGame(),t=m.getGameAnalysisCost(e),n=m.getDeveloper();if(n.money<t){c.play("negate",0);return}c.play("increase",0),n.money-=t,m.save();var r=m.getDeveloperFlag("marketAnalysisCount",0);m.setDeveloperFlag("marketAnalysisCount",r+1),this.fireSceneEvent("marketAnalysis")},_onConfirmCancel:function(){c.play("negate",0),this._confirmAnalysis.hide()},_onGameSettingsClose:function(){c.play("close",0),this._gameSettings.hide()},_onFinancesClose:function(){c.play("close",0),this._finances.hide()},_onShareClose:function(){c.play("close",0),this._share.hide()},_onGameSettingsDarkness:function(e,t){if(e>t)c.play("backspace"+j,0),j=j===1?2:1;else{if(!(e<t))return;c.play("type"+j,0),j=j===1?2:1}var n=m.data.editGameIndex,r=m.getGamesList(),i=r[n];i.darkness=e,m.setGameTestState(n,!1),m.save(),this.menu.updateTestedState(),this.darkness.opacity=e,e>0?this.darkness.visible=!0:this.darkness.visible=!1},_onColorChange:function(e){c.play("select",0);var t=m.data.editGameIndex,n=m.getGamesList(),r=n[t];r.backgroundColor=e,m.setGameTestState(t,!1),m.save(),this.backgroundColor=D.fromRGBArray(e),this.menu.updateTestedState(),this._gameSettings.reset(!1)},_onColorPickerClose:function(){c.play("close",0),this._colorPicker.hide()},_onInputMove:function(e){if(this._hideReticle){this._hideReticle=!1;return}var t=this.getTileByPoint(e.point),n=this._reticle;n.x=t.x*16,n.y=t.y*16,n.show()},_onOpenColorPicker:function(){c.play("open",0);var e=m.getEditGame();this._colorPicker.setColor(e.backgroundColor),this._colorPicker.show()},_onOpenName:function(){c.play("open",0);var e=m.getEditGame();this._gameName.reset(e.name),this._gameName.show()},_onOpenPlayer:function(){c.play("open",0);var e=m.getEditGame();this._gamePlayer.reset(e.playerPrefab),this._gamePlayer.show()},_onAnalyze:function(){if(!m.getDeveloperFlag("marketAnalysis")){c.play("negate",0);return}c.play("open",0);var e=m.getEditGame(),t=m.getGameAnalysisCost(e),n=m.getDeveloper(),r=this._confirmAnalysis;r.setCost(t,n.money),r.show()},_onShare:function(e){var t=m.getGamesList(),n=t[m.data.editGameIndex];if(!n.tested){c.play("negate",0);return}var r={game:m.encodeGame(n),developer:m.data.developer,version:i.version};i.pirates&&(r.pirated=!0);var s=JSON.stringify(r),o=btoa(s),u=encodeURIComponent(o),a="http://www.indiegamesim.com/share/",f=a+"?code="+u;if(e){var l="https://twitter.com/intent/tweet?text=";f=l+"I made a game, go play it! "+f}if(window.nw){c.play("select",0);var h=nw.Clipboard.get();h.set(f,"text"),this._reward.show()}else c.play("select",0),window.open(f),console.dir(f)},_polishDraw:function(){if(m.data.editTileKey)var e=m.data.editTileKey;else var e=m.data.editEntityKey;var t=B[e],n=this.levelRenderer._pawnContainer,i=this._reticle,s=new r({parent:n,compositeOperation:"screen",image:"media/images/ui.png",overlayColor:D.getColor(t||"red"),width:16,height:16,z:999999});s.centerOn(i),s.tween({opacity:0,scale:2},250,null,function(){s.dispose()});var o=g[e];if(o){var u=new b({parent:n,text:"$"+o,z:9999});u.shrinkwrap(),u.centerOn(i,0,a.range(-8,-16)),u.tween({opacity:0,y:u.y-8})}},_removeEntitiesByTile:function(e,t){var n=!1,r=this.level,i=r.map,s=r.getEntitiesByTile(e,t);for(var o=0,u=s.length;o<u;++o){var a=s[o];n=a.type,r.despawnEntity(a)}return n},_scroll:function(e,t,n){this._inputActive=!1;var r=this.level,i=r.camera,s=128*(n/1e3);i.x+=e*s,i.y+=t*s,this.minimap.ping(r,i),this._reticle.hide(),this.parallax.update(r,this.levelRenderer)},_onRewardOK:function(){c.play("done",0),this._reward.hide()}});t.defaults={backgroundColor:D.getColor("black"),musicKey:"holdPlease"}}),n("js/view/Fan",["require","exports","module","djinn/view/View","djinn/math/random"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random");n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.imageX=80+i.range(0,5)*8,this.imageY=64+i.range(0,5)*8},startHop:function(){this._hopTimer||(this._hopTimer=this.createTimer(0,"_onHopTimer")),this._hopTimer.start(i.range(200,500))},_onHopTimer:function(){this.completeTween();var e=this.y;this.tween({y:e-2},100).tween({y:e},100)}}),t.defaults={image:"media/images/actors.png",width:8,height:8}}),n("js/view/scenes/FinalBossScene",["require","exports","module","djinn/view/View","djinn/math/random","djinn/utils/Pattern","djinn/audio/jukebox","./Scene","../../gameData","../Screenshot","../Typer","../Doubt","../Fan","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=e("djinn/utils/Pattern"),o=e("djinn/audio/jukebox"),u=e("./Scene"),a=e("../../gameData"),f=e("../Screenshot"),l=e("../Typer"),c=e("../Doubt"),h=e("../Fan"),p=e("../style"),d=[{x:5},{x:16,y:2},{x:42,y:2},{x:54},{x:78},{flipX:!0,x:150},{flipX:!0,x:172},{flipX:!0,x:178,y:2},{flipX:!0,x:190,y:2},{flipX:!0,x:222}],t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this.on("inputStart",this,"_onInputStart"),(new s({parent:this,tileConf:{image:"media/images/finalFloor.png",width:24,height:32},width:this.width,height:32})).align(null,"bottom"),this._fans=new r({parent:this,y:109}),this.darkness=new r({parent:this,image:"media/images/credits.png",opacity:.75}),this._heartContainer=new r({parent:this,y:4}),this._screenshotStrip=new r({parent:this});var e=this.titan=new c({parent:this});e.align("center","bottom",0,-26),e.playAnimation("idle"),this._ready=(new l({parent:this})).align("center","bottom",0,-4),this.overlay=new r({parent:this,backgroundColor:p.getColor("white")}),this.sortChildren()},reset:function(e){this._ready.completeTween({opacity:0}),this.titan.playAnimation("idle");var t=10,n=5,s=a.data.developer,o=a.getPublishedGamesByDeveloper(s);o.sort(function(e,t){return t.deaths-e.deaths}),o.length>t&&(o=o.slice(0,t)),this.intro=e==="doubt"||!e,this.intro?(a.enableFinalBoss=!0,a.finalBossIndex=0,a.finalBossHearts=n):e==="level"&&(a.died?a.finalBossHearts-=1:a.finalBossIndex+=1),this.lost=a.died&&a.finalBossHearts<1,this.won=!a.died&&a.finalBossIndex>=t;var u=this._heartContainer;u.disposeChildren();var l=this._screenshotStrip;l.disposeChildren(),l.completeTween();var c=this._fans;c.disposeChildren();var v=d.concat();this._firstScreenshotWidth=0,o.reverse();var m=0;for(var g=0;g<o.length;++g){var y=o[g];g===a.finalBossIndex&&(a.data.gameIndex=y.gameIndex);var b=y.tiles,w=new f({parent:l,x:m,width:b[0].length*2,height:b.length*2});w.setGame(y),m+=w.width+8,g<a.finalBossIndex&&(w.overlayColor=p.getColor("black",.9)),this._firstScreenshotWidth||(this._firstScreenshotWidth=w.width)}l.shrinkwrap(),l.align(null,"center");for(var g=0;g<n;++g){if(g<a.finalBossHearts)var E=96,S=0;else var E=64,S=80;var x=new r({parent:u,image:"media/images/actors.png",imageX:E,imageY:S,x:u.center.x+g*20-20*n/2,y:4,width:16,height:16});a.died&&g===a.finalBossHearts&&(this.heart=new r({parent:u,image:"media/images/actors.png",imageX:96,imageY:0,x:u.center.x+g*20-20*n/2,y:4,width:16,height:16}))}for(var g=0;g<a.finalBossHearts*2;++g){var T=new h({parent:c}),N=i.choice(v,!0);T.set(N)}if(this.intro)l.right=this.center.x+w.width/2;else{if(a.died)var w=this._screenshotStrip.children[a.finalBossIndex];else var w=this._screenshotStrip.children[a.finalBossIndex-1];l.x=this.center.x-w.center.x}l.children.forEach(function(e){e.align(null,"center")}),this.overlay.completeTween({opacity:0})},activate:function(e,t){this._super(e,t),this.captureInputEvents=!1;if(this.intro){this.delayTween(500,bind(this,function(){o.play("clear",0),this._screenshotStrip.tween({x:this.center.x-this._firstScreenshotWidth/2},2e3,null,bind(this,function(){this.ready("Ready?")}))}));return}if(a.died)this.delayTween(500,bind(this,function(){o.play("choice1",0),this.shake(),this.lost?this.titan.playAnimation("celebrate"):this.titan.playAnimation("happy"),this.heart.completeTween({overlayColor:p.getColor("white")}).tween({opacity:0},1e3,null,bind(this,function(){this.lost?this.ready("Game Over"):this.ready("Ready?")}))}));else if(this.won)this.titan.playAnimation("sad"),this._fans.children.forEach(function(e){e.startHop()}),this.delayTween(500,bind(this,function(){o.play("increase",0),this.ready("Success!")}));else{this.titan.playAnimation("bothered");var n=this._screenshotStrip.children[a.finalBossIndex],r=this._screenshotStrip;this.delayTween(500,bind(this,function(){o.play("add",0),r.tween({x:this.center.x-n.center.x},500,null,bind(this,function(){this.ready("Ready?")}))}))}},deactivate:function(e,t){e!=="level"&&this._super(e,t)},cleanup:function(e,t){e!=="level"&&this._super(e,t)},ready:function(e){o.play("open",0),this.captureInputEvents=!0,this.parent.mouse.show(),this._ready.text=e,this._ready.shrinkwrap(),this._ready.align("center"),this._ready.tween({opacity:1},500)},tick:function(e){if(!this.captureInputEvents)return;(this.getInput("action",!0)||this.getInput("negate",!0))&&this._onInputStart()},_onInputStart:function(){if(!this.captureInputEvents)return;this.captureInputEvents=!1;if(this.lost){o.play("dud",0),a.died=!1,a.enableFinalBoss=!1,this.overlay.completeTween({opacity:1}).tween({opacity:0},500,null,bind(this,function(){this.fireSceneEvent("computer")}));return}if(this.won){o.play("choice2",0),a.died=!1,a.enableFinalBoss=!1,this.overlay.completeTween({opacity:1}).tween({opacity:0},500,null,bind(this,function(){a.setDeveloperFlag("doubtKey","ending"),this.fireSceneEvent("doubt")}));return}o.play("choice2",0),this.overlay.completeTween({opacity:1}).tween({opacity:0},500,null,bind(this,function(){a.died=!1,this.fireSceneEvent("level")}))}});t.defaults={backgroundColor:p.getColor("blue"),musicKey:"fusionFactory"}}),n("djinn/utils/DataStore",["require","exports","module","../Emitter","./storage","./object"],function(e,t,n){var r=e("../Emitter"),i=e("./storage"),s=e("./object"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.key=e.key,this.saveDelay=e.saveDelay,this._saveTimeout=null,this.load(),e.defaults&&(this.defaults=e.defaults,this.data=merge(this.data,e.defaults))},load:function(){if(this.key){var e=i.getObject(this.key);this.data=e||{}}else this.data={}},save:function(){if(!this.key)return;this._saveTimeout&&clearTimeout(this._saveTimeout),this._saveTimeout=setTimeout(bind(this,"_save"),this.saveDelay)},set:function(e,t){this.data[e]=t,this.save(),this.fire("set:"+e,[t])},get:function(e,t){var n=this.data[e];return n!==undefined?n:t},toggle:function(e){this.set(e,!this.get(e))},increment:function(e,t){var t=t||1,n=this.get(e,0);this.set(e,n+t)},restoreDefaults:function(e){if(!this.defaults)return;var t=s.clone(this.defaults);for(var n in t)(!e||n===e)&&this.set(n,t[n])},_save:function(){i.setObject(this.key,this.data)}});t.defaults={key:null,saveDelay:1e3}}),n("js/settings",["require","exports","module","djinn/client","djinn/manifest","djinn/utils/DataStore"],function(e,t,n){var r=e("djinn/client"),i=e("djinn/manifest"),s=e("djinn/utils/DataStore"),t=n.exports=new s({key:i.shortName+"_settings",defaults:{fullscreen:!0,soundVolume:.5,musicVolume:.5,keyBinds:{moveUp:["w"],moveDown:["s"],moveLeft:["a"],moveRight:["d"],action:["space"],negate:["escape"]},analogDeadZoneLeft:.2,gamepadBinds:{action:"face1",negate:"start"}}});r.on("fullscreenChange",function(e){t.set("fullscreen",e)})}),n("js/view/scenes/GamepadScene",["require","exports","module","djinn/utils/intl","djinn/manifest","djinn/view/View","djinn/audio/jukebox","djinn/input/gamepad","./Scene","../../gameData","../../settings","../Typer","../Starfield","../BackButton","../Scrollbar","../Slider","../avatarFactory","../style"],function(e,t,n){var r=e("djinn/utils/intl"),i=e("djinn/manifest"),s=e("djinn/view/View"),o=e("djinn/audio/jukebox"),u=e("djinn/input/gamepad"),a=e("./Scene"),f=e("../../gameData"),l=e("../../settings"),c=e("../Typer"),h=e("../Starfield"),p=e("../BackButton"),d=e("../Scrollbar"),v=e("../Slider"),m=e("../avatarFactory"),g=e("../style"),y=u.buttons,b=["start","select","face1","face2","face3","face4"],t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new h({parent:this});var e=new p({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),new c({parent:this,text:"Gamepad",color:"silver",x:24,y:8}),new c({parent:this,text:"-------",x:24,y:16}),this._window=new s({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:32,width:240,height:104}),this._container=new s({parent:this._window,acceptInputEvents:!0});var t=this._scrollbar=(new d({parent:this._window,barColor:g.getColor("black"),width:8})).align("right");t.attach(this._container);var n="playerBenzer";i.pirates?n="pirate":f.hasRolledCredits()&&(n="playerRaga");var r=this.avatar=m.create(n,{parent:this});r.playAnimation("walk"),this.sortChildren()},reset:function(){this.avatar.align("center","bottom",0,-8),this._targetKey=null,this._populate()},tick:function(e){if(!this.captureInputEvents)return;if(this._targetKey){var t=null;for(var n=0,r=b.length;n<r;++n){var i=b[n],s=y[i];if(u.isButtonDown(s,!0)){var t=i;break}}if(!t)return;o.play("set",0);var a=l.get("gamepadBinds");a[this._targetKey]=t,u.bind(a),l.set("gamepadBinds",a),l.save(),this._targetKey=null,this._populate(),u.clearButtons(t);return}this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e);var f=this.avatar;this.getInput("left")?(f.x-=64*e/1e3,f.flipX||o.play("trash1",0),f.flipX=!0):this.getInput("right")&&(f.x+=64*e/1e3,f.flipX&&o.play("trash2",0),f.flipX=!1)},_populate:function(){var e=this._container;e.disposeChildren();var t=l.get("gamepadBinds"),n=0;for(var i in t){var o=t[i],u=new s({parent:e,acceptInputEvents:!0,y:n,height:8});u.key=i,u.on("inputStart",this,"_onKeySelect");var a=new c({parent:u,text:r.get(i),color:"silver"}),a=new c({parent:u,text:i===this._targetKey?"press any button":o,x:128});n+=16}var f=new c({parent:e,text:"Dead zone",color:"silver",y:n}),h=new v({parent:e,x:128,y:n,width:64,height:8});h.setValue(l.get("analogDeadZoneLeft")),h.on("change",this,"_onDeadZoneChange"),n+=16;var f=new c({parent:e,text:"Reset",acceptInputEvents:!0,y:n});f.on("inputStart",this,"_onReset"),e.shrinkwrap(),this._scrollbar.reset()},_onKeySelect:function(e){o.play("open",!0),this._targetKey=e.target.key,this._populate()},_onDeadZoneChange:function(e,t){if(e>t)o.play("backspace1",0);else{if(!(e<t))return;o.play("type1",0)}l.set("analogDeadZoneLeft",e),u.analogDeadZoneLeft=l.get("analogDeadZoneLeft"),l.save()},_onReset:function(){o.play("remove",0),l.restoreDefaults("gamepadBinds"),u.bind(l.get("gamepadBinds")),l.restoreDefaults("analogDeadZoneLeft"),u.analogDeadZoneLeft=l.get("analogDeadZoneLeft"),this._populate()},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)}});t.defaults={backgroundColor:g.getColor("black"),musicKey:"streets"}}),n("js/view/SuperTyper",["require","exports","module","djinn/view/View","./Typer"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Typer"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=e.text,r=new i({parent:this,text:n,color:"black",x:1,y:1});r.shrinkwrap();var s=new i({parent:this,text:n,color:e.color});s.shrinkwrap(),this.width=n.length*8,r.align("center","center",1,1),s.align("center","center"),e.bgText===!1&&r.hide()},reset:function(){this.completeTween()},flash:function(){this.completeTween({opacity:1,visible:!0});for(var e=0;e<4;++e)this.delayTween(250,bind(this,function(){this.opacity=this.opacity?0:1}));this.tween({opacity:0},1e3,r.transitions.easeIn,bind(this,function(){this.visible=!1}))}});t.defaults={imageSmoothingEnabled:!1,height:8,scale:2}}),n("js/view/scenes/ImpactScene",["require","exports","module","djinn/view/View","djinn/math/random","djinn/view/shapes/Pinwheel","djinn/manifest","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../Starfield","../SuperTyper","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=e("djinn/view/shapes/Pinwheel"),o=e("djinn/manifest"),u=e("djinn/audio/jukebox"),a=e("./Scene"),f=e("../../gameData"),l=e("../Typer"),c=e("../Starfield"),h=e("../SuperTyper"),p=e("../style"),d=["red","green","blue","orange","purple"],v="UNLOCK",m="NEW TOOLS",t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults)),this.elapsed=0,this._index=0},setup:function(){this._super(),(new h({parent:this,text:v,bgText:!1,z:2})).align("center","center",0,-16),(new h({parent:this,text:m,bgText:!1,z:2})).align("center","center",0,16),this.sortChildren()},activate:function(e,t){this._super(e,t),this.bgText(v,"black",0,-16,6,6),this.bgText(m,"black",0,16,6,6),this.bgText(v,"black",0,-16,4,4),this.bgText(m,"black",0,16,4,4),this.bgText(v,"black",0,-16,2,2),this.bgText(m,"black",0,16,2,2),this.sortChildren()},bgText:function(e,t,n,r,i,s){var o=500,u=(new h({parent:this,text:e,color:t})).align("center","center",n,r),a=u.x,f=u.y;u.x=a+i,u.y=f+s;for(var l=0;l<2;++l)u.tween({x:a-i},o).tween({y:f-s},o).tween({x:a+i},o).tween({y:f+s},o)},tick:function(e){this.elapsed+=e,this.elapsed>250&&(this.elapsed=0,console.log(d[this._index]),this.backgroundColor=p.getColor(d[this._index]),this._index++,this._index>=d.length&&(this._index=0))}});t.defaults={backgroundColor:p.getColor("red")}}),n("js/view/scenes/KeyboardScene",["require","exports","module","djinn/utils/intl","djinn/view/View","djinn/audio/jukebox","djinn/input/keyboard","./Scene","../../gameData","../../settings","../Typer","../Starfield","../BackButton","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/utils/intl"),i=e("djinn/view/View"),s=e("djinn/audio/jukebox"),o=e("djinn/input/keyboard"),u=e("./Scene"),a=e("../../gameData"),f=e("../../settings"),l=e("../Typer"),c=e("../Starfield"),h=e("../BackButton"),p=e("../Scrollbar"),d=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new c({parent:this});var e=new h({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),new l({parent:this,text:"Keyboard",color:"silver",x:24,y:8}),new l({parent:this,text:"--------",x:24,y:16}),this._window=new i({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:32,width:240,height:104}),this._container=new i({parent:this._window,acceptInputEvents:!0});var t=this._scrollbar=(new p({parent:this._window,barColor:d.getColor("black"),width:8})).align("right");t.attach(this._container),o.on("keyDown",this,"_onKeyDown"),this.sortChildren()},reset:function(){this._targetKey=null,this._populate()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_populate:function(){var e=this._container;e.disposeChildren();var t=f.get("keyBinds"),n=0;for(var s in t){var o=t[s][0],u=new i({parent:e,acceptInputEvents:!0,y:n,height:8});u.key=s,u.on("inputStart",this,"_onKeySelect");var a=new l({parent:u,text:r.get(s),color:"silver"}),a=new l({parent:u,text:s===this._targetKey?"press any key":o,x:128});n+=16}var c=new l({parent:e,text:"Reset",acceptInputEvents:!0,y:n});c.on("inputStart",this,"_onReset"),e.shrinkwrap(),this._scrollbar.reset()},_onKeySelect:function(e){s.play("open",!0),this._targetKey=e.target.key,this._populate()},_onKeyDown:function(e){if(!this._targetKey)return;s.play("set",0);var t=f.get("keyBinds"),n=o.getKeyAliasByCode(e);t[this._targetKey]=[n],o.bind(t),f.set("keyBinds",t),f.save(),this._targetKey=null,this._populate(),o.clearKeys(e)},_onReset:function(){s.play("remove",0),f.restoreDefaults("keyBinds"),o.bind(f.get("keyBinds")),this._populate()},_onQuit:function(){s.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)}});t.defaults={backgroundColor:d.getColor("black"),musicKey:"streets"}}),n("js/view/Query",["require","exports","module","djinn/view/View","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./Typer"),s=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults))},navigate:function(e,t){this._selectedIndex},setOptions:function(e){this.disposeChildren(),this._optionX=0,this._optionY=0,this._options=[];for(var t=0,n=e.length;t<n;++t)this._addOption(e[t].text,t);this._selectedIndex=0,this.cursor=new r({parent:this,image:"media/images/ui.png",imageX:32,width:16,height:16}),this._updateCursor()},select:function(){this.fire(this._options[this._selectedIndex].index)},_addOption:function(e,t){var n=(new i({parent:this,text:e,acceptInputEvents:!0,width:~~(this.width/2),x:this._optionX,y:this._optionY})).on("inputPress",this,function(){this.fire("select",[t])});n.index=t,this._optionY+=8,this._optionY>=this.height&&(this._optionX+=~~(this.width/2),this._optionY=0),this._options.push(n)},_updateCursor:function(){this.cursor.x=this._options[this._selectedIndex].x+4,this.cursor.y=this._options[this._selectedIndex].y-4}}),t.defaults={acceptInputEvents:!0,width:192,height:16}}),n("js/view/Transition",["require","exports","module","djinn/view/View","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("./style");n.exports=r.extend({init:function(e){this._super(e),this._left=new r({parent:this,backgroundColor:i.getColor("black")}),this._right=new r({parent:this,backgroundColor:i.getColor("black")})},animate:function(e,t){this.show(),this._left.completeTween({width:0}).tween({width:this.width/2},250,null,e).tween({width:0},250,null,t),this._right.completeTween({x:this.width}).tween({x:this.width/2},250).tween({x:this.width},250)}})}),n("js/view/scenes/LevelScene",["require","exports","module","djinn/view/View","djinn/achievements","djinn/audio/jukebox","djinn/utils/string","djinn/sim/shared/position","./Scene","../../sim/Level","../../gameData","../../unlocks","../LevelRenderer","../Menu","../Dialog","../Query","../Typer","../SuperTyper","../Transition","../Starfield","../Darkness","../Reward","../Parallax","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/audio/jukebox"),o=e("djinn/utils/string"),u=e("djinn/sim/shared/position"),a=e("./Scene"),f=e("../../sim/Level"),l=e("../../gameData"),c=e("../../unlocks"),h=e("../LevelRenderer"),p=e("../Menu"),d=e("../Dialog"),v=e("../Query"),m=e("../Typer"),g=e("../SuperTyper"),y=e("../Transition"),b=e("../Starfield"),w=e("../Darkness"),E=e("../Reward"),S=e("../Parallax"),x=e("../style"),T=1,t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults)),this._input={},this.musicId=null,this.timeTrackId=null},setup:function(){this._super(),this.parallax=new S({parent:this}),this.levelRenderer=new h({parent:this}),this.darkness=new w({parent:this}),this.menu=(new p({parent:this})).align("center","center"),this.menu.on("close",this,"_onMenuClose"),this.menu.on("quit",this,"_onMenuQuit");var e=this.dialog=(new d({parent:this,acceptInputEvents:!0})).align("center","bottom",0,-8);e.on("done",this,"_onDialogDone");var t=this.query=(new v({parent:e})).align(null,"bottom",0,-8);t.on("select",this,"_onQuerySelect"),this.time=(new m({parent:this,anchorX:.5,width:40})).align("center","top",0,4);var n=this._reward=(new E({parent:this})).align("center","center");n.on("ok",this,"_onRewardOK"),this.trans=new y({parent:this});var r=this._bossText=new g({parent:this,text:"BOSS GAME!"});r.align("center","center",0,-32),this.sortChildren()},reset:function(){this._super();if(l.codeData)var e=l.codeData.game;else{var t=l.getGamesList(),n=l.data;if(l.playtest)var e=t[n.editGameIndex];else var e=t[n.gameIndex]}this.loadMap(e);if(l.playtest){var r=this.level,i=r.createEntity("funWatcher");r.spawnEntity(i)}this.menu.hide(),this.dialog.hide(),this.query.hide(),this._reward.hide(),this.trans.hide(),this._bossText.reset(),this._bossText.hide(),this.parent.mouse.hide(),this.dialogData=null,this.dialogIndex=null,this.playtestData={left:0,right:0,jump:0},this.elapsed=0,this._updateTime(),this.sortChildren()},activate:function(e,t){var n=this.game.boss;l.enableFinalBoss?this.musicKey="fusionFactory":n?this.musicKey="flux":this.musicKey="corridor",this._super(e,t),n&&l.showBossText&&(this._bossText.flash(),l.showBossText=!1),this.levelRenderer.paused=!1,this.level.start(),this.level.fire("activate")},deactivate:function(e,t){this.game.player?this.timeTrackId="playtest":this.timeTrackId="research",this._super(e,t)},loadMap:function(e,t,n){this.game=e,this.level&&this.level.dispose();var r=this.levelRenderer;r.detach();var i=this.level=new f;i.on("entityDamage",this,"_onEntityDamage"),i.on("entityDie",this,"_onEntityDie"),i.on("goal",this,"_onGoal"),i.on("entityCollect",this,"_onEntityCollect"),i.on("entitySpawn",this,"_onEntitySpawn"),i.on("goalOpen",this,"_onGoalOpen"),i.on("dialog",this,"_onDialog"),i.on("lightToggle",this,"_onLightToggle");if(t===undefined||n===undefined)t=8,n=4;var s=i.loadMap(e,t,n,!0);r.attach(i);var o="media/images/env.png";l.enableFinalBoss&&(o="media/images/envBlack.png"),r.mapRenderer.tileImage=o,i.reset(),e.backgroundColor&&(this.backgroundColor=x.fromRGBArray(e.backgroundColor)),l.enableFinalBoss&&(this.backgroundColor=x.getColor("silver"));var u=this.darkness;u.level=i,e.darkness?(u.opacity=e.darkness,u.visible=!0):u.visible=!1,i.updateCamera(),r.updateCamera(),this.parallax.update(i,r);var a=e.musicId;a?this.playMusic(a):a===!1&&this.stopMusic()},playMusic:function(e){if(this.musicId){if(e===this.musicId)return;s.stop(this.musicId)}this.musicId=e,s.play(e,0)},stopMusic:function(){this.musicId&&s.stop(this.musicId)},tick:function(e){if(!this.captureInputEvents)return;var t=this.level;t.running&&(this.elapsed+=e,this._updateTime()),this.query.visible?this._handleQuery():this.dialog.visible?this._handleDialog():this._reward.visible?this._handleReward():this.menu.visible?this._handleMenu():this._handleInput(),t.update(e),this.parallax.update(t,this.levelRenderer)},cleanup:function(e,t){this._super(e,t),this.musicId&&(s.stop(this.musicId),this.musicId=null),this.levelRenderer.detach()},_fail:function(){var e=this.level;if(!e.running)return;e.stop(),this.levelRenderer.paused=!0,this.completeTween().delayTween(500,bind(this,function(){if(l.playtest){l.playtest=!1,l.setGameTestState(l.data.editGameIndex,!1),l.camera={x:e.camera.x,y:e.camera.y};var t=l.getGamesList();t[l.data.editGameIndex].deaths+=1,l.save()}l.enableFinalBoss&&(l.died=!0,this.oldSceneId="finalBoss"),this.fireSceneEvent(this.oldSceneId)}))},_handleQuery:function(){var e=this.query;this.getInput("left",!0)?e.navigate(-1,0):this.getInput("right",!0)&&e.navigate(1,0),this.getInput("up",!0)?e.navigate(0,-1):this.getInput("down",!0)&&e.navigate(0,1),this.getInput("action",!0)&&e.select()},_handleDialog:function(){this.getInput("action",!0)&&(this.dialog.advance()||this._advanceDialog())},_handleReward:function(){this.getInput("negate",!0)&&this._onRewardOK()},_handleMenu:function(){this.getInput("negate",!0)&&this._hideMenu()},_handleInput:function(){var e=this.level;this.getInput("negate",!0)&&(s.play("select",0),e.stop(),this.menu.reset(),this.menu.show(),this.levelRenderer.paused=!0,this.parent.mouse.show());var t=e.player,n=t.control;n.x=0,n.y=0;var r=this.playtestData,i=this._input;this.getInput("left")?(n.x=-1,r.left++):this.getInput("right")&&(n.x=1,r.right++),t.gravity||(this.getInput("up")?n.y=-1:this.getInput("down")&&(n.y=1)),this.getInput("action",!0)&&(r.jump++,e.playerAction())},_hideMenu:function(){s.play("play",0),this.menu.hide(),this.levelRenderer.paused=!1,this.level.start(),this.parent.mouse.hide()},_onDialog:function(e){this.dialogData=e,this.dialogIndex=0,this.level.stop(),this._parseDialog()},_onLightToggle:function(){this.darkness.visible=!this.darkness.visible},_onEntityDamage:function(e,t,n){e.type==="boss"&&n.type==="shellLights"&&i.trackProgress("goldenBoy",1)},_onEntityDie:function(e){e.meta.role==="player"&&this._fail()},_onEntityCollect:function(){s.play("collect"+T,0),T=T===1?2:1},_onEntitySpawn:function(e){e.type==="explosion"?(s.play("explosion"+T,0),T=T===1?2:1):e.type==="survey"?(s.play("survey"+T,0),T=T===1?2:1):e.type==="banner"&&(s.play("banner"+T,0),T=T===1?2:1)},_onGoalOpen:function(){s.play("unlock",0)},_onDialogDone:function(){this.dialog.hide(),this.query.hide(),this.level.start(),this.parent.mouse.hide()},_onGoal:function(e){var t=this.level;if(!t.running)return;t.stop(),s.play("success",0),this.levelRenderer.paused=!0;if(l.playtest){var n=l.data.editGameIndex;l.playtest=!1,l.setGameTime(n,this.elapsed),l.setGameTestState(n,!0),l.setGamePlaytestData(n,this.playtestData),l.setGameSurvey(n,this.level),l.camera={x:t.camera.x,y:t.camera.y}}else if(l.codeData)var r=!1;else if(l.enableFinalBoss)var r=!1;else var i=l.data.gameIndex,r=l.checkBestTime(i,this.elapsed);this.completeTween().delayTween(500,bind(this,function(){this._finish(r)}))},_onQuerySelect:function(e){this.query.hide();var t=this.dialogData[this.dialogIndex],n=t.query[e].select;n?n():this._onDialogDone()},_onMenuClose:function(){this._hideMenu()},_onMenuQuit:function(){s.play("remove",0),this.captureInputEvents=!1,l.playtest&&(l.editing=!0,l.camera={x:this.level.camera.x,y:this.level.camera.y}),l.enableFinalBoss&&(l.enableFinalBoss=!1,this.oldSceneId="computer"),this.fireSceneEvent(this.oldSceneId)},_onRewardOK:function(){s.play("done",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)},_advanceDialog:function(){++this.dialogIndex,this.dialogData[this.dialogIndex]?this._parseDialog():(this.dialog.hide(),this.level.start(),this.parent.mouse.hide())},_parseDialog:function(){var e=this.dialogData[this.dialogIndex];e.text?(this.dialog.animate(e.text),this.dialog.show()):e.query&&(this.parent.mouse.hide(),this.query.setOptions(e.query),this.query.show())},_finish:function(e){var t=this.game.unlockId,n=c[t];n&&!l.getDeveloperFlag(t)?(s.play("unlock",0),l.developerUnlockById(t),this._reward.setHeader("UNLOCKED!"),this._reward.setContentConf(n.avatar),this._reward.show(),this.parent.mouse.show(),l.hasDeveloperBeatAllGames()&&i.trackProgress("expertPlayer",1)):e?(s.play("increase",0),this._reward.setHeader("New Best Time"),this._reward.setContentText(o.formatTime(this.elapsed,2)),this._reward.show(),this.parent.mouse.show()):this.fireSceneEvent(this.oldSceneId)},_updateTime:function(){var e=this.time;e.text=o.formatTime(this.elapsed,2),e.shrinkwrap(),e.align("center")}});t.defaults={backgroundColor:x.getColor("blue")}}),n("js/view/DeveloperWindow",["require","exports","module","djinn/view/View","djinn/math/core","djinn/utils/string","djinn/utils/object","./Typer","../gameData","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("djinn/utils/string"),o=e("djinn/utils/object"),u=e("./Typer"),a=e("../gameData"),f=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults)),(new r({parent:this,backgroundColor:f.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center"),this._header=new u({parent:this,color:"silver",x:8,y:8});var n=(new u({parent:this,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-8,8);n.on("inputPress",this,"_onClose"),this._container=new r({parent:this,acceptInputEvents:!0})},reset:function(){var e=this._container;e.disposeChildren();var t=a.getDevelopers(),n=o.getLength(t);this._header.text=s.sprintf("Developers (%s)",n);var r=0;for(var i in t){var f=24+r++*8,l=t[i].gamesList,c=0;l.forEach(function(e){e.player&&c++});var h=new u({parent:e,text:s.sprintf("%s (%s)",i,c),acceptInputEvents:!0,x:16,y:f,width:144});h.developer=i,h.on("inputPress",this,"_onItemSelect");var p=new u({parent:e,text:"X",acceptInputEvents:!0,x:this.width-24,y:f,width:8});p.developer=i,p.on("inputPress",this,"_onItemRemove")}},_onClose:function(){this.fire("close")},_onItemSelect:function(e){this.fire("select",[e.target.developer])},_onItemRemove:function(e){this.fire("remove",[e.target.developer])}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:f.getColor("white"),width:192,height:96}}),n("js/view/scenes/LoginScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/sim/shared/position","./Scene","../../sim/Level","../../gameData","../Menu","../Dialog","../Typer","../DeveloperWindow","../TextBox","../Confirmation","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/sim/shared/position"),o=e("./Scene"),u=e("../../sim/Level"),a=e("../../gameData"),f=e("../Menu"),l=e("../Dialog"),c=e("../Typer"),h=e("../DeveloperWindow"),p=e("../TextBox"),d=e("../Confirmation"),v=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=(new r({parent:this,acceptInputEvents:!0,image:"media/images/window.png",width:240,height:112})).align("center","center"),t=this.addQuitX();e.addChild(t),t.align("right","top",-3,4),new c({parent:e,text:"Welcome",x:4,y:4});var n=new r({parent:e,acceptInputEvents:!0,y:24,height:12});n.on("inputPress",this,"_onList");var i=(new r({parent:n,image:"media/images/ui.png",imageX:16,imageY:80,x:8,width:8,height:8})).align(null,"center");(new c({parent:n,text:"Login",acceptInputEvents:!0,color:"black",x:i.right+8})).align(null,"center");var s=new r({parent:e,acceptInputEvents:!0,y:n.bottom,height:12});s.on("inputPress",this,"_onNew");var o=(new r({parent:s,image:"media/images/ui.png",imageX:24,imageY:80,x:8,width:8,height:8})).align(null,"center");this._createText=(new c({parent:s,text:"Create Account",acceptInputEvents:!0,color:"black",x:i.right+8})).align(null,"center");var u=this._developerWindow=(new h({parent:this})).align("center","center");u.on("close",this,"_onDeveloperWindowClose"),u.on("select",this,"_onDeveloperWindowSelect"),u.on("remove",this,"_onDeveloperWindowRemove");var a=this._developerName=(new p({parent:this})).align("center","center");a.setHeaderText("Developer Name"),a.on("done",this,"_onDeveloperNameDone"),a.on("close",this,"_onDeveloperNameClose");var f=this._confirmation=(new d({parent:this})).align("center","center");f.on("confirm",this,"_onConfirmDelete"),f.on("cancel",this,"_onConfirmCancel"),f.setHeader("Really delete?"),f.setConfirmButton("DELETE!");var l=this.addSettingsGear();l.on("inputStart",this,"_onSettings"),this.sortChildren()},reset:function(){this._super(),this._developerWindow.hide(),this._developerName.hide(),this._confirmation.hide(),this._updateMakeNewDeveloper()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&(this._confirmation.visible?this._onConfirmCancel():this._developerWindow.visible?this._onDeveloperWindowClose():this._developerName.visible?this._onDeveloperNameClose():this._onQuit())},_onNew:function(){a.canMakeNewDeveloper()?(i.play("open",0),this._developerName.reset(),this._developerName.show()):i.play("negate",0)},_onList:function(){i.play("open",0),this._developerWindow.reset(),this._developerWindow.show()},_onQuit:function(){i.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")},_onDeveloperWindowClose:function(){i.play("close",0),this._developerWindow.hide()},_onDeveloperWindowSelect:function(e){i.play("select",0),a.setDeveloper(e),this.captureInputEvents=!1,this.fireSceneEvent("play")},_onDeveloperWindowRemove:function(e){i.play("negate",0),this._removeDeveloper=e,this._confirmation.show()},_onConfirmDelete:function(){i.play("remove",0),a.removeDeveloper(this._removeDeveloper),this._confirmation.hide(),this._developerWindow.reset(),this._updateMakeNewDeveloper()},_onConfirmCancel:function(){i.play("negate",0),this._confirmation.hide()},_onDeveloperNameDone:function(e){a.addDeveloper(e)?(i.play("create",0),a.setDeveloper(e),a.publishCompetitor(),this.captureInputEvents=!1,this.fireSceneEvent("play")):i.play("negate",0)},_onDeveloperNameClose:function(){i.play("close",0),this._developerName.hide()},_onSettings:function(){i.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("settings")},_updateMakeNewDeveloper:function(){a.canMakeNewDeveloper()?this._createText.color="black":this._createText.color="gray"}});t.defaults={backgroundColor:"rgb(0, 128, 129)",musicKey:"funkBump"}}),n("js/view/scenes/MarketAllScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","./Scene","../../gameData","../GameListItem","../Typer","../BackButton","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("./Scene"),o=e("../../gameData"),u=e("../GameListItem"),a=e("../Typer"),f=e("../BackButton"),l=e("../Scrollbar"),c=e("../style"),t=n.exports=s.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=new f({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),new a({parent:this,text:"Browsing New Releases",x:24,y:8}),new a({parent:this,text:"on Vault",color:"silver",x:24,y:16}),new a({parent:this,text:"------------------------------",x:8,y:24});var t=new a({parent:this,text:"X",acceptInputEvents:!0,width:8,height:8});t.align("right","top",-4,4),t.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:96}),this._container=new r({parent:this._window,acceptInputEvents:!0});var n=this._scrollbar=(new l({parent:this._window,barColor:c.getColor("marketBG"),width:8})).align("right");n.attach(this._container)},reset:function(){this._super();var e=this._container;e.disposeChildren();var t=o.getPublishedGames(),n=0;for(var r=0,i=t.length;r<i;++r){var s=new u({parent:e,y:n});s.on("selectGame",this,"_onSelectGame"),s.on("selectDetails",this,"_onSelectDetails");var a=t[r];s.setGame(a),s.gameIndex=a.gameIndex,n+=s.height+8,(!a.bestTime||a.unlockId&&!o.getDeveloperFlag(a.unlockId))&&s.markAsUnplayed()}e.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onSelectGame:function(e){i.play("select",0),o.data.gameIndex=e,o.save(),this.captureInputEvents=!1,this.fireSceneEvent("game")},_onSelectDetails:function(e,t){i.play("select",0),o.data.profile=t,o.save(),this.captureInputEvents=!1,this.fireSceneEvent("profile")},_onQuit:function(){i.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")}});t.defaults={backgroundColor:c.getColor("marketBG"),musicKey:"streets"}}),n("js/view/scenes/MarketAnalysisScene",["require","exports","module","djinn/view/View","djinn/math/core","djinn/utils/string","djinn/audio/jukebox","djinn/input/keyboard","djinn/sim/shared/position","./Scene","../../sim/Level","../../gameData","../GameListItem","../Menu","../Dialog","../Typer","../TextBox","../Screenshot","../GameSettings","../ColorPicker","../Scrollbar","../Confirmation","../PlayerPicker","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("djinn/utils/string"),o=e("djinn/audio/jukebox"),u=e("djinn/input/keyboard"),a=e("djinn/sim/shared/position"),f=e("./Scene"),l=e("../../sim/Level"),c=e("../../gameData"),h=e("../GameListItem"),p=e("../Menu"),d=e("../Dialog"),v=e("../Typer"),m=e("../TextBox"),g=e("../Screenshot"),y=e("../GameSettings"),b=e("../ColorPicker"),w=e("../Scrollbar"),E=e("../Confirmation"),S=e("../PlayerPicker"),x=e("../style"),t=n.exports=f.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this.addQuitX("black");var e=0;e+=8,this._header=new v({parent:this,color:"black",x:8,y:e}),e+=8,new v({parent:this,text:"------------------------------",color:"silver",x:8,y:e}),e+=16,this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:32,width:240,height:104}),this._container=new r({parent:this._window,acceptInputEvents:!0});var t=this._scrollbar=(new w({parent:this._window,barColor:x.getColor("white"),cursorColor:x.getColor("gray"),width:8})).align("right");t.attach(this._container),this.sortChildren()},reset:function(){this._super();var e=this._container;e.disposeChildren();var t=c.data.editGameIndex,n=c.getGamesList(),o=n[t];this._header.text=o.name+" Market Analysis",this._addLine("Screenshot","black"),this._addLine();var u=new g({parent:e,x:0,y:this._y,width:o.tiles[0].length*2,height:o.tiles.length*2});u.setGame(o),this._y=u.bottom+8;var a=c.getGameAverageContentCount(o),f=c.getGameContentCount(o);this._addLine(s.sprintf("Content count: %s",f),"black"),this._addLine();if(f<a){var l=Math.round(a-f);this._addLine(s.sprintf("- Consider adding %s objects",l),"red")}else this._addLine(s.sprintf("+ Good amount of content"),"green");this._addLine(),o.darkness>0?this._addLine(s.sprintf("+ Good lighting effects"),"green"):(this._addLine(s.sprintf("- Consider adding lighting"),"red"),this._addLine(s.sprintf("  effects (it looks cool)"),"red")),this._addLine(),c.isDefaultColor(o.backgroundColor)?(this._addLine(s.sprintf("- Consider changing the"),"red"),this._addLine(s.sprintf("  background color"),"red")):this._addLine(s.sprintf("+ Good background coloring"),"green"),this._addLine(),o.playerPrefab==="playerDog"?(this._addLine(s.sprintf("- Consider changing dog,"),"red"),this._addLine(s.sprintf("  it is OVERPLAYED!"),"red")):this._addLine(s.sprintf("+ Good player for market"),"green"),this._addLine();var h=c.getAverageGameUniqueContentCount(),p=c.getGameUniqueContentCount(o),d=i.clamp(p/h,0,1),v=Math.round(d*100);p<h?(this._addLine(s.sprintf("- %s% unique to this market.",v),"red"),this._addLine(s.sprintf("  Consider investing in more"),"red"),this._addLine(s.sprintf("  game dev tools."),"red")):(this._addLine(s.sprintf("+ %s% unique to this market.",v),"green"),this._addLine(s.sprintf("  Very unique!"),"green")),this._addLine(),this._addLine("Playtesting","black"),this._addLine();if(o.playtestData){var m=c.getAverageGameJoyCount(),y=i.clamp(o.joyCount/m,0,1),b=Math.round(y*100);o.joyCount<m?(this._addLine(s.sprintf("- Fun factor: %s",o.joyCount),"red"),this._addLine(s.sprintf("  Market average: %s",Math.round(m)),"red"),this._addLine(s.sprintf("  Consider more excitement!"),"red")):(this._addLine(s.sprintf("+ Fun factor: %s",o.joyCount),"green"),this._addLine(s.sprintf("  Market average: %s",Math.round(m)),"green"),this._addLine(s.sprintf("  Great job!"),"green")),this._addLine();var w=c.getAverageGameSurveyArea(),E=i.clamp(o.surveyArea/w,0,1),S=i.round(o.surveyArea*100,0),x=Math.round(w*100);if(o.surveyArea<w){var T=o.surveyArea/w;this._addLine(s.sprintf("- Only exploring %s% of game",S),"red"),this._addLine(s.sprintf("  Market average: %s%",x),"red"),this._addLine(s.sprintf("  Offer more gameplay."),"red")}else this._addLine(s.sprintf("+ Exploring %s% of game",S),"green"),this._addLine(s.sprintf("  Market average: %s%",x),"green"),this._addLine(s.sprintf("  Excellent gameplay!"),"green");this._addLine(),this._addLine("Summary","black"),this._addLine();var N=c.getGameRating(o),C=i.round(N*100,0);this._addLine(s.sprintf("We estimate a %s% rating.",C),"gray")}else this._addLine("- Game has not been tested,","red"),this._addLine("  consider testing!","red");this._addLine(),this._addLine("----------------------------","gray"),this._addLine();var k=this._addLine("   Thank you for patronizing","gray"),L=c.getDeveloperFlag("marketAnalysisCount",1);this._addLine(s.sprintf("   Tiger Hat Marketing (%s)",L),"black"),new r({parent:e,image:"media/images/objects.png",imageX:16,imageY:96,x:k.x,y:k.y,width:16,height:16}),e.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("edit")}});t.defaults={backgroundColor:x.getColor("white"),musicKey:"holdPlease"}}),n("js/view/scenes/MarketGameScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/math/core","djinn/utils/string","./Scene","../../gameData","../GameListItem","../Typer","../BackButton","../Screenshot","../avatarFactory","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/math/core"),o=e("djinn/utils/string"),u=e("./Scene"),a=e("../../gameData"),f=e("../GameListItem"),l=e("../Typer"),c=e("../BackButton"),h=e("../Screenshot"),p=e("../avatarFactory"),d=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=new c({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),this._container=new r({parent:this,acceptInputEvents:!0}),this.sortChildren()},reset:function(){this._super(),this._button=null;var e=this._container;e.disposeChildren();var t=new f({parent:e,x:24,y:8});new l({parent:e,text:"------------------------------",x:8,y:24});var n=a.data.gameIndex,i=a.getGameByIndex(n);t.setGame(i);var u=(new l({parent:e,text:"Rating:",color:"silver",x:8,y:40})).shrinkwrap();new l({parent:e,text:s.round(i.rating*100,2)+"%",x:u.right+8,y:u.y});var u=(new l({parent:e,text:"Owners:",color:"silver",x:8,y:48})).shrinkwrap();new l({parent:e,text:o.formatNumber(i.sales),x:u.right+8,y:u.y});var c=new h({parent:e,x:8,y:64,width:i.tiles[0].length*2,height:i.tiles.length*2});c.setGame(i);var p=c.bottom+8,d=new l({parent:e,text:"Read reviews",acceptInputEvents:!0,x:8,y:p});d.shrinkwrap(),d.underline(),d.on("inputStart",this,"_onReviews");if(i.player){p+=16;var v=new l({parent:e,text:"View analytics",acceptInputEvents:!0,x:8,y:p});v.shrinkwrap(),v.underline(),v.on("inputStart",this,"_onAnalytics")}var m=this._button=new r({parent:e,acceptInputEvents:!0,image:"media/images/ui.png",imageY:34,x:160,y:40,width:54,height:14});m.on("inputStart",this,"_onButton"),this._buttonText=new l({parent:e});var u=new l({parent:e,text:"Your Best Time",color:"silver"});u.shrinkwrap(),u.centerOn(m,0,24);var g=i.bestTime,y=new l({parent:e,text:g?o.formatTime(g,2):"N/A"});y.shrinkwrap(),y.centerOn(u,0,16),this._updateButton()},activate:function(e,t){this.parent.mouse.show();var n=this.oldSceneId;this._super(e,t);if(e==="level"||e==="reviews"||e==="analytics")this.oldSceneId=n;e!=="level"&&(a.showBossText=!0)},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate")&&this._onQuit(),this.getInput("action",!0)&&this._onButton()},_onButton:function(){var e=a.data.gameIndex,t=a.getGameByIndex(e);t.player||a.developerBoughtGame(e)?(i.play("play",0),this.captureInputEvents=!1,this.fireSceneEvent("play")):a.developerCanAffordGame(e)?(i.play("increase",0),a.developerBuyGame(e),this._updateButton()):i.play("negate",0)},_onReviews:function(){i.play("select",0),a.data.analyticsIndex=a.data.gameIndex,a.save(),this.captureInputEvents=!1,this.fireSceneEvent("reviews")},_onAnalytics:function(){i.play("select",0),a.data.analyticsIndex=a.data.gameIndex,a.save(),this.captureInputEvents=!1,this.fireSceneEvent("analytics")},_onQuit:function(){i.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId||"market")},_updateButton:function(){var e=a.data.gameIndex,t=a.developerBoughtGame(e),n=a.getGameByIndex(e);this._button.imageX=0,!n.player&&!t&&!a.developerCanAffordGame(e)&&(this._button.imageX=this._button.width);var r=this._buttonText;if(n.player||t)r.text="Play";else{var n=a.getGameByIndex(e);r.text="$"+n.price}r.shrinkwrap(),r.centerOn(this._button)}});t.defaults={backgroundColor:d.getColor("marketBG"),musicKey:"streets"}}),n("js/view/scenes/MarketScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/utils/string","./Scene","../../gameData","../GameListItem","../Typer","../TyperBadge","../Scrollbar","../Screenshot","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/utils/string"),o=e("./Scene"),u=e("../../gameData"),a=e("../GameListItem"),f=e("../Typer"),l=e("../TyperBadge"),c=e("../Scrollbar"),h=e("../Screenshot"),p=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new r({parent:this,image:"media/images/objects.png",imageX:16,imageY:0,x:4,y:8,width:16,height:16}),new f({parent:this,text:"Welcome to Vault",x:24,y:8}),new f({parent:this,text:"The #1 online game store",color:"silver",x:24,y:16}),new f({parent:this,text:"--------------------------",x:8,y:24});var e=new f({parent:this,text:"X",acceptInputEvents:!0,width:8,height:8});e.align("right","top",-4,4),e.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:80}),this._container=new r({parent:this._window,acceptInputEvents:!0});var t=this._scrollbar=(new c({parent:this._window,barColor:p.getColor("marketBG"),width:8})).align("right");t.attach(this._container);var n=this._developers=new f({parent:this,text:"Developer Account",acceptInputEvents:!0,x:8,y:128});n.shrinkwrap(),n.on("inputStart",this,"_onDevelopers")},reset:function(){this._super();var e=this._developers;u.developerHasGameReadyToPublish()?e.color="gold":e.color="silver",e.underline();var t=this._container;t.disposeChildren();var n=u.getTopGames();(new f({parent:t,text:s.sprintf("Best Sellers (%s)",n.length),acceptInputEvents:!0})).on("inputStart",this,"_onTop").shrinkwrap();var i=u.getPublishedGames();if(u.developerShouldPlayGames()){var o="gold",a="     Releases (%s)";new l({parent:t,text:"NEW!",y:16})}else var o="white",a="New Releases (%s)";(new f({parent:t,text:s.sprintf(a,i.length),color:o,acceptInputEvents:!0,y:16})).on("inputStart",this,"_onAll").shrinkwrap();var c=new r({parent:t,acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:p.getColor("silver"),x:152,y:0,width:80,height:72});new r({parent:t,backgroundColor:p.getColor("marketBG"),x:c.x+1,y:c.y+1,width:c.width-2,height:c.height-2}),new f({parent:t,text:"Featured",color:"gold",x:160,y:8});var d=new h({parent:t,x:160,y:24,width:64,height:36}),v=n[0];d.setGame(v),c.gameIndex=v.gameIndex,c.on("inputStart",this,"_onSelectGame"),t.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onSelectGame:function(e){i.play("select",0),u.data.gameIndex=e.target.gameIndex,u.save(),this.captureInputEvents=!1,this.fireSceneEvent("game")},_onTop:function(e){i.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("top")},_onAll:function(e){i.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("all")},_onDevelopers:function(e){i.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("developers")},_onQuit:function(){i.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")}});t.defaults={backgroundColor:p.getColor("marketBG"),musicKey:"streets"}}),n("js/view/scenes/MarketTopScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","./Scene","../../gameData","../GameListItem","../Typer","../BackButton","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("./Scene"),o=e("../../gameData"),u=e("../GameListItem"),a=e("../Typer"),f=e("../BackButton"),l=e("../Scrollbar"),c=e("../style"),t=n.exports=s.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=new f({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),new a({parent:this,text:"Browsing Best Sellers",color:"gold",x:24,y:8}),new a({parent:this,text:"on Vault!",color:"silver",x:24,y:16}),new a({parent:this,text:"------------------------------",x:8,y:24});var t=new a({parent:this,text:"X",acceptInputEvents:!0,width:8,height:8});t.align("right","top",-4,4),t.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:96}),this._container=new r({parent:this._window,acceptInputEvents:!0});var n=this._scrollbar=(new l({parent:this._window,barColor:c.getColor("marketBG"),width:8})).align("right");n.attach(this._container)},reset:function(){this._super();var e=this._container;e.disposeChildren();var t=o.getTopGames(),n=0;for(var r=0,i=t.length;r<i;++r){var s=new u({parent:e,y:n});s.on("selectGame",this,"_onSelectGame"),s.on("selectDetails",this,"_onSelectDetails");var a=t[r];s.setGame(a),s.gameIndex=a.gameIndex,n+=s.height+8,(!a.bestTime||a.unlockId&&!o.getDeveloperFlag(a.unlockId))&&s.markAsUnplayed()}e.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onSelectGame:function(e){i.play("select",0),o.data.gameIndex=e,o.save(),this.captureInputEvents=!1,this.fireSceneEvent("game")},_onSelectDetails:function(e,t){i.play("select",0),o.data.profile=t,o.save(),this.captureInputEvents=!1,this.fireSceneEvent("profile")},_onQuit:function(){i.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")}});t.defaults={backgroundColor:c.getColor("marketBG"),musicKey:"streets"}}),n("js/view/scenes/NewsScene",["require","exports","module","djinn/view/View","djinn/manifest","djinn/utils/string","djinn/math/random","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/manifest"),s=e("djinn/utils/string"),o=e("djinn/math/random"),u=e("djinn/audio/jukebox"),a=e("./Scene"),f=e("../../gameData"),l=e("../Typer"),c=e("../Scrollbar"),h=e("../style"),p="----------------------------",d=["Things you'll like","No real-world news","Reading is good","Insert slogan here"],t=n.exports=a.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new r({parent:this,image:"media/images/objects.png",imageX:64,x:4,y:8,width:16,height:16}),new l({parent:this,text:"News Reader",color:"black",x:24,y:8}),this._slogin=new l({parent:this,color:"gray",x:24,y:16}),new l({parent:this,text:p,color:"black",x:8,y:24});var e=new l({parent:this,text:"X",acceptInputEvents:!0,color:"black",width:8,height:8});e.align("right","top",-4,4),e.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:80}),this._container=new r({parent:this._window,acceptInputEvents:!0});var t=this._scrollbar=(new c({parent:this._window,barColor:h.getColor("white"),cursorColor:h.getColor("silver"),width:8})).align("right");t.attach(this._container)},reset:function(){this.parent.mouse.show(),this._super(),this._slogin.text=o.choice(d);var e=this._container;e.disposeChildren();var t=f.data.developer;if(f.developerHasPublishedGames()||f.getDeveloperFlag("stats"))this._addStats(),this._addLine(),this._addLine(p,"black"),this._addLine();var n=f.hasDeveloperBoughtSomething();if(n||f.getDeveloperFlag("market"))this._addMarket(),this._addLine(),this._addLine(p,"black"),this._addLine();var r=f.getGamesByDeveloper(t);if(r.length>0||f.getDeveloperFlag("store"))this._addStore(),this._addLine(),this._addLine(p,"black"),this._addLine();this._addDev(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit();var t=this._scrollbar;this.getInput("down")?t.scroll(1,e):this.getInput("up")&&t.scroll(-1,e)},_addDev:function(){var e=f.getDeveloperFlag("dev"),t=e?"silver":"black",n=this._addLine("Make the Game",t),i=this._addLine("of Your Dreams",t);this._addLine(),new r({parent:this._container,image:"media/images/objects.png",imageX:112,imageY:16,overlayColor:e?h.getColor("silver"):undefined,x:n.x,y:n.y,width:16,height:16}),n.x+=24,i.x+=24;var t=e?"silver":"gray";this._addLine("Anyone can now make their",t),this._addLine("very own games using the",t),this._addLine("new Djinn Game Editor.",t),this._addLine("Get started, developer!",t),this._addLine();var t=e?"silver":"green",s=this._addLine("Install Game Editor",t);s.underline(),s.on("inputStart",this,bind(this,function(){e?u.play("error",0):this._install("dev")}))},_addStore:function(){var e=f.getDeveloperFlag("store"),t=e?"silver":"black",n=this._addLine("Amazing Store",t),i=this._addLine("Open for Business",t);this._addLine(),new r({parent:this._container,image:"media/images/objects.png",imageX:112,imageY:0,overlayColor:e?h.getColor("silver"):undefined,x:n.x,y:n.y,width:16,height:16}),n.x+=24,i.x+=24;var t=e?"silver":"gray";this._addLine("The Amazing Store is now",t),this._addLine("open for business. Here you",t),this._addLine("can purchase anything from",t),this._addLine("home furnishings to game dev",t),this._addLine("tools. Visit today!",t),this._addLine();var t=e?"silver":"green",s=this._addLine("Install Store App",t);s.underline(),s.on("inputStart",this,bind(this,function(){e?u.play("error",0):this._install("store")}))},_addMarket:function(){var e=f.getDeveloperFlag("market"),t=e?"silver":"black",n=this._addLine("Sell Your Games on Vault,",t),i=this._addLine("the #1 online retailer",t);this._addLine(),new r({parent:this._container,image:"media/images/objects.png",imageX:16,imageY:0,overlayColor:e?h.getColor("silver"):undefined,x:n.x,y:n.y,width:16,height:16}),n.x+=24,i.x+=24;var t=e?"silver":"gray";this._addLine("Developers can now upload",t),this._addLine("their finished, tested",t),this._addLine("games to the Vault market.",t),this._addLine("Install and get started!",t),this._addLine();var t=e?"silver":"green",s=this._addLine("Install Vault",t);s.underline(),s.on("inputStart",this,bind(this,function(){e?u.play("negate",0):this._install("market")}))},_addStats:function(){var e=f.getDeveloperFlag("stats"),t=e?"silver":"black",n=this._addLine("Track Your Stats",t),i=this._addLine("For Great Justice",t);this._addLine(),new r({parent:this._container,image:"media/images/objects.png",imageX:80,imageY:32,overlayColor:e?h.getColor("silver"):undefined,x:n.x,y:n.y,width:16,height:16}),n.x+=24,i.x+=24;var t=e?"silver":"gray";this._addLine("The Stats app is now",t),this._addLine("available. How quickly can",t),this._addLine("you do stuff? Happy running!",t),this._addLine();var t=e?"silver":"green",s=this._addLine("Install Stats",t);s.underline(),s.on("inputStart",this,bind(this,function(){e?u.play("negate",0):this._install("stats")}))},_install:function(e){u.play("create",0),f.newApp=e,f.setDeveloperFlag(e,!0),this.captureInputEvents=!1,this.fireSceneEvent("computer")},_onQuit:function(){u.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("computer")}});t.defaults={backgroundColor:h.getColor("white"),musicKey:"streets"}}),n("djinn/ViewCollection",["djinn/Collection"],function(e){return e.extend({remove:function(e,t,n){typeof e.removeFromParent!="function"&&(e=this.get(e));if(!e)return;n||e.removeFromParent(),this._super(e,t)}})}),n("js/view/Rain",["require","exports","module","djinn/view/View","djinn/math/random","djinn/audio/jukebox"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/random"),s=e("djinn/audio/jukebox");n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this._rainTimer=this.createTimer(100,"_onRainTimer")},reset:function(){this._rainTimer.stop(),this.disposeChildren()},start:function(e){this.count=e,this._rainTimer.start(),this._onRainTimer()},_onRainTimer:function(){this.toggle=!this.toggle,s.play("profit"+(this.toggle?"1":"2"),0),--this.count<1&&this._rainTimer.stop();var e=new r({parent:this,image:"media/images/ui.png",imageX:80,imageY:48,width:16,height:8});e.x=i.range(0,this.width-e.width),e.y=-(e.height+1),e.tween({y:this.height},2e3,null,function(){e.dispose()})}}),t.defaults={}}),n("js/view/Fans",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/math/random"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/math/random");n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this._fanTimer=this.createTimer(1,"_onFanTimer")},reset:function(){this._fanTimer.stop(),this.disposeChildren()},start:function(e){this.count=e,this._fanTimer.start(),this._onFanTimer()},_onFanTimer:function(){this.toggle=!this.toggle,i.play("fan"+(this.toggle?"1":"2"),0),this._fanTimer.start(s.range(50,200)),--this.count<1&&this._fanTimer.stop();var e=new r({parent:this,image:"media/images/actors.png",x:0,width:8,height:8});this.negative?(e.imageX=64+s.range(0,1)*8,e.imageY=64):(e.imageX=80+s.range(0,5)*8,e.imageY=64+s.range(0,5)*8),e.tween({x:this.width},5e3,null,function(){e.dispose()})}}),t.defaults={height:8}}),n("js/view/scenes/PartyScene",["require","exports","module","djinn/view/View","djinn/achievements","djinn/manifest","djinn/ViewCollection","djinn/client","djinn/utils/string","djinn/math/core","djinn/view/shapes/Pinwheel","djinn/audio/jukebox","./Scene","../../gameData","../../players","../Typer","../SuperTyper","../Screenshot","../Rain","../Fans","../style","../avatarFactory"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/manifest"),o=e("djinn/ViewCollection"),u=e("djinn/client"),a=e("djinn/utils/string"),f=e("djinn/math/core"),l=e("djinn/view/shapes/Pinwheel"),c=e("djinn/audio/jukebox"),h=e("./Scene"),p=e("../../gameData"),d=e("../../players"),v=e("../Typer"),m=e("../SuperTyper"),g=e("../Screenshot"),y=e("../Rain"),b=e("../Fans"),w=e("../style"),E=e("../avatarFactory"),t=n.exports=h.extend({init:function(e){this._super(merge(e,t.defaults)),this._players=new o,this._flashTimer=this.createTimer(0,"_onFlashTimer")},setup:function(){this._super(),this.pinwheel=(new l({parent:this,fillColor:null,rayColor:w.getColor("white",.2),rayRotationSpeed:1e-4})).align("center","center"),this._screenshot=new g({parent:this}),this.overlay=new r({parent:this,backgroundColor:w.getColor("black")}),this._rain=new y({parent:this}),this._fans=new b({parent:this,y:112});var e=this._subtitle=(new v({parent:this,text:"Release Party",y:24})).shrinkwrap().align("center"),t=this._ratingContainer=new r({parent:this,height:8,x:8,y:64}),n=(new v({parent:t,text:"Rating:",color:"silver"})).shrinkwrap();this._ratingValue=new v({parent:t,x:n.right+8});var i=this._profitContainer=new r({parent:this,height:8,x:8,y:80}),s=(new v({parent:i,text:"Profit:",color:"silver"})).shrinkwrap();this._profitValue=new v({parent:i,x:s.right+8});var o=this._fansContainer=new r({parent:this,height:8,x:8,y:96}),u=(new v({parent:o,text:"New fans:",color:"silver"})).shrinkwrap();this._fansValue=new v({parent:o,x:u.right+8});var a=this._button=(new r({parent:this,acceptInputEvents:!0,image:"media/images/ui.png",imageY:34,width:54,height:14})).align("center");a.on("inputStart",this,"_onDone");var f=new v({parent:a,acceptInputEvents:!0,text:"OK"});f.shrinkwrap(),f.align("center","center"),this.sortChildren()},reset:function(){this._super();var e=p.data.analyticsIndex,t=p.getGamesList(),n=this.game=t[e];this.overlay.completeTween({opacity:0});var r=n.backgroundColor;this.pinwheel.fillColor=a.sprintf("rgb(%s, %s, %s)",r[0],r[1],r[2]);var i=this._screenshot;i.setGame(n),i.backgroundColor="rgba(0, 0, 0, 0)",i.redrawBuffer();var s=n.tiles,o=s[0].length,u=s.length,f=Math.floor(this.width/o)||1,l=Math.floor(this.height/u)||1;i.width=o*f,i.height=u*l,i.align("center","center"),this._rain.reset(),this._fans.reset(),this._ratingContainer.hide(),this._profitContainer.hide(),this._fansContainer.hide(),this._header&&this._header.dispose();var c=this._header=this._makeSuperText(n.name);c.align("center"),c.bottom=-8,this._subtitle.completeTween({opacity:0}),this.movePlayers=!0,this._players.removeAll();var h=0,d=Math.round(n.rating*100);n.rating>.6&&(h+=1),this._ratingValue.text=d+"%",this._ratingValue.color=w.getColorFromNormal(n.rating);var v=n.net-n.devCost;this._rainCount=Math.floor(v/500),v>0&&(h+=1),this._profitValue.text="$"+a.formatMoney(v),this._profitValue.color=v>0?"green":"red";var m=n.newFans;this._newFans=Math.ceil(m/10)||1,this._fansValue.text=a.formatNumber(m),this._fansValue.color=m>0?"green":"red",this.positiveResult=h>1,this._button.completeTween({y:this.height})},activate:function(e,t){this._super(e,t);if(s.pirates)var n=["pirate","playerBird","pirate","playerBoy","pirate"];else var n=p.getPlayerPrefabs();this.delayTween(1e3,bind(this,function(){this.overlay.tween({opacity:.85}),this._header.tween({y:8},1e3,null,bind(this,function(){this._subtitle.tween({opacity:1});for(var e=0;e<n.length;++e){var t=E.create(n[e],{parent:this,right:-16-e*32,y:40});t.playAnimation("walk"),this._players.add(t)}this._players.length>=8&&i.trackProgress("partyAnimal",!0),this.delayTween(1e3,bind(this,function(){c.play("reveal",0),this._ratingContainer.show(),this.delayTween(1e3,bind(this,function(){c.play("reveal",0),this._profitContainer.show(),this._rainCount>0&&this._rain.start(this._rainCount),this.delayTween(1e3,bind(this,function(){c.play("reveal",0),this._fansContainer.show(),this._newFans>0?(this._fans.negative=!1,this._fans.start(this._newFans)):this._newFans<0&&(this._fans.negative=!0,this._fans.start(-this._newFans)),this.delayTween(1e3,bind(this,function(){this.positiveResult?(c.play("increase",0),this._players.forEach(function(e){e.playAnimation("celebrate")})):(c.play("dud",0),this.movePlayers=!1,this._players.forEach(function(e){e.showDamage()})),this._button.tween({bottom:this.height-4},500)}))}))}))}))}))})),this._flashTimer.start(500)},tick:function(e){if(!this.captureInputEvents)return;if(!this.movePlayers)return;var t=e/1e3,n=this.width;this._players.forEach(function(e){e.x+=32*t,e.x>n&&(e.right=0)})},_makeSuperText:function(e){var t=new r({parent:this,imageSmoothingEnabled:!1,scale:2,height:10}),n=[{x:-1,y:0},{x:1,y:0},{x:0,y:-1},{x:0,y:1}];for(var i=0,s=n.length;i<s;++i){var o=n[i];(new v({parent:t,text:e,color:"black"})).shrinkwrap().align("center","center",o.x,o.y)}return(new v({parent:t,text:e,y:16})).shrinkwrap().align("center","center"),t},_onFlashTimer:function(){var e=this.pinwheel,t=1;e.rayRotationSpeed=f.lerp(.002,1e-4,t),this._flashTimer.start(500*t)},_onDone:function(){c.play("start",0),this.captureInputEvents=!1,this.fireSceneEvent("analytics")}});t.defaults={backgroundColor:w.getColor("black"),musicKey:"streets"}}),n("js/view/scenes/ProfileScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/utils/string","./Scene","../../gameData","../GameListItem","../Typer","../BackButton","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/utils/string"),o=e("./Scene"),u=e("../../gameData"),a=e("../GameListItem"),f=e("../Typer"),l=e("../BackButton"),c=e("../Scrollbar"),h=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this._header=new f({parent:this,x:24,y:8}),new f({parent:this,text:"Developer Profile",color:"silver",x:24,y:16}),new f({parent:this,text:"------------------------",x:8,y:24}),this._fans=new f({parent:this,color:"silver",x:24,y:32});var e=new l({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:48,width:240,height:88}),this._container=new r({parent:this._window,acceptInputEvents:!0});var t=this._scrollbar=(new c({parent:this._window,barColor:h.getColor("marketBG"),width:8})).align("right");t.attach(this._container)},reset:function(){this._super();var e=u.data.profile,t=u.getFansByProfile(e);this._fans.text="Fans: "+s.formatNumber(t),this._header.text=e;var n=this._container;n.disposeChildren();var r=u.getPublishedGamesByDeveloper(e),i=0;for(var o=0,f=r.length;o<f;++o){var l=new a({parent:n,y:i});l.on("selectGame",this,"_onSelectGame");var c=r[o];l.setGame(c),l.gameIndex=c.gameIndex,i+=l.height+8}n.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},activate:function(e,t){var n=this.oldSceneId;this._super(e,t),e==="marketGame"&&(this.oldSceneId=n)},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onSelectGame:function(e){i.play("select",0),u.data.gameIndex=e,this.captureInputEvents=!1,this.fireSceneEvent("marketGame")},_onQuit:function(){i.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId||"market")}});t.defaults={backgroundColor:h.getColor("marketBG"),musicKey:"streets"}}),n("js/view/scenes/PropertyScene",["require","exports","module","djinn/view/View","djinn/utils/string","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/string"),s=e("djinn/audio/jukebox"),o=e("./Scene"),u=e("../../gameData"),a=e("../Typer"),f=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),this._ground=(new r({parent:this,height:32})).align(null,"bottom"),(new r({parent:this,image:"media/images/property.png",imageY:112,height:32})).align(null,"bottom"),this._container=new r({parent:this}),this._rec=(new r({parent:this,image:"media/images/ui.png",imageX:16,imageY:88,width:8,height:8})).align("left","top",8,8),(new a({parent:this,text:"REC"})).shrinkwrap().align("left","top",20,8),this._time=new a({parent:this}),this._filter=new r({parent:this,compositeOperation:"overlay",opacity:.75,image:"media/images/filter.png"}),this.addQuitX(),this._filterTimer=this.createTimer(3e3,"_onFilterTimer"),this._filterTimer.start(),this._onFilterTimer(),this._recTimer=this.createTimer(500,"_onRECTimer"),this._recTimer.start(),this._onRECTimer()},reset:function(){this.parent.mouse.show();var e=this._container;e.disposeChildren(),u.getDeveloperFlag("rlTower")&&new r({parent:e,image:"media/images/property.png",imageX:16,imageY:64,width:32,height:48,x:16,y:64}),u.getDeveloperFlag("rlAirship")&&new r({parent:e,image:"media/images/property.png",imageX:64,imageY:16,width:32,height:32,x:64,y:16}),u.getDeveloperFlag("rlGarage")&&new r({parent:e,image:"media/images/property.png",imageX:64,imageY:80,width:32,height:32,x:64,y:80}),u.getDeveloperFlag("rlMotorcycle")&&new r({parent:e,image:"media/images/property2.png",imageX:64,imageY:104,width:16,height:8,x:64,y:104}),u.getDeveloperFlag("rlCar")&&new r({parent:e,image:"media/images/property2.png",imageX:80,imageY:104,width:16,height:8,x:80,y:104}),u.getDeveloperFlag("rlHouse")?new r({parent:e,image:"media/images/property.png",imageX:112,imageY:96,width:32,height:16,x:112,y:96}):new r({parent:e,image:"media/images/property2.png",imageX:0,imageY:16,width:16,height:16,x:120,y:96}),u.getDeveloperFlag("rlTree")&&(new r({parent:e,image:"media/images/property2.png",imageX:144,imageY:16,width:96,height:96,x:144,y:16}),u.getDeveloperFlag("rlBeehive")&&new r({parent:e,image:"media/images/property.png",imageX:160,imageY:32,width:16,height:16,x:160,y:32})),u.getDeveloperFlag("rlChopperPad")&&(new r({parent:e,image:"media/images/property.png",imageX:160,imageY:96,width:32,height:16,x:160,y:96}),u.getDeveloperFlag("rlChopper")&&new r({parent:e,image:"media/images/property.png",imageX:160,imageY:80,width:32,height:16,x:160,y:80})),u.getDeveloperFlag("rlWaterslide")&&new r({parent:e,image:"media/images/property.png",imageX:208,imageY:48,width:32,height:64,x:208,y:48}),this.backgroundColor=f.getColor("silver"),this._ground.backgroundColor=f.getColor("gray"),this._updateTime()},tick:function(e){if(!this.captureInputEvents)return;this._updateTime(),this.getInput("negate",!0)&&this._onQuit()},_onFilterTimer:function(){this._filter.completeTween().tween({opacity:.5},1500).tween({opacity:.75},1500)},_onRECTimer:function(){this._rec.visible=!this._rec.visible},_onQuit:function(){s.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)},_updateTime:function(){var e=new Date,t=this._time;t.text=i.sprintf("%s:%s:%s",e.getHours(),i.padLeft(e.getMinutes(),"0",2),i.padLeft(e.getSeconds(),"0",2)),t.shrinkwrap(),t.align("right","bottom",-8,-8)}});t.defaults={backgroundColor:f.getColor("black"),musicKey:"streets"}}),n("djinn/view/shapes/Rectangle",["require","exports","module","../View","../utils/canvas"],function(e,t,n){var r=e("../View"),i=e("../utils/canvas"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),this.fillColor=e.fillColor,this.strokeColor=e.strokeColor,this.strokeWidth=e.strokeWidth,this.borderRadius=e.borderRadius},render:function(e){i.drawRect(e,0,0,this.width,this.height,this.fillColor,this.strokeColor,this.strokeWidth,this.borderRadius)}});t.defaults={buffer:!0,bufferPadding:10,width:100,height:100,fillColor:"white",strokeColor:null,strokeWidth:1,borderRadius:0}}),n("js/view/scenes/PromoScene",["require","exports","module","djinn/view/View","djinn/view/Sprite","djinn/view/shapes/Rectangle","djinn/math/random","djinn/view/shapes/Pinwheel","djinn/manifest","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../Starfield","../Dialog","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/view/Sprite"),s=e("djinn/view/shapes/Rectangle"),o=e("djinn/math/random"),u=e("djinn/view/shapes/Pinwheel"),a=e("djinn/manifest"),f=e("djinn/audio/jukebox"),l=e("./Scene"),c=e("../../gameData"),h=e("../Typer"),p=e("../Starfield"),d=e("../Dialog"),v=e("../style"),t=n.exports=l.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new r({parent:this,image:"media/images/promo/bg.png"}),this._title=(new r({parent:this,image:"media/images/promo/title.png",width:112,height:9,bottom:-1})).align("center"),this._cta=(new r({parent:this,image:"media/images/promo/dec8.png",width:81,height:9,y:this.height})).align("center"),this._titan=(new i({parent:this,animations:{idle:{frameRate:2,frames:[[0,32],[16,32]]}},image:"media/images/actors.png",opacity:0,y:30,width:16,height:16})).align("center").playAnimation("idle"),this._reticle=(new s({parent:this,buffer:!1,fillColor:null,opacity:0,strokeColor:v.getColor("yellow"),strokeWidth:2,width:28,height:28})).centerOn(this._titan),this.sortChildren()},activate:function(e,t){this._super(e,t);var n=this._titan.center,r={x:this._reticle.x,y:this._reticle.y,width:28,height:28};this.completeTween().delayTween(500,bind(this,function(){this._title.tween({y:6},500,null,bind(this,function(){this.parent.mouse.completeTween({x:n.x+16,y:n.y+32,visible:!0}).tween({x:r.x,y:r.y},500,null,bind(this,function(){this._reticle.completeTween({opacity:1,width:1,height:1}).tween({width:28,height:28},750).delayTween(500).tween({opacity:0},250)})).tween({x:r.x+r.width,y:r.y+r.height},750,null,bind(this,function(){this._titan.tween({opacity:1},250)})).delayTween(250).tween({x:this.width},250)})),this._cta.tween({bottom:this.height-4},500)}))},tick:function(e){if(!this.captureInputEvents)return}});t.defaults={backgroundColor:v.getColor("black")}}),n("js/view/scenes/PublishedGamesScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","djinn/math/core","djinn/utils/string","./Scene","../../gameData","../GameListItem","../Typer","../BackButton","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("djinn/math/core"),o=e("djinn/utils/string"),u=e("./Scene"),a=e("../../gameData"),f=e("../GameListItem"),l=e("../Typer"),c=e("../BackButton"),h=e("../Scrollbar"),p=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new l({parent:this,text:"Vaultworks Sales Analytics",x:24,y:8}),new l({parent:this,text:"Your games, your money",color:"silver",x:24,y:16}),new l({parent:this,text:"---------------------------",x:8,y:24});var e=new c({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:96}),this._container=new r({parent:this._window,acceptInputEvents:!0,y:40});var t=this._scrollbar=(new h({parent:this._window,barColor:p.getColor("marketBG"),width:8})).align("right");t.attach(this._container),this.sortChildren()},reset:function(){this._super();var e=this._container;e.disposeChildren();var t=a.getPublishedGamesByDeveloper(a.data.developer);if(t.length){var n=0;for(var r=0,i=t.length;r<i;++r){var s=new f({parent:e,y:n});s.on("selectGame",this,"_onSelectGame");var u=t[r];s.setGame(u),s.gameIndex=u.gameIndex,n+=s.height+8,s.addLabel("$"+o.formatMoney(u.net))}}else new l({parent:e,text:"No published games found",color:"silver",x:8,y:0});e.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onSelectGame:function(e){i.play("select",0),a.data.analyticsIndex=e,a.save(),this.captureInputEvents=!1,this.fireSceneEvent("analytics")},_onQuit:function(){i.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")}});t.defaults={backgroundColor:p.getColor("marketBG"),musicKey:"streets"}}),n("js/view/SelectBox",["require","exports","module","djinn/view/View","djinn/audio/jukebox","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("./Typer"),o=e("./style");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults)),this.prefix=e.prefix,(new r({parent:this,backgroundColor:o.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center");var n=this._header=new s({parent:this,text:"Set the price",color:"silver",anchorX:.5});n.shrinkwrap(),n.align("center","top",0,4);var i=(new s({parent:this,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-4,4);i.on("inputPress",this,"_onClose"),this._container=new r({parent:this,acceptInputEvents:!0,y:22});var u=this._done=new s({parent:this,text:"Save",acceptInputEvents:!0,anchorX:.5,width:32});u.align("center","bottom",0,-8),u.on("inputPress",this,"_onDone")},reset:function(e){this.value=e,this._done.color="gray";var t=this._container;t.disposeChildren();var n=this.options,r=12;for(var i=0,o=n.length;i<o;++i){var u=n[i],a=new s({parent:t,text:this.prefix+u.value,acceptInputEvents:!0,anchorX:.5,y:r});a.optionIndex=i,a.shrinkwrap(),a.align("center"),a.on("inputStart",this,"_onValueSelect"),u.value===e?(a.color="white",this._done.color="white"):u.enabled?a.color="silver":a.color="gray",a.value=u.value,r+=a.height*2}},setOptions:function(e){this.options=e,this.reset()},_onValueSelect:function(e){var t=e.target;if(this.options[t.optionIndex].enabled){i.play("select",0);var n=this.value=t.value;this.reset(n),this._done.color="white"}else i.play("negate",0)},_onDone:function(){if(this.value===null){i.play("negate",0);return}this.fire("done",[this.value])},_onClose:function(){this.fire("close")}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,backgroundColor:o.getColor("white"),prefix:"",width:192,height:112}}),n("js/view/scenes/PublishGameScene",["require","exports","module","djinn/view/View","djinn/utils/string","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../BackButton","../Screenshot","../SelectBox","../Confirmation","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/string"),s=e("djinn/audio/jukebox"),o=e("./Scene"),u=e("../../gameData"),a=e("../Typer"),f=e("../BackButton"),l=e("../Screenshot"),c=e("../SelectBox"),h=e("../Confirmation"),p=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new a({parent:this,text:"Vaultworks Publishing Tools",x:24,y:8});var e=new f({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),this._container=new r({parent:this,acceptInputEvents:!0,height:this.height-16,y:16});var t=this._priceBox=(new c({parent:this,prefix:"$"})).align("center","center");t.on("done",this,"_onPriceBoxDone"),t.on("close",this,"_onPriceBoxClose");var n=this._confirmation=(new h({parent:this})).align("center","center");n.on("confirm",this,"_onConfirmPublish"),n.on("cancel",this,"_onCancelPublish"),n.setHeader("Ready to publish?"),n.setConfirmButton("Publish"),this.sortChildren()},reset:function(){this._super(),this.price=null,this._confirmation.hide();var e=[{enabled:!0,value:4.99}];e.push({enabled:u.getDeveloperFlag("sizeMedium"),value:9.99}),e.push({enabled:u.getDeveloperFlag("sizeLarge"),value:14.99});var t=this._priceBox;t.hide(),t.setOptions(e);var n=this._container;n.disposeChildren();var r=u.data.publishGameIndex,s=u.getGamesList(),o=s[r],f=0;new a({parent:n,text:"Publish "+o.name,color:"silver",x:24,y:0}),f+=8,new a({parent:n,text:"------------------------------",x:8,y:8}),f+=16;var c=new l({parent:n,x:8,y:f,width:o.tiles[0].length*3,height:o.tiles.length*3});c.setGame(o),f+=c.height+8;var h=u.getDeveloperMoney(),p=new a({parent:n,text:"Your money",color:"silver",x:c.right+8,y:c.y}),d=(new a({parent:n,text:"$"+i.formatMoney(h),y:p.bottom+1})).shrinkwrap(),v=u.getGameTotalCost(o),m=(new a({parent:n,text:"Cost to publish",color:"silver",x:p.x,y:d.bottom+7})).shrinkwrap(),g=(new a({parent:n,text:"$"+i.formatMoney(v),color:h>=v?"green":"red",x:d.x,y:m.bottom+1})).shrinkwrap();d.right=m.right,g.right=m.right;var y=Math.max(c.bottom,g.bottom),b=this._priceTyper=new a({parent:n,text:"Price: (click to set)",acceptInputEvents:!0,x:8,y:y+8});b.on("inputStart",this,"_onPrice");var w=this._publishButton=new a({parent:n,text:"Publish",acceptInputEvents:!0,color:"gray"});w.shrinkwrap(),w.align("center","bottom",0,-8),w.on("inputStart",this,"_onPublish")},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&(this._confirmation.visible?this._onCancelPublish():this._priceBox.visible?this._onPriceBoxClose():this._onQuit())},_canAffordToPublish:function(){var e=u.data.publishGameIndex,t=u.getGamesList(),n=t[e],r=u.getGameTotalCost(n),i=u.getDeveloper();return i.money>=r},_onPriceBoxDone:function(e){s.play("start",0),this.price=e,this._priceTyper.text="Price: $"+e,this._canAffordToPublish()&&(this._publishButton.color="gold");var t=u.data.publishGameIndex;u.updateGamePrice(t,e),this._priceBox.hide()},_onPrice:function(){s.play("open",0),this._priceBox.reset(this.price),this._priceBox.show()},_onPriceBoxClose:function(){s.play("close",0),this._priceBox.hide()},_onPublish:function(){this.price===null||!this._canAffordToPublish()?s.play("negate",0):(s.play("open",0),this._confirmation.show())},_onConfirmPublish:function(){s.play("start",0),u.publishCompetitor();var e=u.data.publishGameIndex;u.publishGame(e);var t=u.getGamesList(),n=t[e],r=u.getGameTotalCost(n),i=u.getDeveloper();i.money-=r,u.save();var o=u.moveGameToEnd(e);u.data.analyticsIndex=o,u.save(),this.captureInputEvents=!1,this.fireSceneEvent("party")},_onCancelPublish:function(){s.play("negate",0),this._confirmation.hide()},_onQuit:function(){s.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)}});t.defaults={backgroundColor:p.getColor("marketBG"),musicKey:"streets"}}),n("js/view/scenes/ReviewsScene",["require","exports","module","djinn/view/View","djinn/math/core","djinn/utils/string","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../BackButton","../Screenshot","../Scrollbar","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/math/core"),s=e("djinn/utils/string"),o=e("djinn/audio/jukebox"),u=e("./Scene"),a=e("../../gameData"),f=e("../Typer"),l=e("../BackButton"),c=e("../Screenshot"),h=e("../Scrollbar"),p=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=8;this._gameName=new f({parent:this,x:24,y:e}),e+=8,new f({parent:this,text:"Reviews",color:"silver",x:24,y:e}),e+=8,this._br=new f({parent:this,text:"------------------------------",x:8,y:e}),e+=16;var t=new l({parent:this});t.align("left","top",4,8),t.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:96}),this._container=new r({parent:this._window,acceptInputEvents:!0});var n=this._scrollbar=(new h({parent:this._window,barColor:p.getColor("marketBG"),cursorColor:p.getColor("white"),width:8})).align("right");n.attach(this._container),this.sortChildren()},reset:function(){this._super();var e=a.data.analyticsIndex,t=a.getGamesList(),n=this.game=t[e],i=n.reviews;this._gameName.text=n.name;var s=this._container;s.disposeChildren();for(var o=0,u=i.length;o<u;++o){var f=i[o],l=this._addLine("   "+f.name,"silver");this._addLine("   "+f.text),this._addLine(),new r({parent:s,image:"media/images/ui.png",imageX:(f.reco?5:6)*16,x:l.x,y:l.y,width:16,height:16})}this._scrollbar.reset()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit();var t=this._scrollbar;this.getInput("down")?t.scroll(1,e):this.getInput("up")&&t.scroll(-1,e)},_onReviews:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("reviews")},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId||"marketGame")}});t.defaults={backgroundColor:p.getColor("marketBG"),musicKey:"streets"}}),n("js/view/scenes/SettingsScene",["require","exports","module","djinn/view/View","djinn/client","djinn/manifest","djinn/audio/jukebox","./Scene","../../gameData","../../settings","../Slider","../Typer","../Starfield","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/client"),s=e("djinn/manifest"),o=e("djinn/audio/jukebox"),u=e("./Scene"),a=e("../../gameData"),f=e("../../settings"),l=e("../Slider"),c=e("../Typer"),h=e("../Starfield"),p=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new h({parent:this}),new c({parent:this,text:"Settings v0.14",color:"silver",x:8,y:8}),new c({parent:this,text:"--------------",x:8,y:16}),this.addQuitX(),new c({parent:this,text:"Sound",color:"silver",x:8,y:32});var e=this._sounds=new l({parent:this,x:64,y:32,width:64,height:8});e.on("change",this,"_onSoundChange"),new c({parent:this,text:"Music",color:"silver",x:8,y:48});var t=this._music=new l({parent:this,x:64,y:48,width:64,height:8});t.on("change",this,"_onMusicChange"),(new c({parent:this,text:"Keyboard ...",acceptInputEvents:!0,x:8,y:64})).on("inputStart",this,"_onKeyboard"),(new c({parent:this,text:"Gamepad...",acceptInputEvents:!0,x:8,y:80})).on("inputStart",this,"_onGamepad"),this._deleteData=(new c({parent:this,text:"Delete data ...",acceptInputEvents:!0,x:8,y:96})).on("inputStart",this,"_onDeleteData"),this._fullscreen=(new c({parent:this,acceptInputEvents:!0,x:8,y:112})).on("inputStart",this,"_onToggleFullscreen"),this.sortChildren()},reset:function(){this._sounds.value=f.get("soundVolume"),this._music.value=f.get("musicVolume"),this._fullscreen.visible=i.native,this._updateFullscreenText(),this._deleteData.visible=s.entry==="title"},activate:function(e,t){var n=this.oldSceneId;this._super(e,t);if(e==="deleteData"||e==="keyboard"||e==="gamepad")this.oldSceneId=n},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit()},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId)},_onSoundChange:function(e,t){if(e>t)o.play("backspace1",0);else{if(!(e<t))return;o.play("type1",0)}o.soundVolume=e,f.set("soundVolume",e),f.save()},_onMusicChange:function(e,t){if(e>t)o.play("backspace2",0);else{if(!(e<t))return;o.play("type2",0)}o.musicVolume=e,f.set("musicVolume",e),f.save()},_onKeyboard:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("keyboard")},_onGamepad:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("gamepad")},_onDeleteData:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("deleteData")},_onToggleFullscreen:function(){f.set("fullscreen",!f.get("fullscreen")),f.get("fullscreen")?o.play("select",0):o.play("negate",0),i.toggleFullscreen(),this._updateFullscreenText()},_updateFullscreenText:function(){f.get("fullscreen")?this._fullscreen.text="(X) Fullscreen":this._fullscreen.text="( ) Fullscreen"}});t.defaults={backgroundColor:p.getColor("black"),musicKey:"streets"}}),n("js/view/scenes/ShareScene",["require","exports","module","djinn/view/View","djinn/view/Sprite","djinn/manifest","djinn/audio/jukebox","djinn/math/core","djinn/utils/string","./Scene","../../gameData","../Typer","../SuperTyper","../Screenshot","../avatarFactory","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/view/Sprite"),s=e("djinn/manifest"),o=e("djinn/audio/jukebox"),u=e("djinn/math/core"),a=e("djinn/utils/string"),f=e("./Scene"),l=e("../../gameData"),c=e("../Typer"),h=e("../SuperTyper"),p=e("../Screenshot"),d=e("../avatarFactory"),v=e("../style"),t=n.exports=f.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super();var e=s.title.toUpperCase();(new h({parent:this,text:e,y:8})).align("center"),new c({parent:this,text:"------------------------------",color:"silver",x:8,y:24});var t=this._gear=this.addSettingsGear();t.align("right","bottom",-8,-8),t.on("inputStart",this,"_onSettings");var n=this._version=(new c({parent:this})).align(null,"bottom",0,-8);this._container=new r({parent:this,acceptInputEvents:!0,x:8,y:40}),this.sortChildren()},reset:function(){this._super(),this._button=null;var e=this._container;e.disposeChildren();var t=null,n=l.codeData;n?n.error&&(t="Sorry, invalid code."):t="Sorry, invalid code.";if(t){new c({parent:e,text:t,color:"red"});var u=new c({parent:e,text:"Try this game instead:",y:8}),f=this._button=new r({parent:e,acceptInputEvents:!0,image:"media/images/ui.png",imageY:34,y:u.bottom+8,width:54,height:14});f.on("inputStart",this,"_onFallback");var h=new c({parent:e,text:"Play"});h.shrinkwrap(),h.centerOn(f)}else{var d=n.game,v=n.developer,m=new p({parent:e,width:d.tiles[0].length*2,height:d.tiles.length*2});m.setGame(d);var g=new c({parent:e,text:d.name,x:m.right+8}),y=new c({parent:e,text:"by "+v,color:"silver",x:g.x,y:g.bottom}),f=this._button=new r({parent:e,acceptInputEvents:!0,image:"media/images/ui.png",imageY:34,x:m.right+8,y:y.bottom+8,width:54,height:14});f.on("inputStart",this,"_onButton");var h=new c({parent:e,text:"Play"});h.shrinkwrap(),h.centerOn(f)}var b=new c({parent:e,text:"------------------------------",color:"silver",y:f.bottom+8}),w=new i({parent:e,acceptInputEvents:!0,cancelInputEvents:!0,animations:{idle:{frameRate:2,frames:[[0,32],[16,32]]}},image:"media/images/actors.png",y:b.bottom+8,width:16,height:16});w.playAnimation("idle");var u=new c({parent:e,text:a.sprintf("Support %s!",s.title),color:"silver",x:w.right+8,y:b.bottom+8}),E=new c({parent:e,text:"Buy it on Humble.",color:"silver",x:w.right+8,y:u.bottom}),S=new r({parent:e,acceptInputEvents:!0,image:"media/images/ui.png",imageY:48,x:w.right+8-2,y:E.bottom+8,width:54,height:14});S.on("inputStart",this,bind(this,function(){o.play("play",0),S.imageX=0,S.imageY=62,this.captureInputEvents=!1,location.href="https://goo.gl/aWfbXe"}));var x=new c({parent:e,text:"Love"});x.shrinkwrap(),x.centerOn(S);var T=this._version;n&&n.version&&n.version!==s.version?(T.color="red",T.text=a.sprintf("v%s (v%s)",s.version,n.version)):(T.color="white",T.text=a.sprintf("v%s",s.version)),n&&n.pirated&&(T.text+="p"),T.shrinkwrap(),T.right=this._gear.x-8,T.hide()},activate:function(e,t){this._super(e,t),this.parent.mouse.show()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&(o.play("negate",0),this._version.visible=!this._version.visible),this.getInput("action",!0)&&this._onButton()},_onButton:function(){o.play("play",0),this.captureInputEvents=!1,this.fireSceneEvent("level")},_onFallback:function(){o.play("play",0),this.captureInputEvents=!1,location.href="http://www.indiegamesim.com/share/?code=eyJnYW1lIjp7Im5hbWUiOiJXaW5ncyIsImRldmVsb3BlciI6IlJvb2siLCJwbGF5ZXJQcmVmYWIiOiJwbGF5ZXJHb2JsaW4iLCJiYWNrZ3JvdW5kQ29sb3IiOlsyMDQsMjA0LDE3OV0sImRhcmtuZXNzIjowLjIsInRpbWUiOjQ1MDAwLCJ0aWxlcyI6W1sxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMSwxMV0sWzExLDAsMCwwLDU4LDAsMCwwLDAsMCw1OCwwLDAsMCwwLDAsNTgsMCwwLDAsMCwwLDExXSxbMTEsNTgsMCwwLDAsMCwwLDU4LDAsMCwwLDAsMCw1OCwwLDAsMCwwLDAsNTgsMCwwLDExXSxbMTEsNjIsNjIsNjIsOSw5LDksOSw5LDksOSw5LDksOSw5LDksOSw5LDExLDExLDAsMCwxMV0sWzExLDAsMCwwLDYyLDYyLDksNjIsNjIsMCwwLDAsMCwwLDAsMCw5LDAsMCwxMSwwLDAsMTFdLFsxMSwwLDAsMCw2Miw2Miw5LDYyLDAsMCwwLDAsMCwwLDAsMCw5LDAsMCw5LDAsNTYsMTFdLFsxMSwwLDAsMCw2Miw2Miw5LDYyLDksOSwwLDAsMCwwLDAsNTcsOSw5LDAsOSwwLDExLDExXSxbOSwwLDAsMCw5LDYyLDYyLDYyLDksMCwwLDAsMCwwLDAsMCwwLDAsMCw5LDAsMCwxMV0sWzksMCw1MSwwLDksNjIsNjIsNjIsOSwwLDAsMCwwLDY1LDAsMCw5LDAsMCwxMSw1NiwwLDExXSxbOSw5LDksOSw5LDksOSw5LDksOSw5LDksOSw5LDksOSw5LDksMCwxMSwxMSwwLDExXSxbOSwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCw4XSxbOCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwwLDAsMCwxMywwLDAsMCwwLDU2LDhdLFs4LDAsNTAsMCwwLDAsMCwwLDEzLDAsMTMsMCwwLDAsMCwwLDEzLDAsNjQsMCwwLDgsOF0sWzgsOCw4LDgsMCw2NSwwLDEzLDEzLDAsMTMsMTMsMCw2NSwwLDAsOCw4LDAsOCw4LDgsOF0sWzgsOCw4LDgsOCw4LDgsMTMsNTMsNTMsNTMsMTMsOCw4LDgsOCw4LDgsOCw4LDgsOCw4XV0sImpveU5vcm1hbCI6MC44MzUzMjIxOTU3MDQwNTczLCJzdXJ2ZXlOb3JtYWwiOjF9LCJkZXZlbG9wZXIiOiJBTEwiLCJ2ZXJzaW9uIjoiMC43LjMifQ%3D%3D"},_onSettings:function(){o.play("select",0),this.captureInputEvents=!1,this.fireSceneEvent("settings")}});t.defaults={backgroundColor:v.getColor("marketBG")}}),n("js/view/scenes/StatsScene",["require","exports","module","djinn/view/View","djinn/achievements","djinn/utils/string","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../Starfield","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/utils/string"),o=e("djinn/audio/jukebox"),u=e("./Scene"),a=e("../../gameData"),f=e("../Typer"),l=e("../Starfield"),c=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new l({parent:this}),new f({parent:this,text:"Stats v0.6",x:8,y:8}),new f({parent:this,text:"-----------------------------",color:"silver",x:8,y:16}),this._container=new r({parent:this,acceptInputEvents:!0,y:24}),this.addQuitX(),this.sortChildren()},reset:function(){this._super();var e=this._container;e.disposeChildren();var t=8,n=a.getDeveloperMoney(),r=(new f({parent:e,text:"Money:",color:"silver",x:8,y:t})).shrinkwrap();new f({parent:e,text:"$"+s.formatMoney(n),x:r.right+8,y:t}),t+=16;var o=a.getProductCount(),u=a.getDeveloperProductCount(),l=(new f({parent:e,text:"Products bought:",color:"silver",x:8,y:t})).shrinkwrap();new f({parent:e,text:u+"/"+o,x:l.right+8,y:t}),t+=16;var c=(new f({parent:e,text:"Achievements:",color:"silver",x:8,y:t})).shrinkwrap();new f({parent:e,text:i.earned+"/"+i.total,x:c.right+8,y:t}),t+=16;var h=a.getSceneTime("edit"),p=(new f({parent:e,text:"Development time:",color:"silver",x:8,y:t})).shrinkwrap();new f({parent:e,text:s.formatTime(h),x:p.right+8,y:t}),t+=16;var d=a.getSceneTime("playtest"),v=(new f({parent:e,text:"Playtest time:",color:"silver",x:8,y:t})).shrinkwrap();new f({parent:e,text:s.formatTime(d),x:p.right+8,y:t}),t+=16;var m=a.getSceneTime("research"),g=(new f({parent:e,text:"Research time:",color:"silver",x:8,y:t})).shrinkwrap();new f({parent:e,text:s.formatTime(m),x:p.right+8,y:t}),t+=16;var y=h+d+m,b=(new f({parent:e,text:"Total time:",color:"silver",x:8,y:t})).shrinkwrap();new f({parent:e,text:s.formatTime(y),x:p.right+8,y:t})},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit()},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent(this.oldSceneId||"computer")}});t.defaults={backgroundColor:c.getColor("black"),musicKey:"streets"}}),n("js/view/Product",["require","exports","module","djinn/view/View","djinn/utils/string","../products","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/utils/string"),s=e("../products"),o=e("./Typer"),u=e("./style"),t=n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e)},setProductId:function(e){var t=s[e];this.productId=e,this._avatar=new r(merge({parent:this,width:16,height:16},t.avatar)),this._name=new o({parent:this,text:t.name,color:"black",x:24});if(t.price===0)var n="FREE";else var n="$"+i.formatMoney(t.price);this._price=new o({parent:this,text:n,color:"green"}),this._price.shrinkwrap(),this._price.align("right",null,-16),this._desc=new o({parent:this,text:t.description,color:"gray",x:24,y:8})},markAsLocked:function(){this._name.color="silver",this._desc.color="silver",this._price.color="silver",this._price.text="locked",this._price.shrinkwrap(),this._price.align("right",null,-16),this._avatar.overlayColor=u.getColor("silver")},markAsOwned:function(){this._name.color="silver",this._desc.color="silver",this._price.color="gray",this._price.text="owned",this._price.shrinkwrap(),this._price.align("right",null,-16)},markAsTooExpensive:function(){this._price.color="red"}});t.defaults={acceptInputEvents:!0,height:24}}),n("js/view/scenes/StoreScene",["require","exports","module","djinn/view/View","djinn/achievements","djinn/utils/string","djinn/audio/jukebox","./Scene","../../gameData","../../products","../Typer","../Scrollbar","../Product","../Reward","../Confirmation","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/utils/string"),o=e("djinn/audio/jukebox"),u=e("./Scene"),a=e("../../gameData"),f=e("../../products"),l=e("../Typer"),c=e("../Scrollbar"),h=e("../Product"),p=e("../Reward"),d=e("../Confirmation"),v=e("../style"),t=n.exports=u.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new r({parent:this,image:"media/images/objects.png",imageX:112,x:4,y:8,width:16,height:16}),new l({parent:this,text:"Amazing Store",color:"black",x:24,y:8}),this._subtitle=new l({parent:this,color:"gray",x:24,y:16}),new l({parent:this,text:"------------------------------",color:"silver",x:8,y:24}),this._funds=new l({parent:this,color:"black",x:8,y:32}),this.addQuitX("black"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:48,width:240,height:80}),this._container=new r({parent:this._window,acceptInputEvents:!0});var e=this._scrollbar=(new c({parent:this._window,barColor:v.getColor("white"),cursorColor:v.getColor("silver"),width:8})).align("right");e.attach(this._container),this._reward=(new p({parent:this,backgroundColor:v.getColor("black")})).align("center","center"),this._reward.on("ok",this,"_onRewardOK");var t=this._confirmation=(new d({parent:this,backgroundColor:v.getColor("black")})).align("center","center");t.on("confirm",this,"_onConfirmPurchase"),t.on("cancel",this,"_onConfirmCancel"),t.setBackgroundColor("silver"),t.setHeader("Purchase?"),t.setConfirmButton("Buy")},reset:function(){this.parent.mouse.show(),this._super(),this._confirmation.hide(),this._updateFunds(),a.hasDeveloperBoughtEverything()?this._subtitle.text="Everything you bought":a.developerHasAllTools()?this._subtitle.text="Down to just luxuries":this._subtitle.text="Everything you need";var e=this._container;e.disposeChildren(),e.height=0;var t=null;for(var n in f){var i=f[n];if(i.category&&i.category!==t){t=i.category;var s=new r({parent:e,backgroundColor:v.getColor("silver"),height:12,x:0,y:e.height,width:e.width-16});e.shrinkwrap(),e.width=e.parent.width,e.height+=8,new l({parent:s,text:i.category.toUpperCase(),color:"white",x:4,y:2})}this._addProduct(n)}this._scrollbar.reset(),this._reward.hide(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&(this._confirmation.visible?this._onConfirmCancel():this._reward.visible?this._onRewardOK():this._onQuit()),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_addProduct:function(e){var t=this._container,n=f[e],r=new h({parent:t,y:t.height});r.setProductId(e),r.on("inputStart",this,"_onBuyProduct"),t.shrinkwrap(),a.developerOwnsProduct(e)?r.markAsOwned():n.price>a.getDeveloperMoney()&&r.markAsTooExpensive()},_onBuyProduct:function(e){var t=e.target.productId,n=f[t];if(a.developerOwnsProduct(t)){o.play("negate",0);return}var n=f[t];if(n.price>a.getDeveloperMoney()){o.play("negate",0);return}o.play("select",0),this.productId=t,this._confirmation.setContentConf(n.avatar),this._confirmation.show()},_onRewardOK:function(){o.play("done",0),this._reward.hide()},_onConfirmPurchase:function(){o.play("increase",0);var e=this.productId;a.developerBuyProduct(e);var t=this._reward,n=f[e];t.setHeader("Bought"),t.setContentConf(n.avatar),t.show(),this._confirmation.hide(),this._updateFunds();var r=this._container.children;for(var s=0,u=r.length;s<u;++s){var l=r[s],e=l.productId;if(!e)continue;var n=f[e];a.developerOwnsProduct(e)?l.markAsOwned():n.price>a.getDeveloperMoney()&&l.markAsTooExpensive()}a.developerHasAllTools()&&i.trackProgress("consumerDev",1),a.hasDeveloperBoughtEverything()&&i.trackProgress("consumerAll",1)},_onConfirmCancel:function(){o.play("negate",0),this._confirmation.hide()},_onDoubt:function(){this.captureInputEvents=!1,this.fireSceneEvent("doubt")},_onQuit:function(){o.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("computer")},_updateFunds:function(){var e=a.data.developer,t=s.formatMoney(a.getDeveloperMoney());this._funds.text=s.sprintf("%s: $%s",e,t)}});t.defaults={backgroundColor:v.getColor("white"),musicKey:"streets"}}),n("js/view/scenes/TerminalScene",["require","exports","module","djinn/view/View","djinn/client","djinn/audio/jukebox","./Scene","../../gameData","../../settings","../Slider","../Typer","../Color","../ColorPicker","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/client"),s=e("djinn/audio/jukebox"),o=e("./Scene"),u=e("../../gameData"),a=e("../../settings"),f=e("../Slider"),l=e("../Typer"),c=e("../Color"),h=e("../ColorPicker"),p=e("../style"),t=n.exports=o.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new l({parent:this,text:"Terminal v0.1",x:8,y:8}),new l({parent:this,text:"-------------",x:8,y:16}),this.addQuitX();var e=this._container=new r({parent:this,acceptInputEvents:!0,x:8,y:32});(new l({parent:e,text:"Do all teh things",acceptInputEvents:!0})).on("inputStart",this,"_onDoThings"),this.sortChildren()},reset:function(){},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit()},_onQuit:function(){s.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("computer")},_onDoThings:function(){s.play("select",0)}});t.defaults={backgroundColor:p.getColor("orange")}}),n("js/view/scenes/TitleScene",["require","exports","module","djinn/view/View","djinn/client","djinn/math/core","djinn/view/shapes/Pinwheel","djinn/manifest","djinn/audio/jukebox","./Scene","../../gameData","../Typer","../SuperTyper","../Quitting","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/client"),s=e("djinn/math/core"),o=e("djinn/view/shapes/Pinwheel"),u=e("djinn/manifest"),a=e("djinn/audio/jukebox"),f=e("./Scene"),l=e("../../gameData"),c=e("../Typer"),h=e("../SuperTyper"),p=e("../Quitting"),d=e("../style"),t=n.exports=f.extend({init:function(e){this._super(merge(e,t.defaults)),this._flashTimer=this.createTimer(0,"_onFlashTimer")},setup:function(){this._super(),this.pinwheel=(new o({parent:this,rayColor:d.getColor("black"),rayRotationSpeed:1e-4})).align("center","center"),this._header=this._makeSuperText(u.title.toUpperCase()),this._headerY=this._header.y;var e=this._demo=(new c({parent:this,text:"DEMO",y:this._header.bottom})).shrinkwrap().align("center"),t=this._button=(new r({parent:this,acceptInputEvents:!0,image:"media/images/ui.png",width:54,height:14})).align("center","center");t.on("inputStart",this,"_onPlay");var n=new c({parent:t,acceptInputEvents:!0,text:"Play"});n.shrinkwrap(),n.align("center","center"),this._quit=(new p({parent:this})).align("center","center",0,32),this._quit.on("quit",this,"_onQuit");var i=u.version.replace(/\./g,"");u.pirates&&(i+="p");var s=this._footer=new c({parent:this,text:"v"+i+" LDG 2016",acceptInputEvents:!0,color:"black"});s.shrinkwrap().align("center","bottom",0,-8),this.on("inputMove",this,"_onInputMove"),this.sortChildren()},reset:function(){this._super(),this.parent.mouse.hide(),this._header.y=this._headerY,this.normal=1;var e=this._button;e.imageY=34,this._demo.visible=u.demo,this._demo.y=this._footer.y-16,this._quit.reset(),l.hasRolledCredits()?(this.lightColor="gold",this.darkColor="orange",e.imageY+=e.height*2):l.getDeveloperCount()?(this.lightColor="blue",this.darkColor="darkBlue",e.imageY+=e.height):(this.lightColor="green",this.darkColor="darkGreen"),this.pinwheel.fillColor=d.getColor(this.darkColor)},activate:function(e,t){this._super(e,t),this._flashTimer.start(500)},tick:function(e){if(!this.captureInputEvents)return;this.getInput("action",!0)&&this._onPlay(),this.getInput("negate")?this._quit.activate(e):this._quit.reset()},_makeSuperText:function(e){var t=new r({parent:this,imageSmoothingEnabled:!1,scale:2,y:16,height:10}),n=[{x:-1,y:0},{x:1,y:0},{x:0,y:-1},{x:0,y:1}];for(var i=0,s=n.length;i<s;++i){var o=n[i];(new c({parent:t,text:e,color:"black"})).shrinkwrap().align("center","center",o.x,o.y)}return(new c({parent:t,text:e,y:16})).shrinkwrap().align("center","center"),t.align("center"),t},_onFlashTimer:function(){var e=this.pinwheel;e.fillColor===d.getColor(this.darkColor)?e.fillColor=d.getColor(this.lightColor):e.fillColor=d.getColor(this.darkColor),e.rayRotationSpeed=s.lerp(.002,1e-4,this.normal),this._flashTimer.start(500*this.normal)},_onInputMove:function(e){var t=this._button,n=t.center,r=this._header,i=r.center,o=e.point,u=s.distance(o.x,o.y,i.x,i.y),a=s.distance(n.x,n.y,this.width,this.height),f=this.normal=u/a;r.y=s.lerp(t.y-t.height,this._headerY,f),this._demo.y=s.lerp(this._button.bottom,this._footer.y-16,f),this.parent.mouse.show()},_onPlay:function(){a.play("start",0),this.captureInputEvents=!1,this.fireSceneEvent("play")},_onQuit:function(){i.quit()}});t.defaults={backgroundColor:d.getColor("black"),musicKey:"funkBump"}}),n("js/view/scenes/UnpublishedGamesScene",["require","exports","module","djinn/view/View","djinn/audio/jukebox","./Scene","../../gameData","../GameListItem","../Typer","../Scrollbar","../BackButton","../style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/audio/jukebox"),s=e("./Scene"),o=e("../../gameData"),u=e("../GameListItem"),a=e("../Typer"),f=e("../Scrollbar"),l=e("../BackButton"),c=e("../style"),t=n.exports=s.extend({init:function(e){this._super(merge(e,t.defaults))},setup:function(){this._super(),new a({parent:this,text:"Vaultworks Publishing Tools",x:24,y:8}),new a({parent:this,text:"Publish new game",color:"silver",x:24,y:16}),new a({parent:this,text:"---------------------------",x:8,y:24});var e=new l({parent:this});e.align("left","top",4,8),e.on("inputPress",this,"_onQuit"),this._window=new r({parent:this,acceptInputEvents:!0,clip:!0,x:8,y:40,width:240,height:96}),this._container=new r({parent:this._window,acceptInputEvents:!0,y:40});var t=this._scrollbar=(new f({parent:this._window,barColor:c.getColor("marketBG"),width:8})).align("right");t.attach(this._container),this.sortChildren()},reset:function(){this._super();var e=this._container;e.disposeChildren();var t=o.getUnpublishedGamesByDeveloper(o.data.developer);if(t.length){var n=0;for(var r=0,i=t.length;r<i;++r){var s=new u({parent:e,y:n}),f=t[r];s.setGame(f),f.tested?(s.on("selectGame",this,"_onSelectGame"),s.on("selectDetails",this,"_onSelectGame"),s.addLabel("Ready to publish","green")):(s.on("selectGame",this,"_onRejectGame"),s.on("selectDetails",this,"_onRejectGame"),s.addLabel("Untested","red"),s.setNameColor("silver")),s.gameIndex=f.gameIndex,n+=s.height+8}}else new a({parent:e,text:"No unpublished games found",color:"silver",x:8,y:0});e.shrinkwrap(),this._scrollbar.reset(),this.sortChildren()},tick:function(e){if(!this.captureInputEvents)return;this.getInput("negate",!0)&&this._onQuit(),this.getInput("down")?this._scrollbar.scroll(1,e):this.getInput("up")&&this._scrollbar.scroll(-1,e)},_onSelectGame:function(e){i.play("select",0),o.data.publishGameIndex=e,o.save(),this.captureInputEvents=!1,this.fireSceneEvent("publishGame")},_onRejectGame:function(){i.play("negate",0)},_onQuit:function(){i.play("negate",0),this.captureInputEvents=!1,this.fireSceneEvent("quit")}});t.defaults={backgroundColor:c.getColor("marketBG"),musicKey:"streets"}}),n("js/scenes",["require","exports","module","./view/scenes/AchievementsScene","./view/scenes/AnalyticsScene","./view/scenes/AuthScene","./view/scenes/BillboardScene","./view/scenes/ComputerScene","./view/scenes/CreditsScene","./view/scenes/DeleteDataScene","./view/scenes/DevelopersScene","./view/scenes/DevScene","./view/scenes/DoubtScene","./view/scenes/EditScene","./view/scenes/FinalBossScene","./view/scenes/GamepadScene","./view/scenes/ImpactScene","./view/scenes/KeyboardScene","./view/scenes/LevelScene","./view/scenes/LoginScene","./view/scenes/MarketAllScene","./view/scenes/MarketAnalysisScene","./view/scenes/MarketGameScene","./view/scenes/MarketScene","./view/scenes/MarketTopScene","./view/scenes/NewsScene","./view/scenes/PartyScene","./view/scenes/ProfileScene","./view/scenes/PropertyScene","./view/scenes/PromoScene","./view/scenes/PublishedGamesScene","./view/scenes/PublishGameScene","./view/scenes/ReviewsScene","./view/scenes/SettingsScene","./view/scenes/ShareScene","./view/scenes/StatsScene","./view/scenes/StoreScene","./view/scenes/TerminalScene","./view/scenes/TitleScene","./view/scenes/UnpublishedGamesScene"],function(e,t,n){var r=e("./view/scenes/AchievementsScene"),i=e("./view/scenes/AnalyticsScene"),s=e("./view/scenes/AuthScene"),o=e("./view/scenes/BillboardScene"),u=e("./view/scenes/ComputerScene"),a=e("./view/scenes/CreditsScene"),f=e("./view/scenes/DeleteDataScene"),l=e("./view/scenes/DevelopersScene"),c=e("./view/scenes/DevScene"),h=e("./view/scenes/DoubtScene"),p=e("./view/scenes/EditScene"),d=e("./view/scenes/FinalBossScene"),v=e("./view/scenes/GamepadScene"),m=e("./view/scenes/ImpactScene"),g=e("./view/scenes/KeyboardScene"),y=e("./view/scenes/LevelScene"),b=e("./view/scenes/LoginScene"),w=e("./view/scenes/MarketAllScene"),E=e("./view/scenes/MarketAnalysisScene"),S=e("./view/scenes/MarketGameScene"),x=e("./view/scenes/MarketScene"),T=e("./view/scenes/MarketTopScene"),N=e("./view/scenes/NewsScene"),C=e("./view/scenes/PartyScene"),k=e("./view/scenes/ProfileScene"),L=e("./view/scenes/PropertyScene"),A=e("./view/scenes/PromoScene"),O=e("./view/scenes/PublishedGamesScene"),M=e("./view/scenes/PublishGameScene"),_=e("./view/scenes/ReviewsScene"),D=e("./view/scenes/SettingsScene"),P=e("./view/scenes/ShareScene"),H=e("./view/scenes/StatsScene"),B=e("./view/scenes/StoreScene"),j=e("./view/scenes/TerminalScene"),F=e("./view/scenes/TitleScene"),I=e("./view/scenes/UnpublishedGamesScene"),q=100;t.title={ctor:F,events:{play:{id:"login",transitions:"fade",conf:{duration:q}}}},t.achievements={ctor:r,events:{computer:{id:"computer",transitions:"fade",conf:{duration:q}}}},t.analytics={ctor:i,events:{marketGame:{id:"marketGame",transitions:"fade",conf:{duration:q}},publishGame:{id:"developers",transitions:"fade",conf:{duration:q}},publishedGames:{id:"publishedGames",transitions:"fade",conf:{duration:q}},reviews:{id:"reviews",transitions:"fade",conf:{duration:q}}}},t.computer={ctor:u,events:{doubt:{id:"doubt",transitions:"fade",conf:{duration:1e3}},dev:{id:"dev",transitions:"fade",conf:{duration:q}},market:{id:"market",transitions:"fade",conf:{duration:q}},news:{id:"news",transitions:"fade",conf:{duration:q}},settings:{id:"settings",transitions:"fade",conf:{duration:q}},achievements:{id:"achievements",transitions:"fade",conf:{duration:q}},stats:{id:"stats",transitions:"fade",conf:{duration:q}},quit:{id:"login",transitions:"fade",conf:{duration:q}},store:{id:"store",transitions:"fade",conf:{duration:q}},property:{id:"property",transitions:"fade",conf:{duration:q}}}},t.edit={ctor:p,events:{playtest:{id:"level",transitions:"fade",conf:{duration:q}},marketAnalysis:{id:"marketAnalysis",transitions:"fade",conf:{duration:q}},auth:{id:"auth",transitions:"fade",conf:{duration:q}},quit:{id:"dev",transitions:"fade",conf:{duration:q}}}},t.dev={ctor:c,events:{edit:{id:"edit",transitions:"fade",conf:{duration:q}},publishGame:{id:"publishGame",transitions:"fade",conf:{duration:q}},doubt:{id:"doubt",transitions:"fade",conf:{duration:1e3}},quit:{id:"computer",transitions:"fade",conf:{duration:q}}}},t.developers={ctor:l,events:{publishedGames:{id:"publishedGames",transitions:"fade",conf:{duration:q}},unpublishedGames:{id:"unpublishedGames",transitions:"fade",conf:{duration:q}},quit:{id:"market",transitions:"fade",conf:{duration:q}}}},t.finalBoss={ctor:d,events:{doubt:{id:"doubt",transitions:"fade",conf:{duration:q}},level:{id:"level",transitions:"fade",conf:{duration:q}},computer:{id:"computer",transitions:"fade",conf:{duration:q}}}},t.marketAnalysis={ctor:E,events:{edit:{id:"edit",transitions:"fade",conf:{duration:q}}}},t.login={ctor:b,events:{play:{id:"computer",transitions:"fade",conf:{duration:q}},settings:{id:"settings",transitions:"fade",conf:{duration:q}},quit:{id:"title",transitions:"fade",conf:{duration:q}}}},t.auth={ctor:s,events:{edit:{id:"edit",transitions:"fade",conf:{duration:q}}}},t.level={ctor:y,events:{edit:{id:"edit",transitions:"fade",conf:{duration:250}},marketGame:{id:"marketGame",transitions:"fade",conf:{duration:250}},share:{id:"share",transitions:"fade",conf:{duration:250}},finalBoss:{id:"finalBoss",transitions:"fade",conf:{duration:250}},computer:{id:"computer",transitions:"fade",conf:{duration:250}}}},t.market={ctor:x,events:{game:{id:"marketGame",transitions:"fade",conf:{duration:q}},all:{id:"marketAll",transitions:"fade",conf:{duration:q}},top:{id:"marketTop",transitions:"fade",conf:{duration:q}},profile:{id:"profile",transitions:"fade",conf:{duration:q}},developers:{id:"developers",transitions:"fade",conf:{duration:q}},quit:{id:"computer",transitions:"fade",conf:{duration:q}}}},t.marketAll={ctor:w,events:{game:{id:"marketGame",transitions:"fade",conf:{duration:q}},profile:{id:"profile",transitions:"fade",conf:{duration:q}},quit:{id:"market",transitions:"fade",conf:{duration:q}}}},t.marketTop={ctor:T,events:{game:{id:"marketGame",transitions:"fade",conf:{duration:q}},profile:{id:"profile",transitions:"fade",conf:{duration:q}},quit:{id:"market",transitions:"fade",conf:{duration:q}}}},t.marketGame={ctor:S,events:{play:{id:"level",transitions:"fade",conf:{duration:q}},profile:{id:"profile",transitions:"fade",conf:{duration:q}},analytics:{id:"analytics",transitions:"fade",conf:{duration:q}},reviews:{id:"reviews",transitions:"fade",conf:{duration:q}},market:{id:"market",transitions:"fade",conf:{duration:q}},marketAll:{id:"marketAll",transitions:"fade",conf:{duration:q}},marketTop:{id:"marketTop",transitions:"fade",conf:{duration:q}}}},t.news={ctor:N,events:{computer:{id:"computer",transitions:"fade",conf:{duration:q}},credits:{id:"credits",transitions:"fade",conf:{duration:q}}}},t.profile={ctor:k,events:{market:{id:"market",transitions:"fade",conf:{duration:q}},marketGame:{id:"marketGame",transitions:"fade",conf:{duration:q}},marketAll:{id:"marketAll",transitions:"fade",conf:{duration:q}},marketTop:{id:"marketTop",transitions:"fade",conf:{duration:q}}}},t.doubt={ctor:h,events:{computer:{id:"computer",transitions:"fade",conf:{duration:500}},store:{id:"store",transitions:"fade",conf:{duration:500}},dev:{id:"dev",transitions:"fade",conf:{duration:500}},finalBoss:{id:"finalBoss",transitions:"fade",conf:{duration:500}},credits:{id:"credits",transitions:"fade",conf:{duration:500}}}},t.party={ctor:C,events:{analytics:{id:"analytics",transitions:"fade",conf:{duration:500}}}},t.unpublishedGames={ctor:I,events:{publishGame:{id:"publishGame",transitions:"fade",conf:{duration:q}},quit:{id:"developers",transitions:"fade",conf:{duration:q}}}},t.publishedGames={ctor:O,events:{analytics:{id:"analytics",transitions:"fade",conf:{duration:q}},quit:{id:"developers",transitions:"fade",conf:{duration:q}}}},t.publishGame={ctor:M,events:{party:{id:"party",transitions:"fade",conf:{duration:q}},dev:{id:"dev",transitions:"fade",conf:{duration:q}},unpublishedGames:{id:"unpublishedGames",transitions:"fade",conf:{duration:q}}}},t.reviews={ctor:_,events:{analytics:{id:"analytics",transitions:"fade",conf:{duration:q}},marketGame:{id:"marketGame",transitions:"fade",conf:{duration:q}}}},t.share={ctor:P,events:{level:{id:"level",transitions:"fade",conf:{duration:q}},settings:{id:"settings",transitions:"fade",conf:{duration:q}}}},t.stats={ctor:H,events:{computer:{id:"computer",transitions:"fade",conf:{duration:q}}}},t.credits={ctor:a,events:{title:{id:"title",transitions:"fade",conf:{duration:q}}}},t.store={ctor:B,events:{computer:{id:"computer",transitions:"fade",conf:{duration:q}},doubt:{id:"doubt",transitions:"fade",conf:{duration:1e3}}}},t.deleteData={ctor:f,events:{deleteData:{id:"title",transitions:"fade",conf:{duration:q}},login:{id:"login",transitions:"fade",conf:{duration:q}},settings:{id:"settings",transitions:"fade",conf:{duration:q}}}},t.keyboard={ctor:g,events:{settings:{id:"settings",transitions:"fade",conf:{duration:q}}}},t.gamepad={ctor:v,events:{settings:{id:"settings",transitions:"fade",conf:{duration:q}}}},t.property={ctor:L,events:{computer:{id:"computer",transitions:"fade",conf:{duration:q}}}},t.settings={ctor:D,events:{computer:{id:"computer",transitions:"fade",conf:{duration:q}},login:{id:"login",transitions:"fade",conf:{duration:q}},keyboard:{id:"keyboard",transitions:"fade",conf:{duration:q}},gamepad:{id:"gamepad",transitions:"fade",conf:{duration:q}},deleteData:{id:"deleteData",transitions:"fade",conf:{duration:q}},share:{id:"share",transitions:"fade",conf:{duration:q}}}},t.billboard={ctor:o,events:{}},t.impact={ctor:m,events:{}},t.promo={ctor:A,events:{}},t.terminal={ctor:j,events:{computer:{id:"computer",transitions:"fade",conf:{duration:q}}}}}),n("js/sounds",{sounds:{achievement:{paths:["media/sounds/ui/achievement.ogg"]},add:{paths:["media/sounds/ui/add.ogg"]},backspace1:{paths:["media/sounds/ui/backspace1.ogg"]},backspace2:{paths:["media/sounds/ui/backspace2.ogg"]},choice1:{paths:["media/sounds/ui/choice1.ogg"]},choice2:{paths:["media/sounds/ui/choice2.ogg"]},clear:{paths:["media/sounds/ui/clear.ogg"]},close:{paths:["media/sounds/ui/close.ogg"]},create:{paths:["media/sounds/ui/create.ogg"]},done:{paths:["media/sounds/ui/done.ogg"]},doubt1:{paths:["media/sounds/ui/doubt1.ogg"]},doubt2:{paths:["media/sounds/ui/doubt2.ogg"]},doubt3:{paths:["media/sounds/ui/doubt3.ogg"]},doubt4:{paths:["media/sounds/ui/doubt4.ogg"]},doubt5:{paths:["media/sounds/ui/doubt5.ogg"]},dialog1:{paths:["media/sounds/ui/dialog1.ogg"]},dialog2:{paths:["media/sounds/ui/dialog2.ogg"]},dialog3:{paths:["media/sounds/ui/dialog3.ogg"]},dialog4:{paths:["media/sounds/ui/dialog4.ogg"]},dud:{paths:["media/sounds/ui/dud.ogg"]},error:{paths:["media/sounds/ui/error.ogg"]},fan1:{paths:["media/sounds/ui/fan1.ogg"]},fan2:{paths:["media/sounds/ui/fan2.ogg"]},increase:{paths:["media/sounds/ui/increase.ogg"]},negate:{paths:["media/sounds/ui/negate.ogg"]},open:{paths:["media/sounds/ui/open.ogg"]},phase:{paths:["media/sounds/ui/phase.ogg"]},placeMed1:{paths:["media/sounds/ui/placeMed1.ogg"]},placeMed2:{paths:["media/sounds/ui/placeMed2.ogg"]},placePos1:{paths:["media/sounds/ui/placePos1.ogg"]},placePos2:{paths:["media/sounds/ui/placePos2.ogg"]},placeNeg1:{paths:["media/sounds/ui/placeNeg1.ogg"]},placeNeg2:{paths:["media/sounds/ui/placeNeg2.ogg"]},play:{paths:["media/sounds/ui/play.ogg"]},profit1:{paths:["media/sounds/ui/profit1.ogg"]},profit2:{paths:["media/sounds/ui/profit2.ogg"]},remove:{paths:["media/sounds/ui/remove.ogg"]},reveal:{paths:["media/sounds/ui/reveal.ogg"]},select:{paths:["media/sounds/ui/select.ogg"]},set:{paths:["media/sounds/ui/set.ogg"]},start:{paths:["media/sounds/ui/start.ogg"]},success:{paths:["media/sounds/ui/success.ogg"]},trash1:{paths:["media/sounds/ui/trash1.ogg"]},trash2:{paths:["media/sounds/ui/trash2.ogg"]},type1:{paths:["media/sounds/ui/type1.ogg"]},type2:{paths:["media/sounds/ui/type2.ogg"]},unlock:{paths:["media/sounds/ui/unlock.ogg"]},appear:{paths:["media/sounds/gameplay/appear.ogg"]},banner1:{paths:["media/sounds/gameplay/banner1.ogg"]},banner2:{paths:["media/sounds/gameplay/banner2.ogg"]},beam:{paths:["media/sounds/gameplay/beam.ogg"]},bounce:{paths:["media/sounds/gameplay/bounce.ogg"]},cannon:{paths:["media/sounds/gameplay/cannon.ogg"]},collect1:{paths:["media/sounds/gameplay/collect1.ogg"]},collect2:{paths:["media/sounds/gameplay/collect2.ogg"]},damage:{paths:["media/sounds/gameplay/damage.ogg"]},death:{paths:["media/sounds/gameplay/death.ogg"]},disappear:{paths:["media/sounds/gameplay/disappear.ogg"]},explosion1:{paths:["media/sounds/gameplay/explosion1.ogg"]},explosion2:{paths:["media/sounds/gameplay/explosion2.ogg"]},fragileWarn:{paths:["media/sounds/gameplay/fragileWarn.ogg"]},grass:{paths:["media/sounds/gameplay/grass.ogg"]},gravity1:{paths:["media/sounds/gameplay/gravity1.ogg"]},gravity2:{paths:["media/sounds/gameplay/gravity2.ogg"]},lights:{paths:["media/sounds/gameplay/lights.ogg"]},joy1:{paths:["media/sounds/gameplay/joy1.ogg"]},joy2:{paths:["media/sounds/gameplay/joy2.ogg"]},jump:{paths:["media/sounds/gameplay/jump.ogg"]},jump2:{paths:["media/sounds/gameplay/jump2.ogg"]},pulse:{paths:["media/sounds/gameplay/pulse.ogg"]},pulseBlock:{paths:["media/sounds/gameplay/pulseBlock.ogg"]},pulseBlockSolid:{paths:["media/sounds/gameplay/pulseBlockSolid.ogg"]},shot:{paths:["media/sounds/gameplay/shot.ogg"]},spawn:{paths:["media/sounds/gameplay/spawn.ogg"]},spawnWarning:{paths:["media/sounds/gameplay/spawnWarning.ogg"]},survey1:{paths:["media/sounds/gameplay/survey1.ogg"]},survey2:{paths:["media/sounds/gameplay/survey2.ogg"]},teleport:{paths:["media/sounds/gameplay/teleport.ogg"]},warning:{paths:["media/sounds/gameplay/warning.ogg"]},woosh:{paths:["media/sounds/gameplay/woosh.ogg"]},alligators:{paths:["media/music/alligators.ogg"],loop:!0,type:"music"},corridor:{paths:["media/music/corridor.ogg"],loop:!0,type:"music"},flux:{paths:["media/music/flux.ogg"],loop:!0,type:"music"},funkBump:{paths:["media/music/funkBump.ogg"],loop:!0,type:"music"},fusionFactory:{paths:["media/music/fusionFactory.ogg"],loop:!0,type:"music"},holdPlease:{paths:["media/music/holdPlease.ogg"],loop:!0,type:"music"},streets:{paths:["media/music/streets.ogg"],loop:!0,type:"music"},youGotMe:{paths:["media/music/youGotMe.ogg"],loop:!0,type:"music"}}}),n("js/achievementData",["require","exports","module"],function(e,t,n){t.selfPublisher={title:"Self-Publisher",description:"Publish a game on Vault",goal:1,points:0},t.mediumDev={title:"Thinking Bigger",description:"Make a medium-sized game",goal:1,points:0},t.prolificPublisher={title:"Prolific Publisher",description:"Publish 10 games",goal:1,points:0},t.largeDev={title:"Outrageous!!1",description:"Publish a $14.99 game",goal:1,points:0},t.consumerDev={title:"Full Stack Dev",description:"Buy all dev tools",goal:1,points:0},t.consumerAll={title:"Ballin'",description:"Buy out the store",goal:1,points:0},t.expertPlayer={title:"Expert Player",description:"Beat all competitor games",goal:1,points:0},t.solidEffort={title:"Solid Effort",description:"Make $10k with one game",goal:1,points:0},t.hitGame={title:"Hit Game",description:"Make $100k with one game",goal:1,points:0},t.bigSpender={title:"Big Spender",description:"Publish a game for $50k",goal:1,points:0},t.bigTime={title:"The Big Time",description:"Make $1 million total",goal:1,points:0},t.partyAnimal={title:"Party Animal",description:"Throw an 8-person party",goal:1,points:0},t.newUsers={title:"New Users",description:"Get 1k fans with 1 game",goal:1,points:0},t.fanClub={title:"Fan Club",description:"Get 10k total fans",goal:1,points:0},t.rollCredits={title:"Roll Call",description:"Roll the Credits",goal:1,points:0},t.playerBenzer={title:"Lizard Schoolboy",description:"Unlock Benzer",goal:1,points:0},t.playerChicken={title:"Chicken Dance",description:"Unlock the player chicken",goal:1,points:0},t.playerFranklin={title:"Pixelated",description:"Unlock Franklin",goal:1,points:0},t.playerGoblin={title:"Genero",description:"Unlock the goblin",goal:1,points:0},t.playerJanitor={title:"It's-a-Him",description:"Unlock the janitor",goal:1,points:0},t.playerLars={title:"Lars Blade",description:"Unlock Lars",goal:1,points:0},t.playerLuna={title:"Huntress",description:"Unlock Luna",goal:1,points:0},t.playerWizard={title:"A Wizard",description:"Unlock the wizard",goal:1,points:0},t.playerRaga={title:"A Wizard's Lizard",description:"Unlock Raga",goal:1,points:0},t.playerTiger={title:"Tiger Hat",description:"Unlock the tiger",goal:1,points:0},t.playerXam={title:"Gladiator",description:"Unlock Xam",goal:1,points:0},t.playerZombie={title:"Brains etc.",description:"Unlock the zombie",goal:1,points:0},t.playerMother={title:"Marigold",description:"Unlock Marigold",goal:1,points:0},t.playerFather={title:"Mr. Hackett",description:"Unlock Mr. Hackett",goal:1,points:0},t.boss={title:"Totally Boss",description:"Unlock the boss",goal:1,points:0},t.goldenBoy={title:"Golden Boy",description:"Kill a boss with gold",goal:1,points:0}}),n("js/view/Achievement",["require","exports","module","djinn/view/View","djinn/achievements","djinn/audio/jukebox","./Typer","./style"],function(e,t,n){var r=e("djinn/view/View"),i=e("djinn/achievements"),s=e("djinn/audio/jukebox"),o=e("./Typer"),u=e("./style");n.exports=r.extend({init:function(e){var e=merge(e,t.defaults);this._super(e);var n=this._bg=(new r({parent:this,acceptInputEvents:!0,backgroundColor:u.getColor("black"),width:this.width-2,height:this.height-2})).align("center","center"),i=new o({parent:n,text:"ACHIEVEMENT UNLOCKED",color:"gold",x:4,y:4}),s=this._name=new o({parent:n,x:4,y:i.bottom+2});this._desc=new o({parent:n,color:"silver",x:4,y:s.bottom+2});var a=(new o({parent:n,acceptInputEvents:!0,text:"X",width:8})).align("right","top",-4,4);a.on("inputPress",this,"_onClose")},setAchievement:function(e){s.play("achievement",0);var t=i.getById(e);this._name.text=t.title,this._desc.text=t.description},show:function(){this._bg.visible=!1,this.completeTween({opacity:0,scale:2,visible:!0}).tween({opacity:1,scale:1},500,null,bind(this,function(){this._bg.visible=!0}))},hide:function(){this._bg.visible=!1,this.completeTween().tween({opacity:0,scale:0},500,null,bind(this,function(){this.opacity=1,this.scale=1,this.visible=!1,this._bg.visible=!0,this.fire("hide")}))},_onClose:function(){s.play("success",0),this.hide()}}),t.defaults={acceptInputEvents:!0,cancelInputEvents:!0,anchorX:.5,anchorY:.5,backgroundColor:u.getColor("gold"),width:210,height:36}}),n("js/view/Mouse",["require","exports","module","djinn/view/View"],function(e,t,n){var r=e("djinn/view/View");n.exports=r.extend({init:function(e){this._super(merge(e,t.defaults))}}),t.defaults={image:"media/images/ui.png",imageX:64,width:16,height:16}}),n("js/Main",["require","exports","module","djinn/utils/intl","./intl/en","djinn/Game","djinn/achievements","djinn/client","djinn/manifest","djinn/utils/request","djinn/audio/jukebox","djinn/input/keyboard","djinn/input/gamepad","./gameData","./scenes","./settings","./sounds","./achievementData","./view/Achievement","./view/Mouse"],function(e,t,n){var r=e("djinn/utils/intl"),i=e("./intl/en"),s=e("djinn/Game"),o=e("djinn/achievements"),u=e("djinn/client"),a=e("djinn/manifest"),f=e("djinn/utils/request"),l=e("djinn/audio/jukebox"),c=e("djinn/input/keyboard"),h=e("djinn/input/gamepad"),p=e("./gameData"),d=e("./scenes"),v=e("./settings"),m=e("./sounds"),g=e("./achievementData"),y=e("./view/Achievement"),b=e("./view/Mouse");n.exports=s.extend({init:function(e){var e=merge(e,t.defaults);this._super(e),r.addLanguage(i),r.setLanguage("en"),p.load(),v.get("fullscreen")&&u.enterFullscreen(),c.bind(v.get("keyBinds")),c.capture([c.keys.backspace]),l.configure(m),l.volumeExponent=5,l.soundVolume=v.get("soundVolume"),l.musicVolume=v.get("musicVolume"),h.bind(v.get("gamepadBinds")),h.analogDeadZoneLeft=v.get("analogDeadZoneLeft"),this._achievementQueue=[],o.setup(g),o.on("earn",this,"_onAchievementEarn"),this.preloadAssets(["media/images/actors.png","media/images/credits.png","media/images/darkness.png","media/images/doubt.png","media/images/env.png","media/images/filter.png","media/images/finalFloor.png","media/images/objects.png","media/images/palm.png","media/images/parallax.png","media/images/property.png","media/images/property2.png","media/images/ui.png","media/images/window.png","media/images/text/black.png","media/images/text/blue.png","media/images/text/gold.png","media/images/text/gray.png","media/images/text/green.png","media/images/text/red.png","media/images/text/silver.png","media/images/text/white.png"]),this.view.mouse=(new b({parent:this.view,visible:!1,z:99999})).align("center","center"),this.view.on("inputMove",this,"_onInputMove"),this.setupScenes(d),this.on("load",this,"_onGameLoad"),this.on("ready",this,"_onGameReady")},_onGameLoad:function(){l.preloadByType("sound")},_onGameReady:function(){var e=this._achievement=(new y({parent:this.view,visible:!1,z:9999})).align("center","bottom",0,-4);e.on("hide",this,"_processAchievementQueue"),this.view.sortChildren();var t=a.entry;if(f.params.oauth_verifier)t="auth";else if(f.params.code){t="share";var n=f.params.code;try{var r=decodeURIComponent(n),i=atob(r),s=JSON.parse(i);p.codeData={game:p.decodeGame(s.game),developer:s.developer,pirated:s.pirated,version:s.version}}catch(o){p.codeData={error:!0},console.log("[Main._onGameReady]",o)}}this.activateScene(t,"fade")},_onInputMove:function(e){var t=this.view.mouse,n=e.point;t.x=n.x-1,t.y=n.y-1},_onAchievementEarn:function(e){this._achievementQueue.push(e),this._processAchievementQueue()},_processAchievementQueue:function(){var e=this._achievement,t=this._achievementQueue;if(e.visible||t.length<1)return;var n=t.shift();e.setAchievement(n),e.show()}}),t.defaults={showLoadingScreen:!0}}),t(["js/Main"],function(e){var t=new e;t.run()}),n("_launch",function(){})})();;
