/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import com.sun.xml.internal.ws.message.AbstractHeaderImpl;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.util.DOMUtil;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class DOMHeader<N extends Element>
extends AbstractHeaderImpl {
    protected final N node;
    private final String nsUri;
    private final String localName;

    public DOMHeader(N n) {
        assert (n != null);
        this.node = n;
        this.nsUri = DOMHeader.fixNull(n.getNamespaceURI());
        this.localName = n.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.nsUri;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        DOMStreamReader dOMStreamReader = new DOMStreamReader((Node)this.node);
        dOMStreamReader.nextTag();
        return dOMStreamReader;
    }

    @Override
    public <T> T readAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        return (T)unmarshaller.unmarshal((Node)this.node);
    }

    @Override
    public <T> T readAsJAXB(Bridge<T> bridge) throws JAXBException {
        return bridge.unmarshal((Node)this.node);
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        DOMUtil.serializeNode(this.node, xMLStreamWriter);
    }

    private static String fixNull(String string) {
        if (string != null) {
            return string;
        }
        return "";
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        DOMScanner dOMScanner = new DOMScanner();
        dOMScanner.setContentHandler(contentHandler);
        dOMScanner.scan((Element)this.node);
    }

    @Override
    public String getAttribute(String string, String string2) {
        if (string.length() == 0) {
            string = null;
        }
        return this.node.getAttributeNS(string, string2);
    }

    @Override
    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
        if (sOAPHeader == null) {
            sOAPHeader = sOAPMessage.getSOAPPart().getEnvelope().addHeader();
        }
        Node node = sOAPHeader.getOwnerDocument().importNode((Node)this.node, true);
        sOAPHeader.appendChild(node);
    }

    @Override
    public String getStringContent() {
        return this.node.getTextContent();
    }
}

