/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.Enumeration;
import java.util.logging.Level;

class SnmpSubBulkRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;

    protected SnmpSubBulkRequestHandler(SnmpEngine snmpEngine, SnmpAdaptorServer snmpAdaptorServer, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n, int n2, int n3) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpAdaptorServer, snmpPdu, n, n2, n3);
    }

    protected SnmpSubBulkRequestHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, int n, int n2, int n3) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpAdaptorServer, snmpPdu, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            this.size = this.varBind.size();
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getBulk operation on " + this.agent.getMibName());
                    }
                    this.agent.getBulk(this.createMibRequest(this.varBind, this.version, this.data), this.nonRepeat, this.maxRepeat);
                }
                finally {
                    ThreadContext.restore(threadContext);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation", snmpStatusException);
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block9;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occured during the operation", exception);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    private void init(SnmpAdaptorServer snmpAdaptorServer, SnmpPdu snmpPdu, int n, int n2, int n3) {
        this.server = snmpAdaptorServer;
        this.nonRepeat = n;
        this.maxRepeat = n2;
        this.globalR = n3;
        int n4 = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < n4; ++i) {
            this.translation[i] = i;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[i].oid, snmpVarBindArray[i].value);
            nonSyncVector.addNonSyncElement(snmpVarBind);
        }
    }

    private SnmpVarBind findVarBind(SnmpVarBind snmpVarBind, SnmpVarBind snmpVarBind2) {
        if (snmpVarBind == null) {
            return null;
        }
        if (snmpVarBind2.oid == null) {
            return snmpVarBind;
        }
        if (snmpVarBind.value == SnmpVarBind.endOfMibView) {
            return snmpVarBind2;
        }
        if (snmpVarBind2.value == SnmpVarBind.endOfMibView) {
            return snmpVarBind;
        }
        SnmpValue snmpValue = snmpVarBind2.value;
        int n = snmpVarBind.oid.compareTo(snmpVarBind2.oid);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Comparing OID element : " + snmpVarBind.oid + " with result : " + snmpVarBind2.oid);
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Values element : " + snmpVarBind.value + " result : " + snmpVarBind2.value);
        }
        if (n < 0) {
            return snmpVarBind;
        }
        if (n == 0) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", " oid overlapping. Oid : " + snmpVarBind.oid + "value :" + snmpVarBind.value);
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Already present varBind : " + snmpVarBind2);
            }
            SnmpOid snmpOid = snmpVarBind2.oid;
            SnmpMibAgent snmpMibAgent = this.server.getAgentMib(snmpOid);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Deeper agent : " + snmpMibAgent);
            }
            if (snmpMibAgent == this.agent) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "The current agent is the deeper one. Update the value with the current one");
                }
                return snmpVarBind;
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "The current agent is not the deeper one. return the previous one.");
            }
            return snmpVarBind2;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "The right varBind is the already present one");
        }
        return snmpVarBind2;
    }

    @Override
    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n;
        int n2;
        Enumeration enumeration = this.varBind.elements();
        int n3 = snmpVarBindArray.length;
        for (n2 = 0; n2 < this.size; ++n2) {
            SnmpVarBind snmpVarBind;
            if (!enumeration.hasMoreElements()) {
                return;
            }
            n = this.translation[n2];
            if (n >= n3) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateResult", "Position '" + n + "' is out of bound...");
                continue;
            }
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpVarBind2 == null) continue;
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Non repeaters Current element : " + snmpVarBind2 + " from agent : " + this.agent);
            }
            if ((snmpVarBind = this.findVarBind(snmpVarBind2, snmpVarBindArray[n])) == null) continue;
            snmpVarBindArray[n] = snmpVarBind;
        }
        n2 = this.size - this.nonRepeat;
        for (n = 2; n <= this.maxRepeat; ++n) {
            for (int i = 0; i < n2; ++i) {
                SnmpVarBind snmpVarBind;
                int n4 = (n - 1) * this.globalR + this.translation[this.nonRepeat + i];
                if (n4 >= n3) {
                    return;
                }
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                SnmpVarBind snmpVarBind3 = (SnmpVarBind)enumeration.nextElement();
                if (snmpVarBind3 == null) continue;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Repeaters Current element : " + snmpVarBind3 + " from agent : " + this.agent);
                }
                if ((snmpVarBind = this.findVarBind(snmpVarBind3, snmpVarBindArray[n4])) == null) continue;
                snmpVarBindArray[n4] = snmpVarBind;
            }
        }
    }
}

