﻿// http://developer.garmin.com/web/communicator-api/documentation/index.html

////////////////////////////////////////////////////////////////////////////
var control;
var listener = Class.create();
var initialized = false;
var devices = null;
var dataType = '';
var fileId = '';
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function OnLoad()
{
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
listener.prototype =
{
  initialize: function ()
  {
  },

  onFinishFindDevices: function (json)
  {
    try
    {
      devices = json.controller.getDevices();
      string = '';

      for (var i = 0; i < devices.length; i++)
      {
        string += devices[i].getNumber() + "|";
        string += devices[i].getId() + "|";
        string += devices[i].getDisplayName() + "|";
        string += devices[i].getSoftwareVersion() + "|";
        string += Number(devices[i].isFileBased()) + "|";
        string += Number(devices[i].supportDeviceDataTypeRead("GPSData")) + "|";
        string += Number(devices[i].supportDeviceDataTypeRead("FitnessHistory")) + "|";
        string += Number(devices[i].supportDeviceDataTypeRead("FIT_TYPE_4")) + "|";
      }

      window.external.RaiseDevicesFound(string);
    }
    catch (e)
    {
      window.external.RaiseError(e.message);
    }
  },

  onFinishReadFromDevice: function (json)
  {
    try
    {
      if (json.success == true)
      {
        if (dataType == "TcxList")
        {
          window.external.RaiseFilesRead("tcx", control.gpsDataString);
        }
        else if (dataType == "FitList")
        {
          window.external.RaiseFilesRead("fit", control.gpsDataString);
        }
        else if (dataType == "GpxList")
        {
          window.external.RaiseFilesRead("gpx", control.gpsDataString);
        }
        else if (dataType == "Tcx")
        {
          window.external.RaiseFileRead(fileId, "tcx", control.gpsDataString);
        }
        else if (dataType == "Fit")
        {
          window.external.RaiseFileRead(fileId, "fit", control.gpsDataString);
        }
        else if (dataType == "Gpx")
        {
          window.external.RaiseFileRead(fileId, "gpx", control.gpsDataString);
        }
        else
        {
          throw Error("Unsupported data requested.");
        }
      }
      else
      {
        throw Error("Reading from device failed.");
      }
    }
    catch (e)
    {
      window.external.RaiseError(e.message);
    }
  },

  onProgressReadFromDevice: function (json)
  {
  },

  onCancelReadFromDevice: function (controller)
  {    
    window.external.RaiseOperationCanceled();
  },

  onCancelFindDevices: function (controller)
  {
    window.external.RaiseOperationCanceled();
  }
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function Init()
{
  try
  {
    control = new Garmin.DeviceControl();    
    control.register(new listener());

    if (!control.isPluginInstalled())
    {
      throw new Error("Plugin is not installed.");
    }

    if (!control.isPluginInitialized())
    {
      throw new Error("Plugin is not initialized.");
    }    

    if (control.unlock(["", ""]))
    {
      $('unlock').innerHTML = "OK";
      initialized = true;

      window.external.RaiseInitialized();
    }
    else
    {
      $('unlock').innerHTML = "Failed";
      throw new Error("Plugin unlock failed.");
    }
  }
  catch (e)
  {    
    $('version').innerHTML = "Not found!";
    window.external.RaiseError(e.message);
  }
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function GetDevices()
{
  try
  {
    if (initialized)
    {
      devices = null;
      control.findDevices();
    }
    else
    {
      throw new Error("Unable to call a method. Plugin is not initialized.");
    }
  }
  catch (e)
  {
    window.external.RaiseError(e.message);
  }
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function SetDevice(no)
{
  try
  {
    if (initialized)
    {
      control.setDeviceNumber(no);
    }
    else
    {
      throw new Error("Unable to call a method. Plugin is not initialized.");
    }
  }
  catch (e)
  {
    window.external.RaiseError(e.message);
  }
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function CancelReadFiles()
{
  try
  {    
    if (initialized)
    {     
      control.cancelReadFromDevice();
    }  
  }
  catch (e)
  {    
  }
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function CancelGetDevices()
{
  try
  {
    if (initialized)
    {
      control.cancelFindDevices();
    }
  }
  catch (e)
  {
  }
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function GetDeviceFiles(type)
{
  try
  {
    if (initialized)
    {
      if (control.getReadCompletionState() != 1)
      {
        if (type == "tcx")
        {
          dataType = "TcxList";
          control.readDataFromDevice("FitnessHistoryDirectory");
        }
        else if (type == "fit")
        {
          dataType = "FitList";
          opt = [{ dataTypeName: 'FIT_TYPE_4', dataTypeID: 'FIT', computeMD5: false}];
          control.readDataFromDevice(Garmin.DeviceControl.FILE_TYPES.readableDir, opt);
        }
        else if (type == "gpx")
        {
          dataType = "GpxList";
          opt = [{ dataTypeName: 'UserDataSync'/*'GpsData'*/, dataTypeID: 'http://www.topografix.com/GPX/1/1', computeMD5: false}];
          control.readDataFromDevice(Garmin.DeviceControl.FILE_TYPES.readableDir, opt);
        }
      }
      else
      {
        throw new Error("Device is reading a file. Another request is not possible.")
      }
    }
    else
    {
      throw new Error("Unable to call a method. Plugin is not initialized.");
    }
  }
  catch (e)
  {
    window.external.RaiseError(e.message);
  }
}
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
function GetDeviceFile(id, type)
{
  try
  {    
    if (control.getReadCompletionState() != 1)
    {
      fileId = id;

      if (type == "tcx")
      {
        dataType = "Tcx";      
        control.readDetailFromDevice(Garmin.DeviceControl.FILE_TYPES.tcxDetail, id);
      }
      else if (type == "fit")
      {
        dataType = "Fit";
        control.getBinaryFile(control.getDeviceNumber(), id);
      }
      else if (type == "gpx")
      {
        dataType = "Gpx";
        control.getBinaryFile(control.getDeviceNumber(), id);
      }
    }
    else 
    {
      throw new Error("Device is reading a file. Another request is not possible.")      
    }
  }
  catch (e)
  {
    window.external.RaiseError(e.message);
  }
}
////////////////////////////////////////////////////////////////////////////
