﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ClassStudents.aspx.cs"
    Inherits="SWTraining.Teacher.ClassStudents" Title="教师工作台-班级学员列表" %>

<%@ Register Src="../UserCol/ReportControl.ascx" TagName="ReportControl" TagPrefix="uc2" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function __Control_Prints(id) {

            var KeyID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        KeyID += "," + e.value;
                    }
                }
            }

            if (KeyID.length > 0) {
                KeyID = KeyID.substring(1, KeyID.length);
            }

            __Control_Print(id, KeyID);
        }

        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }
      
    </script>
    <script type="text/javascript">
        function Send() {
            var StuClassID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StuClassID += "," + e.value;
                    }
                }
            }

            if (StuClassID.length > 0) {
                StuClassID = StuClassID.substring(1, StuClassID.length);
                document.getElementById("StuClassID").value = StuClassID;
                document.formStudent.action = "../SMS/SendToStudent.aspx";
                document.formStudent.submit();
            }
        }
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="tool_ControlPanel">
        <table cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <input onclick="Checks(this)" type="checkbox">
                </td>
                <td>
                    全选
                </td>
                <td class="ico_sms">
                </td>
                <td>
                    <asp:HyperLink ID="hlkSMS" runat="server" NavigateUrl='<%#string.Format("javascript:Send();void(0);") %>'
                        Text="发短信" />
                </td>
                <td>
                    <uc2:ReportControl ID="ReportControl1" runat="server" />
                </td>
                <td>
                    筛选：<asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                        <asp:ListItem Value="0">默认</asp:ListItem>
                        <asp:ListItem Value="1">显示全部</asp:ListItem>
                        <asp:ListItem Value="2">状态正常</asp:ListItem>
                        <asp:ListItem Value="3">状态异常</asp:ListItem>
                        <asp:ListItem Value="4">课时未完学员</asp:ListItem>
                        <asp:ListItem Value="5">课时上完学员</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
        </table>
    </div>
    <div style="clear: both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="StuClassID" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="学号" ItemStyle-Width="120">
                    <ItemTemplate>
                        <input type="checkbox" id="id" value='<%#Eval("StuClassID")%>' />
                        <%#Eval("StudentID")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="姓名">
                    <ItemTemplate>
                        <%# ShowStudent(Eval("StudentName"), Eval("Byname"), Eval("Sex"), Eval("StudentType"), Eval("SignInID"), Eval("MobileTel"), Eval("SignInSMS"), Eval("FingerState"), Eval("FingerCode"), Eval("LastAppLoginTime"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="选班状态">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="ScStateID" Text='<%# Rs.Items.GetScState(Eval("ScStateID")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                        <%#Rs.Items.GetStuClassType(Eval("ContinueReg"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="选班日期">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labDateAndTime" Text='<%# Eval("DateAndTime") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="课时进度">
                    <ItemTemplate>
                        <uc1:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                            Width="90%" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="成绩">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="labScore" Text='<%#Eval("Score")%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="评价">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="hlkOpinion" Text="评价" NavigateUrl='<%# string.Format("PostOpinion.aspx?StuClassID={0}&GetURL={1}",Eval("StuClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员关怀">
                    <ItemTemplate>
                        <span style="color: red">
                            <%#Eval("ReCount")%>
                        </span>次|<a href='StuReply.aspx?StudentID=<%#Eval("StudentID")%>&GetURL=<% = swq.Web.PathAndQuery() %>'>关怀</a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="控制面板">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkControlPanel" runat="server" Text="控制面板" NavigateUrl='<%# string.Format("StudentFrame.aspx?StuClassID={0}&StudentID={1}&GetURL={2}",Eval("StuClassID"),Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input id="Button1" causesvalidation="false" type="button" runat="server" onclick="back()"
                value="返回" />
        </label>
    </div>
    </form>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
    <!--短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
    <input id="StuClassID" name="StuClassID" type="hidden" value="" />
    </form>
    <!--短信Post传递参数代码E-->
</body>
</html>
