﻿<%@ Page Language="c#" CodeBehind="StuClass.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Student.StuClass"
    Title="学员选班列表" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="StuClassID" OnRowDataBound="GridView1_RowDataBound">
            <SelectedRowStyle CssClass="selected" />
            <Columns>
                <asp:TemplateField HeaderText="选班号">
                    <ItemTemplate>
                        <%#Eval("StuClassID")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员">
                    <ItemTemplate>
                        <%#Eval("StudentName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="DateAndTime" ReadOnly="True" HeaderText="选班日期" />
                <asp:TemplateField HeaderText="班级名称">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkClassShow" runat="server" Text='<%#Eval("ClassName")%>' NavigateUrl='<%# string.Format("Class.aspx?ClassID={0}&GetURL={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课地点">
                    <ItemTemplate>
                        <%#Eval("SchoolName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="选班状态">
                    <ItemTemplate>
                        <%#Rs.Items.GetScState(Eval("ScStateID"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="课时进度">
                    <ItemTemplate>
                        <uc1:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                            ProgressWidth="65%" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="PostSchoolName" ReadOnly="True" HeaderText="报名点" />
                <asp:TemplateField HeaderText="评价老师">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkShow" runat="server" Text="评价" NavigateUrl='<%# string.Format("PostTeacher.aspx?StuClassID={0}",Eval("StuClassID")) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="详细信息">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkShow" runat="server" Text="详细信息" NavigateUrl='<%# string.Format("StuClassShow.aspx?StuClassID={0}",Eval("StuClassID")) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
        </label>
    </div>
    </form>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
</body>
</html>
