﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/">

    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>21.5cm</paperwidth>
          <paperheight>9cm</paperheight>
          <pageleft>35mm</pageleft>
          <pageright>5mm</pageright>
          <pagetop>10mm</pagetop>
          <pagebottom>5mm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>8</fontsize>
          <doctype>1</doctype>
          <resolutionkind>3</resolutionkind>
        </pagesetting>

        <style>
          .thead{
          border-top-width:0.2mm;
          border-left-width:0.2mm;
          border-bottom-width:0.2mm;
          border-right-width:0.2mm;
          text-align:center;
          font-style:bold
          }

          .bottom{
          border-left-width:0.2mm;
          border-bottom-width:0.2mm;
          border-right-width:0.2mm;
          font-style:bold
          }

          .left{
          border-left-width:0.2mm;
          font-style:bold
          }

          .right{
          border-right-width:0.2mm;
          font-style:bold
          }

          .leftright{
          border-left-width:0.2mm;
          border-right-width:0.2mm;
          font-style:bold
          }

        </style>
      </head>
      <body>

        <span x="0" y="0.1cm" style="width:14cm; height:1cm;text-align:center;font-size:18;font-family:黑体;">
<xsl:if test="ds/Bill/BillTypeID = 1">报名凭据</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">退货凭据</xsl:if>
</span>
        <span x="11.5cm" y="1cm">
          账户欠费：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Student/CreditMoney)" />
        </span>
        <span x="0" y="1cm" align="left" width="14cm" height="1.27cm">
          姓名：<xsl:value-of select="ds/Bill/StudentName" />$nbsp;学号：<xsl:value-of select="ds/Bill/StudentID" />$nbsp;日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd}',ds/Bill/DateAndTime)" />$nbsp;流水号：<xsl:value-of select="ds/Bill/BillID" />
        </span>

        <table x="0" y="1.5cm" minlines="6" style="border:0.1mm">

          <thead>
            <tr height="0.5cm" class="thead">
              <td width="4.5cm" style="font-style:bold">收费项</td>
              <td width="1.5cm" style="font-style:bold">单价</td>
              <td width="1cm" style="font-style:bold">数量</td>
              <td width="1cm" style="font-style:bold">单位</td>
              <td width="1.5cm" style="font-style:bold">小计</td>
              <td width="5cm" style="font-style:bold">备注</td>
            </tr>
            <tr x="9.5cm" height="0cm">
              <td width="5cm" style="height:4cm;border-right-width:0.2mm">
                <xsl:value-of select="ds/Bill/Remark" />
              </td>
            </tr>
          </thead>


          <tbody>

            <xsl:for-each select="ds/BillItem">
              <tr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;">
                <td width="4.5cm" style="border-left-width:0.2mm;text-formatflags:linelimit">
                  <xsl:value-of select="ProductName" />
                </td>
                <td width="1.5cm" style="font-size:7">
                  <xsl:value-of select="String:FormatNumber('{0:c}',UnitPrice)" />
                </td>
                <td width="1cm">
                  <xsl:value-of select="Amount" />
                </td>
                <td width="1cm">
                  <xsl:value-of select="UnitName" />
                </td>
                <td width="1.5cm" style="font-size:7">
                  <xsl:value-of select="String:FormatNumber('{0:c}',Amount * UnitPrice)" />
                </td>
              </tr>
            </xsl:for-each>
            <filltr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;">
              <td width="4.5cm" style="border-left-width:0.2mm;">
              </td>
              <td width="1.5cm">
              </td>
              <td width="1cm">
              </td>
              <td width="1cm">
              </td>
              <td width="1.5cm">
              </td>
            </filltr>
          </tbody>

          <tfoot>
            <tr height="0.5cm" style="border-top-width:0.25mm;border-bottom-width:0.25mm;">
              <td width="4.5cm" style="border-left-width:0.2mm;">合计：</td>
              <td width="5cm">
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Pay)" />
              </td>
            </tr>
            <tr height="0.5cm" style="border-top-width:0.25mm;border-bottom-width:0.25mm;">
              <td width="4.5cm" style="border-left-width:0.2mm;">
              <xsl:if test="ds/Bill/BillTypeID = 1">优惠：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">扣除：</xsl:if>
              </td>
              <td width="5cm">
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Favourable)" />
              </td>
            </tr>
            <tr height="0.75cm" class="bottom">
              <td width="14.5cm">
                <xsl:if test="ds/Bill/BillTypeID = 1">实收金额：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">实退金额：</xsl:if>
<xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payed)"/> （大写）<xsl:value-of select="String:CHSMoney(ds/Bill/Payed)"/> $nbsp;客户签字：______________________
              </td>
            </tr>



          </tfoot>

        </table>

        <span x="0" y="6.8cm" width="13.8cm" height="1.3cm" style="text-align:right">
          录入员：<xsl:value-of select="ds/Bill/TrueName" />$nbsp;收费点：<xsl:value-of select="ds/Bill/PostSchoolName" />
        </span>

        <span x="0" y="6.8cm" width="11cm" height="1.3cm" style="font-size:6; font-style:italic;">
          打印者：<xsl:value-of select="$PrintTrueName" />$nbsp;打印时间：<xsl:value-of select="$PrintDateTime" />
        </span>

      </body>
    </html>

  </xsl:template>
</xsl:stylesheet>