﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString">
  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>21cm</paperwidth>
          <paperheight>10cm</paperheight>
          <pageleft>6mm</pageleft>
          <pageright>5mm</pageright>
          <pagetop>8mm</pagetop>
          <pagebottom>5mm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>8</fontsize>
          <doctype>1</doctype>
          <resolutionkind>3</resolutionkind>
        </pagesetting>
        <style>
          .thead{
          border-top-width:0.3mm;
          border-left-width:0.3mm;
          border-bottom-width:0.3mm;
          border-right-width:0.3mm;
          text-align:center;
          font-style:bold
          }
          .bottom{
          border-left-width:0.3mm;
          border-bottom-width:0.3mm;
          border-right-width:0.3mm;
          font-style:bold
          }
          .left{
          border-left-width:0.3mm;
          font-style:bold
          }
          .right{
          border-right-width:0.3mm;
          font-style:bold
          }
          .leftright{
          border-left-width:0.3mm;
          border-right-width:0.3mm;
          font-style:bold
          }
        </style>
      </head>
      <body>
        <div  x="0.5cm" y="0.3cm" style="padding:0">

          <span x="3" y="0.5cm" style="width:14cm; height:1cm;text-align:center;font-size:18;font-family:黑体;">
            <xsl:if test="ds/Bill/BillTypeID = 1">消费明细单</xsl:if>
            <xsl:if test="ds/Bill/BillTypeID = 0">退货明细单</xsl:if>
          </span>
          <span x="10.3cm" y="1.5cm">
            账户欠费：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Student/CreditMoney)" />
          </span>
          <span x="3" y="1.5cm" align="left" width="14cm" height="1.27cm">
            姓名：<xsl:value-of select="ds/Bill/StudentName" />$nbsp;学号：<xsl:value-of select="ds/Bill/StudentID" />$nbsp;日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd}',ds/Bill/DateAndTime)" />$nbsp;流水号：<xsl:value-of select="ds/Bill/BillID" />
          </span>

          <table x="3" y="2cm" minlines="6" style="border:0.2mm">
            <thead>
              <tr height="0.5cm" class="thead">
                <td width="3.8cm" style="font-style:bold">收费项</td>
                <td width="1.5cm" style="font-style:bold">单价</td>
                <td width="1cm" style="font-style:bold">数量</td>
                <td width="1cm" style="font-style:bold">单位</td>
                <td width="1.5cm" style="font-style:bold">小计</td>
                <td width="4cm" style="font-style:bold">备注</td>
              </tr>
              <tr x="8.8cm" height="0cm">
                <td width="4cm" style="height:4cm;border-right-width:0.3mm">

                      <xsl:for-each select="/ds/Class">
                            班号：<xsl:value-of select="ClassID" />
                            名称：<xsl:value-of select="ClassName" />
                            上课规律：<xsl:value-of select="TimeRule" />
                            教室：<xsl:value-of select="ClassroomName" />
                            老师：<xsl:value-of select="TeacherName" />
                      </xsl:for-each>

                  <xsl:value-of select="ds/Bill/Remark" />

                </td>
              </tr>
            </thead>

            <tbody>
              <xsl:for-each select="ds/BillItem">
                <tr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;">
                  <td width="3.8cm" style="border-left-width:0.3mm;text-formatflags:linelimit">
                    <xsl:value-of select="ProductName" />
                  </td>
                  <td width="1.5cm" style="font-size:7">
                    <xsl:value-of select="String:FormatNumber('{0:c}',UnitPrice)" />
                  </td>
                  <td width="1cm">
                    <xsl:value-of select="Amount" />
                  </td>
                  <td width="1cm">
                    <xsl:value-of select="UnitName" />
                  </td>
                  <td width="1.5cm" style="font-size:7">
                    <xsl:value-of select="String:FormatNumber('{0:c}',Amount * UnitPrice)" />
                  </td>
                </tr>
              </xsl:for-each>
              <filltr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;">
                <td width="3.8cm" style="border-left-width:0.3mm;">
                </td>
                <td width="1.5cm">
                </td>
                <td width="1cm">
                </td>
                <td width="1cm">
                </td>
                <td width="1.5cm">
                </td>
              </filltr>
            </tbody>
            <tfoot>
              <tr height="0.5cm" style="border-top-width:0.2mm;border-bottom-width:0.2mm;">
                <td width="3.8cm" style="border-left-width:0.3mm;">合计：</td>
                <td width="5cm">
                  <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Pay)" />
                </td>
              </tr>
              <tr height="0.5cm" style="border-top-width:0.2mm;border-bottom-width:0.2mm;">
                <td width="3.8cm" style="border-left-width:0.3mm;">
                  <xsl:if test="ds/Bill/BillTypeID = 1">优惠：</xsl:if>
                  <xsl:if test="ds/Bill/BillTypeID = 0">扣除：</xsl:if>
                </td>
                <td width="5cm">
                  <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Favourable)" />
                </td>
              </tr>
              <tr height="0.75cm" class="bottom">
                <td width="12.8cm">
                  <xsl:if test="ds/Bill/BillTypeID = 1">实收金额：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">实退金额：</xsl:if>
                  <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payed)"/> （大写）<xsl:value-of select="String:CHSMoney(ds/Bill/Payed)"/> $nbsp;客户签字：______________________
                </td>
              </tr>

            </tfoot>
          </table>
          <span x="3" y="7.4cm" width="12.8cm" height="1.3cm" style="text-align:right">
            录入员：<xsl:value-of select="ds/Bill/TrueName" />$nbsp;收费点：<xsl:value-of select="ds/Bill/PostSchoolName" />
          </span>
          <span x="3" y="7.4cm" width="11cm" height="1.3cm" style="font-size:6; font-style:italic;">
            打印者：<xsl:value-of select="$PrintTrueName" />$nbsp;打印时间：<xsl:value-of select="$PrintDateTime" />
          </span>

          <line x="13.5cm" y="0" endx="13.5cm" endy="8cm" style="border:0.2mm; border-style:dot"></line>

          <div  x="13.9cm" y="0cm" style="padding:0">
            <span x="0cm" y="0.5cm" style="width:6cm; height:1cm;text-align:center;font-size:18;font-family:黑体;">
              <xsl:if test="ds/Bill/BillTypeID = 1">消费明细单</xsl:if>
              <xsl:if test="ds/Bill/BillTypeID = 0">退货明细单</xsl:if>
            </span>
            <p x="0cm" y="1.3cm" style="width:5cm;height:1.5cm;font-width:100%; line-height:60%;text-align:left">
              姓名：<xsl:value-of select="ds/Bill/StudentName" /><br />
              学号：<xsl:value-of select="ds/Bill/StudentID" /><br />
              日期：<xsl:value-of select="String:FormatDate('{0:D}',ds/Bill/DateAndTime)" /><br />
              流水号：<xsl:value-of select="ds/Bill/BillID" />
            </p>
            <table x="0cm" y="2.8cm"  style="border:0.25mm" minlines="6">
              <thead class="thead">
                <tr height="0.5cm">
                  <td width="2.5cm">收费项</td>
                  <td width="1.5cm">单价</td>
                  <td width="1cm">数量</td>
                </tr>
              </thead>

              <tbody>
                <xsl:for-each select="ds/BillItem">
                  <tr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;">
                    <td width="2.5cm" style="border-left-width:0.3mm;text-formatflags:linelimit">
                      <xsl:value-of select="ProductName" />
                    </td>
                    <td width="1.5cm" style="font-size:7">
                      <xsl:value-of select="String:FormatNumber('{0:c}',UnitPrice)" />
                    </td>
                    <td width="1cm" align="center" style="border-right-width:0.3mm;text-formatflags:linelimit">
                      <xsl:value-of select="Amount" />
                      <xsl:value-of select="UnitName" />
                    </td>
                  </tr>
                </xsl:for-each>
                <filltr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;">
                  <td width="2.5cm" style="border-left-width:0.3mm;">
                  </td>
                  <td width="1.5cm">
                  </td>
                  <td width="1cm" style="border-right-width:0.3mm;">
                  </td>
                </filltr>
              </tbody>
              <tfoot class="bottom" style="border-top-width:0.3mm">
                <tr height="1cm">
                  <td width="5cm" style="text-align:left">
                    <xsl:if test="ds/Bill/BillTypeID = 1">优惠：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">扣除：</xsl:if>
                    <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Favourable)" /><br />
                    <xsl:if test="ds/Bill/BillTypeID = 1">实收：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">实退：</xsl:if>
                    <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payed)"/><br />
                    单位盖章：______________
                  </td>
                </tr>
              </tfoot>
            </table>
            <span x="0cm" y="7.6cm" width="5cm" height="1.3cm" style="font-size:6;text-align:right">
              录入员：<xsl:value-of select="ds/Bill/TrueName" />$nbsp;收费点：<xsl:value-of select="ds/Bill/PostSchoolName" />
            </span>
            <span x="0cm" y="7.3cm" width="11cm" height="1.3cm" style="font-size:6; font-style:italic;">
              打印者：<xsl:value-of select="$PrintTrueName" />$nbsp;打印时间：<xsl:value-of select="$PrintDateTime" />
            </span>
          </div>
        </div>

      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>