﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/" >

    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>A4</paperkind>
          <pageleft>1cm</pageleft>
          <pageright>1cm</pageright>
          <pagetop>0.5cm</pagetop>
          <pagebottom>0.5cm</pagebottom>
          <pageno>页码：{0}/{1}</pageno>
          <fontname>宋体</fontname>
          <doctype>3</doctype>

        </pagesetting>

        <style>
          .thead{
          border-top-width:0.5mm;
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          text-align:center;
          font-style:bold
          }

          .bottom{
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }

          .left{
          border-left-width:0.5mm;
          font-style:bold
          }

          .right{
          border-right-width:0.5mm;
          font-style:bold
          }

          .leftright{
          border-left-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }

          .bold
          {
          font-style:bold;
          }


        </style>
      </head>
      
      <xsl:for-each select="ds/Class">

        <xsl:variable name="ClassID" select="ClassID" ></xsl:variable>

        <body>
          <text x="0" y="3cm"  style="font-size:16;font-family:黑体;text-align:center" width="19cm" height="1.3cm">
            <xsl:value-of select="ClassName" />课程表
          </text>

          <table x="0" y="5cm" style="border:0.25mm" maxlines="50">

            <thead class="thead">
              <tr height="0.5cm">
                <td width="1.3cm" class="bold">序号</td>
                <td width="5cm" class="bold">主题</td>
                <td width="2.5cm" class="bold">上课日期</td>
                <td width="2.3cm" class="bold">星期</td>
                <td width="2cm" class="bold">课时</td>
                <td width="5.7cm" class="bold">上课时段</td>

              </tr>

            </thead>


            <tbody class="bottom">

              <xsl:for-each select="/ds/LessonDegree[ClassID=$ClassID]">
                <tr height="0.4cm">
                  <td width="1.3cm" align="center">
                    <xsl:number value="position()" format="1" />
                  </td>
                  <td width="5cm" align="center">
                    <xsl:value-of select="Subject" />
                  </td>
                  <td width="2.5cm" align="center">
                    <xsl:value-of select="String:FormatDate('{0:d}',StartDate)" />
                  </td>
                  <td width="2.3cm" align="center">
                    <xsl:value-of select="String:GetWeekText(String:GetDayOfWeek('d',StartDate))" />
                  </td>
                  <td width="2cm" align="center">
                    <xsl:value-of select="Lessons" />
                  </td>
                  <td width="5.7cm" align="center">
                    <xsl:value-of select="String:FormatDate('{0:HH:mm}',StartDate)" />-<xsl:value-of select="String:FormatDate('{0:HH:mm}',EndDate)" />
                  </td>
                </tr>
              </xsl:for-each>
            </tbody>

          </table>

        </body>
      </xsl:for-each>
    </html>

  </xsl:template>
</xsl:stylesheet>