﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString">

  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/">

    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>A4</paperkind>
          <pageleft>1cm</pageleft>
          <pageright>1cm</pageright>
          <pagetop>1cm</pagetop>
          <pagebottom>1cm</pagebottom>
          <fontname>宋体</fontname>
          <doctype>3</doctype>
        </pagesetting>
      </head>
      <body>

        <span x="0" y="1.5cm"  style="font-size:16;font-family:黑体;text-align:center" width="19cm" height="1.3cm">成绩单</span>
        <table x="0.2cm" y="3.8cm" style="border:0.25" maxlines="10">
          <tbody>
            <xsl:for-each select="ds/StuClass">
              <xsl:variable name="StudentID" select="StudentID" ></xsl:variable>
              <xsl:variable name="ClassID" select="ClassID" ></xsl:variable>
              <tr height="0.7cm">
                <td width="2.2cm"  style="text-align:center">姓    名</td>
                <td width="4.8cm"  style="text-align:center">
                  <xsl:value-of select="StudentName" />
                </td>
                <td width="2.2cm"  style="text-align:center">学    号</td>
                <td width="5cm" style="text-align:center">
                  <xsl:value-of select="StudentID" />
                </td>
                <td width="3.8cm"  style="text-align:center" height="4.2cm" format="child">
                  <image x="0.5cm" y="0.2cm" width="2.8cm" height="3.8cm"  byte="true" alt="相片">
                    <xsl:value-of select="/ds/Student[StudentID=$StudentID]/Photo" />
                  </image>
                </td>

              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">性    别</td>
                <td width="4.8cm"  style="text-align:center">
                  <xsl:value-of select="String:GetSex(Sex)" />
                </td>
                <td width="2.2cm"  style="text-align:center">选班日期</td>
                <td width="5cm"  style="text-align:center">
                  <xsl:value-of select="String:FormatDate('{0:d}',DateAndTime)" />
                </td>
              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">班级名称</td>
                <td width="4.8cm" style="text-align:center">
                  <xsl:value-of select="ClassName" />
                </td>
                <td width="2.2cm" style="text-align:center">班    号</td>
                <td width="5cm" style="text-align:center">
                  <xsl:value-of select="ClassID" />
                </td>

              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">上课时间</td>
                <td width="12cm" style="text-align:left">
                  <xsl:value-of select="String:FormatDate('{0:d}',/ds/Class[ClassID=$ClassID]/StartDate)" /> 至 <xsl:value-of select="String:FormatDate('{0:d}',/ds/Class[ClassID=$ClassID]/EndDate)" />
                </td>

              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">上课规律</td>
                <td width="12cm" style="text-align:left">
                  <xsl:value-of select="/ds/Class[ClassID=$ClassID]/TimeRule" />
                </td>

              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">主讲老师</td>
                <td width="12cm" style="text-align:left">
                  <xsl:value-of select="/ds/Class[ClassID=$ClassID]/TeacherName" />
                </td>

              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">迟到次数</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="LateCount" />
                </td>
                <td width="2.2cm" style="text-align:center">早退次数</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="AdvanceCount" />
                </td>
                <td width="2.2cm" style="text-align:center">请假次数</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="LeaveCount" />
                </td>

              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">旷课次数</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="TruancyCount" />
                </td>
                <td width="2.2cm" style="text-align:center">补课次数</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="FillCount" />
                </td>
                <td width="2.2cm" style="text-align:center">实上次数</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="FactCount" />
                </td>

              </tr>
              <tr height="0.7cm">
                <td width="2.2cm" style="text-align:center">上课时数</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="CourseProgress" />/<xsl:value-of select="Lessons" />总课时
                </td>
                <td width="2.2cm" style="text-align:center">学    分</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="String:FormatNumber('{0:f2}',Score)" />
                </td>
                <td width="2.2cm" style="text-align:center">等    级</td>
                <td width="3.8cm" style="text-align:center">
                  <xsl:value-of select="Grade" />
                </td>

              </tr>
              <tr height="14cm">
                <td width="18cm" style="vertical-align:top" format="p">
                  <span>评    语：</span><br />
                  <xsl:value-of select="Opinion" />
                </td>

              </tr>
            </xsl:for-each>
          </tbody>
        </table>


      </body>

    </html>

  </xsl:template>
</xsl:stylesheet>