﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString"
>

  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/">

    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>A4</paperkind>
          <papername>听课证</papername>
          <pageleft>25</pageleft>
          <pageright>25</pageright>
          <pagetop>5</pagetop>
          <pagebottom>0</pagebottom>
          <fontname>宋体</fontname>
          <doctype>2</doctype>
        </pagesetting>

        <style>
          .thead{
          border-top-width:0.5mm;
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          text-align:center;
          font-style:bold
          }

          .bottom{
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }

          .left{
          border-left-width:0.5mm;
          font-style:bold
          }

          .right{
          border-right-width:0.5mm;
          font-style:bold
          }

          .leftright{
          border-left-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }

        </style>
      </head>
      <body>

        <table x="0" y="0" maxlines="5" style="border:0.1mm;border-style:dot">
          <tbody>
            <xsl:for-each select="ds/StuClass">
              <xsl:variable name="StudentID" select="StudentID" ></xsl:variable>
              <tr height="5cm">
                <td width="8cm" height="5cm" style="border-right-width:0" format="child">

                  <image x="5.18cm" y="1.5cm" width="2.28cm" height="3cm" byte="true">
                    <xsl:value-of select="/ds/Student[StudentID=$StudentID]/Photo" />
                  </image>
                  <span y="0.6cm" style="font-size:16;font-family:黑体;height:0.7cm;text-align:center">听课证</span>
                  <p y="1.4cm" width="5.5cm" height="3.5cm" style="line-height:120%;padding:2;border:0">
                    姓名：
                    <span style="font-size:10;font-family:黑体;">
                      <xsl:value-of select="StudentName" />
                    </span><br />
                    性别：<xsl:value-of select="String:GetSex(/ds/Student[StudentID=$StudentID]/Sex)" /><br />
                    学号：<xsl:value-of select="StudentID" /><br />
                    日期：<xsl:value-of select="String:FormatDate('{0:yyyy年M月d日}',DateAndTime)" /><br />
                    班号：<xsl:value-of select="ClassID" /><br />
                    班名：<xsl:value-of select="ClassName" />
                    </p>
                </td>
                <td width="8.5cm" height="5cm" format="child">
                  <span y="0.7cm" style="font-size:12;font-family:黑体;height:0.6cm;text-align:center" byte="true">学员需知</span>
                  <p style="text-valign:middle;line-height:120%;padding-left:2.4">
                    1、听课证限本人使用，不得转借他人。<br />
                    2、听课证作为本校学员象征，不作其他使用。<br />
                    3、来校上课时请佩戴此证。
                  </p>
                </td>
              </tr>
            </xsl:for-each>
          </tbody>
        </table>

      </body>

    </html>

  </xsl:template>
</xsl:stylesheet>