﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:SWString">
  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>5.5cm</paperwidth>
          <paperheight>15cm</paperheight>
          <pageleft>1mm</pageleft>
          <pageright>5mm</pageright>
          <pagetop>8mm</pagetop>
          <pagebottom>5mm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>9</fontsize>
          <doctype>1</doctype>
          <resolutionkind>3</resolutionkind>
        </pagesetting>
        <style>
          .thead{
          border-top-width:0.5mm;
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          text-align:center;
          font-style:bold
          }
          .bottom{
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
          .left{
          border-left-width:0.5mm;
          font-style:bold
          }
          .right{
          border-right-width:0.5mm;
          font-style:bold
          }
          .leftright{
          border-left-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
        </style>
      </head>
      <body>

          <span x="0" y="0.2cm"  style="text-align:center;font-size:22;font-family:黑体;" width="4.5cm" height="1.3cm">充值单</span>
          <span x="0" y="1.3cm" align="left" width="7.6cm" height="1.3cm">
            姓名：<xsl:value-of select="ds/Payment/StudentName" />$nbsp;学号：<xsl:value-of select="ds/Payment/StudentID" />
          </span>
          <span x="0" y="1.6cm" align="left" width="7.6cm" height="1.3cm">
            日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd HH:mm:ss}',ds/Payment/DateAndTime)" />
          </span>
          <span x="0" y="2cm" align="left" width="7.6cm" height="1.3cm">
            编号：<xsl:value-of select="ds/Payment/PaymentID" />
          </span>
          <span x="0" y="2.4cm" align="left" width="7.6cm" height="1.3cm">
            类型：<xsl:value-of select="ds/Payment/PaymentTypeName" />
          </span>
          <span x="0" y="3.3cm" style="text-align:left;font-size:14" width="7.6cm" height="1.3cm">
            金额：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Payment/PayMoney)" />
          </span>
          <span x="0" y="4.3cm" style="text-align:left;font-size:10" width="7.6cm" height="0.5cm">
            （大写）<xsl:value-of select="String:CHSMoney(ds/Payment/PayMoney)"/>
          </span>
          
          <span x="0" y="4.8cm" style="text-align:left;font-size:10" width="7.6cm" height="2cm">
            备注：<xsl:value-of select="ds/Payment/Remark" />
          </span>
        
        <span x="0" y="6.2cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">客户签字：______________________</span>
        <p x="0cm" y="7.1cm" style="width:5cm;height:1.5cm;font-width:100%; line-height:120%;text-align:left">
          录入员：<xsl:value-of select="ds/Payment/TrueName" /><br />
          收费点：<xsl:value-of select="ds/Payment/PostSchoolName" /><br />
          打印者：<xsl:value-of select="$PrintTrueName" /><br />
          打印时间：<xsl:value-of select="$PrintDateTime" />
        </p>

<image x="0.8cm" y="10cm" width="2.8cm" height="2.8cm" twocode="true">
<xsl:value-of select="ds/Payment/PaymentID" />
</image>

        <line x="0cm" y="14cm" endx="5cm" endy="14cm" style="border:0.1mm; border-style:dot"></line>

      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>