﻿<%@ Page Language="c#" CodeBehind="StuClass.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Register.StuClass"
    Title="报名管理-学员选班列表" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/ReportControl.ascx" TagName="ReportControl" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function __Control_Prints(id) {

            var KeyID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        KeyID += "," + e.value;
                    }
                }
            }

            if (KeyID.length > 0) {
                KeyID = KeyID.substring(1, KeyID.length);
            }

            __Control_Print(id, KeyID);
        }

        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }
      
    </script>
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="StuClassID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <SelectedRowStyle CssClass="selected" />
            <Columns>
                <asp:TemplateField HeaderText="选班号">
                    <ItemTemplate>
                        <input type="checkbox" id="id" value='<%#Eval("StuClassID")%>' />
                        <%#Eval("StuClassID")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员">
                    <ItemTemplate>
                        <%#Eval("StudentName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="DateAndTime" ReadOnly="True" HeaderText="选班日期" />
                <asp:TemplateField HeaderText="班级名称">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkClassShow" runat="server" Text='<%#Eval("ClassName")%>' NavigateUrl='<%# string.Format("Class.aspx?ClassID={0}&GetURL={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课地点">
                    <ItemTemplate>
                        <%#Eval("SchoolName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="选班状态">
                    <ItemTemplate>
                        <%#Rs.Items.GetScState(Eval("ScStateID"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                        <%#Rs.Items.GetStuClassType(Eval("ContinueReg"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="课时进度">
                    <ItemTemplate>
                        <uc1:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                            ProgressWidth="65%" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="PostSchoolName" ReadOnly="True" HeaderText="报名点" />
                <asp:TemplateField HeaderText="课时库存">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkBuy" runat="server" Text="课时库存" NavigateUrl='<%# string.Format("BuyLessonsLog.aspx?StuClassID={0}",Eval("StuClassID")) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="浏览">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkShow" runat="server" Text="浏览" NavigateUrl='<%# string.Format("StuClassShow.aspx?StuClassID={0}",Eval("StuClassID")) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkEdit" runat="server" Text="编辑" NavigateUrl='<%# string.Format("PostStuClass.aspx?StuClassID={0}&StudentID={1}&ClassID={2}&GetURL={3}",Eval("StuClassID"),Eval("StudentID"),Eval("ClassID"),Server.UrlEncode(Request.Url.PathAndQuery)) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                            OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="tool_ControlPanel">
        <table>
            <tr>
                <td>
                    <input onclick="Checks(this)" type="checkbox">全选
                </td>
                <td>
                    <uc2:ReportControl ID="ReportControl1" runat="server" />
                </td>
            </tr>
        </table>
    </div>
    <div class="both"></div>

    <div class="backpanel">
        <label class="lab_buttom">
<input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
</label>
    </div>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、如果您发现选班信息无法编辑或删除，请到教务模块：学员控制面板-选班信息-编辑或删除，因为选班信息的管理工作由教务负责。<br />
    </div>
    </form>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
</body>
</html>
