﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LikeStudent.aspx.cs" Inherits="SWTraining.Service.LikeStudent"
    Title="报名管理-学员同名检测" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
            <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
                DataKeyNames="StudentID" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="学号">
                        <ItemTemplate>
                            <asp:Label ID="labStudentID" runat="server" Text='<%# Eval("StudentID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员">
                        <ItemTemplate>
                            <%#Eval("StudentName")%><%# (Convert.IsDBNull(Eval("Byname")) || Eval("Byname").ToString().Trim() == "") ? "" : "(" + Eval("Byname").ToString() + ")"%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类别">
                        <ItemTemplate>
                            <%#Rs.Items.GetStudentType(Eval("StudentType"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="DateAndTime" DataFormatString="{0:d}" HeaderText="报名日期" />
                    <asp:TemplateField HeaderText="校区">
                        <ItemTemplate>
                            <%#Eval("SchoolName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="可用余额">
                        <ItemTemplate>
                            <%#Eval("AvailableMoney", "{0:c2}")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="消费单">
                        <ItemTemplate>
                            帐单数<span style="color: Red"><b>
                                <%#Eval("BillCount")%></b></span>
                            <asp:HyperLink ID="hlkBill" runat="server" Text="增加" NavigateUrl='<%# string.Format("StudentFrame.aspx?StudentID={0}&PageIndex=2&action=add&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="最新选班">
                        <ItemTemplate>
                            <%#Eval("LastClassName")%>
                            (<span style="color: Red"><b><%#Eval("StuClassCount")%></b></span>)
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="控制面板">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkControlPanel" runat="server" Text="控制面板" NavigateUrl='<%# string.Format("StudentFrame.aspx?StudentID={0}&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="录入员">
                        <ItemTemplate>
                            <%#Eval("TrueName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
<asp:Button ID="btnBack" runat="server" OnClick="btnBack_Click" Text = "返回" />
</label>
    </div>
    </form>
</body>
</html>
