﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UserReward.aspx.cs" Inherits="SWTraining.Personnel.UserReward"
    Title="人事管理-奖罚管理" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
        <table id="FeeTable" runat="server" cellspacing="0" class="table">
            <tr>
                <th colspan="2">
                    奖罚处理
                </th>
            </tr>
            <tr>
                <td align="right" style="width: 124px">
                    员工：
                </td>
                <td>
                    <asp:ListBox ID="lbxUsers" runat="server" SelectionMode="Multiple" DataTextField="TrueName"
                        DataValueField="UserID" Height="93px" Width="124px"></asp:ListBox>
                </td>
            </tr>
            <tr>
                <td align="right" style="width: 124px; height: 11px">
                    类型：
                </td>
                <td style="height: 11px">
                    <asp:DropDownList ID="ddlReward" runat="server" DataTextField="RewardName" DataValueField="RewardID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td align="right" style="width: 124px; height: 11px">
                    金额：
                </td>
                <td>
                    <asp:TextBox ID="tbxPay" runat="server" Width="43px"></asp:TextBox>
                    <span style="color: Red">*</span>
                </td>
            </tr>
            <tr>
                <td align="right" style="width: 124px; height: 11px">
                    时间：
                </td>
                <td style="height: 11px">
                    <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td align="right" style="width: 124px; height: 11px">
                    理由：
                </td>
                <td style="height: 11px">
                    <asp:TextBox ID="tbxRemark" runat="server" Width="489px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td align="right" style="width: 124px; height: 11px">
                </td>
                <td style="height: 11px">
                    <label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click" />
</label>
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="UserRewardID"
            CssClass="gridview" OnRowDeleting="GridView1_RowDeleting" Width="100%" OnRowCancelingEdit="GridView1_RowCancelingEdit"
            OnRowEditing="GridView1_RowEditing" OnRowDataBound="GridView1_RowDataBound" OnRowUpdating="GridView1_RowUpdating">
            <Columns>
                <asp:BoundField DataField="UserRewardID" HeaderText="编号" InsertVisible="False"
                    ReadOnly="True" SortExpression="UserRewardID">
                    <ItemStyle HorizontalAlign="Left" />
                </asp:BoundField>
                <asp:TemplateField HeaderText="员工" SortExpression="ToTrueName">
                    <ItemTemplate>
                        <asp:Label ID="labToTrueName" runat="server" Text='<%# Bind("ToTrueName") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList runat="server" ID="ddlUser" DataSource='<%# swq.Cache.GetUsers() %>'
                            DataTextField="TrueName" DataValueField="UserID">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类型" SortExpression="RewardID">
                    <ItemTemplate>
                        <asp:Label ID="labRewardName" runat="server" Text='<%# Bind("RewardName") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlReward" DataSource='<%# swq.Cache.GetReward() %>' runat="server"
                            SelectedValue='<%# Bind("RewardID") %>' DataTextField="RewardName" DataValueField="RewardID">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="金额" SortExpression="Pay">
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxPay" runat="server" Text='<%# Bind("Pay","{0:f2}") %>' Width="50px"></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labPay" runat="server" Text='<%# Bind("Pay","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="时间" SortExpression="DateAndTime">
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField SortExpression="Remark" HeaderText="理由">
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Bind("Remark") %>' Width="150px"></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="录入员" ShowHeader="False">
                    <ItemTemplate>
                        <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消"
                    UpdateText="更新" CausesValidation="False" ShowEditButton="True" />
                <asp:TemplateField HeaderText="删除" ShowHeader="False">
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButton2" runat="server" CausesValidation="False" CommandName="Delete"
                            Text="删除" OnClientClick="<%# Rs.Messages.确定删除 %>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
