﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Teacher.aspx.cs" Inherits="SWTraining.Mobile.User.Teacher"
    Title="查看学员出勤" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link href="Themes/css.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <uc1:Header ID="Header1" runat="server" />
    <div class="tool_Search">
        时间：<asp:DropDownList ID="ddlDate" runat="server">
            <asp:ListItem Value="0">全部</asp:ListItem>
            <asp:ListItem Value="-2">前天</asp:ListItem>
            <asp:ListItem Value="-1">昨天</asp:ListItem>
            <asp:ListItem Value="1">今日</asp:ListItem>
            <asp:ListItem Value="2">明日</asp:ListItem>
            <asp:ListItem Value="3" Selected="True">最近7天</asp:ListItem>
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="转到" />
        </label>
    </div>
    <div class="divpanel">
        <div class="tabletitle">
            课程表</div>
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" DataKeyNames="LessonDegreeID"
            AutoGenerateColumns="false" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                            ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                            CommandArgument='<%#Eval("LeStateID")%>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="ClassName" ReadOnly="True" HeaderText="班级" />
                <asp:TemplateField HeaderText="上课日期">
                    <ItemTemplate>
                        <span runat="server" id="spanDate">
                            <%#Eval("StartDate","{0:d}")%></span><span style="color: Red">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="上课时段">
                    <ItemTemplate>
                        <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
        </label>
    </div>
    </form>
</body>
</html>
