﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuClassShow.aspx.cs" Inherits="SWTraining.Mobile.Student.StuClassShow"
    Title="浏览选班信息" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link href="Themes/css.css" rel="stylesheet" type="text/css" />
    <script>
        function autoHeight() {
            td_parent.style.height = document.getElementById("fvStuClassInfo_gvScores").clientHeight + 1 + "px";
        }
    </script>
</head>
<body onload="autoHeight()">
    <form id="form1" runat="server">
    <uc2:Header ID="Header1" runat="server" />
    <div class="divpanel">
        <asp:FormView ID="fvStuClassInfo" runat="server" Width="100%">
            <ItemTemplate>
                <table class="table" cellspacing="0">
                    <tr>
                        <th colspan="2">
                            基本信息
                        </th>
                    </tr>
                    <tr>
                        <td style="width: 30%">
                            学号：
                        </td>
                        <td>
                            <%#Eval("StudentID")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            姓名：
                        </td>
                        <td>
                            <%#Eval("StudentName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            班号：
                        </td>
                        <td>
                            <%#Eval("ClassID")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            班级：
                        </td>
                        <td>
                            <%#Eval("ClassName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            选班日期：
                        </td>
                        <td>
                            <%#Eval("DateAndTime")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            选班状态：
                        </td>
                        <td>
                            <%# Rs.Items.GetScState(Eval("ScStateID"))%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            续报：
                        </td>
                        <td>
                            <%# Rs.Items.GetYN(Eval("ContinueReg"))%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            报名点：
                        </td>
                        <td>
                            <%#Eval("PostSchoolName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            备注：
                        </td>
                        <td>
                            <asp:Literal ID="litRemark" runat="server" Mode="Encode" Text='<%#Eval("Remark")%>'></asp:Literal>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            录入员：
                        </td>
                        <td>
                            <%#Eval("TrueName")%>
                        </td>
                    </tr>
                </table>
                <table class="table" cellspacing="0" style="margin-top: 9px">
                    <tr>
                        <th colspan="2">
                            上课信息
                        </th>
                    </tr>
                    <tr>
                        <td style="width: 30%">
                            上课地点：
                        </td>
                        <td>
                            <%#Eval("SchoolName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            课时进度：
                        </td>
                        <td>
                            <%#Eval("Lessons") %>/<%#Eval("CourseProgress") %>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            出勤次数：
                        </td>
                        <td>
                            <%#Eval("FactCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            迟到次数：
                        </td>
                        <td>
                            <%#Eval("LateCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            早退次数：
                        </td>
                        <td>
                            <%#Eval("AdvanceCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            旷课次数：
                        </td>
                        <td>
                            <%#Eval("TruancyCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            请假次数：
                        </td>
                        <td>
                            <%#Eval("LeaveCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            补课次数：
                        </td>
                        <td>
                            <%#Eval("FillCount")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            评价日期：
                        </td>
                        <td>
                            <%#Eval("OpinionDate")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            总成绩：
                        </td>
                        <td>
                            <%#Eval("Score")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            阶段或科目成绩：
                        </td>
                        <td valign="top" style="height: auto; position: relative" id="td_parent">
                            <div style="width: 90%; height: auto; position: relative">
                                <asp:GridView ID="gvScores" runat="server" Height="100%" CssClass="gridview" DataSource='<%# db.Score.GetScore((int)Eval("StuClassID")) %>'
                                    AutoGenerateColumns="False">
                                    <Columns>
                                        <asp:TemplateField HeaderText="成绩名称">
                                            <ItemTemplate>
                                                <asp:Label ID="labScoreName" runat="server" Text='<%# Eval("ScoreName") %>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="日期">
                                            <ItemTemplate>
                                                <asp:Label ID="labDateAndTime" runat="server" Text='<%# Eval("DateAndTime") %>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="分数">
                                            <ItemTemplate>
                                                <asp:Label ID="labScore" runat="server" Text='<%# Eval("Score","{0:f2}") %>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            等级：
                        </td>
                        <td>
                            <%#Eval("Grade")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            评价内容：
                        </td>
                        <td>
                            <asp:Literal ID="litOpinion" runat="server" Mode="Encode" Text='<%#Eval("Opinion")%>'></asp:Literal>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
        </label>
    </div>
    </form>
</body>
</html>
