﻿<%@ Page Language="c#" CodeBehind="LessonShow.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Mobile.Student.LessonShow"
    Title="学员选班列表" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="Header.ascx" TagName="Header" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link href="Themes/css.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <uc1:Header ID="Header1" runat="server" />
    <div class="divpanel">
        <asp:FormView ID="fvLessonDegreeInfo" runat="server" Width="100%">
            <ItemTemplate>
                <table class="table" cellspacing="0">
                    <tr>
                        <th colspan="2">
                            上课信息
                        </th>
                    </tr>
                    <tr>
                        <td style="width:30%">
                            课题：
                        </td>
                        <td>
                            <%#Eval("Subject")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            班级：
                        </td>
                        <td>
                            <%#Eval("ClassName")%>(<%#Eval("ClassID")%>)
                        </td>
                    </tr>
                    <tr>
                        <td>
                            讲师：
                        </td>
                        <td>
                            <%#Eval("TeacherName")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            上课日期：
                        </td>
                        <td>
                            <span>
                                <%#Eval("StartDate","{0:d}")%></span><span style="color: Red">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            上课时段：
                        </td>
                        <td>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            课时数：
                        </td>
                        <td>
                            <%#Eval("Lessons")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            家庭作业：
                        </td>
                        <td>
                            <%#Eval("Remark")%>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
    </div>
    <div class="divpanel">
        <asp:FormView ID="fvLessonInfo" runat="server" Width="100%">
            <ItemTemplate>
                <table class="table" cellspacing="0">
                    <tr>
                        <th colspan="2">
                            考勤信息
                        </th>
                    </tr>
                    <tr>
                        <td style="width:30%">
                            状态：
                        </td>
                        <td>
                            <%#Rs.Items.GetAtState(Eval("AtStateID"))%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            有效课时：
                        </td>
                        <td>
                            <%#Eval("Lessons")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            签到时间：
                        </td>
                        <td>
                            <%#Eval("SignOn")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            签退时间：
                        </td>
                        <td>
                            <%#Eval("SignOut")%>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            课堂表现：
                        </td>
                        <td>
                            <%#Eval("Remark")%>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
            <input id="Button1" causesvalidation="false" type="button" runat="server" onclick="back()"
                value="返回" />
        </label>
    </div>
    </form>
</body>
</html>
