﻿<%@ Page Language="c#" CodeBehind="StudentList.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Finance.StudentList"
    Title="财务管理-学员列表" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }



        function Send() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StudentID += "," + e.value;
                    }
                }
            }

            if (StudentID.length > 0) {
                StudentID = StudentID.substring(1, StudentID.length);
                document.getElementById("StudentID").value = StudentID;
                document.formStudent.action = "../SMS/SendToStudent.aspx";
                document.formStudent.submit();
            }
        }
    </script>
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        ＩＤ卡号：<asp:TextBox ID="tbxSignInID" runat="server" Width="101px"></asp:TextBox>
        学号：<asp:TextBox ID="tbxStudentID" runat="server" Width="84px"></asp:TextBox>
        姓名：<asp:TextBox ID="tbxStudentName" runat="server" Width="88px"></asp:TextBox>
        电话：<asp:TextBox ID="tbxTel" runat="server" Width="88px"></asp:TextBox>
        校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
        </asp:DropDownList>
        录入员：<asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
        </asp:DropDownList>
        顾问：<asp:DropDownList ID="ddlConsultant" runat="server" DataTextField="TrueName" DataValueField="UserID">
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSelect" runat="server" Text="查询" OnClick="btnSelect_Click"></asp:Button>
        </label>
    </div>
    <div class="both">
    </div>
    <div class="tool_ControlPanel">
        <table cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <input onclick="Checks(this)" type="checkbox">
                </td>
                <td>
                    全选
                </td>
                <td class="ico_sms">
                </td>
                <td>
                    <asp:HyperLink ID="hlkSMS" runat="server" NavigateUrl='<%#string.Format("javascript:Send();void(0);") %>'
                        Text="发短信" />
                </td>
                <td style="padding-left: 2px">
                    排序：
                </td>
                <td>
                    <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                        <asp:ListItem Value="0">默认排序</asp:ListItem>
                        <asp:ListItem Value="2">录入日期</asp:ListItem>
                        <asp:ListItem Value="3">学员编号</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
        </table>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="StudentID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="学号">
                    <ItemTemplate>
                        <span runat="server" id="spanBox">
                            <input type="checkbox" id="id" value='<%#Eval("StudentID")%>' /></span>
                        <asp:Label ID="labStudentID" runat="server" Text='<%# Eval("StudentID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员">
                    <ItemTemplate>
                        <%# ShowStudent(Eval("StudentName"), Eval("Byname"), Eval("Sex"), Eval("StudentType"), Eval("SignInID"), Eval("MobileTel"), Eval("SignInSMS"), Eval("FingerState"), Eval("FingerCode"), Eval("LastAppLoginTime"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="DateAndTime" DataFormatString="{0:d}" HeaderText="报名日期" />
                <asp:TemplateField HeaderText="校区">
                    <ItemTemplate>
                        <%#Eval("SchoolName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="消费总额">
                    <ItemTemplate>
                        <%#Eval("ConsumedMoney", "{0:c2}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="可用余额">
                    <ItemTemplate>
                        <%#Eval("AvailableMoney", "{0:c2}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="欠费">
                    <ItemTemplate>
                        <%#Eval("CreditMoney", "{0:c2}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员账户">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkPayment" runat="server" Text="账户" NavigateUrl='<%# string.Format("StudentFrame.aspx?StudentID={0}&PageIndex=1&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="消费单">
                    <ItemTemplate>
                        帐单数<span style="color: Red"><b>
                            <%#Eval("BillCount")%></b></span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="最新选班">
                    <ItemTemplate>
                        <%#Eval("LastClassName")%>
                        (<span style="color: Red"><b><%#Eval("StuClassCount")%></b></span>)
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="控制面板">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkControlPanel" runat="server" Text="控制面板" NavigateUrl='<%# string.Format("StudentFrame.aspx?StudentID={0}&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="积分兑换">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkPoints" runat="server" Text="兑换" NavigateUrl='<%# string.Format("StudentFrame.aspx?StudentID={0}&PageIndex=8&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="录入员">
                    <ItemTemplate>
                        <%#Eval("TrueName")%>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
    <!--学员短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
    <input id="StudentID" name="StudentID" type="hidden" value="" />
    </form>
    <!--学员短信Post传递参数代码E-->
    <div class="divremark">
        <b>注意事项：</b><br />
        1、在学员姓名栏中输入姓名拼音简写可快速查询学员（如：输入kz，可查询出孔子）。<br />
    </div>
</body>
</html>
