﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuPayment.aspx.cs" Inherits="SWTraining.Finance.StuPayment"
    Title="财务管理-学员账户管理" %>

<%@ Import Namespace="SWTraining" %>
<%@ Register Src="../UserCol/Remark.ascx" TagName="Remark" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function StudentBox() {
            window.showModelessDialog('../Tools/StudentBox.aspx', window, 'dialogWidth=750px;dialogHeight=500px');
        }
    </script>
</head>
<body>
    <script type="text/javascript">        var IsPrint = false;</script>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
    <form id="form1" runat="server">
    <div class="divpanel" runat="server" id="divSellInfo" visible="false">
        <table class="table" cellspacing="0">
            <tr>
                <th>
                    订单提示
                </th>
            </tr>
            <tr>
                <td>
                    本次需支付：<asp:Label ID="labPayed" runat="server" ForeColor="#000099"></asp:Label>
                    元&nbsp;&nbsp; <span runat="server" id="spanMissing" visible="false">帐户缺少：<asp:Label
                        ID="labMissing" runat="server" ForeColor="Red"></asp:Label>
                        元</span>
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <table class="table" cellspacing="0">
            <tr>
                <th colspan="3">
                    &nbsp; 学员账户管理
                </th>
            </tr>
            <tr>
                <td>
                    学号：
                </td>
                <td>
                    <asp:TextBox ID="tbxStudentID" runat="server" ReadOnly="True"></asp:TextBox>
                </td>
                <td rowspan="7" style="width: 350px">
                    <asp:FormView ID="fvStudent" runat="server" Width="100%">
                        <ItemTemplate>
                            <table class="smallgridview" cellspacing="0">
                                <tr>
                                    <th colspan="3" style="text-align: center">
                                        账户信息
                                    </th>
                                </tr>
                                <tr>
                                    <td>
                                        学号：
                                    </td>
                                    <td>
                                        <%#Eval("StudentID")%>
                                    </td>
                                    <td rowspan="2">
                                        <asp:Image ID="imgPhoto" runat="server" Height="50" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        姓名：
                                    </td>
                                    <td>
                                        <%#Eval("StudentName")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        可用余额：
                                    </td>
                                    <td colspan="2">
                                        <span style="color: Red">
                                            <%#Eval("AvailableMoney", "{0:c2}")%></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        消费总额：
                                    </td>
                                    <td colspan="2">
                                        <%#Eval("ConsumedMoney","{0:c2}")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        借款金额：
                                    </td>
                                    <td colspan="2">
                                        <%#Eval("CreditMoney", "{0:c2}")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        积分：
                                    </td>
                                    <td colspan="2">
                                        <%#Eval("Points")%>分
                                    </td>
                                </tr>
                            </table>
                        </ItemTemplate>
                    </asp:FormView>
                </td>
            </tr>
            <tr>
                <td>
                    姓名：
                </td>
                <td>
                    <asp:TextBox ID="tbxStudentName" runat="server" ReadOnly="True"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    交费类型：
                </td>
                <td>
                    <asp:DropDownList ID="ddlPaymentType" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlPaymentType_SelectedIndexChanged">
                        <asp:ListItem Value="1">交费</asp:ListItem>
                        <asp:ListItem Value="2">退费</asp:ListItem>
                        <asp:ListItem Value="3">借款</asp:ListItem>
                        <asp:ListItem Value="4">扣除借款</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    收款方式：
                </td>
                <td>
                    <asp:DropDownList ID="ddlPayMethod" runat="server">
                        <asp:ListItem Value="">--</asp:ListItem>
                        <asp:ListItem Value="现金">现金</asp:ListItem>
                        <asp:ListItem Value="刷卡">刷卡</asp:ListItem>
                        <asp:ListItem Value="转账">转账</asp:ListItem>
                        <asp:ListItem Value="支票">支票</asp:ListItem>
                        <asp:ListItem Value="网银">网银</asp:ListItem>
                        <asp:ListItem Value="支付宝">支付宝</asp:ListItem>
                        <asp:ListItem Value="其它">其它</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    金额：
                </td>
                <td>
                    <asp:TextBox ID="tbxPayMoney" runat="server" Width="58px"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    日期：
                </td>
                <td>
                    <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    备注：
                </td>
                <td>
                    <asp:TextBox ID="tbxRemark" runat="server" Width="209px"></asp:TextBox>
                </td>
            </tr>
            <tr runat="server" id="trCredit" visible="false">
                <td>
                    借款到期：
                </td>
                <td colspan="2">
                    <asp:TextBox ID="tbxCreditExpiration" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    交费点：
                </td>
                <td colspan="2">
                    <asp:DropDownList ID="ddlPostSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    收费文员：
                </td>
                <td colspan="2">
                    <asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    短信通知：
                </td>
                <td colspan="2">
                    <asp:CheckBox ID="cbxSMS" runat="server" Checked="True" />
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;
                </td>
                <td colspan="2">
                    <label class="lab_buttom">
<asp:Button ID="btnPost" runat="server" Text="确定" OnClick="btnPost_Click" />
</label>
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="gridview"
            OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowDeleting="GridView1_RowDeleting"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" DataKeyNames="PaymentID"
            OnRowDataBound="GridView1_RowDataBound" OnRowCommand="GridView1_RowCommand">
            <Columns>
                <asp:BoundField DataField="PaymentID" HeaderText="编号" ReadOnly="true" />
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                        <asp:Label ID="labPaymentType" runat="server" Text='<%#Eval("PaymentTypeName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="金额">
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxPayMoney" runat="server" Text='<%# Bind("PayMoney") %>'></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labPayMoney" runat="server" Text='<%# Bind("PayMoney", "{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="收款方式">
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlPayMethod" runat="server" SelectedValue='<%# Eval("PayMethod") %>'>
                            <asp:ListItem Value="">--</asp:ListItem>
                            <asp:ListItem Value="现金">现金</asp:ListItem>
                            <asp:ListItem Value="刷卡">刷卡</asp:ListItem>
                            <asp:ListItem Value="转账">转账</asp:ListItem>
                            <asp:ListItem Value="支票">支票</asp:ListItem>
                            <asp:ListItem Value="网银">网银</asp:ListItem>
                            <asp:ListItem Value="支付宝">支付宝</asp:ListItem>
                            <asp:ListItem Value="其它">其它</asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labPayMethod" runat="server" Text='<%# Bind("PayMethod") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="日期">
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="备注">
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="借款到期">
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxCreditExpiration" runat="server" Text='<%# Bind("CreditExpiration") %>'></asp:TextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <asp:Label ID="labCreditExpiration" runat="server" Text='<%# Bind("CreditExpiration") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="办理点">
                    <ItemTemplate>
                        <asp:Label ID="labPostSchoolName" runat="server" Text='<%# Bind("PostSchoolName") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlPostSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="收费文员">
                    <ItemTemplate>
                        <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="已打">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnPrint" runat="server" CommandName="Print" CommandArgument='<%#Eval("PaymentID") %>'
                            Text='<%# (int)Eval("PrintCount") > 0 ? "已" : "未" %>' Font-Size="9pt"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="打印">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkPrint" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("PaymentID")) %>'
                            ImageUrl='<%# accTheme("print.gif")%>' CssClass="noborder"></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="divpanel">
        <uc2:Remark ID="imgBig" runat="server" />
    </div>
    <div class="backpanel">
        <label class="lab_buttom">
<input id="Button1" causesvalidation="false" type="button" runat="server" onclick="back()"
            value="返回" />
</label>
    </div>
    <div class="divremark">
        <b>注意事项：</b><br />
        退费、扣除借款请使用负数。<br />
    </div>
    </form>
</body>
</html>
