﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="IncomeList.aspx.cs" Inherits="SWTraining.Finance.IncomeList"
    Title="财务管理-帐目列表" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel" runat="server">
        <table class="table" cellspacing="0">
            <tr>
                <th colspan="2">
                    账目查询
                </th>
            </tr>
            <tr>
                <td>
                    入帐日期：
                </td>
                <td>
                        <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                        -<asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    校区：
                </td>
                <td>
                    <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    类型：</td>
                <td>
                    <asp:DropDownList ID="ddlIncome" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlIncome_SelectedIndexChanged">
                        <asp:ListItem Value="-1" Text=" "></asp:ListItem>
                        <asp:ListItem Value="0">支出</asp:ListItem>
                        <asp:ListItem Value="1">收入</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;&nbsp;&nbsp;<br />
                </td>
            </tr>
            <tr>
                <td>
                    账目分类：</td>
                <td>
                    <asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                        DataValueField="IncomeClassID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    资金账户：</td>
                <td>
                    <asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName"
                        DataValueField="AccountID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    <label class="lab_buttom">
<asp:Button ID="btnSearch" runat="server" Text="查询" OnClick="btnSearch_Click" />
</label>
                </td>
            </tr>
        </table>
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="smallgridview" AutoGenerateColumns="False"
            DataKeyNames="IncomeID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
            OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting">
            <Columns>
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                        <%# (int)Eval("Income") == 0 ? "支出" : "收入" %>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="日期">
                    <ItemTemplate>
                        <asp:Label ID="labAccountDate" runat="server" Text='<%# Eval("AccountDate","{0:d}") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxAccountDate" runat="server" Text='<%# Eval("AccountDate","{0:d}") %>'
                            Width="80"></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="账目">
                    <ItemTemplate>
                        <asp:Label ID="labIncomeClassName" runat="server" Text='<%# Eval("IncomeClassName") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                            DataValueField="IncomeClassID" DataSource='<%# swq.Cache.GetIncomeClass((int)Eval("Income")) %>'
                            SelectedValue='<%# Eval("IncomeClassID") %>'>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="金额">
                    <ItemTemplate>
                        <asp:Label ID="labPrice" runat="server" Text='<%# Eval("Price","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxPrice" runat="server" Text='<%# Eval("Price") %>' Width="60"></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="帐户">
                    <ItemTemplate>
                        <asp:Label ID="labAccountName" runat="server" Text='<%# Eval("AccountName") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName" DataValueField="AccountID"
                            DataSource='<%# swq.Cache.GetAccount() %>' SelectedValue='<%# Eval("AccountID") %>'>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="校区">
                    <ItemTemplate>
                        <%# Eval("SchoolName") %>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>"
                            SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="备注">
                    <ItemTemplate>
                        <asp:Label ID="labRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
