﻿<%@ Page Language="c#" CodeBehind="StudentList.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Consultant.StudentList"
    Title="顾问工作台-我的学员" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }



        function Send() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StudentID += "," + e.value;
                    }
                }
            }

            if (StudentID.length > 0) {
                StudentID = StudentID.substring(1, StudentID.length);
                document.getElementById("StudentID").value = StudentID;
                document.formStudent.action = "../SMS/SendToStudent.aspx";
                document.formStudent.submit();
            }
        }
    </script>
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        ＩＤ卡号：<asp:TextBox ID="tbxSignInID" runat="server" Width="114px"></asp:TextBox>
        学号：<asp:TextBox ID="tbxStudentID" runat="server" Width="84px"></asp:TextBox>
        姓名：<asp:TextBox ID="tbxStudentName" runat="server" Width="88px"></asp:TextBox>
        电话：<asp:TextBox ID="tbxTel" runat="server" Width="94px"></asp:TextBox>
        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
        </asp:DropDownList>
        <label class="lab_buttom">
            <asp:Button ID="btnSelect" runat="server" Text="查询" OnClick="btnSelect_Click"></asp:Button>
        </label>
    </div>
    <div class="both">
    </div>
    <div class="tool_ControlPanel">
        <table cellpadding="0" cellspacing="0">
            <tr>
                <td>
                    <input onclick="Checks(this)" type="checkbox">
                </td>
                <td>
                    全选
                </td>
                <td class="ico_sms">
                </td>
                <td>
                    <asp:HyperLink ID="hlkSMS" runat="server" NavigateUrl='<%#string.Format("javascript:Send();void(0);") %>'
                        Text="发短信" />
                </td>
                <td style="padding-left: 2px">
                </td>
            </tr>
        </table>
    </div>
    <div style="clear: both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="StudentID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField HeaderText="学号">
                    <ItemTemplate>
                        <span runat="server" id="spanBox">
                            <input type="checkbox" id="id" value='<%#Eval("StudentID")%>' /></span>
                        <asp:Label ID="labStudentID" runat="server" Text='<%# Eval("StudentID") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员">
                    <ItemTemplate>
                        <%#Eval("StudentName")%><%# (Convert.IsDBNull(Eval("Byname")) || Eval("Byname").ToString().Trim() == "") ? "" : "(" + Eval("Byname").ToString() + ")"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类别">
                    <ItemTemplate>
                        <%#Rs.Items.GetStudentType(Eval("StudentType"))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="DateAndTime" DataFormatString="{0:d}" HeaderText="报名日期" />
                <asp:TemplateField HeaderText="校区">
                    <ItemTemplate>
                        <%#Eval("SchoolName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="可用余额">
                    <ItemTemplate>
                        <%#Eval("AvailableMoney", "{0:c2}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="最新选班">
                    <ItemTemplate>
                        <%#Eval("LastClassName")%>
                        (<span style="color: Red"><b><%#Eval("StuClassCount")%></b></span>)
                        <asp:HyperLink ID="hlkStuClass" runat="server" Text="查看" NavigateUrl='<%# string.Format("StuClass.aspx?StudentID={0}&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="最后回访信息">
                    <ItemTemplate>
                        <%#Eval("LastPostName")%>|<%#Eval("LastPostTime")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="学员关怀">
                    <ItemTemplate>
                        <span style="color: red">
                            <%#Eval("ReCount")%>
                        </span>次|<a href='StuReply.aspx?StudentID=<%#Eval("StudentID")%>&GetURL=<% = swq.Web.PathAndQuery() %>'>关怀</a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="浏览" SortExpression="edit">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkShow" runat="server" Text="浏览" NavigateUrl='<%# string.Format("StudentShow.aspx?StudentID={0}&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
    </form>
    <!--短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
    <input id="StudentID" name="StudentID" type="hidden" value="" />
    </form>
    <!--短信Post传递参数代码E-->
    <div class="divremark">
        <b>注意事项：</b><br />
        1、我的正式学员是指，学员正式报名时，咨询顾问填的是我才是显示在这里。<br />
        2、由于潜在学员管理与正式学员管理是分开的系统，由于软件设置不同或者人为操作，我的潜在学员正式报名后，不一定出现在“我的正式学员”里，可联系系统管理员或上级主管修正。<br />
    </div>
</body>
</html>
