﻿<%@ Page Language="c#" CodeBehind="Reply.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Consultant.Reply"
    Title="顾问工作台-回访咨询信息" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="divpanel">
        <asp:FormView ID="fvSubject" runat="server" Width="100%" CssClass="ClearCollapse">
            <ItemTemplate>
                <table cellpadding="4" cellspacing="0" class="table" style="height: 40px" width="100%">
                    <tr>
                        <td align="center" style="width: 124px; border-top-width: 0px" rowspan="3">
                            <div style="font-size: 14px; font-weight: bold">
                                <asp:Label runat="server" ID="name" ForeColor='<%# Convert.ToInt32(Eval("StatusID")) == 3 ? System.Drawing.Color.ForestGreen:System.Drawing.Color.Black%>'
                                    Text='<%#Eval("PotentialName")%>'>
                                </asp:Label>
                            </div>
                        </td>
                        <td align="left" style="height: 22px; border-top-width: 0px">
                            电话：<%#swq.TelPrivacy ? Eval("Tel") : swq.Tools.PrivacyNumber(Eval("Tel"), 2)%>
                            手机：<%# swq.TelPrivacy ? Eval("MobileTel") : swq.Tools.PrivacyNumber(Eval("MobileTel"), 3)%>
                            电话1：<%#swq.TelPrivacy ? Eval("Tel1") : swq.Tools.PrivacyNumber(Eval("Tel1"), 2)%>
                            电话2：<%#swq.TelPrivacy ? Eval("Tel2") : swq.Tools.PrivacyNumber(Eval("Tel2"), 2)%>
                            电话3：<%#swq.TelPrivacy ? Eval("Tel3") : swq.Tools.PrivacyNumber(Eval("Tel3"), 2)%>
                            QQ：<%#Eval("QQ")%>
                            Email：<%#Eval("Email")%>
                            课程名称：<%#Eval("CourseName")%>
                            上课规律：<%#Eval("TimeRule")%><br />
                            年龄：<%#swq.Tools.GetAge(Eval("Birthday"))%>
                            原学校：<%#Eval("School")%>
                            年级：<%#Eval("Grade")%>
                            班级：<%#Eval("Class")%>
                            <asp:HyperLink ID="hlkEdit" runat="server" Text="编辑" NavigateUrl='<%# string.Format("PostPotential.aspx?PotentialID={0}&GetURL={1}",Eval("PotentialID"),swq.Web.PathAndQuery()) %>' />
                        </td>
                    </tr>
                    <tr>
                        <td align="left" height="120">
                            <%#swq.Tools.HtmlEncode(Eval("Remark").ToString())%>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" height="22">
                            客户状态：<%#Eval("StatusName")%>
                            状态描述：<%# Eval("StatusReasonName") == Convert.DBNull ? "-" : Eval("StatusReasonName")%>
                            录入员：<%#Eval("TrueName")%>
                            时间：<%#Eval("DateAndTime")%>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
    </div>
    <div class="divpanel">
        <asp:DataList ID="DataList1" runat="server" DataKeyField="ReplyID" Width="100%" CssClass="ClearCollapse"
            OnCancelCommand="DataList1_CancelCommand" OnEditCommand="DataList1_EditCommand"
            OnItemCommand="DataList1_ItemCommand" OnItemDataBound="DataList1_ItemDataBound"
            OnUpdateCommand="DataList1_UpdateCommand">
            <ItemTemplate>
                <table cellpadding="4" cellspacing="0" class="table" style="height: 40px" width="100%">
                    <tr>
                        <td rowspan="2" style="width: 124px; border-top-width: 0px">
                            回访人：<%#Eval("TrueName")%>
                        </td>
                        <td style="height: 20px; border-top-width: 0px">
                            结果：<%# Eval("StatusName")%>
                            结果描述：<%# Eval("StatusReasonName") == Convert.DBNull ? "-" : Eval("StatusReasonName")%>
                            <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CommandName="edit" CausesValidation="false"></asp:LinkButton>
                            <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"
                                OnClientClick="<%# Rs.Messages.确定删除%>">
                            </asp:LinkButton>
                        </td>
                    </tr>
                    <tr>
                        <td height="50">
                            <%#swq.Tools.HtmlEncode(Eval("Content").ToString())%>
                            <p align="right">
                                时间：<%#Eval("DateAndTime")%>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
            <EditItemTemplate>
                <table cellpadding="4" cellspacing="0" class="table" style="height: 40px" width="100%">
                    <tr>
                        <th colspan="2">
                        </th>
                    </tr>
                    <tr>
                        <td rowspan="2" style="width: 124px;">
                            追踪人：<%#Eval("TrueName")%>
                        </td>
                        <td>
                            结果：<asp:DropDownList ID="ddlStatus" DataSource='<%#swq.Cache.GetStatus() %>' DataTextField="StatusName"
                                DataValueField="StatusID" SelectedValue='<%#Eval("StatusID")%>' AutoPostBack="True"
                                OnSelectedIndexChanged="ddlStatus2_SelectedIndexChanged" runat="server">
                            </asp:DropDownList>
                            结果描述：<asp:DropDownList ID="ddlStatusReason" runat="server" DataTextField="StatusReasonName"
                                DataValueField="StatusReasonID">
                            </asp:DropDownList>
                            <asp:LinkButton ID="Linkbutton1" runat="server" Text="更新" CommandName="update" CommandArgument='<%#Eval("UserID")%>'
                                CausesValidation="false">
                            </asp:LinkButton>
                            <asp:LinkButton ID="Linkbutton2" runat="server" Text="取消" CommandName="cancel" CausesValidation="false"></asp:LinkButton>
                        </td>
                    </tr>
                    <tr>
                        <td height="50">
                            <asp:TextBox TextMode="MultiLine" Rows="5" Width="90%" ID="tBody" Text='<%#Eval("Content")%>'
                                runat="server" />
                            <p align="right">
                                时间：<asp:TextBox ID="dtime" Text='<%#Eval("DateAndTime")%>' runat="server">
                                </asp:TextBox>
                        </td>
                    </tr>
                </table>
            </EditItemTemplate>
        </asp:DataList>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div class="divpanel">
        <table class="table" cellspacing="0" width="85%">
            <tr>
                <th colspan="2">
                    回访信息
                </th>
            </tr>
            <tr>
                <td>
                    时间：
                </td>
                <td>
                    <asp:TextBox ID="tbxDateAndTime" runat="server" Width="167px"></asp:TextBox>
                    <span style="color: Red">*</span>
                </td>
            </tr>
            <tr>
                <td>
                    内容：
                </td>
                <td>
                    <asp:TextBox ID="tbxContent" runat="server" Width="461px" Height="78px" TextMode="MultiLine"></asp:TextBox>
                    <span style="color: Red">*</span>
                </td>
            </tr>
            <tr>
                <td>
                    结果：
                </td>
                <td>
                    <asp:DropDownList ID="ddlStatus" runat="server" DataTextField="StatusName" DataValueField="StatusID"
                        AutoPostBack="True" OnSelectedIndexChanged="ddlStatus_SelectedIndexChanged">
                    </asp:DropDownList>
                    <span style="color: Red">*</span>
                </td>
            </tr>
            <tr>
                <td>
                    结果描述：
                </td>
                <td>
                    <asp:DropDownList ID="ddlStatusReason" runat="server" DataTextField="StatusReasonName"
                        DataValueField="StatusReasonID">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    下次回访日期：
                </td>
                <td>
                    <asp:TextBox ID="tbxNextReplyDate" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="2">
                    <label class="lab_buttom">
                        <asp:Button ID="btnSubmit" runat="server" Text="提交" OnClick="btnSubmit_Click"></asp:Button>
                    </label>
                    <label class="lab_buttom">
                        <input causesvalidation="false" type="button" runat="server" onclick="back()" value="返回" />
                    </label>
                </td>
            </tr>
        </table>
    </div>
    </form>
    <div class="divremark">
        <b>注意事项：</b><br />
        1、将结果选择“成功”时，请确认学员已正式报名，并且档案已经输入到正式学员信息里，很多操作者不明白，认为这里回访状态选择“成功”就表示学员正式报名了，结果正式学员列表里又找不到他。<br />
        2、将结果选择“成功”后，“我的正式学员”里没有他，原因有两种：a 学员信息并没有录入到正式学员系统。 b 录入正式学员信息时咨询顾问填的不是你，联系上级负责人修正。<br />
    </div>
</body>
</html>
