﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UseCommodity.aspx.cs" Inherits="SWTraining.Commodity.UseCommodity"
    Title="仓库管理-领用查询" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript"> 
<!--

        function Focus() {
            if (!document.getElementById("tbxBarcode").disabled) {
                document.getElementById("tbxBarcode").focus();
            }
        }

//--> 
    </script>
</head>
<body onload="Focus();">
    <form id="form1" runat="server">
    <div class="tool_Search">
        条形码：<asp:TextBox ID="tbxBarcode" runat="server" Width="110px"></asp:TextBox>
        &nbsp;类型：<asp:DropDownList ID="ddlUseCommodityType" runat="server">
            <asp:ListItem Value="-1">全部</asp:ListItem>
            <asp:ListItem Value="0">领用</asp:ListItem>
            <asp:ListItem Value="1">借用</asp:ListItem>
            <asp:ListItem Value="2">借用已还</asp:ListItem>
            <asp:ListItem Value="3">借用未还</asp:ListItem>
        </asp:DropDownList>
        分类：<asp:DropDownList ID="ddlCommodityType" runat="server" DataTextField="CommodityTypeName"
            DataValueField="CommodityTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodityType_SelectedIndexChanged">
        </asp:DropDownList>
        商品：<asp:DropDownList ID="ddlCommodity" runat="server" DataTextField="CommodityName"
            DataValueField="CommodityID">
        </asp:DropDownList>
        仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
            DataValueField="StoreroomID">
        </asp:DropDownList>
        日期：<asp:TextBox ID="tbxStartDate" runat="server" Width="79px"></asp:TextBox>
        -<asp:TextBox ID="tbxEndDate" runat="server" Width="79px"></asp:TextBox>
        领用人：<asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
        </asp:DropDownList>
        <label class="lab_buttom">
<asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="查询" />
</label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="UseCommodityID"
            CssClass="gridview" Width="100%" OnRowDataBound="GridView1_RowDataBound" OnRowDeleting="GridView1_RowDeleting">
            <Columns>
                <asp:BoundField DataField="CommodityID" HeaderText="商品编号" InsertVisible="False" ReadOnly="True"
                    SortExpression="CommodityID" />
                <asp:TemplateField HeaderText="商品名称" SortExpression="CommodityName">
                    <ItemTemplate>
                        <asp:Label ID="labCommodityName" runat="server" Text='<%# Bind("CommodityName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                        <%# (int)Eval("UseCommodityTypeID") == 0 ? "领用" : "借用"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="DateAndTime" DataFormatString="{0}" HeaderText="办理时间" />
                <asp:BoundField DataField="ReturnDate" DataFormatString="{0:d}" HeaderText="到期时间" />
                <asp:TemplateField HeaderText="仓库" SortExpression="CommodityName">
                    <ItemTemplate>
                        <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Amount" HeaderText="数量" />
                <asp:BoundField DataField="UnitName" HeaderText="单位" />
                <asp:BoundField DataField="ToTrueName" HeaderText="领用人" />
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <%# (int)Eval("UseCommodityTypeID") == 1 ? ((int)Eval("ReturnState") == 0 ? "未还" : "已还") : "--"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="hlkEdit" Text="编辑" NavigateUrl='<%# string.Format("PostUseCommodity.aspx?UseCommodityID={0}&GetUrl={1}",Eval("UseCommodityID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
