﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CommodityWarn.aspx.cs"
    Inherits="SWTraining.Commodity.CommodityWarn" Title="仓库管理-库存报警" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="CommodityID"
            CssClass="gridview" Width="100%" OnRowDataBound="GridView1_RowDataBound" OnRowCancelingEdit="GridView1_RowCancelingEdit"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting"
            OnSelectedIndexChanging="GridView1_SelectedIndexChanging">
            <Columns>
                <asp:TemplateField InsertVisible="False" HeaderText="商品编号" SortExpression="CommodityID">
                    <ItemTemplate>
                        <asp:ImageButton ID="ibnSelect" CommandName="Select" ImageUrl='<%# accTheme("node_close.gif") %>'
                            runat="server" />
                        <asp:LinkButton ID="lbnCommodityIDSelect" runat="server" Text='<%# Eval("CommodityID") %>'
                            CommandName="Select" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品名称">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnCommodityNameSelect" runat="server" Text='<%# Eval("CommodityName") %>'
                            CommandName="Select" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Amount" HeaderText="库存" ItemStyle-ForeColor="Red" ItemStyle-Font-Bold="true"
                    ReadOnly="True" SortExpression="Amount" />
                <asp:TemplateField HeaderText="警示数" SortExpression="WarnAmount">
                    <ItemTemplate>
                        <asp:Label ID="Label5" runat="server" Text='<%# Bind("WarnAmount") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="PurchasePrice" HeaderText="进价" SortExpression="PurchasePrice"
                    ReadOnly="True" DataFormatString="{0:f2}" HtmlEncode="False" />
                <asp:TemplateField HeaderText="售价" SortExpression="UnitPrice">
                    <ItemTemplate>
                        <asp:Label ID="Label6" runat="server" Text='<%# Bind("UnitPrice","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态" SortExpression="LockState">
                    <ItemTemplate>
                        <asp:Label ID="Label1" runat="server" Text='<%#Eval("LockState").ToString() == "0" ? Rs.Strings.禁用:Rs.Strings.启用%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div id="divItems" style="visibility: hidden">
        <div style="width: 50%">
            <asp:GridView ID="gvItems" runat="server" CssClass="smallgridview" AutoGenerateColumns="False"
                DataKeyNames="StoCommodityID">
                <Columns>
                    <asp:BoundField DataField="StoreroomID" ReadOnly="True" HeaderText="仓库编号" />
                    <asp:TemplateField HeaderText="隶属仓库">
                        <ItemTemplate>
                            <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="库存">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
    </div>
    </form>
</body>
</html>
