﻿<%@ Page Language="c#" CodeBehind="Commodity.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Commodity.Commodity"
    Title="仓库管理-商品/库存管理" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
    <script type="text/javascript"> 
<!--

        function Focus() {
            if (!document.getElementById("tbxBarcode").disabled) {
                document.getElementById("tbxBarcode").focus();
            }
        }

//--> 
    </script>
    <!--form中使用defaultbutton="btnGoto"属性时，Chrome浏览器无法正确调用CreateSubMenu，可能是Chrome的BUG//-->
</head>
<body onload="Focus();">
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        条形码：<asp:TextBox ID="tbxBarcode" runat="server"></asp:TextBox>
        &nbsp;分类：<asp:DropDownList ID="ddlCommodityType" runat="server" DataTextField="CommodityTypeName"
            DataValueField="CommodityTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodityType_SelectedIndexChanged">
        </asp:DropDownList>
        商品：<asp:DropDownList ID="ddlCommodity" runat="server" DataTextField="CommodityName"
            DataValueField="CommodityID">
        </asp:DropDownList>
        <label class="lab_buttom">
<asp:Button ID="btnGoto" runat="server" Text="查询" OnClick="btnGoto_Click"></asp:Button>
</label>
        &nbsp;<label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" OnClick="btnAdd_Click" Text="增加商品" />
</label>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="CommodityID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound"
            OnSelectedIndexChanging="GridView1_SelectedIndexChanging">
            <Columns>
                <asp:TemplateField InsertVisible="False" HeaderText="商品编号" SortExpression="CommodityID">
                    <ItemTemplate>
                        <asp:ImageButton ID="ibnSelect" CommandName="Select" ImageUrl='<%# accTheme("node_close.gif") %>'
                            runat="server" />
                        <asp:LinkButton ID="lbnCommodityIDSelect" runat="server" Text='<%# Eval("CommodityID") %>'
                            CommandName="Select" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品名称">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnCommodityNameSelect" runat="server" Text='<%# Eval("CommodityName") %>'
                            CommandName="Select" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="进价">
                    <ItemTemplate>
                        <asp:Label ID="labPurchasePrice" runat="server" Text='<%# Eval("PurchasePrice","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="售价">
                    <ItemTemplate>
                        <asp:Label ID="labUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:c2}") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Amount" HeaderText="库存" ItemStyle-ForeColor="Red" ItemStyle-Font-Bold="true"
                    ReadOnly="True" SortExpression="Amount" />
                <asp:TemplateField HeaderText="警示数" SortExpression="WarnAmount">
                    <ItemTemplate>
                        <asp:Label ID="Label5" runat="server" Text='<%# Bind("WarnAmount") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="单位">
                    <ItemTemplate>
                        <asp:Label ID="labUnitName" runat="server" Text='<%# Eval("UnitName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="分类">
                    <ItemTemplate>
                        <asp:Label ID="labCommodityTypeName" runat="server" Text='<%# Eval("CommodityTypeName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <%# (int)Eval("LockState") == 0 ? "禁用" : "启用"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlkShow" runat="server" Text="编辑" NavigateUrl='<%# string.Format("PostCommodity.aspx?CommodityID={0}&GetURL={1}",Eval("CommodityID"),swq.Web.PathAndQuery()) %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="return confirm('你是否确定删除这条记录？');"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div class="divpanel">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div id="divItems" style="visibility: hidden">
        <div style="width: 50%">
            <asp:GridView ID="gvItems" runat="server" CssClass="smallgridview" AutoGenerateColumns="False"
                DataKeyNames="StoCommodityID">
                <Columns>
                    <asp:BoundField DataField="StoreroomID" ReadOnly="True" HeaderText="仓库编号" />
                    <asp:TemplateField HeaderText="隶属仓库">
                        <ItemTemplate>
                            <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="库存">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
    </div>
    </form>
</body>
</html>
