﻿<%@ Page Language="c#" CodeBehind="PeriodTime.aspx.cs" AutoEventWireup="True" Inherits="SWTraining.Class.PeriodTime"
    Title="教务管理-时段设置" %>

<%@ Import Namespace="SWTraining" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="../Themes/Blue/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <div class="tool_Search">
        <asp:Label ID="labPeriodTimeName" runat="server" Text="时间段："></asp:Label><asp:TextBox
            ID="tbxPeriodTimeName" runat="server"></asp:TextBox>
        组：<asp:DropDownList ID="ddlGroupType" runat="server">
            <asp:ListItem Value="1" Text="春"></asp:ListItem>
            <asp:ListItem Value="2" Text="夏"></asp:ListItem>
            <asp:ListItem Value="3" Text="秋"></asp:ListItem>
            <asp:ListItem Value="4" Text="冬"></asp:ListItem>
            <asp:ListItem Value="7" Text="其它"></asp:ListItem>
        </asp:DropDownList>
        <label class="lab_buttom">
<asp:Button ID="btnGo" runat="server" Text="转到" OnClick="btnGo_Click"></asp:Button>
</label>
        <label class="lab_buttom">
<asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click"></asp:Button>
</label>
        格式：14:30-17:30<asp:RegularExpressionValidator ID="_tbxPeriodTimeName" runat="server"
            ControlToValidate="tbxPeriodTimeName" ValidationExpression="(((0?[1-9])|((1[0-9])|(2[0-4])))[\:]((0?[0-9])|((1|2|3|4|5)[0-9])))[\-](((0?[0-9])|((1[0-9])|(2[0-4])))[\:]((0?[0-9])|((1|2|3|4|5)[0-9])))$"></asp:RegularExpressionValidator>
    </div>
    <div class="both">
    </div>
    <div class="divpanel">
        <asp:GridView ID="GridView1" runat="server" CssClass="gridview" AutoGenerateColumns="False"
            DataKeyNames="PeriodTimeID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
            OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
            OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:BoundField DataField="PeriodTimeID" ReadOnly="True" HeaderText="编号" />
                <asp:TemplateField HeaderText="时间段">
                    <ItemTemplate>
                        <asp:Label ID="labPeriodTimeName" runat="server" Text='<%# Eval("StartTime").ToString() +"-"+Eval("EndTime").ToString() %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="tbxStartTime" runat="server" Text='<%# Eval("StartTime") %>' Width="40"></asp:TextBox>-<asp:TextBox
                            ID="tbxEndTime" runat="server" Text='<%# Eval("EndTime") %>' Width="40"></asp:TextBox>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="组">
                    <ItemTemplate>
                        <%# Rs.Items.GetGroupType(Eval("GroupType"))%>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:DropDownList runat="server" ID="ddlGroupType" SelectedValue='<%#Eval("GroupType") %>'>
                            <asp:ListItem Value="1" Text="春"></asp:ListItem>
                            <asp:ListItem Value="2" Text="夏"></asp:ListItem>
                            <asp:ListItem Value="3" Text="秋"></asp:ListItem>
                            <asp:ListItem Value="4" Text="冬"></asp:ListItem>
                            <asp:ListItem Value="7" Text="其它"></asp:ListItem>
                        </asp:DropDownList>
                    </EditItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                        <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" meta:resourcekey="btnUp"
                            Text="↑"></asp:LinkButton>
                        <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" meta:resourcekey="btnDo"
                            Text="↓"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />
                <asp:TemplateField HeaderText="删除">
                    <ItemTemplate>
                        <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    <div id="sw_pagercontrol">
        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    </form>
</body>
</html>
